/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.conf.ConfigLoader;
import org.apache.cayenne.conf.ConfigLoaderDelegate;
import org.apache.cayenne.conf.ConfigSaverDelegate;
import org.apache.cayenne.conf.ConfigStatus;
import org.apache.cayenne.conf.DriverDataSourceFactory;
import org.apache.cayenne.conf.JNDIDataSourceFactory;
import org.apache.cayenne.project.ApplicationProjectFile;
import org.apache.cayenne.project.DataNodeConfigInfo;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectException;
import org.apache.cayenne.project.ProjectFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialProject
extends Project {
    protected String projectVersion;
    protected Map<String, DomainMetaData> domains;
    protected ConfigLoaderDelegate loadDelegate;
    protected Map<String, String> dataViewLocations;

    public PartialProject(File projectFile) {
        super(projectFile);
    }

    @Override
    public void upgrade() throws ProjectException {
        throw new ProjectException("'PartialProject' does not support upgrades.");
    }

    public void updateNodes(List<? extends DataNodeConfigInfo> list) throws ProjectException {
        for (DataNodeConfigInfo dataNodeConfigInfo : list) {
            NodeMetaData node;
            String domainName = dataNodeConfigInfo.getDomain();
            if (domainName == null && this.domains.size() != 1) {
                throw new IllegalArgumentException("Node must have domain set explicitly if there is no default domain.");
            }
            if (domainName == null) {
                domainName = ((DomainMetaData)this.domains.values().toArray()[0]).name;
            }
            if ((node = this.findNode(domainName, dataNodeConfigInfo.getName(), false)) == null) continue;
            if (dataNodeConfigInfo.getAdapter() != null) {
                node.adapter = dataNodeConfigInfo.getAdapter();
            }
            if (dataNodeConfigInfo.getDataSource() != null) {
                node.dataSource = dataNodeConfigInfo.getDataSource();
                node.factory = JNDIDataSourceFactory.class.getName();
                continue;
            }
            if (dataNodeConfigInfo.getDriverFile() == null) continue;
            node.dataSource = node.name + ".driver.xml";
            node.factory = DriverDataSourceFactory.class.getName();
        }
    }

    protected void prepareSave(List filesToSave, List wrappedObjects) throws ProjectException {
        filesToSave.addAll(this.files);
    }

    @Override
    protected void postInitialize(File projectFile) {
        this.loadDelegate = new LoadDelegate();
        this.domains = new HashMap<String, DomainMetaData>();
        try {
            FileInputStream in = new FileInputStream(projectFile);
            try {
                new ConfigLoader(this.loadDelegate).loadDomains(in);
            }
            catch (Exception ex) {
                throw new ProjectException("Error creating PartialProject.", ex);
            }
            finally {
                in.close();
            }
        }
        catch (IOException ioex) {
            throw new ProjectException("Error creating PartialProject.", ioex);
        }
        super.postInitialize(projectFile);
    }

    @Override
    public List getChildren() {
        return new ArrayList<DomainMetaData>(this.domains.values());
    }

    @Override
    public void checkForUpgrades() {
    }

    public List buildFileList() {
        ArrayList<ProjectFile> list = new ArrayList<ProjectFile>();
        list.add(this.projectFileForObject(this));
        return list;
    }

    @Override
    public ConfigStatus getLoadStatus() {
        return this.loadDelegate.getStatus();
    }

    @Override
    public ProjectFile projectFileForObject(Object obj) {
        if (obj != this) {
            return null;
        }
        ApplicationProjectFile projectFile = new ApplicationProjectFile(this);
        projectFile.setSaveDelegate(new SaveDelegate());
        return projectFile;
    }

    private DomainMetaData findDomain(String domainName) {
        DomainMetaData domain = this.domains.get(domainName);
        if (domain == null) {
            throw new IllegalArgumentException("Can't find domain: " + domainName);
        }
        return domain;
    }

    private NodeMetaData findNode(String domainName, String nodeName, boolean failIfNotFound) {
        DomainMetaData domain = this.findDomain(domainName);
        NodeMetaData node = domain.nodes.get(nodeName);
        if (node == null && failIfNotFound) {
            throw new IllegalArgumentException("Can't find node: " + domainName + "." + nodeName);
        }
        return node;
    }

    class SaveDelegate
    implements ConfigSaverDelegate {
        SaveDelegate() {
        }

        public String projectVersion() {
            return PartialProject.this.projectVersion;
        }

        public Iterator domainNames() {
            return PartialProject.this.domains.keySet().iterator();
        }

        public Iterator viewNames() {
            if (PartialProject.this.dataViewLocations == null) {
                PartialProject.this.dataViewLocations = new HashMap<String, String>();
            }
            return PartialProject.this.dataViewLocations.keySet().iterator();
        }

        public String viewLocation(String dataViewName) {
            if (PartialProject.this.dataViewLocations == null) {
                PartialProject.this.dataViewLocations = new HashMap<String, String>();
            }
            return PartialProject.this.dataViewLocations.get(dataViewName);
        }

        public Iterator propertyNames(String domainName) {
            return ((PartialProject)PartialProject.this).findDomain((String)domainName).properties.keySet().iterator();
        }

        public String propertyValue(String domainName, String propertyName) {
            return (String)((PartialProject)PartialProject.this).findDomain((String)domainName).properties.get(propertyName);
        }

        public Iterator linkedMapNames(String domainName, String nodeName) {
            return ((PartialProject)PartialProject.this).findDomain((String)domainName).nodes.get((Object)nodeName).maps.iterator();
        }

        public String mapLocation(String domainName, String mapName) {
            return ((PartialProject)PartialProject.this).findDomain((String)domainName).maps.get((Object)mapName).location;
        }

        public Iterator mapNames(String domainName) {
            return ((PartialProject)PartialProject.this).findDomain((String)domainName).maps.keySet().iterator();
        }

        public String nodeAdapterName(String domainName, String nodeName) {
            return ((PartialProject)PartialProject.this).findDomain((String)domainName).nodes.get((Object)nodeName).adapter;
        }

        public String nodeDataSourceName(String domainName, String nodeName) {
            return ((PartialProject)PartialProject.this).findDomain((String)domainName).nodes.get((Object)nodeName).dataSource;
        }

        public String nodeFactoryName(String domainName, String nodeName) {
            return ((PartialProject)PartialProject.this).findDomain((String)domainName).nodes.get((Object)nodeName).factory;
        }

        public Iterator nodeNames(String domainName) {
            return ((PartialProject)PartialProject.this).findDomain((String)domainName).nodes.keySet().iterator();
        }
    }

    class LoadDelegate
    implements ConfigLoaderDelegate {
        protected ConfigStatus status = new ConfigStatus();

        LoadDelegate() {
        }

        public void shouldLoadProjectVersion(String version) {
            PartialProject.this.projectVersion = version;
        }

        protected DomainMetaData findDomain(String name) {
            DomainMetaData domain = PartialProject.this.domains.get(name);
            if (domain == null) {
                throw new ProjectException("Can't find domain: " + name);
            }
            return domain;
        }

        protected MapMetaData findMap(String domainName, String mapName) {
            DomainMetaData domain = this.findDomain(domainName);
            MapMetaData map = domain.maps.get(mapName);
            if (map == null) {
                throw new ProjectException("Can't find map: " + mapName);
            }
            return map;
        }

        protected NodeMetaData findNode(String domainName, String nodeName) {
            DomainMetaData domain = this.findDomain(domainName);
            NodeMetaData node = domain.nodes.get(nodeName);
            if (node == null) {
                throw new ProjectException("Can't find node: " + nodeName);
            }
            return node;
        }

        public void startedLoading() {
            PartialProject.this.domains.clear();
        }

        public void finishedLoading() {
        }

        public ConfigStatus getStatus() {
            return this.status;
        }

        public boolean loadError(Throwable th) {
            this.status.getOtherFailures().add(th.getMessage());
            return false;
        }

        public void shouldLinkDataMap(String domainName, String nodeName, String mapName) {
            this.findNode((String)domainName, (String)nodeName).maps.add(mapName);
        }

        public void shouldLoadDataDomain(String name) {
            PartialProject.this.domains.put(name, new DomainMetaData(name));
        }

        public void shouldLoadDataDomainProperties(String domainName, Map properties) {
            if (properties == null || properties.isEmpty()) {
                return;
            }
            DomainMetaData domain = this.findDomain(domainName);
            domain.properties.putAll(properties);
        }

        public void shouldLoadDataMaps(String domainName, Map locations) {
            if (locations.size() == 0) {
                return;
            }
            DomainMetaData domain = this.findDomain(domainName);
            for (Map.Entry entry : locations.entrySet()) {
                String name = (String)entry.getKey();
                MapMetaData map = new MapMetaData(name);
                map.location = (String)entry.getValue();
                domain.maps.put(name, map);
            }
        }

        public void shouldLoadDataNode(String domainName, String nodeName, String dataSource, String adapter, String factory) {
            NodeMetaData node = new NodeMetaData(nodeName);
            node.adapter = adapter;
            node.factory = factory;
            node.dataSource = dataSource;
            this.findDomain((String)domainName).nodes.put(nodeName, node);
        }

        public void shouldRegisterDataView(String dataViewName, String dataViewLocation) {
            if (dataViewName == null) {
                throw new NullPointerException("Null dataViewName");
            }
            if (dataViewLocation == null) {
                throw new NullPointerException("Null dataViewLocation");
            }
            if (PartialProject.this.dataViewLocations == null) {
                PartialProject.this.dataViewLocations = new HashMap<String, String>();
            }
            PartialProject.this.dataViewLocations.put(dataViewName, dataViewLocation);
        }
    }

    protected class MapMetaData {
        protected String name;
        protected String location;

        public MapMetaData(String name) {
            this.name = name;
        }
    }

    protected class NodeMetaData {
        protected String name;
        protected String dataSource;
        protected String adapter;
        protected String factory;
        protected List<String> maps = new ArrayList<String>();

        public NodeMetaData(String name) {
            this.name = name;
        }
    }

    protected class DomainMetaData {
        protected String name;
        protected Map<String, NodeMetaData> nodes = new HashMap<String, NodeMetaData>();
        protected Map<String, MapMetaData> maps = new HashMap<String, MapMetaData>();
        protected Map mapDependencies = new HashMap();
        protected Map properties = new HashMap();

        public DomainMetaData(String name) {
            this.name = name;
        }
    }
}

