/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.DataRowPostProcessor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCResultIterator
implements ResultIterator {
    protected Connection connection;
    protected Statement statement;
    protected ResultSet resultSet;
    protected RowDescriptor rowDescriptor;
    DataRowPostProcessor postProcessor;
    protected DbEntity rootEntity;
    protected int[] pkIndices;
    protected int mapCapacity;
    protected boolean closingConnection;
    protected boolean closed;
    protected boolean nextRow;
    private String[] labels;
    private int[] types;

    public JDBCResultIterator(Connection connection, Statement statement, ResultSet resultSet, RowDescriptor descriptor) throws CayenneException {
        this.connection = connection;
        this.statement = statement;
        this.resultSet = resultSet;
        this.rowDescriptor = descriptor;
        this.mapCapacity = (int)Math.ceil((double)descriptor.getWidth() / 0.75);
        this.checkNextRow();
        if (this.nextRow) {
            ColumnDescriptor[] columns = descriptor.getColumns();
            int width = columns.length;
            this.labels = new String[width];
            this.types = new int[width];
            for (int i = 0; i < width; ++i) {
                this.labels[i] = columns[i].getLabel();
                this.types[i] = columns[i].getJdbcType();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataRow> dataRows(boolean close) throws CayenneException {
        ArrayList<DataRow> list = new ArrayList<DataRow>();
        try {
            while (this.hasNextRow()) {
                list.add((DataRow)this.nextDataRow());
            }
        }
        finally {
            if (close) {
                this.close();
            }
        }
        return list;
    }

    @Override
    public boolean hasNextRow() {
        return this.nextRow;
    }

    @Override
    public Map<String, Object> nextDataRow() throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        Map<String, Object> row = this.readDataRow();
        this.checkNextRow();
        return row;
    }

    @Override
    public Map<String, Object> nextObjectId(DbEntity entity) throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        if (this.rootEntity != entity || this.pkIndices == null) {
            this.rootEntity = entity;
            this.indexPK();
        }
        Map<String, Object> row = this.readIdRow();
        this.checkNextRow();
        return row;
    }

    @Override
    public Object nextId(DbEntity entity) throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        if (this.rootEntity != entity || this.pkIndices == null) {
            this.rootEntity = entity;
            this.indexPK();
        }
        Object id = this.readId();
        this.checkNextRow();
        return id;
    }

    @Override
    public void skipDataRow() throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        this.checkNextRow();
    }

    @Override
    public void close() throws CayenneException {
        if (!this.closed) {
            this.nextRow = false;
            StringBuffer errors = new StringBuffer();
            try {
                this.resultSet.close();
            }
            catch (SQLException e1) {
                errors.append("Error closing ResultSet.");
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException e2) {
                    errors.append("Error closing PreparedStatement.");
                }
            }
            if (this.connection != null && this.isClosingConnection()) {
                try {
                    this.connection.close();
                }
                catch (SQLException e3) {
                    errors.append("Error closing Connection.");
                }
            }
            if (errors.length() > 0) {
                throw new CayenneException("Error closing ResultIterator: " + errors.toString());
            }
            this.closed = true;
        }
    }

    @Override
    public int getDataRowWidth() {
        return this.rowDescriptor.getWidth();
    }

    protected void checkNextRow() throws CayenneException {
        this.nextRow = false;
        try {
            if (this.resultSet.next()) {
                this.nextRow = true;
            }
        }
        catch (SQLException e) {
            throw new CayenneException("Error rewinding ResultSet", e);
        }
    }

    protected Map<String, Object> readDataRow() throws CayenneException {
        try {
            DataRow dataRow = new DataRow(this.mapCapacity);
            ExtendedType[] converters = this.rowDescriptor.getConverters();
            int resultWidth = this.labels.length;
            for (int i = 0; i < resultWidth; ++i) {
                Object val = converters[i].materializeObject(this.resultSet, i + 1, this.types[i]);
                dataRow.put(this.labels[i], val);
            }
            if (this.postProcessor != null) {
                this.postProcessor.postprocessRow(this.resultSet, dataRow);
            }
            return dataRow;
        }
        catch (CayenneException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneException("Exception materializing column.", Util.unwindException(otherex));
        }
    }

    protected Object readId() throws CayenneException {
        int len = this.pkIndices.length;
        if (len != 1) {
            return this.readIdRow();
        }
        ExtendedType[] converters = this.rowDescriptor.getConverters();
        try {
            int index = this.pkIndices[0];
            Object val = converters[index].materializeObject(this.resultSet, index + 1, this.types[index]);
            return val;
        }
        catch (CayenneException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneException("Exception materializing id column.", Util.unwindException(otherex));
        }
    }

    protected Map<String, Object> readIdRow() throws CayenneException {
        try {
            DataRow idRow = new DataRow(2);
            ExtendedType[] converters = this.rowDescriptor.getConverters();
            for (int index : this.pkIndices) {
                Object val = converters[index].materializeObject(this.resultSet, index + 1, this.types[index]);
                idRow.put(this.labels[index], val);
            }
            if (this.postProcessor != null) {
                this.postProcessor.postprocessRow(this.resultSet, idRow);
            }
            return idRow;
        }
        catch (CayenneException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneException("Exception materializing id column.", Util.unwindException(otherex));
        }
    }

    protected void indexPK() {
        if (this.rootEntity == null) {
            throw new CayenneRuntimeException("Null root DbEntity, can't index PK");
        }
        int len = this.rootEntity.getPrimaryKeys().size();
        if (len == 0) {
            throw new CayenneRuntimeException("Root DbEntity has no PK defined: " + this.rootEntity);
        }
        int[] pk = new int[len];
        ColumnDescriptor[] columns = this.rowDescriptor.getColumns();
        int j = 0;
        for (int i = 0; i < columns.length; ++i) {
            DbAttribute a = (DbAttribute)this.rootEntity.getAttribute(columns[i].getName());
            if (a == null || !a.isPrimaryKey()) continue;
            pk[j++] = i;
        }
        this.pkIndices = pk;
    }

    public boolean isClosingConnection() {
        return this.closingConnection;
    }

    public void setClosingConnection(boolean flag) {
        this.closingConnection = flag;
    }

    public RowDescriptor getRowDescriptor() {
        return this.rowDescriptor;
    }

    void setPostProcessor(DataRowPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }
}

