/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.map.DbEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitResultIterator
implements ResultIterator {
    protected ResultIterator wrappedIterator;
    protected Map<String, Object> nextDataObjectIds;
    protected int fetchLimit;
    protected int offset;
    protected int fetchedSoFar;
    protected boolean nextRow;

    public LimitResultIterator(ResultIterator wrappedIterator, int offset, int fetchLimit) throws CayenneException {
        if (wrappedIterator == null) {
            throw new CayenneException("Null wrapped iterator.");
        }
        this.wrappedIterator = wrappedIterator;
        this.offset = offset;
        this.fetchLimit = fetchLimit;
        this.checkOffset();
        this.checkNextRow();
    }

    private void checkOffset() throws CayenneException {
        for (int i = 0; i < this.offset && this.wrappedIterator.hasNextRow(); ++i) {
            this.wrappedIterator.nextDataRow();
        }
    }

    private void checkNextRow() throws CayenneException {
        this.nextRow = false;
        if ((this.fetchLimit <= 0 || this.fetchedSoFar < this.fetchLimit) && this.wrappedIterator.hasNextRow()) {
            this.nextRow = true;
            ++this.fetchedSoFar;
        }
    }

    protected Map readDataRow() throws CayenneException {
        Map<String, Object> next = this.wrappedIterator.nextDataRow();
        return next;
    }

    @Override
    public void close() throws CayenneException {
        this.wrappedIterator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List dataRows(boolean close) throws CayenneException {
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            while (this.hasNextRow()) {
                list.add(this.nextDataRow());
            }
            ArrayList<Map> arrayList = list;
            return arrayList;
        }
        finally {
            if (close) {
                this.close();
            }
        }
    }

    @Override
    public int getDataRowWidth() {
        return this.wrappedIterator.getDataRowWidth();
    }

    @Override
    public boolean hasNextRow() throws CayenneException {
        return this.nextRow;
    }

    public Map nextDataRow() throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        Map row = this.readDataRow();
        this.checkNextRow();
        return row;
    }

    @Override
    public Object nextId(DbEntity entity) throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        Object id = this.readId(entity);
        this.checkNextId(entity);
        return id;
    }

    @Override
    public Map<String, Object> nextObjectId(DbEntity entity) throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        this.checkNextObjectId(entity);
        return this.nextDataObjectIds;
    }

    @Override
    public void skipDataRow() throws CayenneException {
        this.wrappedIterator.skipDataRow();
    }

    void checkNextId(DbEntity entity) throws CayenneException {
        if (entity == null) {
            throw new CayenneException("Null DbEntity, can't create id.");
        }
        this.nextRow = false;
        if (this.wrappedIterator.hasNextRow()) {
            this.nextRow = true;
        }
    }

    public Object readId(DbEntity entity) throws CayenneException {
        Object next = this.wrappedIterator.nextId(entity);
        return next;
    }

    void checkNextObjectId(DbEntity entity) throws CayenneException {
        if (entity == null) {
            throw new CayenneException("Null DbEntity, can't create id.");
        }
        this.nextRow = false;
        this.nextDataObjectIds = null;
        if (this.wrappedIterator.hasNextRow()) {
            this.nextRow = true;
            Map<String, Object> next = this.wrappedIterator.nextObjectId(entity);
            this.nextDataObjectIds = next;
        }
    }
}

