/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.CallbackDescriptor;
import org.apache.cayenne.map.ClientEntityResolver;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.map.EntityListenerFactory;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLResultSetMapping;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.reflect.SingletonFaultFactory;
import org.apache.cayenne.reflect.generic.DataObjectDescriptorFactory;
import org.apache.cayenne.reflect.pojo.EnhancedPojoDescriptorFactory;
import org.apache.cayenne.reflect.valueholder.ValueHolderDescriptorFactory;
import org.apache.cayenne.util.Util;
import org.apache.commons.collections.collection.CompositeCollection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityResolver
implements MappingNamespace,
Serializable {
    static final ObjEntity DUPLICATE_MARKER = new ObjEntity();
    protected static final Log logger = LogFactory.getLog(EntityResolver.class);
    protected boolean indexedByClass = true;
    protected Collection<DataMap> maps = new ArrayList<DataMap>(3);
    protected transient Map<String, Query> queryCache;
    protected transient Map<String, Embeddable> embeddableCache = new HashMap<String, Embeddable>();
    protected transient Map<String, SQLResultSetMapping> resultSetMappingCache;
    protected transient Map<String, DbEntity> dbEntityCache;
    protected transient Map<String, ObjEntity> objEntityCache;
    protected transient Map<String, Procedure> procedureCache;
    protected transient Map<String, EntityInheritanceTree> entityInheritanceCache;
    protected EntityResolver clientEntityResolver;
    protected transient ClassDescriptorMap classDescriptorMap;
    protected transient LifecycleCallbackRegistry callbackRegistry;
    protected EntityListenerFactory entityListenerFactory;

    public EntityResolver() {
        this.queryCache = new HashMap<String, Query>();
        this.dbEntityCache = new HashMap<String, DbEntity>();
        this.objEntityCache = new HashMap<String, ObjEntity>();
        this.procedureCache = new HashMap<String, Procedure>();
        this.entityInheritanceCache = new HashMap<String, EntityInheritanceTree>();
        this.resultSetMappingCache = new HashMap<String, SQLResultSetMapping>();
    }

    public EntityResolver(Collection<DataMap> dataMaps) {
        this();
        this.maps.addAll(dataMaps);
        this.constructCache();
    }

    public void applyDBLayerDefaults() {
        for (DataMap map : this.getDataMaps()) {
            for (DbEntity entity : map.getDbEntities()) {
                Object[] relationships = entity.getRelationships().toArray();
                for (int i = 0; i < relationships.length; ++i) {
                    DbRelationship relationship = (DbRelationship)relationships[i];
                    if (relationship.getReverseRelationship() != null) continue;
                    DbRelationship reverse = relationship.createReverseRelationship();
                    Entity targetEntity = reverse.getSourceEntity();
                    reverse.setName(this.makeUniqueRelationshipName(targetEntity));
                    reverse.setRuntime(true);
                    targetEntity.addRelationship(reverse);
                    logger.info("added runtime complimentary DbRelationship from " + targetEntity.getName() + " to " + reverse.getTargetEntityName());
                }
            }
        }
    }

    public void applyObjectLayerDefaults() {
        for (DataMap map : this.getDataMaps()) {
            for (ObjEntity entity : map.getObjEntities()) {
                Object[] relationships = entity.getRelationships().toArray();
                for (int i = 0; i < relationships.length; ++i) {
                    ObjRelationship relationship = (ObjRelationship)relationships[i];
                    if (relationship.getReverseRelationship() != null) continue;
                    ObjRelationship reverse = relationship.createReverseRelationship();
                    Entity targetEntity = reverse.getSourceEntity();
                    reverse.setName(this.makeUniqueRelationshipName(targetEntity));
                    reverse.setRuntime(true);
                    targetEntity.addRelationship(reverse);
                    logger.info("added runtime complimentary ObjRelationship from " + targetEntity.getName() + " to " + reverse.getTargetEntityName());
                }
            }
        }
    }

    private String makeUniqueRelationshipName(Entity entity) {
        for (int i = 0; i < 1000; ++i) {
            String name = "runtimeRelationship" + i;
            if (entity.getRelationship(name) != null) continue;
            return name;
        }
        throw new CayenneRuntimeException("Could not come up with a unique relationship name");
    }

    synchronized void initCallbacks() {
        if (this.callbackRegistry == null) {
            LifecycleCallbackRegistry callbackRegistry = new LifecycleCallbackRegistry(this);
            for (DataMap map : this.maps) {
                for (EntityListener listener : map.getDefaultEntityListeners()) {
                    CallbackDescriptor[] callbacks;
                    Object listenerInstance = this.createListener(listener, null);
                    if (listenerInstance == null) continue;
                    for (CallbackDescriptor callback : callbacks = listener.getCallbackMap().getCallbacks()) {
                        for (String method : callback.getCallbackMethods()) {
                            callbackRegistry.addDefaultListener(callback.getCallbackType(), listenerInstance, method);
                        }
                    }
                }
            }
            for (ObjEntity entity : this.getObjEntities()) {
                CallbackDescriptor[] callbacks;
                Class<?> entityClass = entity.getJavaClass();
                for (EntityListener listener : entity.getEntityListeners()) {
                    CallbackDescriptor[] callbacks2;
                    Object listenerInstance = this.createListener(listener, entity);
                    if (listenerInstance == null) continue;
                    for (CallbackDescriptor callback : callbacks2 = listener.getCallbackMap().getCallbacks()) {
                        for (String method : callback.getCallbackMethods()) {
                            callbackRegistry.addListener(callback.getCallbackType(), entityClass, listenerInstance, method);
                        }
                    }
                }
                for (CallbackDescriptor callback : callbacks = entity.getCallbackMap().getCallbacks()) {
                    for (String method : callback.getCallbackMethods()) {
                        callbackRegistry.addListener(callback.getCallbackType(), entityClass, method);
                    }
                }
            }
            this.callbackRegistry = callbackRegistry;
        }
    }

    private Object createListener(EntityListener listener, ObjEntity entity) {
        Class<?> listenerClass;
        if (this.entityListenerFactory != null) {
            return this.entityListenerFactory.createListener(listener, entity);
        }
        try {
            listenerClass = Util.getJavaClass(listener.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new CayenneRuntimeException("Invalid listener class: " + listener.getClassName(), e);
        }
        try {
            return listenerClass.newInstance();
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Listener class " + listener.getClassName() + " default constructor call failed", e);
        }
    }

    public LifecycleCallbackRegistry getCallbackRegistry() {
        if (this.callbackRegistry == null) {
            this.initCallbacks();
        }
        return this.callbackRegistry;
    }

    public void setCallbackRegistry(LifecycleCallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityResolver getClientEntityResolver() {
        if (this.clientEntityResolver == null) {
            EntityResolver entityResolver = this;
            synchronized (entityResolver) {
                if (this.clientEntityResolver == null) {
                    ClientEntityResolver resolver = new ClientEntityResolver();
                    for (DataMap map : this.getDataMaps()) {
                        DataMap clientMap = map.getClientDataMap(this);
                        if (clientMap == null) continue;
                        resolver.addDataMap(clientMap);
                    }
                    this.clientEntityResolver = resolver;
                }
            }
        }
        return this.clientEntityResolver;
    }

    @Override
    public Collection<DbEntity> getDbEntities() {
        CompositeCollection c = new CompositeCollection();
        for (DataMap map : this.getDataMaps()) {
            c.addComposited(map.getDbEntities());
        }
        return c;
    }

    @Override
    public Collection<ObjEntity> getObjEntities() {
        CompositeCollection c = new CompositeCollection();
        for (DataMap map : this.getDataMaps()) {
            c.addComposited(map.getObjEntities());
        }
        return c;
    }

    public Collection<Embeddable> getEmbeddables() {
        CompositeCollection c = new CompositeCollection();
        for (DataMap map : this.getDataMaps()) {
            c.addComposited(map.getEmbeddables());
        }
        return c;
    }

    public Collection<SQLResultSetMapping> getResultSetMappings() {
        CompositeCollection c = new CompositeCollection();
        for (DataMap map : this.getDataMaps()) {
            c.addComposited(map.getResultSetMappings());
        }
        return c;
    }

    @Override
    public Collection<Procedure> getProcedures() {
        CompositeCollection c = new CompositeCollection();
        for (DataMap map : this.getDataMaps()) {
            c.addComposited(map.getProcedures());
        }
        return c;
    }

    @Override
    public Collection<Query> getQueries() {
        CompositeCollection c = new CompositeCollection();
        for (DataMap map : this.getDataMaps()) {
            c.addComposited(map.getQueries());
        }
        return c;
    }

    @Override
    public DbEntity getDbEntity(String name) {
        return this._lookupDbEntity(name);
    }

    @Override
    public ObjEntity getObjEntity(String name) {
        return this._lookupObjEntity(name);
    }

    @Override
    public Procedure getProcedure(String name) {
        return this.lookupProcedure(name);
    }

    @Override
    public Query getQuery(String name) {
        return this.lookupQuery(name);
    }

    @Override
    public Embeddable getEmbeddable(String className) {
        Embeddable result = this.embeddableCache.get(className);
        if (result == null) {
            this.constructCache();
            result = this.embeddableCache.get(className);
        }
        return result;
    }

    @Override
    public SQLResultSetMapping getResultSetMapping(String name) {
        SQLResultSetMapping result = this.resultSetMappingCache.get(name);
        if (result == null) {
            this.constructCache();
            result = this.resultSetMappingCache.get(name);
        }
        return result;
    }

    public synchronized ClassDescriptor getClassDescriptor(String entityName) {
        if (entityName == null) {
            throw new IllegalArgumentException("Null entityName");
        }
        return this.getClassDescriptorMap().getDescriptor(entityName);
    }

    public synchronized void addDataMap(DataMap map) {
        if (!this.maps.contains(map)) {
            this.maps.add(map);
            map.setNamespace(this);
            this.clearCache();
        }
    }

    public synchronized void clearCache() {
        this.queryCache.clear();
        this.dbEntityCache.clear();
        this.objEntityCache.clear();
        this.procedureCache.clear();
        this.entityInheritanceCache.clear();
        this.resultSetMappingCache.clear();
        this.embeddableCache.clear();
        this.clientEntityResolver = null;
    }

    protected synchronized void constructCache() {
        this.clearCache();
        for (DataMap map : this.maps) {
            for (DbEntity de : map.getDbEntities()) {
                this.dbEntityCache.put(de.getName(), de);
            }
        }
        for (DataMap map : this.maps) {
            for (ObjEntity oe : map.getObjEntities()) {
                String className;
                this.objEntityCache.put(oe.getName(), oe);
                if (!this.indexedByClass || (className = oe.getJavaClassName()) == null) continue;
                String classKey = this.classKey(className);
                ObjEntity existing = this.objEntityCache.get(classKey);
                if (existing != null) {
                    if (existing == DUPLICATE_MARKER) continue;
                    this.objEntityCache.put(classKey, DUPLICATE_MARKER);
                    continue;
                }
                this.objEntityCache.put(classKey, oe);
            }
            for (Procedure proc : map.getProcedures()) {
                this.procedureCache.put(proc.getName(), proc);
            }
            for (Query query : map.getQueries()) {
                String name = query.getName();
                Query existingQuery = this.queryCache.put(name, query);
                if (existingQuery == null || query == existingQuery) continue;
                throw new CayenneRuntimeException("More than one Query for name" + name);
            }
        }
        for (DataMap map : this.maps) {
            for (ObjEntity oe : map.getObjEntities()) {
                String superOEName;
                EntityInheritanceTree node = this.entityInheritanceCache.get(oe.getName());
                if (node == null) {
                    node = new EntityInheritanceTree(oe);
                    this.entityInheritanceCache.put(oe.getName(), node);
                }
                if ((superOEName = oe.getSuperEntityName()) == null) continue;
                EntityInheritanceTree superNode = this.entityInheritanceCache.get(superOEName);
                if (superNode == null) {
                    ObjEntity superOE = this.objEntityCache.get(superOEName);
                    if (superOE != null) {
                        superNode = new EntityInheritanceTree(superOE);
                        this.entityInheritanceCache.put(superOEName, superNode);
                    } else {
                        logger.warn("No super entity mapping for '" + superOEName + "'");
                        continue;
                    }
                }
                superNode.addChildNode(node);
            }
        }
    }

    public synchronized DataMap getDataMap(String mapName) {
        if (mapName == null) {
            return null;
        }
        for (DataMap map : this.maps) {
            if (!mapName.equals(map.getName())) continue;
            return map;
        }
        return null;
    }

    public synchronized void setDataMaps(Collection<DataMap> maps) {
        this.maps.clear();
        this.maps.addAll(maps);
        this.clearCache();
    }

    public Collection<DataMap> getDataMaps() {
        return Collections.unmodifiableCollection(this.maps);
    }

    public synchronized DbEntity lookupDbEntity(Class<?> aClass) {
        ObjEntity oe = this.lookupObjEntity(aClass);
        return oe != null ? oe.getDbEntity() : null;
    }

    public synchronized DbEntity lookupDbEntity(Persistent dataObject) {
        return this.lookupDbEntity(dataObject.getClass());
    }

    public EntityInheritanceTree lookupInheritanceTree(ObjEntity entity) {
        EntityInheritanceTree tree = this.entityInheritanceCache.get(entity.getName());
        if (tree == null) {
            this.constructCache();
            tree = this.entityInheritanceCache.get(entity.getName());
        }
        return tree == null || tree.getChildrenCount() == 0 ? null : tree;
    }

    public synchronized ObjEntity lookupObjEntity(Class<?> aClass) {
        if (!this.indexedByClass) {
            throw new CayenneRuntimeException("Class index is disabled.");
        }
        return this._lookupObjEntity(this.classKey(aClass.getName()));
    }

    public synchronized ObjEntity lookupObjEntity(Object object) {
        if (object instanceof ObjEntity) {
            return (ObjEntity)object;
        }
        if (object instanceof Persistent) {
            ObjectId id = ((Persistent)object).getObjectId();
            if (id != null) {
                return this._lookupObjEntity(id.getEntityName());
            }
        } else if (object instanceof Class) {
            return this.lookupObjEntity((Class)object);
        }
        return this.lookupObjEntity(object.getClass());
    }

    public synchronized ObjEntity lookupObjEntity(String entityName) {
        return this._lookupObjEntity(entityName);
    }

    public Procedure lookupProcedure(Query q) {
        return q.getMetaData(this).getProcedure();
    }

    public Procedure lookupProcedure(String procedureName) {
        Procedure result = this.procedureCache.get(procedureName);
        if (result == null) {
            this.constructCache();
            result = this.procedureCache.get(procedureName);
        }
        return result;
    }

    public synchronized Query lookupQuery(String name) {
        Query result = this.queryCache.get(name);
        if (result == null) {
            this.constructCache();
            result = this.queryCache.get(name);
        }
        return result;
    }

    public synchronized void removeDataMap(DataMap map) {
        if (this.maps.remove(map)) {
            this.clearCache();
        }
    }

    public boolean isIndexedByClass() {
        return this.indexedByClass;
    }

    public void setIndexedByClass(boolean b) {
        this.indexedByClass = b;
    }

    protected String classKey(String className) {
        return "^cl^" + className;
    }

    protected DbEntity _lookupDbEntity(Object object) {
        if (object instanceof DbEntity) {
            return (DbEntity)object;
        }
        DbEntity result = this.dbEntityCache.get(object);
        if (result == null) {
            this.constructCache();
            result = this.dbEntityCache.get(object);
        }
        if (result == DUPLICATE_MARKER) {
            throw new CayenneRuntimeException("Can't perform lookup. There is more than one DbEntity mapped to " + object);
        }
        return result;
    }

    protected ObjEntity _lookupObjEntity(String key) {
        ObjEntity result = this.objEntityCache.get(key);
        if (result == null) {
            this.constructCache();
            result = this.objEntityCache.get(key);
        }
        if (result == DUPLICATE_MARKER) {
            throw new CayenneRuntimeException("Can't perform lookup. There is more than one ObjEntity mapped to " + key);
        }
        return result;
    }

    public ClassDescriptorMap getClassDescriptorMap() {
        if (this.classDescriptorMap == null) {
            ClassDescriptorMap classDescriptorMap = new ClassDescriptorMap(this);
            SingletonFaultFactory faultFactory = new SingletonFaultFactory();
            classDescriptorMap.addFactory(new ValueHolderDescriptorFactory(classDescriptorMap));
            classDescriptorMap.addFactory(new EnhancedPojoDescriptorFactory(classDescriptorMap, faultFactory));
            classDescriptorMap.addFactory(new DataObjectDescriptorFactory(classDescriptorMap, faultFactory));
            for (DataMap map : this.maps) {
                for (String entityName : map.getObjEntityMap().keySet()) {
                    classDescriptorMap.getDescriptor(entityName);
                }
            }
            this.classDescriptorMap = classDescriptorMap;
        }
        return this.classDescriptorMap;
    }

    public void setEntityListenerFactory(EntityListenerFactory entityListenerFactory) {
        this.entityListenerFactory = entityListenerFactory;
    }
}

