/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.validation.SimpleValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public class ExecutingMergerContext
implements MergerContext {
    private DataMap map;
    private DbAdapter adapter;
    private DataSource dataSource;
    private ValidationResult result = new ValidationResult();

    public ExecutingMergerContext(DataMap map, DataNode node) {
        this.map = map;
        this.dataSource = node.getDataSource();
        this.adapter = node.getAdapter();
    }

    public ExecutingMergerContext(DataMap map, DataSource dataSource, DbAdapter adapter) {
        this.map = map;
        this.dataSource = dataSource;
        this.adapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSql(String sql) {
        Connection conn = null;
        Statement st = null;
        try {
            QueryLogger.log(sql);
            conn = this.dataSource.getConnection();
            st = conn.createStatement();
            st.execute(sql);
        }
        catch (SQLException e) {
            this.result.addFailure(new SimpleValidationFailure(sql, e.getMessage()));
            QueryLogger.logQueryError(e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public DataMap getDataMap() {
        return this.map;
    }

    public ValidationResult getValidationResult() {
        return this.result;
    }
}

