/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.DataMapEvent;
import org.apache.cayenne.map.event.DataNodeEvent;
import org.apache.cayenne.map.event.DomainEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ProcedureEvent;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.ApplicationProject;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.Query;

public class RemoveAction
extends CayenneAction {
    public static String getActionName() {
        return "Remove";
    }

    public RemoveAction(Application application) {
        super(RemoveAction.getActionName(), application);
    }

    protected RemoveAction(String actionName, Application application) {
        super(actionName, application);
    }

    public String getIconName() {
        return "icon-trash.gif";
    }

    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public ConfirmRemoveDialog getConfirmDeleteDialog(boolean allowAsking) {
        return new ConfirmRemoveDialog(allowAsking);
    }

    public void performAction(ActionEvent e) {
        this.performAction(e, true);
    }

    public void performAction(ActionEvent e, boolean allowAsking) {
        ProjectController mediator = this.getProjectController();
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        if (mediator.getCurrentObjEntity() != null) {
            if (dialog.shouldDelete("ObjEntity", mediator.getCurrentObjEntity().getName())) {
                this.removeObjEntity(mediator.getCurrentDataMap(), mediator.getCurrentObjEntity());
            }
        } else if (mediator.getCurrentDbEntity() != null) {
            if (dialog.shouldDelete("DbEntity", mediator.getCurrentDbEntity().getName())) {
                this.removeDbEntity(mediator.getCurrentDataMap(), mediator.getCurrentDbEntity());
            }
        } else if (mediator.getCurrentQuery() != null) {
            if (dialog.shouldDelete("query", mediator.getCurrentQuery().getName())) {
                this.removeQuery(mediator.getCurrentDataMap(), mediator.getCurrentQuery());
            }
        } else if (mediator.getCurrentProcedure() != null) {
            if (dialog.shouldDelete("procedure", mediator.getCurrentProcedure().getName())) {
                this.removeProcedure(mediator.getCurrentDataMap(), mediator.getCurrentProcedure());
            }
        } else if (mediator.getCurrentDataMap() != null) {
            if (dialog.shouldDelete("data map", mediator.getCurrentDataMap().getName())) {
                if (mediator.getCurrentDataNode() != null) {
                    this.removeDataMapFromDataNode(mediator.getCurrentDataNode(), mediator.getCurrentDataMap());
                } else {
                    this.removeDataMap(mediator.getCurrentDataDomain(), mediator.getCurrentDataMap());
                }
            }
        } else if (mediator.getCurrentDataNode() != null) {
            if (dialog.shouldDelete("data node", mediator.getCurrentDataNode().getName())) {
                this.removeDataNode(mediator.getCurrentDataDomain(), mediator.getCurrentDataNode());
            }
        } else if (mediator.getCurrentDataDomain() != null) {
            if (dialog.shouldDelete("data domain", mediator.getCurrentDataDomain().getName())) {
                this.removeDomain(mediator.getCurrentDataDomain());
            }
        } else if (mediator.getCurrentPaths() != null && dialog.shouldDelete("selected objects")) {
            ProjectPath[] paths = mediator.getCurrentPaths();
            for (int i = 0; i < paths.length; ++i) {
                this.removeLastPathComponent(paths[i]);
            }
        }
    }

    private void removeDomain(DataDomain domain) {
        ApplicationProject project = (ApplicationProject)this.getCurrentProject();
        ProjectController mediator = this.getProjectController();
        project.getConfiguration().removeDomain(domain.getName());
        mediator.fireDomainEvent(new DomainEvent((Object)Application.getFrame(), domain, 3));
    }

    private void removeDataMap(DataDomain domain, DataMap map) {
        ProjectController mediator = this.getProjectController();
        DataMapEvent e = new DataMapEvent((Object)Application.getFrame(), map, 3);
        e.setDomain(domain);
        domain.removeMap(map.getName());
        mediator.fireDataMapEvent(e);
    }

    private void removeDataNode(DataDomain domain, DataNode node) {
        ProjectController mediator = this.getProjectController();
        DataNodeEvent e = new DataNodeEvent((Object)Application.getFrame(), node, 3);
        e.setDomain(domain);
        domain.removeDataNode(node.getName());
        mediator.fireDataNodeEvent(e);
    }

    private void removeDbEntity(DataMap map, DbEntity ent) {
        ProjectController mediator = this.getProjectController();
        EntityEvent e = new EntityEvent((Object)Application.getFrame(), (Entity)ent, 3);
        e.setDomain(mediator.findDomain(map));
        map.removeDbEntity(ent.getName(), true);
        mediator.fireDbEntityEvent(e);
    }

    private void removeQuery(DataMap map, Query query) {
        ProjectController mediator = this.getProjectController();
        QueryEvent e = new QueryEvent((Object)Application.getFrame(), query, 3, map);
        e.setDomain(mediator.findDomain(map));
        map.removeQuery(query.getName());
        mediator.fireQueryEvent(e);
    }

    private void removeProcedure(DataMap map, Procedure procedure) {
        ProjectController mediator = this.getProjectController();
        ProcedureEvent e = new ProcedureEvent((Object)Application.getFrame(), procedure, 3);
        e.setDomain(mediator.findDomain(map));
        map.removeProcedure(procedure.getName());
        mediator.fireProcedureEvent(e);
    }

    private void removeObjEntity(DataMap map, ObjEntity entity) {
        ProjectController mediator = this.getProjectController();
        EntityEvent e = new EntityEvent((Object)Application.getFrame(), (Entity)entity, 3);
        e.setDomain(mediator.findDomain(map));
        map.removeObjEntity(entity.getName(), true);
        mediator.fireObjEntityEvent(e);
        for (AbstractQuery abstractQuery : new ArrayList<Query>(map.getQueries())) {
            Object root = abstractQuery.getRoot();
            if (root != entity && (!(root instanceof String) || !root.toString().equals(entity.getName()))) continue;
            this.removeQuery(map, abstractQuery);
        }
    }

    private void removeDataMapFromDataNode(DataNode node, DataMap map) {
        ProjectController mediator = this.getProjectController();
        DataNodeEvent e = new DataNodeEvent((Object)Application.getFrame(), node);
        e.setDomain(mediator.findDomain(node));
        node.removeDataMap(map.getName());
        mediator.fireDataNodeEvent(e);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        Object lastObject = path.getObject();
        if (lastObject instanceof DataDomain) {
            return true;
        }
        if (lastObject instanceof DataMap) {
            return true;
        }
        if (lastObject instanceof DataNode) {
            return true;
        }
        if (lastObject instanceof Entity) {
            return true;
        }
        if (lastObject instanceof Attribute) {
            return true;
        }
        if (lastObject instanceof Relationship) {
            return true;
        }
        if (lastObject instanceof Procedure) {
            return true;
        }
        return lastObject instanceof ProcedureParameter;
    }

    private void removeLastPathComponent(ProjectPath path) {
        Object lastObject = path.getObject();
        if (lastObject instanceof DataDomain) {
            this.removeDomain((DataDomain)lastObject);
        } else if (lastObject instanceof DataMap) {
            Object parent = path.getObjectParent();
            if (parent instanceof DataDomain) {
                this.removeDataMap((DataDomain)parent, (DataMap)lastObject);
            } else {
                this.removeDataMapFromDataNode((DataNode)parent, (DataMap)lastObject);
            }
        } else if (lastObject instanceof DataNode) {
            this.removeDataNode((DataDomain)path.getObjectParent(), (DataNode)lastObject);
        } else if (lastObject instanceof DbEntity) {
            this.removeDbEntity((DataMap)path.getObjectParent(), (DbEntity)lastObject);
        } else if (lastObject instanceof ObjEntity) {
            this.removeObjEntity((DataMap)path.getObjectParent(), (ObjEntity)lastObject);
        } else if (lastObject instanceof Query) {
            this.removeQuery((DataMap)path.getObjectParent(), (Query)lastObject);
        } else if (lastObject instanceof Procedure) {
            this.removeProcedure((DataMap)path.getObjectParent(), (Procedure)lastObject);
        }
    }
}

