/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.MultipleObjectsAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.project.ProjectPath;

public class RemoveRelationshipAction
extends RemoveAction
implements MultipleObjectsAction {
    private static final String ACTION_NAME = "Remove Relationship";
    private static final String ACTION_NAME_MULTIPLE = "Remove Relationships";

    public static String getActionName() {
        return ACTION_NAME;
    }

    public String getActionName(boolean multiple) {
        return multiple ? ACTION_NAME_MULTIPLE : ACTION_NAME;
    }

    public RemoveRelationshipAction(Application application) {
        super(ACTION_NAME, application);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.getObject() instanceof Relationship;
    }

    public void performAction(ActionEvent e, boolean allowAsking) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        ObjRelationship[] rels = this.getProjectController().getCurrentObjRelationships();
        if (rels != null && rels.length > 0) {
            if (rels.length == 1 && dialog.shouldDelete("ObjRelationship", rels[0].getName()) || rels.length > 1 && dialog.shouldDelete("selected ObjRelationships")) {
                this.removeObjRelationships();
            }
        } else {
            DbRelationship[] dbRels = this.getProjectController().getCurrentDbRelationships();
            if (dbRels != null && dbRels.length > 0 && (dbRels.length == 1 && dialog.shouldDelete("DbRelationship", dbRels[0].getName()) || dbRels.length > 1 && dialog.shouldDelete("selected DbRelationships"))) {
                this.removeDbRelationships();
            }
        }
    }

    protected void removeObjRelationships() {
        ProjectController mediator = this.getProjectController();
        ObjEntity entity = mediator.getCurrentObjEntity();
        ObjRelationship[] rels = mediator.getCurrentObjRelationships();
        for (int i = 0; i < rels.length; ++i) {
            entity.removeRelationship(rels[i].getName());
            RelationshipEvent e = new RelationshipEvent((Object)Application.getFrame(), (Relationship)rels[i], (Entity)entity, 3);
            mediator.fireObjRelationshipEvent(e);
        }
    }

    protected void removeDbRelationships() {
        ProjectController mediator = this.getProjectController();
        DbEntity entity = mediator.getCurrentDbEntity();
        DbRelationship[] rels = mediator.getCurrentDbRelationships();
        for (int i = 0; i < rels.length; ++i) {
            entity.removeRelationship(rels[i].getName());
            RelationshipEvent e = new RelationshipEvent((Object)Application.getFrame(), (Relationship)rels[i], (Entity)entity, 3);
            mediator.fireDbRelationshipEvent(e);
        }
        ProjectUtil.cleanObjMappings(mediator.getCurrentDataMap());
    }
}

