/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.tree.TreePath;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ProjectTreeModel;
import org.apache.cayenne.modeler.dialog.FindDialogView;
import org.apache.cayenne.modeler.editor.EditorView;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneController;

public class FindDialog
extends CayenneController {
    private FindDialogView view;
    private List paths;

    public FindDialog(CayenneController parent, List paths) {
        super(parent);
        this.paths = paths;
        HashMap<Integer, String> objEntityNames = new HashMap<Integer, String>();
        HashMap<Integer, String> dbEntityNames = new HashMap<Integer, String>();
        HashMap<Integer, String> attrNames = new HashMap<Integer, String>();
        HashMap<Integer, String> relatNames = new HashMap<Integer, String>();
        Iterator it = paths.iterator();
        int index = 0;
        while (it.hasNext()) {
            Object[] path = (Object[])it.next();
            if (path[path.length - 1] instanceof ObjEntity) {
                objEntityNames.put(new Integer(index++), ((ObjEntity)path[path.length - 1]).getName());
            }
            if (path[path.length - 1] instanceof DbEntity) {
                dbEntityNames.put(new Integer(index++), ((DbEntity)path[path.length - 1]).getName());
            }
            if (path[path.length - 1] instanceof Attribute) {
                attrNames.put(new Integer(index++), ((Attribute)path[path.length - 1]).getName());
            }
            if (!(path[path.length - 1] instanceof Relationship)) continue;
            relatNames.put(new Integer(index++), ((Relationship)path[path.length - 1]).getName());
        }
        this.view = new FindDialogView(objEntityNames, dbEntityNames, attrNames, relatNames);
        this.initBindings();
    }

    public void startupAction() {
        this.view.pack();
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.view.setVisible(true);
    }

    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        this.view.getOkButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.view.dispose();
            }
        });
        for (JButton b : this.view.getEntityButtons()) {
            b.addActionListener(new JumpToResultActionListener());
        }
    }

    private class JumpToResultActionListener
    implements ActionListener {
        private EditorView editor;

        private JumpToResultActionListener() {
            this.editor = ((CayenneModelerFrame)FindDialog.this.application.getFrameController().getView()).getView();
        }

        public void actionPerformed(ActionEvent e) {
            EntityDisplayEvent event;
            JButton source = (JButton)e.getSource();
            Object[] path = (Object[])FindDialog.this.paths.get(((FindDialogView.EntityButtonModel)source.getModel()).getIndex());
            if (path[path.length - 1] instanceof Entity) {
                this.editor.getProjectTreeView().getSelectionModel().setSelectionPath(this.buildTreePath(path));
                event = new EntityDisplayEvent((Object)this.editor.getProjectTreeView(), (Entity)path[path.length - 1], (DataMap)path[path.length - 2], (DataDomain)path[path.length - 3]);
                event.setMainTabFocus(true);
                if (path[path.length - 1] instanceof ObjEntity) {
                    this.editor.getObjDetailView().currentObjEntityChanged(event);
                }
                if (path[path.length - 1] instanceof DbEntity) {
                    this.editor.getDbDetailView().currentDbEntityChanged(event);
                }
            }
            if (path[path.length - 1] instanceof Attribute || path[path.length - 1] instanceof Relationship) {
                Object[] o = new Object[path.length - 1];
                for (int i = 0; i < path.length - 1; ++i) {
                    o[i] = path[i];
                }
                this.editor.getProjectTreeView().getSelectionModel().setSelectionPath(this.buildTreePath(o));
                if (path[path.length - 1] instanceof DbAttribute) {
                    AttributeDisplayEvent event2 = new AttributeDisplayEvent((Object)this.editor.getProjectTreeView(), (Attribute)path[path.length - 1], (Entity)path[path.length - 2], (DataMap)path[path.length - 3], (DataDomain)path[path.length - 4]);
                    event2.setMainTabFocus(true);
                    this.editor.getDbDetailView().currentDbAttributeChanged(event2);
                }
                if (path[path.length - 1] instanceof ObjAttribute) {
                    AttributeDisplayEvent event3 = new AttributeDisplayEvent((Object)this.editor.getProjectTreeView(), (Attribute)path[path.length - 1], (Entity)path[path.length - 2], (DataMap)path[path.length - 3], (DataDomain)path[path.length - 4]);
                    event3.setMainTabFocus(true);
                    this.editor.getObjDetailView().currentObjAttributeChanged(event3);
                }
                if (path[path.length - 1] instanceof DbRelationship) {
                    RelationshipDisplayEvent event4 = new RelationshipDisplayEvent((Object)this.editor.getProjectTreeView(), (Relationship)path[path.length - 1], (Entity)path[path.length - 2], (DataMap)path[path.length - 3], (DataDomain)path[path.length - 4]);
                    event4.setMainTabFocus(true);
                    this.editor.getDbDetailView().currentDbRelationshipChanged(event4);
                }
            }
            if (path[path.length - 1] instanceof ObjRelationship) {
                event = new RelationshipDisplayEvent((Object)this.editor.getProjectTreeView(), (Relationship)path[path.length - 1], (Entity)path[path.length - 2], (DataMap)path[path.length - 3], (DataDomain)path[path.length - 4]);
                event.setMainTabFocus(true);
                this.editor.getObjDetailView().currentObjRelationshipChanged((RelationshipDisplayEvent)event);
            }
        }

        private TreePath buildTreePath(Object[] path) {
            Object[] mutableTreeNodes = new Object[path.length];
            mutableTreeNodes[0] = ((ProjectTreeModel)this.editor.getProjectTreeView().getModel()).getRootNode();
            for (int i = 1; i < path.length; ++i) {
                Object[] helper = new Object[i];
                int j = 0;
                while (j < i) {
                    helper[j++] = path[j];
                }
                mutableTreeNodes[i] = ((ProjectTreeModel)this.editor.getProjectTreeView().getModel()).getNodeForObjectPath(helper);
            }
            return new TreePath(mutableTreeNodes);
        }
    }
}

