/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.Component;
import java.util.Iterator;
import org.apache.cayenne.modeler.dialog.ValidationResultBrowserView;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public class ValidationResultBrowser
extends CayenneController {
    protected ValidationResultBrowserView view = new ValidationResultBrowserView();

    public ValidationResultBrowser(CayenneController parent) {
        super(parent);
        this.initController();
    }

    protected void initController() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getCloseButton(), "closeDialogAction()");
    }

    public Component getView() {
        return this.view;
    }

    public void closeDialogAction() {
        this.view.dispose();
    }

    public void startupAction(String title, String message, ValidationResult validationResult) {
        this.view.setTitle(title);
        this.view.getMessageLabel().setText(message);
        this.view.getErrorsDisplay().setText(this.buildValidationText(validationResult));
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    protected String buildValidationText(ValidationResult validationResult) {
        StringBuffer buffer = new StringBuffer();
        String separator = System.getProperty("line.separator");
        Iterator<ValidationFailure> it = validationResult.getFailures().iterator();
        while (it.hasNext()) {
            ValidationFailure failure;
            if (buffer.length() > 0) {
                buffer.append(separator);
            }
            if ((failure = it.next()).getSource() != null) {
                buffer.append("[SQL: ").append(failure.getSource()).append("] - ");
            }
            if (failure.getDescription() == null) continue;
            buffer.append(failure.getDescription());
        }
        return buffer.toString();
    }
}

