/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.dialog.objentity.ClassNameUpdater;
import org.apache.cayenne.modeler.dialog.validator.DuplicatedAttributesDialog;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.ExpressionConvertor;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjEntityTab
extends JPanel
implements ObjEntityDisplayListener,
ExistingSelectionProcessor {
    private static final Object noInheritance = new CayenneMapEntry(){

        public String getName() {
            return "Direct Mapping to Table/View";
        }

        public Object getParent() {
            return null;
        }

        public void setParent(Object parent) {
        }
    };
    protected ProjectController mediator;
    protected TextAdapter name;
    protected TextAdapter className;
    protected JLabel superclassLabel;
    protected TextAdapter superClassName;
    protected TextAdapter qualifier;
    protected JComboBox dbEntityCombo;
    protected JButton syncWithDbEntityButton;
    protected JComboBox superEntityCombo;
    protected JButton tableLabel;
    protected JCheckBox readOnly;
    protected JCheckBox optimisticLocking;
    protected JCheckBox excludeSuperclassListeners;
    protected JCheckBox excludeDefaultListeners;
    protected JComponent clientSeparator;
    protected JLabel isAbstractLabel;
    protected JLabel serverOnlyLabel;
    protected JLabel clientClassNameLabel;
    protected JLabel clientSuperClassNameLabel;
    protected JCheckBox serverOnly;
    protected JCheckBox isAbstract;
    protected TextAdapter clientClassName;
    protected TextAdapter clientSuperClassName;

    public ObjEntityTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        Application app = Application.getInstance();
        toolBar.add(app.getAction(ObjEntitySyncAction.getActionName()).buildButton());
        toolBar.add(app.getAction(CreateAttributeAction.getActionName()).buildButton());
        toolBar.add(app.getAction(CreateRelationshipAction.getActionName()).buildButton());
        this.add((Component)toolBar, "North");
        this.name = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                ObjEntityTab.this.setEntityName(text);
            }
        };
        this.superClassName = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                ObjEntityTab.this.setSuperClassName(text);
            }
        };
        this.className = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                ObjEntityTab.this.setClassName(text);
            }
        };
        this.qualifier = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                ObjEntityTab.this.setQualifier(text);
            }
        };
        this.dbEntityCombo = CayenneWidgetFactory.createComboBox();
        this.superEntityCombo = CayenneWidgetFactory.createComboBox();
        AutoCompletion.enable(this.dbEntityCombo);
        AutoCompletion.enable(this.superEntityCombo);
        this.readOnly = new JCheckBox();
        this.optimisticLocking = new JCheckBox();
        this.excludeSuperclassListeners = new JCheckBox();
        this.excludeDefaultListeners = new JCheckBox();
        this.tableLabel = CayenneWidgetFactory.createLabelButton("Table/View:");
        this.syncWithDbEntityButton = CayenneWidgetFactory.createButton("Sync w/DbEntity");
        this.syncWithDbEntityButton.setIcon(ModelerUtil.buildIcon("icon-sync.gif"));
        this.syncWithDbEntityButton.setToolTipText("Sync this ObjEntity with its DBEntity");
        this.isAbstract = new JCheckBox();
        this.serverOnly = new JCheckBox();
        this.clientClassName = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                ObjEntityTab.this.setClientClassName(text);
            }
        };
        this.clientSuperClassName = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                ObjEntityTab.this.setClientSuperClassName(text);
            }
        };
        FormLayout layout = new FormLayout("right:100dlu, 3dlu, fill:135dlu, 3dlu, pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("ObjEntity Configuration");
        builder.append("ObjEntity Name:", (Component)this.name.getComponent(), 3);
        builder.append("Inheritance:", (Component)this.superEntityCombo, 3);
        builder.append(this.tableLabel, (Component)this.dbEntityCombo, (Component)this.syncWithDbEntityButton);
        this.isAbstractLabel = builder.append("Abstract class:", (Component)this.isAbstract, 3);
        builder.appendSeparator();
        builder.append("Java Class:", (Component)this.className.getComponent(), 3);
        this.superclassLabel = builder.append("Superclass:", (Component)this.superClassName.getComponent(), 3);
        builder.append("Qualifier:", (Component)this.qualifier.getComponent(), 3);
        builder.append("Read-Only:", (Component)this.readOnly, 3);
        builder.append("Optimistic Locking:", (Component)this.optimisticLocking, 3);
        builder.append("Exclude superclass listeners:", (Component)this.excludeSuperclassListeners, 3);
        builder.append("Exclude default listeners:", (Component)this.excludeDefaultListeners, 3);
        this.clientSeparator = builder.appendSeparator("Java Client");
        this.serverOnlyLabel = builder.append("Not for Client Use:", (Component)this.serverOnly, 3);
        this.clientClassNameLabel = builder.append("Client Java Class:", (Component)this.clientClassName.getComponent(), 3);
        this.clientSuperClassNameLabel = builder.append("Client Superclass:", (Component)this.clientSuperClassName.getComponent(), 3);
        this.add((Component)builder.getPanel(), "Center");
    }

    private void initController() {
        this.mediator.addObjEntityDisplayListener(this);
        this.dbEntityCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjEntity entity = ObjEntityTab.this.mediator.getCurrentObjEntity();
                DbEntity dbEntity = (DbEntity)ObjEntityTab.this.dbEntityCombo.getSelectedItem();
                ObjEntityTab.this.syncWithDbEntityButton.setEnabled(dbEntity != null);
                if (dbEntity != entity.getDbEntity()) {
                    entity.setDbEntity(dbEntity);
                    ObjEntityTab.this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
                }
            }
        });
        this.superEntityCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjEntity entity;
                CayenneMapEntry superEntity = (CayenneMapEntry)ObjEntityTab.this.superEntityCombo.getSelectedItem();
                String name = superEntity == noInheritance ? null : superEntity.getName();
                if (!Util.nullSafeEquals(name, (entity = ObjEntityTab.this.mediator.getCurrentObjEntity()).getSuperEntityName())) {
                    List duplicateAttributes = ObjEntityTab.this.getDuplicatedAttributes((ObjEntity)superEntity);
                    if (duplicateAttributes.size() > 0) {
                        DuplicatedAttributesDialog.showDialog(Application.getFrame(), duplicateAttributes, (ObjEntity)superEntity, entity);
                        if (DuplicatedAttributesDialog.getResult().equals("cancel")) {
                            ObjEntityTab.this.superEntityCombo.setSelectedItem(entity.getSuperEntity());
                            ObjEntityTab.this.superClassName.setText(entity.getSuperClassName());
                            return;
                        }
                    }
                    entity.setSuperEntityName(name);
                    ObjEntityTab.this.toggleEnabled(name == null, !ObjEntityTab.this.serverOnly.isSelected());
                    ObjEntityTab.this.dbEntityCombo.getModel().setSelectedItem(entity.getDbEntity());
                    ObjEntityTab.this.superClassName.setText(entity.getSuperClassName());
                    DataDomain domain = ObjEntityTab.this.mediator.getCurrentDataDomain();
                    DataMap map = ObjEntityTab.this.mediator.getCurrentDataMap();
                    ObjEntityTab.this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
                    ObjEntityTab.this.mediator.fireObjEntityDisplayEvent(new EntityDisplayEvent((Object)this, entity, map, domain));
                }
            }
        });
        this.tableLabel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbEntity entity = ObjEntityTab.this.mediator.getCurrentObjEntity().getDbEntity();
                if (entity != null) {
                    DataDomain dom = ObjEntityTab.this.mediator.getCurrentDataDomain();
                    ObjEntityTab.this.mediator.fireDbEntityDisplayEvent(new EntityDisplayEvent((Object)this, entity, entity.getDataMap(), dom));
                }
            }
        });
        this.syncWithDbEntityButton.addActionListener(new ObjEntitySyncAction(this.mediator.getApplication()));
        this.readOnly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjEntity entity = ObjEntityTab.this.mediator.getCurrentObjEntity();
                if (entity != null) {
                    entity.setReadOnly(ObjEntityTab.this.readOnly.isSelected());
                    ObjEntityTab.this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
                }
            }
        });
        this.optimisticLocking.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjEntity entity = ObjEntityTab.this.mediator.getCurrentObjEntity();
                if (entity != null) {
                    entity.setDeclaredLockType(ObjEntityTab.this.optimisticLocking.isSelected() ? 1 : 0);
                    ObjEntityTab.this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
                }
            }
        });
        this.excludeSuperclassListeners.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjEntity entity = ObjEntityTab.this.mediator.getCurrentObjEntity();
                if (entity != null) {
                    entity.setExcludingSuperclassListeners(ObjEntityTab.this.excludeSuperclassListeners.isSelected());
                    ObjEntityTab.this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
                }
            }
        });
        this.excludeDefaultListeners.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjEntity entity = ObjEntityTab.this.mediator.getCurrentObjEntity();
                if (entity != null) {
                    entity.setExcludingDefaultListeners(ObjEntityTab.this.excludeDefaultListeners.isSelected());
                    ObjEntityTab.this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
                }
            }
        });
        this.serverOnly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjEntity entity = ObjEntityTab.this.mediator.getCurrentObjEntity();
                if (entity != null) {
                    entity.setServerOnly(ObjEntityTab.this.serverOnly.isSelected());
                    ObjEntityTab.this.toggleEnabled(ObjEntityTab.this.dbEntityCombo.isEnabled(), !ObjEntityTab.this.serverOnly.isSelected());
                    ObjEntityTab.this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
                }
            }
        });
        this.isAbstract.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjEntity entity = ObjEntityTab.this.mediator.getCurrentObjEntity();
                if (entity != null) {
                    entity.setIsAbstract(ObjEntityTab.this.isAbstract.isSelected());
                    ObjEntityTab.this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
                }
            }
        });
    }

    private void initFromModel(final ObjEntity entity) {
        this.qualifier.getComponent().setBackground(Color.WHITE);
        this.name.setText(entity.getName());
        this.superClassName.setText(entity.getSuperClassName());
        this.className.setText(entity.getClassName());
        this.readOnly.setSelected(entity.isReadOnly());
        this.isAbstract.setSelected(entity.getIsAbstract());
        this.serverOnly.setSelected(entity.isServerOnly());
        this.clientClassName.setText(entity.getClientClassName());
        this.clientSuperClassName.setText(entity.getClientSuperClassName());
        this.qualifier.setText(new ExpressionConvertor().valueAsString(entity.getDeclaredQualifier()));
        this.optimisticLocking.setSelected(entity.getDeclaredLockType() == 1);
        this.excludeSuperclassListeners.setSelected(entity.isExcludingSuperclassListeners());
        this.excludeDefaultListeners.setSelected(entity.isExcludingDefaultListeners());
        DataMap map = this.mediator.getCurrentDataMap();
        Object[] dbEntities = map.getNamespace().getDbEntities().toArray();
        Arrays.sort(dbEntities, Comparators.getDataMapChildrenComparator());
        DefaultComboBoxModel<Object> dbModel = new DefaultComboBoxModel<Object>(dbEntities);
        dbModel.setSelectedItem(entity.getDbEntity());
        this.dbEntityCombo.setRenderer(CellRenderers.entityListRendererWithIcons(map));
        this.dbEntityCombo.setModel(dbModel);
        this.toggleClientFieldsVisible(map.isClientSupported());
        this.toggleEnabled(entity.getSuperEntityName() == null, !entity.isServerOnly());
        Predicate inheritanceFilter = new Predicate(){

            public boolean evaluate(Object object) {
                if (entity == object) {
                    return false;
                }
                if (object instanceof ObjEntity) {
                    return !((ObjEntity)object).isSubentityOf(entity);
                }
                return false;
            }
        };
        Object[] objEntities = CollectionUtils.select(map.getNamespace().getObjEntities(), inheritanceFilter).toArray();
        Arrays.sort(objEntities, Comparators.getDataMapChildrenComparator());
        Object[] finalObjEntities = new Object[objEntities.length + 1];
        finalObjEntities[0] = noInheritance;
        System.arraycopy(objEntities, 0, finalObjEntities, 1, objEntities.length);
        DefaultComboBoxModel<Object> superEntityModel = new DefaultComboBoxModel<Object>(finalObjEntities);
        superEntityModel.setSelectedItem(entity.getSuperEntity());
        this.superEntityCombo.setRenderer(CellRenderers.entityListRendererWithIcons(map));
        this.superEntityCombo.setModel(superEntityModel);
    }

    void setClassName(String className) {
        ObjEntity entity;
        if (className != null && className.trim().length() == 0) {
            className = null;
        }
        if ((entity = this.mediator.getCurrentObjEntity()) != null && !Util.nullSafeEquals(entity.getClassName(), className)) {
            entity.setClassName(className);
            this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
        }
    }

    void setSuperClassName(String text) {
        ObjEntity ent;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((ent = this.mediator.getCurrentObjEntity()) != null && !Util.nullSafeEquals(ent.getSuperClassName(), text)) {
            ent.setSuperClassName(text);
            this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, ent));
        }
    }

    void setClientClassName(String className) {
        ObjEntity entity;
        if (className != null && className.trim().length() == 0) {
            className = null;
        }
        if ((entity = this.mediator.getCurrentObjEntity()) != null && !Util.nullSafeEquals(entity.getClientClassName(), className)) {
            entity.setClientClassName(className);
            this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
        }
    }

    void setClientSuperClassName(String text) {
        ObjEntity ent;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((ent = this.mediator.getCurrentObjEntity()) != null && !Util.nullSafeEquals(ent.getClientSuperClassName(), text)) {
            ent.setClientSuperClassName(text);
            this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, ent));
        }
    }

    void setQualifier(String text) {
        ObjEntity entity;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((entity = this.mediator.getCurrentObjEntity()) != null) {
            ExpressionConvertor convertor = new ExpressionConvertor();
            try {
                String oldQualifier = convertor.valueAsString(entity.getDeclaredQualifier());
                if (!Util.nullSafeEquals(oldQualifier, text)) {
                    Expression exp = (Expression)convertor.stringAsValue(text);
                    entity.setDeclaredQualifier(exp);
                    this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, entity));
                }
            }
            catch (IllegalArgumentException ex) {
                throw new ValidationException(ex.getMessage());
            }
        }
    }

    void setEntityName(String newName) {
        ObjEntity entity;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((entity = this.mediator.getCurrentObjEntity()) == null) {
            return;
        }
        if (Util.nullSafeEquals(newName, entity.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Entity name is required.");
        }
        if (entity.getDataMap().getObjEntity(newName) == null) {
            EntityEvent e = new EntityEvent((Object)this, (Entity)entity, entity.getName());
            entity.setName(newName);
            this.mediator.fireObjEntityEvent(e);
            ClassNameUpdater nameUpdater = new ClassNameUpdater(Application.getInstance().getFrameController(), entity);
            if (nameUpdater.doNameUpdate()) {
                this.className.setText(entity.getClassName());
                this.clientClassName.setText(entity.getClientClassName());
            }
        } else {
            throw new ValidationException("There is another entity with name '" + newName + "'.");
        }
    }

    void toggleClientFieldsVisible(boolean visible) {
        this.clientSeparator.setVisible(visible);
        this.clientSuperClassNameLabel.setVisible(visible);
        this.clientClassNameLabel.setVisible(visible);
        this.serverOnlyLabel.setVisible(visible);
        this.clientClassName.getComponent().setVisible(visible);
        this.clientSuperClassName.getComponent().setVisible(visible);
        this.serverOnly.setVisible(visible);
    }

    void toggleEnabled(boolean directTableMapping, boolean clientFieldsEnabled) {
        this.superClassName.getComponent().setEnabled(directTableMapping);
        this.superclassLabel.setEnabled(directTableMapping);
        this.syncWithDbEntityButton.setEnabled(this.dbEntityCombo.getSelectedItem() != null);
        this.clientSuperClassName.getComponent().setEnabled(directTableMapping && clientFieldsEnabled);
        this.clientSuperClassNameLabel.setEnabled(directTableMapping && clientFieldsEnabled);
        this.clientClassNameLabel.setEnabled(clientFieldsEnabled);
        this.clientClassName.getComponent().setEnabled(clientFieldsEnabled);
    }

    @Override
    public void processExistingSelection(EventObject e) {
        EntityDisplayEvent ede = new EntityDisplayEvent((Object)this, this.mediator.getCurrentObjEntity(), this.mediator.getCurrentDataMap(), this.mediator.getCurrentDataDomain());
        this.mediator.fireObjEntityDisplayEvent(ede);
    }

    @Override
    public void currentObjEntityChanged(EntityDisplayEvent e) {
        ObjEntity entity = (ObjEntity)e.getEntity();
        if (entity == null || !e.isEntityChanged()) {
            return;
        }
        this.initFromModel(entity);
        this.name.getComponent().requestFocusInWindow();
    }

    private List<ObjAttribute> getDuplicatedAttributes(ObjEntity superEntity) {
        LinkedList<ObjAttribute> result = new LinkedList<ObjAttribute>();
        ObjEntity entity = this.mediator.getCurrentObjEntity();
        for (ObjAttribute attribute : entity.getAttributes()) {
            if (superEntity.getAttribute(attribute.getName()) == null) continue;
            result.add(attribute);
        }
        return result;
    }
}

