/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.datanode;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JOptionPane;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.map.event.DataNodeEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.datanode.PasswordEncoderView;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayListener;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.project.ProjectDataSource;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.BindingDelegate;
import org.apache.cayenne.swing.ObjectBinding;

public class PasswordEncoderEditor
extends CayenneController {
    protected DataNode node;
    protected ObjectBinding[] bindings;
    protected PasswordEncoderView view = new PasswordEncoderView();
    protected BindingDelegate nodeChangeProcessor = new BindingDelegate(){

        public void modelUpdated(ObjectBinding binding, Object oldValue, Object newValue) {
            DataNodeEvent e = new DataNodeEvent((Object)PasswordEncoderEditor.this, PasswordEncoderEditor.this.node);
            ((ProjectController)PasswordEncoderEditor.this.getParent()).fireDataNodeEvent(e);
        }
    };

    public PasswordEncoderEditor(CayenneController parent) {
        super(parent);
        this.initController();
    }

    protected void initController() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.setDelegate(this.nodeChangeProcessor);
        this.bindings = new ObjectBinding[4];
        this.bindings[0] = builder.bindToComboSelection(this.view.getPasswordEncoder(), "node.dataSource.dataSourceInfo.passwordEncoderClass");
        this.bindings[1] = builder.bindToTextField(this.view.getPasswordKey(), "node.dataSource.dataSourceInfo.passwordEncoderKey");
        this.bindings[2] = builder.bindToComboSelection(this.view.getPasswordLocation(), "node.dataSource.dataSourceInfo.passwordLocation");
        this.bindings[3] = builder.bindToTextField(this.view.getPasswordSource(), "node.dataSource.dataSourceInfo.passwordSource");
        ((ProjectController)this.getParent()).addDataNodeDisplayListener(new DataNodeDisplayListener(){

            public void currentDataNodeChanged(DataNodeDisplayEvent e) {
                PasswordEncoderEditor.this.refreshView(e.getDataNode());
            }
        });
        this.getView().addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                PasswordEncoderEditor.this.refreshView(PasswordEncoderEditor.this.node != null ? PasswordEncoderEditor.this.node : ((ProjectController)PasswordEncoderEditor.this.getParent()).getCurrentDataNode());
            }
        });
        builder.bindToAction(this.view.getPasswordEncoder(), "validatePasswordEncoderAction()");
        builder.bindToAction(this.view.getPasswordLocation(), "passwordLocationChangedAction()");
    }

    protected void refreshView(DataNode node) {
        this.node = node;
        if (node == null) {
            this.getView().setVisible(false);
            return;
        }
        for (int i = 0; i < this.bindings.length; ++i) {
            this.bindings[i].updateView();
        }
    }

    public void validatePasswordEncoderAction() {
        if (this.node == null || this.node.getDataSource() == null) {
            return;
        }
        DataSourceInfo dsi = ((ProjectDataSource)this.node.getDataSource()).getDataSourceInfo();
        if (!this.view.getPasswordEncoder().getSelectedItem().equals(dsi.getPasswordEncoderClass())) {
            return;
        }
        if (dsi.getPasswordEncoder() == null) {
            JOptionPane.showMessageDialog(this.getView(), "A valid Password Encoder should be specified (check your CLASSPATH).", "Invalid Password Encoder", 0);
        }
    }

    private void updatePasswordElements(boolean isPasswordFieldEnabled, boolean isPasswordLocationEnabled, String passwordText, String passwordLocationLabel, String passwordLocationText) {
        this.view.getPasswordSource().setEnabled(isPasswordLocationEnabled);
        this.view.getPasswordSourceLabel().setText(passwordLocationLabel);
        this.view.getPasswordSource().setText(passwordLocationText);
    }

    public void passwordLocationChangedAction() {
        if (this.node == null || this.node.getDataSource() == null) {
            return;
        }
        DataSourceInfo dsi = ((ProjectDataSource)this.node.getDataSource()).getDataSourceInfo();
        String selectedItem = (String)this.view.getPasswordLocation().getSelectedItem();
        if (selectedItem.equals("classpath")) {
            this.updatePasswordElements(true, true, dsi.getPassword(), "Password Filename:", dsi.getPasswordSourceFilename());
        } else if (selectedItem.equals("executable")) {
            this.updatePasswordElements(false, true, null, "Password Executable:", dsi.getPasswordSourceExecutable());
        } else if (selectedItem.equals("model")) {
            this.updatePasswordElements(true, false, dsi.getPassword(), "Password Source:", dsi.getPasswordSourceModel());
        } else if (selectedItem.equals("url")) {
            this.updatePasswordElements(false, true, null, "Password URL:", dsi.getPasswordSourceUrl());
        }
    }

    public Component getView() {
        return this.view;
    }

    public DataNode getNode() {
        return this.node;
    }

    public void setNode(DataNode node) {
        this.node = node;
    }
}

