/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;

public class CayenneTable
extends JTable {
    public CayenneTable() {
        this.setRowHeight(25);
        this.setRowMargin(3);
        this.setSelectionModel(new CayenneListSelectionModel());
    }

    protected void createDefaultEditors() {
        super.createDefaultEditors();
        JTextField textField = CayenneWidgetFactory.createTextField(0);
        DefaultCellEditor textEditor = CayenneWidgetFactory.createCellEditor(textField);
        textEditor.setClickCountToStart(1);
        this.setDefaultEditor(Object.class, textEditor);
        this.setDefaultEditor(String.class, textEditor);
    }

    public CayenneTableModel getCayenneModel() {
        return (CayenneTableModel)this.getModel();
    }

    public void cancelEditing() {
        this.editingCanceled(new ChangeEvent(this));
    }

    public void select(Object row) {
        if (row == null) {
            return;
        }
        CayenneTableModel model = this.getCayenneModel();
        int ind = model.getObjectList().indexOf(row);
        if (ind >= 0) {
            this.getSelectionModel().setSelectionInterval(ind, ind);
        }
    }

    public void select(int index) {
        CayenneTableModel model = this.getCayenneModel();
        if (index >= model.getObjectList().size()) {
            index = model.getObjectList().size() - 1;
        }
        if (index >= 0) {
            this.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void select(int[] rows) {
        ((CayenneListSelectionModel)this.getSelectionModel()).setSelection(rows);
    }

    public JTextComponent getSelectedTextComponent() {
        Component comp;
        int row = this.getSelectedRow();
        int column = this.getSelectedColumn();
        if (row < 0 || column < 0) {
            return null;
        }
        TableCellEditor editor = this.getCellEditor(row, column);
        if (editor instanceof DefaultCellEditor && (comp = ((DefaultCellEditor)editor).getComponent()) instanceof JTextComponent) {
            return (JTextComponent)comp;
        }
        return null;
    }

    public void tableChanged(TableModelEvent e) {
        this.cancelEditing();
        super.tableChanged(e);
    }

    class CayenneListSelectionModel
    extends DefaultListSelectionModel {
        boolean fireForbidden = false;

        CayenneListSelectionModel() {
        }

        public void setSelection(int[] rows) {
            int i;
            boolean selectionChanged = false;
            for (i = 0; i < rows.length; ++i) {
                if (CayenneTable.this.isRowSelected(rows[i])) continue;
                selectionChanged = true;
                break;
            }
            if (!selectionChanged) {
                for (i = this.getMinSelectionIndex(); i < this.getMaxSelectionIndex(); ++i) {
                    if (!this.isSelectedIndex(i)) continue;
                    boolean inNewSelection = false;
                    for (int j = 0; j < rows.length; ++j) {
                        if (rows[j] != i) continue;
                        inNewSelection = true;
                        break;
                    }
                    if (inNewSelection) continue;
                    selectionChanged = true;
                    break;
                }
            }
            if (!selectionChanged) {
                return;
            }
            this.fireForbidden = true;
            this.clearSelection();
            for (i = 0; i < rows.length; ++i) {
                CayenneTable.this.addRowSelectionInterval(rows[i], rows[i]);
            }
            this.fireForbidden = false;
            this.fireValueChanged(this.getValueIsAdjusting());
        }

        protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
            if (!this.fireForbidden) {
                super.fireValueChanged(firstIndex, lastIndex, isAdjusting);
            }
        }
    }
}

