/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.FieldResult;
import org.apache.cayenne.reflect.ClassDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityResult {
    protected String entityName;
    protected Class<?> entityClass;
    protected Collection<FieldResult> fields;

    public EntityResult(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public EntityResult(String entityName) {
        this.entityName = entityName;
    }

    public ClassDescriptor getClassDescriptor(EntityResolver resolver) {
        return resolver.getClassDescriptor(this.getRootEntity(resolver).getName());
    }

    public Map<String, String> getDbFields(EntityResolver resolver) {
        if (this.fields == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> dbFields = new HashMap<String, String>();
        for (FieldResult field : this.fields) {
            if (field.isDbAttribute()) {
                dbFields.put(field.getAttributeName(), field.getColumn());
                continue;
            }
            ObjEntity entity = field.getEntityName() != null ? resolver.getObjEntity(field.getEntityName()) : this.getRootEntity(resolver);
            ObjAttribute attribute = (ObjAttribute)entity.getAttribute(field.getAttributeName());
            dbFields.put(attribute.getDbAttributePath(), field.getColumn());
        }
        return dbFields;
    }

    public ObjEntity getRootEntity(EntityResolver resolver) {
        if (this.entityName != null) {
            return resolver.getObjEntity(this.entityName);
        }
        if (this.entityClass != null) {
            return resolver.lookupObjEntity(this.entityClass);
        }
        throw new IllegalStateException("Both entity name and class are null");
    }

    public void addObjectField(String attributeName, String column) {
        this.addField(new FieldResult(null, attributeName, column, false));
    }

    public void addObjectField(String entityName, String attributeName, String column) {
        this.addField(new FieldResult(entityName, attributeName, column, false));
    }

    public void addDbField(String dbAttributeName, String column) {
        this.addField(new FieldResult(null, dbAttributeName, column, true));
    }

    void addField(FieldResult field) {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldResult>();
        }
        this.fields.add(field);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Collection<FieldResult> getFields() {
        return this.fields != null ? this.fields : Collections.EMPTY_LIST;
    }
}

