/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.event.EntityListenerEvent;
import org.apache.cayenne.modeler.util.CayenneAction;

public class CreateObjEntityListenerAction
extends CayenneAction {
    private static final String CREATE_ENTITY_LISTENER = "Create objentity entity listener";

    public CreateObjEntityListenerAction(Application application) {
        super(CreateObjEntityListenerAction.getActionName(), application);
    }

    protected CreateObjEntityListenerAction(String actionName, Application application) {
        super(actionName, application);
    }

    public static String getActionName() {
        return CREATE_ENTITY_LISTENER;
    }

    public String getIconName() {
        return "icon-create-listener.gif";
    }

    protected boolean isListenerClassAlreadyExists(String className) {
        return this.getProjectController().getCurrentObjEntity().getEntityListener(className) != null;
    }

    protected void addEntityListener(EntityListener listener) {
        this.getProjectController().getCurrentObjEntity().addEntityListener(listener);
    }

    public void performAction(ActionEvent e) {
        String listenerClass = JOptionPane.showInputDialog("Please enter listener class:");
        if (listenerClass != null && listenerClass.trim().length() > 0) {
            if (this.isListenerClassAlreadyExists(listenerClass)) {
                JOptionPane.showMessageDialog(null, "Listener class already exists.", "Error creating entity listener", 0);
            } else {
                this.addEntityListener(new EntityListener(listenerClass));
                this.getProjectController().fireEntityListenerEvent(new EntityListenerEvent(this, listenerClass, listenerClass, 2));
            }
        }
    }
}

