/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.MultipleObjectsAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.project.ProjectPath;

public class RemoveAttributeAction
extends RemoveAction
implements MultipleObjectsAction {
    private static final String ACTION_NAME = "Remove Attribute";
    private static final String ACTION_NAME_MULTIPLE = "Remove Attributes";

    public static String getActionName() {
        return ACTION_NAME;
    }

    public String getActionName(boolean multiple) {
        return multiple ? ACTION_NAME_MULTIPLE : ACTION_NAME;
    }

    public RemoveAttributeAction(Application application) {
        super(ACTION_NAME, application);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.getObject() instanceof Attribute;
    }

    public void performAction(ActionEvent e, boolean allowAsking) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        ObjAttribute[] attrs = this.getProjectController().getCurrentObjAttributes();
        if (attrs != null && attrs.length > 0) {
            if (attrs.length == 1 && dialog.shouldDelete("ObjAttribute", attrs[0].getName()) || attrs.length > 1 && dialog.shouldDelete("selected ObjAttributes")) {
                this.removeObjAttributes();
            }
        } else {
            DbAttribute[] dbAttrs = this.getProjectController().getCurrentDbAttributes();
            if (dbAttrs != null && dbAttrs.length > 0 && (dbAttrs.length == 1 && dialog.shouldDelete("DbAttribute", dbAttrs[0].getName()) || dbAttrs.length > 1 && dialog.shouldDelete("selected DbAttributes"))) {
                this.removeDbAttributes();
            }
        }
    }

    protected void removeDbAttributes() {
        DbAttribute[] attribs;
        ProjectController mediator = this.getProjectController();
        DbEntity entity = mediator.getCurrentDbEntity();
        for (DbAttribute attrib : attribs = mediator.getCurrentDbAttributes()) {
            entity.removeAttribute(attrib.getName());
            AttributeEvent e = new AttributeEvent((Object)Application.getFrame(), (Attribute)attrib, (Entity)entity, 3);
            mediator.fireDbAttributeEvent(e);
        }
        ProjectUtil.cleanObjMappings(mediator.getCurrentDataMap());
    }

    protected void removeObjAttributes() {
        ObjAttribute[] attribs;
        ProjectController mediator = this.getProjectController();
        ObjEntity entity = mediator.getCurrentObjEntity();
        for (ObjAttribute attrib : attribs = mediator.getCurrentObjAttributes()) {
            entity.removeAttribute(attrib.getName());
            AttributeEvent e = new AttributeEvent((Object)Application.getFrame(), (Attribute)attrib, (Entity)entity, 3);
            mediator.fireObjAttributeEvent(e);
        }
    }
}

