/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.tree.TreePath;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ProjectTreeModel;
import org.apache.cayenne.modeler.dialog.FindDialogView;
import org.apache.cayenne.modeler.editor.EditorView;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneController;

public class FindDialog
extends CayenneController {
    private FindDialogView view;
    private List paths;
    private static Font font;
    private static Font fontSelected;

    public static Font getFont() {
        return font;
    }

    public static Font getFontSelected() {
        return fontSelected;
    }

    public FindDialog(CayenneController parent, List paths) {
        super(parent);
        this.paths = paths;
        HashMap<Integer, String> objEntityNames = new HashMap<Integer, String>();
        HashMap<Integer, String> dbEntityNames = new HashMap<Integer, String>();
        HashMap<Integer, String> attrNames = new HashMap<Integer, String>();
        HashMap<Integer, String> relatNames = new HashMap<Integer, String>();
        Iterator it = paths.iterator();
        int index = 0;
        while (it.hasNext()) {
            Object parentObject;
            Object[] path = (Object[])it.next();
            if (path[path.length - 1] instanceof ObjEntity) {
                objEntityNames.put(new Integer(index++), ((ObjEntity)path[path.length - 1]).getName());
            }
            if (path[path.length - 1] instanceof DbEntity) {
                dbEntityNames.put(new Integer(index++), ((DbEntity)path[path.length - 1]).getName());
            }
            if (path[path.length - 1] instanceof Attribute) {
                parentObject = ((Attribute)path[path.length - 1]).getParent();
                attrNames.put(new Integer(index++), this.getParentName(path, parentObject) + "." + ((Attribute)path[path.length - 1]).getName());
            }
            if (!(path[path.length - 1] instanceof Relationship)) continue;
            parentObject = ((Relationship)path[path.length - 1]).getParent();
            relatNames.put(new Integer(index++), this.getParentName(path, parentObject) + "." + ((Relationship)path[path.length - 1]).getName());
        }
        this.view = new FindDialogView(objEntityNames, dbEntityNames, attrNames, relatNames);
        this.initBindings();
    }

    public void startupAction() {
        this.view.pack();
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.view.setVisible(true);
    }

    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        this.view.getOkButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindDialog.this.view.dispose();
            }
        });
        font = this.view.getOkButton().getFont();
        fontSelected = new Font(font.getFamily(), 1, font.getSize() + 2);
        JTable table = this.view.getTable();
        table.setRowHeight(fontSelected.getSize() + 6);
        table.setRowMargin(0);
        table.addKeyListener(new JumpToResultsKeyListener());
        table.addMouseListener(new JumpToResultActionListener());
        table.getSelectionModel().setSelectionInterval(0, 0);
    }

    public static void jumpToResult(Object[] path, EditorView editor) {
        EntityDisplayEvent event;
        if (path[path.length - 1] instanceof Entity) {
            editor.getProjectTreeView().getSelectionModel().setSelectionPath(FindDialog.buildTreePath(path, editor));
            event = new EntityDisplayEvent((Object)editor.getProjectTreeView(), (Entity)path[path.length - 1], (DataMap)path[path.length - 2], (DataDomain)path[path.length - 3]);
            event.setMainTabFocus(true);
            if (path[path.length - 1] instanceof ObjEntity) {
                editor.getObjDetailView().currentObjEntityChanged(event);
            }
            if (path[path.length - 1] instanceof DbEntity) {
                editor.getDbDetailView().currentDbEntityChanged(event);
            }
        }
        if (path[path.length - 1] instanceof Attribute || path[path.length - 1] instanceof Relationship) {
            Object[] o = new Object[path.length - 1];
            for (int i = 0; i < path.length - 1; ++i) {
                o[i] = path[i];
            }
            editor.getProjectTreeView().getSelectionModel().setSelectionPath(FindDialog.buildTreePath(o, editor));
            if (path[path.length - 1] instanceof DbAttribute) {
                AttributeDisplayEvent event2 = new AttributeDisplayEvent((Object)editor.getProjectTreeView(), (Attribute)path[path.length - 1], (Entity)path[path.length - 2], (DataMap)path[path.length - 3], (DataDomain)path[path.length - 4]);
                event2.setMainTabFocus(true);
                editor.getDbDetailView().currentDbAttributeChanged(event2);
            }
            if (path[path.length - 1] instanceof ObjAttribute) {
                AttributeDisplayEvent event3 = new AttributeDisplayEvent((Object)editor.getProjectTreeView(), (Attribute)path[path.length - 1], (Entity)path[path.length - 2], (DataMap)path[path.length - 3], (DataDomain)path[path.length - 4]);
                event3.setMainTabFocus(true);
                editor.getObjDetailView().currentObjAttributeChanged(event3);
            }
            if (path[path.length - 1] instanceof DbRelationship) {
                RelationshipDisplayEvent event4 = new RelationshipDisplayEvent((Object)editor.getProjectTreeView(), (Relationship)path[path.length - 1], (Entity)path[path.length - 2], (DataMap)path[path.length - 3], (DataDomain)path[path.length - 4]);
                event4.setMainTabFocus(true);
                editor.getDbDetailView().currentDbRelationshipChanged(event4);
            }
        }
        if (path[path.length - 1] instanceof ObjRelationship) {
            event = new RelationshipDisplayEvent((Object)editor.getProjectTreeView(), (Relationship)path[path.length - 1], (Entity)path[path.length - 2], (DataMap)path[path.length - 3], (DataDomain)path[path.length - 4]);
            event.setMainTabFocus(true);
            editor.getObjDetailView().currentObjRelationshipChanged((RelationshipDisplayEvent)event);
        }
    }

    private static TreePath buildTreePath(Object[] path, EditorView editor) {
        Object[] mutableTreeNodes = new Object[path.length];
        mutableTreeNodes[0] = ((ProjectTreeModel)editor.getProjectTreeView().getModel()).getRootNode();
        for (int i = 1; i < path.length; ++i) {
            Object[] helper = new Object[i];
            int j = 0;
            while (j < i) {
                helper[j++] = path[j];
            }
            mutableTreeNodes[i] = ((ProjectTreeModel)editor.getProjectTreeView().getModel()).getNodeForObjectPath(helper);
        }
        return new TreePath(mutableTreeNodes);
    }

    private String getParentName(Object[] path, Object parentObject) {
        String nameParent = null;
        if (parentObject instanceof ObjEntity) {
            ObjEntity objEntity = (ObjEntity)parentObject;
            nameParent = objEntity.getName();
        }
        if (parentObject instanceof DbEntity) {
            DbEntity dbEntity = (DbEntity)parentObject;
            nameParent = dbEntity.getName();
        }
        return nameParent;
    }

    private class JumpToResultsKeyListener
    implements KeyListener {
        private EditorView editor;

        private JumpToResultsKeyListener() {
            this.editor = ((CayenneModelerFrame)FindDialog.this.application.getFrameController().getView()).getView();
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                JTable table = (JTable)e.getSource();
                Integer selectedLine = table.getSelectionModel().getLeadSelectionIndex();
                JLabel label = (JLabel)table.getModel().getValueAt(selectedLine, 0);
                Integer index = (Integer)FindDialogView.getLabelAndObjectIndex().get(label);
                Object[] path = (Object[])FindDialog.this.paths.get(index);
                FindDialog.jumpToResult(path, this.editor);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private class JumpToResultActionListener
    implements MouseListener {
        private EditorView editor;

        private JumpToResultActionListener() {
            this.editor = ((CayenneModelerFrame)FindDialog.this.application.getFrameController().getView()).getView();
        }

        public void mouseClicked(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            Integer selectedLine = table.getSelectionModel().getLeadSelectionIndex();
            JLabel label = (JLabel)table.getModel().getValueAt(selectedLine, 0);
            Integer index = (Integer)FindDialogView.getLabelAndObjectIndex().get(label);
            Object[] path = (Object[])FindDialog.this.paths.get(index);
            FindDialog.jumpToResult(path, this.editor);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

