/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.validator;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.action.ValidateAction;
import org.apache.cayenne.modeler.dialog.validator.ValidationDisplayHandler;
import org.apache.cayenne.modeler.util.CayenneDialog;
import org.apache.cayenne.project.validator.ValidationInfo;
import org.apache.cayenne.project.validator.Validator;

public class ValidatorDialog
extends CayenneDialog {
    protected static ValidatorDialog instance;
    public static final Color WARNING_COLOR;
    public static final Color ERROR_COLOR;
    protected JTable problemsTable;
    protected JButton closeButton;
    protected JButton refreshButton;
    protected List validationObjects = Collections.EMPTY_LIST;

    public static synchronized void showDialog(CayenneModelerFrame editor, Validator validator) {
        if (instance == null) {
            instance = new ValidatorDialog(editor);
            instance.centerWindow();
        }
        instance.refreshFromModel(validator);
        instance.setVisible(true);
    }

    public static synchronized void showValidationSuccess(CayenneModelerFrame editor, Validator val) {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
        JOptionPane.showMessageDialog(Application.getFrame(), "Cayenne project is valid.");
    }

    protected ValidatorDialog(CayenneModelerFrame editor) {
        super(editor, "Validation Problems", false);
        this.initView();
        this.initController();
    }

    private void initView() {
        this.refreshButton = new JButton("Refresh");
        this.closeButton = new JButton("Close");
        this.problemsTable = new JTable();
        this.problemsTable.setRowHeight(25);
        this.problemsTable.setRowMargin(3);
        this.problemsTable.setCellSelectionEnabled(false);
        this.problemsTable.setRowSelectionAllowed(true);
        this.problemsTable.setDefaultRenderer(ValidationInfo.class, new ValidationRenderer());
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("fill:200dlu:grow", "pref, 3dlu, top:40dlu:grow"));
        builder.setDefaultDialogBorder();
        builder.addLabel("Click on any row below to go to the object that has a validation problem:", cc.xy(1, 1));
        builder.add((Component)new JScrollPane(this.problemsTable), cc.xy(1, 3));
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.refreshButton);
        buttons.add(this.closeButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.getContentPane().add((Component)buttons, "South");
        this.setSize(450, 350);
    }

    private void initController() {
        this.setDefaultCloseOperation(2);
        this.problemsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ValidatorDialog.this.showFailedObject();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ValidatorDialog.this.setVisible(false);
                ValidatorDialog.this.dispose();
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Application.getInstance().getAction(ValidateAction.getActionName()).actionPerformed(e);
            }
        });
        this.problemsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int row = ValidatorDialog.this.problemsTable.rowAtPoint(e.getPoint());
                if (row >= 0 && ValidatorDialog.this.problemsTable.getSelectedRow() == row) {
                    ValidatorDialog.this.showFailedObject();
                }
            }
        });
    }

    protected void refreshFromModel(Validator validator) {
        this.validationObjects = validator.validationResults();
        this.problemsTable.setModel(new ValidatorTableModel());
    }

    private void showFailedObject() {
        if (this.problemsTable.getSelectedRow() >= 0) {
            ValidationInfo obj = (ValidationInfo)this.problemsTable.getModel().getValueAt(this.problemsTable.getSelectedRow(), 0);
            ValidationDisplayHandler.getErrorMsg(obj).displayField(this.getMediator(), super.getParentEditor());
        }
    }

    static {
        WARNING_COLOR = new Color(245, 194, 194);
        ERROR_COLOR = new Color(237, 121, 121);
    }

    class ValidationRenderer
    extends DefaultTableCellRenderer {
        ValidationRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean error = false;
            if (value != null) {
                ValidationInfo info = (ValidationInfo)value;
                error = info.getSeverity() == 2;
                value = error ? "Error: " + info.getMessage() : "Warning: " + info.getMessage();
            }
            this.setBackground(error ? ERROR_COLOR : WARNING_COLOR);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class ValidatorTableModel
    extends AbstractTableModel {
        ValidatorTableModel() {
        }

        public int getRowCount() {
            return ValidatorDialog.this.validationObjects.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public Object getValueAt(int row, int col) {
            return ValidatorDialog.this.validationObjects.get(row);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public String getColumnName(int column) {
            return " ";
        }

        public Class getColumnClass(int columnIndex) {
            return ValidationInfo.class;
        }
    }
}

