/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.cayenne.access.trans.BatchQueryBuilder;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.DeleteBatchQuery;

public class DeleteBatchQueryBuilder
extends BatchQueryBuilder {
    public DeleteBatchQueryBuilder(DbAdapter adapter) {
        super(adapter);
    }

    public String createSqlString(BatchQuery batch) throws IOException {
        DeleteBatchQuery deleteBatch = (DeleteBatchQuery)batch;
        boolean status = batch.getDbEntity().getDataMap() != null && batch.getDbEntity().getDataMap().isQuotingSQLIdentifiers();
        QuotingStrategy strategy = this.getAdapter().getQuotingStrategy(status);
        StringBuffer query = new StringBuffer("DELETE FROM ");
        query.append(strategy.quoteFullyQualifiedName(batch.getDbEntity()));
        query.append(" WHERE ");
        Iterator<DbAttribute> i = deleteBatch.getQualifierAttributes().iterator();
        while (i.hasNext()) {
            DbAttribute attribute = i.next();
            this.appendDbAttribute(query, attribute);
            query.append(deleteBatch.isNull(attribute) ? " IS NULL" : " = ?");
            if (!i.hasNext()) continue;
            query.append(" AND ");
        }
        return query.toString();
    }

    public void bindParameters(PreparedStatement statement, BatchQuery query) throws SQLException, Exception {
        DeleteBatchQuery deleteBatch = (DeleteBatchQuery)query;
        int parameterIndex = 1;
        int i = 0;
        for (DbAttribute attribute : deleteBatch.getQualifierAttributes()) {
            Object value = query.getValue(i++);
            if (deleteBatch.isNull(attribute)) continue;
            this.adapter.bindParameter(statement, value, parameterIndex++, attribute.getType(), attribute.getScale());
        }
    }
}

