/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.cayenne.project.CayenneUserDir;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModelerPreferences
extends ExtendedProperties {
    private static final Log logObj = LogFactory.getLog(ModelerPreferences.class);
    public static final String PREFERENCES_NAME = "modeler.preferences";
    public static final String LOGFILE_NAME = "modeler.log";
    public static final String LAST_PROJ_FILES = "Editor.lastSeveralProjectFiles";
    public static final int LAST_PROJ_FILES_SIZE = 12;
    public static final String EDITOR_LAFNAME = "Editor.lookAndFeel";
    public static final String EDITOR_THEMENAME = "Editor.theme";
    public static final String EDITOR_LOGFILE_ENABLED = "Editor.logfileEnabled";
    public static final String EDITOR_LOGFILE = "Editor.logfile";
    public static final int COMBOBOX_MAX_VISIBLE_SIZE = 12;
    protected static ModelerPreferences sharedInstance;

    protected ModelerPreferences() {
    }

    public static ModelerPreferences getPreferences() {
        if (sharedInstance == null) {
            sharedInstance = new ModelerPreferences();
            sharedInstance.loadPreferences();
        }
        return sharedInstance;
    }

    public File preferencesDirectory() {
        return CayenneUserDir.getInstance().getDirectory();
    }

    public void storePreferences() {
        File prefFile = new File(this.preferencesDirectory(), PREFERENCES_NAME);
        try {
            if (!prefFile.exists()) {
                logObj.debug("Cannot save preferences - file " + prefFile + " does not exist");
                return;
            }
            this.save(new FileOutputStream(prefFile), "");
        }
        catch (IOException e) {
            logObj.debug("Error saving preferences: ", e);
        }
    }

    public void loadPreferences() {
        try {
            File prefsFile = new File(this.preferencesDirectory(), PREFERENCES_NAME);
            if (!prefsFile.exists() && !prefsFile.createNewFile()) {
                logObj.warn("Can't create preferences file " + prefsFile);
            }
            this.load(new FileInputStream(prefsFile));
        }
        catch (IOException e) {
            logObj.warn("Error creating preferences file.", e);
        }
    }
}

