/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.sql.Connection;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.DBWizardAction;
import org.apache.cayenne.modeler.dialog.db.ConnectionWizard;
import org.apache.cayenne.modeler.dialog.db.DbLoaderHelper;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.project.ProjectPath;

public class ImportDBAction
extends DBWizardAction {
    public static String getActionName() {
        return "Reengineer Database Schema";
    }

    public ImportDBAction(Application application) {
        super(ImportDBAction.getActionName(), application);
    }

    public void performAction(ActionEvent event) {
        DBConnectionInfo nodeInfo = this.preferredDataSource();
        String nodeKey = this.preferredDataSourceLabel(nodeInfo);
        ConnectionWizard connectWizard = new ConnectionWizard(this.getProjectController(), "Reengineer DB Schema: Connect to Database", nodeKey, nodeInfo);
        if (!connectWizard.startupAction()) {
            return;
        }
        Connection connection = connectWizard.getConnection();
        DbAdapter adapter = connectWizard.getAdapter();
        DBConnectionInfo dataSourceInfo = connectWizard.getConnectionInfo();
        final DbLoaderHelper helper = new DbLoaderHelper(this.getProjectController(), connection, adapter, dataSourceInfo.getUserName());
        Thread th = new Thread(new Runnable(){

            public void run() {
                helper.execute();
            }
        });
        th.start();
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.firstInstanceOf(DataDomain.class) != null;
    }
}

