/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.EventObject;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjAttributeListener;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CopyAttributeAction;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CutAttributeAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.ObjAttributeTableModel;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;

public class ObjEntityAttributeTab
extends JPanel
implements ObjEntityDisplayListener,
ObjEntityListener,
ObjAttributeListener,
ExistingSelectionProcessor {
    protected ProjectController mediator;
    protected CayenneTable table;

    public ObjEntityAttributeTab(ProjectController mediator) {
        this.mediator = mediator;
        this.init();
        this.initController();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        Application app = Application.getInstance();
        toolBar.add(app.getAction(CreateAttributeAction.getActionName()).buildButton());
        toolBar.add(app.getAction(ObjEntitySyncAction.getActionName()).buildButton());
        toolBar.addSeparator();
        toolBar.add(app.getAction(RemoveAttributeAction.getActionName()).buildButton());
        toolBar.addSeparator();
        toolBar.add(app.getAction(CutAttributeAction.getActionName()).buildButton());
        toolBar.add(app.getAction(CopyAttributeAction.getActionName()).buildButton());
        toolBar.add(app.getAction(PasteAction.getActionName()).buildButton());
        this.add((Component)toolBar, "North");
        this.table = new CayenneTable();
        this.table.setDefaultRenderer(String.class, new CellRenderer());
        JPopupMenu popup = new JPopupMenu();
        popup.add(app.getAction(RemoveAttributeAction.getActionName()).buildMenu());
        popup.addSeparator();
        popup.add(app.getAction(CutAttributeAction.getActionName()).buildMenu());
        popup.add(app.getAction(CopyAttributeAction.getActionName()).buildMenu());
        popup.add(app.getAction(PasteAction.getActionName()).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    private void initController() {
        this.mediator.addObjEntityDisplayListener(this);
        this.mediator.addObjEntityListener(this);
        this.mediator.addObjAttributeListener(this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ObjEntityAttributeTab.this.processExistingSelection(e);
            }
        });
        this.mediator.getApplication().getActionManager().setupCCP(this.table, CutAttributeAction.getActionName(), CopyAttributeAction.getActionName());
    }

    public void selectAttributes(ObjAttribute[] attrs) {
        ModelerUtil.updateActions(attrs.length, RemoveAttributeAction.getActionName(), CutAttributeAction.getActionName(), CopyAttributeAction.getActionName());
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        List listAttrs = model.getObjectList();
        int[] newSel = new int[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            newSel[i] = listAttrs.indexOf(attrs[i]);
        }
        this.table.select(newSel);
    }

    public void processExistingSelection(EventObject e) {
        if (e instanceof ChangeEvent) {
            this.table.clearSelection();
        }
        Attribute[] attrs = new ObjAttribute[]{};
        if (this.table.getSelectedRow() >= 0) {
            ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
            int[] sel = this.table.getSelectedRows();
            attrs = new ObjAttribute[sel.length];
            for (int i = 0; i < sel.length; ++i) {
                attrs[i] = model.getAttribute(sel[i]);
            }
            if (sel.length == 1) {
                UIUtil.scrollToSelectedRow(this.table);
            }
        }
        AttributeDisplayEvent ev = new AttributeDisplayEvent((Object)this, attrs, (Entity)this.mediator.getCurrentObjEntity(), this.mediator.getCurrentDataMap(), this.mediator.getCurrentDataDomain());
        this.mediator.fireObjAttributeDisplayEvent(ev);
    }

    public void objAttributeChanged(AttributeEvent e) {
        this.table.select(e.getAttribute());
    }

    public void objAttributeAdded(AttributeEvent e) {
        this.rebuildTable((ObjEntity)e.getEntity());
        this.table.select(e.getAttribute());
    }

    public void objAttributeRemoved(AttributeEvent e) {
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getAttribute());
        model.removeRow(e.getAttribute());
        this.table.select(ind);
    }

    public void currentObjEntityChanged(EntityDisplayEvent e) {
        if (e.getSource() == this) {
            return;
        }
        ObjEntity entity = (ObjEntity)e.getEntity();
        if (entity != null) {
            this.rebuildTable(entity);
        }
        if (e.isUnselectAttributes()) {
            this.table.clearSelection();
        }
    }

    protected void rebuildTable(ObjEntity entity) {
        ObjAttributeTableModel model = new ObjAttributeTableModel(entity, this.mediator, this);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        this.setUpTableStructure(model);
    }

    protected void setUpTableStructure(ObjAttributeTableModel model) {
        TableColumn inheritanceColumn = this.table.getColumnModel().getColumn(0);
        inheritanceColumn.setMinWidth(20);
        inheritanceColumn.setMaxWidth(20);
        TableColumn nameColumn = this.table.getColumnModel().getColumn(1);
        nameColumn.setMinWidth(150);
        TableColumn typeColumn = this.table.getColumnModel().getColumn(2);
        typeColumn.setMinWidth(150);
        JComboBox javaTypesCombo = CayenneWidgetFactory.createComboBox(ModelerUtil.getRegisteredTypeNames(), false);
        AutoCompletion.enable(javaTypesCombo, false, true);
        typeColumn.setCellEditor(CayenneWidgetFactory.createCellEditor(javaTypesCombo));
        TableColumn lockColumn = this.table.getColumnModel().getColumn(5);
        lockColumn.setMinWidth(100);
        TableColumn dbTypeColumn = this.table.getColumnModel().getColumn(4);
        dbTypeColumn.setMinWidth(120);
        TableColumn dbNameColumn = this.table.getColumnModel().getColumn(3);
        dbNameColumn.setMinWidth(150);
        if (model.getEntity().getDbEntity() != null) {
            JComboBox dbAttributesCombo = CayenneWidgetFactory.createComboBox(ModelerUtil.getDbAttributeNames(this.mediator, model.getEntity().getDbEntity()), true);
            AutoCompletion.enable(dbAttributesCombo);
            dbNameColumn.setCellEditor(CayenneWidgetFactory.createCellEditor(dbAttributesCombo));
        }
    }

    public void objEntityChanged(EntityEvent e) {
        if (e.getSource() == this) {
            return;
        }
        if (!(this.table.getModel() instanceof ObjAttributeTableModel)) {
            return;
        }
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        if (model.getDbEntity() != ((ObjEntity)e.getEntity()).getDbEntity()) {
            model.resetDbEntity();
            this.setUpTableStructure(model);
        }
    }

    public void objEntityAdded(EntityEvent e) {
    }

    public void objEntityRemoved(EntityEvent e) {
    }

    final class CellRenderer
    extends DefaultTableCellRenderer {
        CellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ObjAttributeTableModel model = (ObjAttributeTableModel)table.getModel();
            ObjAttribute attribute = model.getAttribute(row);
            if (column != 0) {
                if (!model.isCellEditable(row, column)) {
                    this.setForeground(Color.GRAY);
                } else {
                    this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
                }
                if (attribute.isInherited()) {
                    Font font = this.getFont();
                    Font newFont = font.deriveFont(2);
                    this.setFont(newFont);
                }
                this.setIcon(null);
            } else {
                if (attribute.isInherited()) {
                    ImageIcon objEntityIcon = ModelerUtil.buildIcon("icon-override.gif");
                    this.setIcon(objEntityIcon);
                }
                this.setText("");
            }
            this.setBackground(isSelected && !hasFocus ? table.getSelectionBackground() : table.getBackground());
            return this;
        }
    }
}

