/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import java.beans.Beans;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.DefaultListSelectionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.Selector;
import org.scopemvc.view.swing.ListSelectionParent;
import org.scopemvc.view.swing.Refreshable;
import org.scopemvc.view.swing.SwingBoundModel;
import org.scopemvc.view.util.ModelBindable;

public class SListSelectionModel
extends DefaultListSelectionModel
implements ModelBindable,
Refreshable {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$SListSelectionModel == null ? (class$org$scopemvc$view$swing$SListSelectionModel = SListSelectionModel.class$("org.scopemvc.view.swing.SListSelectionModel")) : class$org$scopemvc$view$swing$SListSelectionModel);
    private SwingBoundModel boundModel = new SwingBoundModel(this);
    private ListSelectionParent parent;
    static /* synthetic */ Class class$org$scopemvc$view$swing$SListSelectionModel;
    static /* synthetic */ Class class$java$util$HashSet;

    public SListSelectionModel(ListSelectionParent listSelectionParent, boolean bl) {
        if (listSelectionParent == null) {
            throw new IllegalArgumentException("SListSelectionModel cannot use a null ListSelectionParent");
        }
        this.parent = listSelectionParent;
        this.parent.setReadOnly(bl && !Beans.isDesignTime());
        this.boundModel.setSelectorMandatory(bl);
    }

    public final Object getBoundModel() {
        return this.boundModel.getBoundModel();
    }

    public final Selector getSelector() {
        return this.boundModel.getSelector();
    }

    public Object getViewValue() {
        Class clazz;
        if ((class$java$util$HashSet == null ? (class$java$util$HashSet = SListSelectionModel.class$("java.util.HashSet")) : class$java$util$HashSet).equals(clazz = this.boundModel.getPropertyClass())) {
            HashSet<Object> hashSet = new HashSet<Object>();
            int n = this.getMinSelectionIndex();
            while (n <= this.getMaxSelectionIndex()) {
                Object object;
                if (this.isSelectedIndex(n) && (object = this.parent.findElementAt(n)) != null) {
                    hashSet.add(this.parent.findElementAt(n));
                }
                ++n;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getViewValue: " + hashSet);
            }
            return hashSet;
        }
        int n = this.getMinSelectionIndex();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getViewValue: " + this.parent.findElementAt(n));
        }
        return this.parent.findElementAt(n);
    }

    public boolean isSelectorMandatory() {
        return this.boundModel.isSelectorMandatory();
    }

    public final void setBoundModel(Object object) {
        this.boundModel.setBoundModel(object);
    }

    public final void setSelector(Selector selector) {
        this.boundModel.setSelector(selector);
    }

    public final void setSelector(String string) {
        this.boundModel.setSelector(string);
    }

    public final void setSelectorString(String string) {
        this.setSelector(string);
    }

    public void updateFromProperty(Object object, boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateFromProperty: " + object + ", " + bl, new Throwable());
        }
        if (this.isSelectorMandatory()) {
            this.parent.setReadOnly(bl);
        } else if (this.getSelector() != null) {
            this.parent.setReadOnly(bl);
        }
        if (object == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("updateFromProperty: clear selection because null property value");
            }
            super.clearSelection();
            return;
        }
        if (object instanceof HashSet) {
            this.updateFromHashSet((HashSet)object);
        } else {
            this.updateFromObject(object);
        }
    }

    public void validationFailed(Exception exception) {
        this.parent.validationFailed(exception);
    }

    public void validationSuccess() {
        this.parent.validationSuccess();
    }

    public void refresh() {
        Object object = this.boundModel.getPropertyValue();
        boolean bl = this.boundModel.getPropertyReadOnly();
        this.updateFromProperty(object, bl);
    }

    protected void updateFromObject(Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateFromObject: value: " + object);
        }
        if (object == null) {
            if (!this.isSelectionEmpty()) {
                this.clearSelection();
            }
            return;
        }
        int n = this.parent.findIndexFor(object);
        if (n < 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("updateFromObject: value not in list of items for " + this.parent);
            }
            if (!this.isSelectionEmpty()) {
                this.clearSelection();
            }
        } else if (this.getMinSelectionIndex() != n) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("updateFromObject: selection index: " + n);
            }
            this.setSelectionInterval(n, n);
        }
    }

    protected void updateFromHashSet(HashSet hashSet) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateFromHashSet: value: " + hashSet);
        }
        if (hashSet == null || hashSet.size() < 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("updateFromHashSet: empty values");
            }
            if (!this.isSelectionEmpty()) {
                this.clearSelection();
            }
            return;
        }
        if (this.getSelectionMode() == 2) {
            if (hashSet.equals(this.getViewValue())) {
                return;
            }
            if (!this.isSelectionEmpty()) {
                this.clearSelection();
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                int n = this.parent.findIndexFor(iterator.next());
                if (this.isSelectedIndex(n)) continue;
                this.addSelectionInterval(n, n);
            }
        } else {
            int n = -1;
            int n2 = -1;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                int n3 = this.parent.findIndexFor(iterator.next());
                n2 = Math.max(n2, n3);
                n = n < 0 ? n2 : Math.min(n, n3);
            }
            if (n < 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("updateFromHashSet: values not in list of items for " + this.parent);
                }
                if (!this.isSelectionEmpty()) {
                    this.clearSelection();
                }
            } else if (this.getMinSelectionIndex() != n || this.getMaxSelectionIndex() != n2) {
                this.setSelectionInterval(n, n2);
            }
        }
    }

    protected void fireValueChanged(int n, int n2, boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireValueChanged: " + n + "," + n2 + "," + bl, new Throwable());
        }
        super.fireValueChanged(n, n2, bl);
        if (!bl) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("fireValueChanged: " + n);
            }
            if (this.getBoundModel() != null) {
                this.boundModel.updateModel();
            }
            this.parent.issueChangeSelectionControl();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

