/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import java.awt.event.ActionEvent;
import java.beans.Beans;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.Control;
import org.scopemvc.core.Controller;
import org.scopemvc.util.UIStrings;
import org.scopemvc.view.swing.SwingSubView;
import org.scopemvc.view.swing.SwingUtil;
import org.scopemvc.view.swing.SwingView;

public class SMenuItem
extends JMenuItem
implements SwingSubView {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$SMenuItem == null ? (class$org$scopemvc$view$swing$SMenuItem = SMenuItem.class$("org.scopemvc.view.swing.SMenuItem")) : class$org$scopemvc$view$swing$SMenuItem);
    private SwingView owner;
    private String controlID;
    static /* synthetic */ Class class$org$scopemvc$view$swing$SMenuItem;

    public SMenuItem() {
        this((String)null);
    }

    public SMenuItem(String string) {
        this(string, null, null);
    }

    public SMenuItem(String string, SwingView swingView) {
        this(string, swingView, null);
    }

    public SMenuItem(String string, SwingView swingView, KeyStroke keyStroke) {
        this.setControlID(string);
        this.setAccelerator(keyStroke);
        this.setOwner(swingView);
    }

    public String getControlID() {
        return this.controlID;
    }

    public SwingView getOwner() {
        return this.owner;
    }

    public void issueControl(Control control) {
        if (this.getOwner() == null) {
            LOG.warn("Cannot issue control: Owner not set");
        } else {
            SwingUtil.issueControl(this.getOwner(), control);
        }
    }

    public Controller getController() {
        return null;
    }

    public Object getBoundModel() {
        return null;
    }

    public void setControlID(String string) {
        this.controlID = string;
        if (this.controlID != null) {
            this.setText(UIStrings.get(this.controlID));
        }
    }

    public void setOwner(SwingView swingView) {
        this.owner = swingView;
        if (this.owner != null) {
            swingView.addSubView(this);
        }
        this.setEnabled(this.owner != null || Beans.isDesignTime());
    }

    public void setController(Controller controller) {
        throw new UnsupportedOperationException("Can't assign a Controller to a " + this.getClass());
    }

    public void setBoundModel(Object object) {
    }

    public void unsetOwner(SwingView swingView) {
        if (this.owner != swingView) {
            return;
        }
        if (this.owner != null) {
            this.owner.removeSubView(this);
        }
        this.owner = null;
        this.setEnabled(false);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this.controlID != null) {
            this.issueControl(this.createControl());
        } else {
            LOG.warn("Cannot issue a Control because no controlID is defined");
        }
    }

    protected Control createControl() {
        if (this.controlID == null) {
            throw new RuntimeException("Can't create a Control because no ControlID set.");
        }
        return new Control(this.controlID);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

