/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.DbEntitySyncAction;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.dbentity.PKCustomSequenceGeneratorPanel;
import org.apache.cayenne.modeler.editor.dbentity.PKDBGeneratorPanel;
import org.apache.cayenne.modeler.editor.dbentity.PKDefaultGeneratorPanel;
import org.apache.cayenne.modeler.editor.dbentity.PKGeneratorPanel;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class DbEntityTab
extends JPanel
implements ExistingSelectionProcessor,
DbEntityDisplayListener {
    static final String PK_DEFAULT_GENERATOR = "Default";
    static final String PK_DB_GENERATOR = "Database-Generated";
    static final String PK_CUSTOM_SEQUENCE_GENERATOR = "Custom Sequence";
    static final String[] PK_GENERATOR_TYPES = new String[]{"Default", "Database-Generated", "Custom Sequence"};
    protected ProjectController mediator;
    protected TextAdapter name;
    protected TextAdapter schema;
    protected JLabel schemaLabel;
    protected JComboBox pkGeneratorType;
    protected JPanel pkGeneratorDetail;
    protected CardLayout pkGeneratorDetailLayout;

    public DbEntityTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initView() {
        JToolBar toolBar = new JToolBar();
        Application app = Application.getInstance();
        toolBar.add(app.getAction(CreateObjEntityAction.getActionName()).buildButton());
        toolBar.add(app.getAction(DbEntitySyncAction.getActionName()).buildButton());
        toolBar.addSeparator();
        toolBar.add(app.getAction(CreateAttributeAction.getActionName()).buildButton());
        toolBar.add(app.getAction(CreateRelationshipAction.getActionName()).buildButton());
        this.name = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                DbEntityTab.this.setEntityName(text);
            }
        };
        this.schemaLabel = new JLabel("Schema:");
        this.schema = new TextAdapter(new JTextField()){

            protected void updateModel(String text) throws ValidationException {
                DbEntityTab.this.setSchema(text);
            }
        };
        this.pkGeneratorType = new JComboBox();
        this.pkGeneratorType.setEditable(false);
        this.pkGeneratorType.setModel(new DefaultComboBoxModel<String>(PK_GENERATOR_TYPES));
        this.pkGeneratorDetailLayout = new CardLayout();
        this.pkGeneratorDetail = new JPanel(this.pkGeneratorDetailLayout);
        this.pkGeneratorDetail.add((Component)new PKDefaultGeneratorPanel(this.mediator), PK_DEFAULT_GENERATOR);
        this.pkGeneratorDetail.add((Component)new PKDBGeneratorPanel(this.mediator), PK_DB_GENERATOR);
        this.pkGeneratorDetail.add((Component)new PKCustomSequenceGeneratorPanel(this.mediator), PK_CUSTOM_SEQUENCE_GENERATOR);
        FormLayout layout = new FormLayout("right:pref, 3dlu, fill:200dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("DbEntity Configuration");
        builder.append("DbEntity Name:", (Component)this.name.getComponent());
        builder.append((Component)this.schemaLabel, (Component)this.schema.getComponent());
        builder.appendSeparator("Primary Key");
        builder.append("PK Generation Strategy:", (Component)this.pkGeneratorType);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)builder.getPanel(), "North");
        mainPanel.add((Component)this.pkGeneratorDetail, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)toolBar, "North");
        this.add((Component)mainPanel, "Center");
    }

    private void initController() {
        this.mediator.addDbEntityDisplayListener(this);
        this.pkGeneratorType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DbEntityTab.this.pkGeneratorDetailLayout.show(DbEntityTab.this.pkGeneratorDetail, (String)DbEntityTab.this.pkGeneratorType.getSelectedItem());
                for (int i = 0; i < DbEntityTab.this.pkGeneratorDetail.getComponentCount(); ++i) {
                    if (!DbEntityTab.this.pkGeneratorDetail.getComponent(i).isVisible()) continue;
                    DbEntity entity = DbEntityTab.this.mediator.getCurrentDbEntity();
                    PKGeneratorPanel panel = (PKGeneratorPanel)DbEntityTab.this.pkGeneratorDetail.getComponent(i);
                    panel.onInit(entity);
                    break;
                }
            }
        });
    }

    public void processExistingSelection(EventObject e) {
        EntityDisplayEvent ede = new EntityDisplayEvent((Object)this, (Entity)this.mediator.getCurrentDbEntity(), this.mediator.getCurrentDataMap(), this.mediator.getCurrentDataDomain());
        this.mediator.fireDbEntityDisplayEvent(ede);
    }

    public void currentDbEntityChanged(EntityDisplayEvent e) {
        DbEntity entity = (DbEntity)e.getEntity();
        if (entity == null) {
            return;
        }
        for (int i = 0; i < this.pkGeneratorDetail.getComponentCount(); ++i) {
            ((PKGeneratorPanel)this.pkGeneratorDetail.getComponent(i)).setDbEntity(entity);
        }
        if (!e.isEntityChanged()) {
            return;
        }
        this.name.setText(entity.getName());
        this.schema.setText(entity.getSchema());
        String type = PK_DEFAULT_GENERATOR;
        if (entity.getPrimaryKeyGenerator() != null) {
            type = PK_CUSTOM_SEQUENCE_GENERATOR;
        } else {
            for (DbAttribute a : entity.getPrimaryKeys()) {
                if (!a.isGenerated()) continue;
                type = PK_DB_GENERATOR;
                break;
            }
        }
        this.schemaLabel.setEnabled(true);
        this.schema.getComponent().setEnabled(true);
        this.pkGeneratorDetail.setVisible(true);
        this.pkGeneratorType.setVisible(true);
        this.pkGeneratorType.setSelectedItem(type);
        this.pkGeneratorDetailLayout.show(this.pkGeneratorDetail, type);
    }

    void setEntityName(String newName) {
        DbEntity entity;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((entity = this.mediator.getCurrentDbEntity()) == null || Util.nullSafeEquals((Object)newName, (Object)entity.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Entity name is required.");
        }
        if (entity.getDataMap().getDbEntity(newName) != null) {
            throw new ValidationException("There is another entity with name '" + newName + "'.");
        }
        EntityEvent e = new EntityEvent((Object)this, (Entity)entity, entity.getName());
        entity.setName(newName);
        this.mediator.fireDbEntityEvent(e);
    }

    void setSchema(String text) {
        DbEntity ent;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((ent = this.mediator.getCurrentDbEntity()) != null && !Util.nullSafeEquals((Object)ent.getSchema(), (Object)text)) {
            ent.setSchema(text);
            this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, (Entity)ent));
        }
    }
}

