/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.util.Comparator;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.query.Query;

public class Comparators {
    private static final Comparator dataDomainChildrenComparator = new DataDomainChildrenComparator();
    private static final Comparator dataMapChildrenComparator = new DataMapChildrenComparator();
    private static final Comparator entityChildrenComparator = new EntityChildrenComparator();
    private static final Comparator namedObjectComparator = new NamedObjectComparator();

    public static Comparator getDataDomainChildrenComparator() {
        return dataDomainChildrenComparator;
    }

    public static Comparator getDataMapChildrenComparator() {
        return dataMapChildrenComparator;
    }

    public static Comparator getEntityChildrenComparator() {
        return entityChildrenComparator;
    }

    public static Comparator getNamedObjectComparator() {
        return namedObjectComparator;
    }

    static final class EntityChildrenComparator
    extends NamedObjectComparator {
        EntityChildrenComparator() {
        }

        public int compare(Object o1, Object o2) {
            int delta = EntityChildrenComparator.getClassWeight(o1) - EntityChildrenComparator.getClassWeight(o2);
            if (delta != 0) {
                return delta;
            }
            return super.compare(o1, o2);
        }

        private static int getClassWeight(Object o) {
            if (o instanceof Entity) {
                return 1;
            }
            if (o instanceof Attribute) {
                return 2;
            }
            if (o instanceof Relationship) {
                return 3;
            }
            return Integer.MAX_VALUE;
        }
    }

    static final class DataMapChildrenComparator
    extends NamedObjectComparator {
        DataMapChildrenComparator() {
        }

        public int compare(Object o1, Object o2) {
            int delta = DataMapChildrenComparator.getClassWeight(o1) - DataMapChildrenComparator.getClassWeight(o2);
            if (delta != 0) {
                return delta;
            }
            return super.compare(o1, o2);
        }

        private static int getClassWeight(Object o) {
            if (o instanceof DataMap) {
                return 1;
            }
            if (o instanceof ObjEntity) {
                return 2;
            }
            if (o instanceof DbEntity) {
                return 3;
            }
            if (o instanceof Procedure) {
                return 4;
            }
            if (o instanceof Query) {
                return 5;
            }
            return Integer.MAX_VALUE;
        }
    }

    static final class DataDomainChildrenComparator
    extends NamedObjectComparator {
        DataDomainChildrenComparator() {
        }

        public int compare(Object o1, Object o2) {
            int delta = DataDomainChildrenComparator.getClassWeight(o1) - DataDomainChildrenComparator.getClassWeight(o2);
            if (delta != 0) {
                return delta;
            }
            return super.compare(o1, o2);
        }

        private static int getClassWeight(Object o) {
            if (o instanceof DataMap) {
                return 1;
            }
            if (o instanceof DataNode) {
                return 2;
            }
            return Integer.MAX_VALUE;
        }
    }

    static class NamedObjectComparator
    implements Comparator {
        NamedObjectComparator() {
        }

        public int compare(Object o1, Object o2) {
            String name1 = ModelerUtil.getObjectName(o1);
            String name2 = ModelerUtil.getObjectName(o2);
            if (name1 == null) {
                return name2 != null ? -1 : 0;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }
}

