/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.instrument;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JpaUnitNameParser {
    static final String DESCRIPTOR_LOCATION = "META-INF/persistence.xml";
    static final String PERSISTENCE_UNIT = "persistence-unit";
    static final String NAME = "name";
    private SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public JpaUnitNameParser() {
        this.parserFactory.setNamespaceAware(true);
    }

    Collection<String> getUnitNames() {
        ArrayList<String> unitNames = new ArrayList<String>(5);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> descriptors = loader.getResources(DESCRIPTOR_LOCATION);
            while (descriptors.hasMoreElements()) {
                String descriptorURL = descriptors.nextElement().toExternalForm();
                this.appendUnitNames(unitNames, new InputSource(descriptorURL));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error inspecting persistence descriptors", e);
        }
        return unitNames;
    }

    private void appendUnitNames(final Collection<String> unitNames, InputSource in) throws Exception {
        SAXParser parser = this.parserFactory.newSAXParser();
        parser.parse(in, new DefaultHandler(){

            public void error(SAXParseException e) throws SAXException {
                throw e;
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                String name;
                if (JpaUnitNameParser.PERSISTENCE_UNIT.equals(qName) && (name = attributes.getValue("", JpaUnitNameParser.NAME)) != null) {
                    unitNames.add(name);
                }
            }
        });
    }
}

