/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.CallbackMap;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.util.NameConverter;

public abstract class AbstractCreateCallbackMethodAction
extends CayenneAction {
    public AbstractCreateCallbackMethodAction(String actionName, Application application) {
        super(actionName, application);
    }

    public abstract CallbackMap getCallbackMap();

    public String getIconName() {
        return "icon-create-method.gif";
    }

    public final void performAction(ActionEvent e) {
        String methodName;
        CallbackType callbackType = this.getProjectController().getCurrentCallbackType();
        String methodNamePrefix = this.toMethodName(callbackType.getType());
        if (!this.getCallbackMap().getCallbackDescriptor(callbackType.getType()).getCallbackMethods().contains(methodNamePrefix)) {
            methodName = methodNamePrefix;
        } else {
            int counter = 1;
            do {
                methodName = methodNamePrefix + counter;
                ++counter;
            } while (this.getCallbackMap().getCallbackDescriptor(callbackType.getType()).getCallbackMethods().contains(methodName));
        }
        this.getCallbackMap().getCallbackDescriptor(callbackType.getType()).addCallbackMethod(methodName);
        CallbackMethodEvent ce = new CallbackMethodEvent(e.getSource(), null, methodName, 2);
        this.getProjectController().fireCallbackMethodEvent(ce);
    }

    private String toMethodName(LifecycleEvent event) {
        return "on" + NameConverter.underscoredToJava(event.name(), true);
    }
}

