/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.project.ProjectPath;

public class CreateAttributeAction
extends CayenneAction {
    public static String getActionName() {
        return "Create Attribute";
    }

    public CreateAttributeAction(Application application) {
        super(CreateAttributeAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-attribute.gif";
    }

    public void performAction(ActionEvent e) {
        if (this.getProjectController().getCurrentObjEntity() != null) {
            this.createObjAttribute();
        } else if (this.getProjectController().getCurrentDbEntity() != null) {
            this.createDbAttribute();
        }
    }

    public void createObjAttribute() {
        ProjectController mediator = this.getProjectController();
        ObjEntity objEntity = mediator.getCurrentObjEntity();
        ObjAttribute attr = (ObjAttribute)NamedObjectFactory.createObject(ObjAttribute.class, objEntity);
        objEntity.addAttribute(attr);
        CreateAttributeAction.fireObjAttributeEvent(this, mediator, objEntity, attr);
    }

    static void fireObjAttributeEvent(Object src, ProjectController mediator, ObjEntity objEntity, ObjAttribute attr) {
        mediator.fireObjAttributeEvent(new AttributeEvent(src, (Attribute)attr, (Entity)objEntity, 2));
        AttributeDisplayEvent ade = new AttributeDisplayEvent(src, attr, (Entity)objEntity, mediator.getCurrentDataMap(), mediator.getCurrentDataDomain());
        mediator.fireObjAttributeDisplayEvent(ade);
    }

    public void createDbAttribute() {
        DbEntity dbEntity = this.getProjectController().getCurrentDbEntity();
        DbAttribute attr = (DbAttribute)NamedObjectFactory.createObject(DbAttribute.class, dbEntity);
        dbEntity.addAttribute(attr);
        ProjectController mediator = this.getProjectController();
        CreateAttributeAction.fireDbAttributeEvent(this, mediator, dbEntity, attr);
    }

    static void fireDbAttributeEvent(Object src, ProjectController mediator, DbEntity dbEntity, DbAttribute attr) {
        mediator.fireDbAttributeEvent(new AttributeEvent(src, (Attribute)attr, (Entity)dbEntity, 2));
        AttributeDisplayEvent ade = new AttributeDisplayEvent(src, attr, (Entity)dbEntity, mediator.getCurrentDataMap(), mediator.getCurrentDataDomain());
        mediator.fireDbAttributeDisplayEvent(ade);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.firstInstanceOf(Entity.class) != null;
    }
}

