/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.project.ProjectPath;

public class CreateDbEntityAction
extends CayenneAction {
    public static String getActionName() {
        return "Create DbEntity";
    }

    public CreateDbEntityAction(Application application) {
        super(CreateDbEntityAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-dbentity.gif";
    }

    public void performAction(ActionEvent e) {
        ProjectController mediator = this.getProjectController();
        DbEntity entity = this.createEntity(mediator.getCurrentDataMap());
        CreateDbEntityAction.fireDbEntityEvent(this, mediator, entity);
    }

    static void fireDbEntityEvent(Object src, ProjectController mediator, DbEntity entity) {
        mediator.fireDbEntityEvent(new EntityEvent(src, (Entity)entity, 2));
        EntityDisplayEvent displayEvent = new EntityDisplayEvent(src, entity, mediator.getCurrentDataMap(), mediator.getCurrentDataNode(), mediator.getCurrentDataDomain());
        displayEvent.setMainTabFocus(true);
        mediator.fireDbEntityDisplayEvent(displayEvent);
    }

    protected DbEntity createEntity(DataMap map) {
        DbEntity entity = (DbEntity)NamedObjectFactory.createObject(DbEntity.class, map);
        entity.setSchema(map.getDefaultSchema());
        map.addDbEntity(entity);
        return entity;
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.firstInstanceOf(DataMap.class) != null;
    }
}

