/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.objentity.EntitySyncController;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.util.EntityMergeSupport;

public class DbEntitySyncAction
extends CayenneAction {
    public static String getActionName() {
        return "Sync Dependent ObjEntities with DbEntity";
    }

    public DbEntitySyncAction(Application application) {
        super(DbEntitySyncAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-sync.gif";
    }

    public void performAction(ActionEvent e) {
        this.synchDbEntity();
    }

    protected void synchDbEntity() {
        ProjectController mediator = this.getProjectController();
        DbEntity dbEntity = mediator.getCurrentDbEntity();
        if (dbEntity != null) {
            Iterator<ObjEntity> it = dbEntity.getDataMap().getMappedEntities(dbEntity).iterator();
            if (!it.hasNext()) {
                return;
            }
            EntityMergeSupport merger = new EntitySyncController((CayenneController)Application.getInstance().getFrameController(), dbEntity).createMerger();
            if (merger == null) {
                return;
            }
            while (it.hasNext()) {
                ObjEntity entity = it.next();
                if (!merger.synchronizeWithDbEntity(entity)) continue;
                mediator.fireObjEntityEvent(new EntityEvent((Object)this, (Entity)entity, 1));
            }
        }
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.firstInstanceOf(DbEntity.class) != null;
    }
}

