/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorController;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CodeGeneratorControllerBase
extends CayenneController {
    public static final String SELECTED_PROPERTY = "selected";
    protected DataMap dataMap;
    protected ValidationResult validation;
    protected List<ObjEntity> entities;
    protected Set selectedEntities;
    protected transient ObjEntity currentEntity;

    public CodeGeneratorControllerBase(CayenneController parent, DataMap dataMap) {
        super(parent);
        this.dataMap = dataMap;
        this.entities = new ArrayList<ObjEntity>(dataMap.getObjEntities());
        this.selectedEntities = new HashSet();
    }

    @Override
    public abstract Component getView();

    public void validate(GeneratorController validator) {
        ValidationResult validationBuffer = new ValidationResult();
        if (validator != null) {
            for (ObjEntity entity : this.entities) {
                validator.validateEntity(validationBuffer, entity, false);
            }
        }
        this.validation = validationBuffer;
    }

    public boolean updateSelection(Predicate predicate) {
        boolean modified = false;
        for (ObjEntity entity : this.entities) {
            boolean select = predicate.evaluate(entity);
            if (select) {
                if (!this.selectedEntities.add(entity.getName())) continue;
                modified = true;
                continue;
            }
            if (!this.selectedEntities.remove(entity.getName())) continue;
            modified = true;
        }
        if (modified) {
            this.firePropertyChange(SELECTED_PROPERTY, null, null);
        }
        return modified;
    }

    public Collection<Embeddable> getSelectedEmbeddables() {
        return this.dataMap.getEmbeddables();
    }

    public List<ObjEntity> getSelectedEntities() {
        ArrayList<ObjEntity> selected = new ArrayList<ObjEntity>(this.selectedEntities.size());
        for (ObjEntity entity : this.entities) {
            if (!this.selectedEntities.contains(entity.getName())) continue;
            selected.add(entity);
        }
        return selected;
    }

    public int getSelectedEntitiesSize() {
        return this.selectedEntities.size();
    }

    public List getEntities() {
        return this.entities;
    }

    public String getProblem(String entityName) {
        if (this.validation == null) {
            return null;
        }
        List<ValidationFailure> failures = this.validation.getFailures(entityName);
        if (failures.isEmpty()) {
            return null;
        }
        return failures.get(0).getDescription();
    }

    public boolean isSelected() {
        return this.currentEntity != null ? this.selectedEntities.contains(this.currentEntity.getName()) : false;
    }

    public void setSelected(boolean selectedFlag) {
        if (this.currentEntity == null) {
            return;
        }
        if (selectedFlag) {
            if (this.selectedEntities.add(this.currentEntity.getName())) {
                this.firePropertyChange(SELECTED_PROPERTY, null, null);
            }
        } else if (this.selectedEntities.remove(this.currentEntity.getName())) {
            this.firePropertyChange(SELECTED_PROPERTY, null, null);
        }
    }

    public ObjEntity getCurrentEntity() {
        return this.currentEntity;
    }

    public void setCurrentEntity(ObjEntity currentEntity) {
        this.currentEntity = currentEntity;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }
}

