/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.map.naming.NamingStrategy;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.modeler.ModelerPreferences;
import org.apache.cayenne.modeler.util.CayenneDialog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbLoaderOptionsDialog
extends CayenneDialog {
    private static final Log logObj = LogFactory.getLog(DbLoaderOptionsDialog.class);
    private static final String STRATEGIES_PREFERENCE = "recent.preferences";
    private static final Vector<String> PREDEFINED_STRATEGIES = new Vector();
    public static final int CANCEL = 0;
    public static final int SELECT = 1;
    protected JLabel schemaLabel;
    protected JComboBox schemaSelector;
    protected JTextField tableNamePatternField;
    protected JCheckBox loadProcedures;
    protected JCheckBox meaningfulPk;
    protected JTextField procNamePatternField;
    protected JLabel procedureLabel;
    protected JButton selectButton;
    protected JButton cancelButton;
    protected JComboBox strategyCombo;
    protected NamingStrategy strategy;
    protected int choice;

    public DbLoaderOptionsDialog(Collection schemas, String dbUserName, boolean loadProcedures) {
        super((Frame)Application.getFrame(), "Reengineer DB Schema: Select Options");
        this.init();
        this.initController();
        this.initFromModel(schemas, dbUserName, loadProcedures);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.centerWindow();
    }

    protected void init() {
        this.selectButton = new JButton("Continue");
        this.cancelButton = new JButton("Cancel");
        this.schemaSelector = new JComboBox();
        this.tableNamePatternField = new JTextField();
        this.procNamePatternField = new JTextField();
        this.loadProcedures = new JCheckBox();
        this.meaningfulPk = new JCheckBox();
        this.strategyCombo = new JComboBox();
        this.strategyCombo.setEditable(true);
        FormLayout layout = new FormLayout("right:pref, 3dlu, fill:max(170dlu;pref):grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        this.schemaLabel = builder.append("Select Schema:", (Component)this.schemaSelector);
        builder.append("Table Name Pattern:", (Component)this.tableNamePatternField);
        builder.append("Load Procedures:", (Component)this.loadProcedures);
        this.procedureLabel = builder.append("Procedure Name Pattern:", (Component)this.procNamePatternField);
        builder.append("Naming Strategy:", (Component)this.strategyCombo);
        builder.append("Meaningful PK", (Component)this.meaningfulPk);
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.cancelButton);
        buttons.add(this.selectButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.getContentPane().add((Component)buttons, "South");
    }

    protected void initController() {
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbLoaderOptionsDialog.this.processSelect();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbLoaderOptionsDialog.this.processCancel();
            }
        });
        this.loadProcedures.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DbLoaderOptionsDialog.this.procNamePatternField.setEnabled(DbLoaderOptionsDialog.this.loadProcedures.isSelected());
                DbLoaderOptionsDialog.this.procedureLabel.setEnabled(DbLoaderOptionsDialog.this.loadProcedures.isSelected());
            }
        });
    }

    protected void initFromModel(Collection<String> schemas, String dbUserName, boolean shouldLoadProcedures) {
        this.choice = 0;
        this.tableNamePatternField.setText("%");
        this.loadProcedures.setSelected(shouldLoadProcedures);
        this.procNamePatternField.setText("%");
        this.procNamePatternField.setEnabled(shouldLoadProcedures);
        this.procedureLabel.setEnabled(shouldLoadProcedures);
        ModelerPreferences pref = ModelerPreferences.getPreferences();
        Vector arr = pref.getVector(STRATEGIES_PREFERENCE, PREDEFINED_STRATEGIES);
        this.strategyCombo.setModel(new DefaultComboBoxModel(arr));
        boolean showSchemaSelector = schemas != null && !schemas.isEmpty();
        this.schemaSelector.setVisible(showSchemaSelector);
        this.schemaLabel.setVisible(showSchemaSelector);
        if (showSchemaSelector) {
            this.schemaSelector.setModel(new DefaultComboBoxModel<Object>(schemas.toArray()));
            if (dbUserName != null) {
                for (String schema : schemas) {
                    if (!dbUserName.equalsIgnoreCase(schema)) continue;
                    this.schemaSelector.setSelectedItem(schema);
                    break;
                }
            }
        }
    }

    public int getChoice() {
        return this.choice;
    }

    private void processSelect() {
        try {
            ClassLoadingService classLoader = Application.getInstance().getClassLoadingService();
            String strategyClass = (String)this.strategyCombo.getSelectedItem();
            this.strategy = (NamingStrategy)classLoader.loadClass(strategyClass).newInstance();
            ModelerPreferences pref = ModelerPreferences.getPreferences();
            Vector arr = pref.getVector(STRATEGIES_PREFERENCE, PREDEFINED_STRATEGIES);
            arr.remove(strategyClass);
            arr.add(0, strategyClass);
            pref.setProperty(STRATEGIES_PREFERENCE, arr);
        }
        catch (Throwable th) {
            logObj.error("Error in " + this.getClass().getName(), th);
            JOptionPane.showMessageDialog(this, "Naming Strategy Initialization Error: " + th.getMessage(), "Naming Strategy Initialization Error", 0);
            return;
        }
        this.choice = 1;
        this.setVisible(false);
    }

    private void processCancel() {
        this.choice = 0;
        this.setVisible(false);
    }

    public String getSelectedSchema() {
        String schema = (String)this.schemaSelector.getSelectedItem();
        return "".equals(schema) ? null : schema;
    }

    public String getTableNamePattern() {
        return "".equals(this.tableNamePatternField.getText()) ? null : this.tableNamePatternField.getText();
    }

    public boolean isLoadingProcedures() {
        return this.loadProcedures.isSelected();
    }

    public boolean isMeaningfulPk() {
        return this.meaningfulPk.isSelected();
    }

    public String getProcedureNamePattern() {
        return "".equals(this.procNamePatternField.getText()) ? null : this.procNamePatternField.getText();
    }

    public NamingStrategy getNamingStrategy() {
        return this.strategy;
    }

    static {
        PREDEFINED_STRATEGIES.add("org.apache.cayenne.map.naming.BasicNamingStrategy");
        PREDEFINED_STRATEGIES.add("org.apache.cayenne.map.naming.SmartNamingStrategy");
    }
}

