/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.CayenneMapEntry;

public final class CellRenderers {
    protected static ImageIcon domainIcon = ModelerUtil.buildIcon("icon-dom.gif");
    protected static ImageIcon nodeIcon = ModelerUtil.buildIcon("icon-node.gif");
    protected static ImageIcon mapIcon = ModelerUtil.buildIcon("icon-datamap.gif");
    protected static ImageIcon dbEntityIcon = ModelerUtil.buildIcon("icon-dbentity.gif");
    protected static ImageIcon objEntityIcon = ModelerUtil.buildIcon("icon-objentity.gif");
    protected static ImageIcon relationshipIcon;
    protected static ImageIcon attributeIcon;
    protected static ImageIcon procedureIcon;
    protected static ImageIcon queryIcon;

    public static ImageIcon iconForObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DataDomain) {
            return domainIcon;
        }
        if (object instanceof DataNode) {
            return nodeIcon;
        }
        if (object instanceof DataMap) {
            return mapIcon;
        }
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            if (entity instanceof DbEntity) {
                return dbEntityIcon;
            }
            if (entity instanceof ObjEntity) {
                return objEntityIcon;
            }
        } else {
            if (object instanceof Procedure) {
                return procedureIcon;
            }
            if (object instanceof Query) {
                return queryIcon;
            }
            if (object instanceof Relationship) {
                return relationshipIcon;
            }
            if (object instanceof Attribute) {
                return attributeIcon;
            }
        }
        return null;
    }

    public static TreeCellRenderer treeRenderer() {
        return new TreeRenderer();
    }

    public static ListCellRenderer listRenderer() {
        return new ListRenderer(false);
    }

    public static ListCellRenderer listRendererWithIcons() {
        return new ListRenderer(true);
    }

    public static ListCellRenderer entityListRendererWithIcons(MappingNamespace namespace) {
        return new EntityRenderer(namespace);
    }

    public static TableCellRenderer entityTableRendererWithIcons(ProjectController mediator) {
        return new EntityTableRenderer(mediator);
    }

    public static String asString(Object obj) {
        return CellRenderers.asString(obj, Application.getInstance().getFrameController().getProjectController().getCurrentDataMap());
    }

    public static String asString(Object obj, MappingNamespace namespace) {
        if (obj instanceof CayenneMapEntry) {
            Entity entity;
            DataMap dataMap;
            CayenneMapEntry mapObject = (CayenneMapEntry)obj;
            String label = mapObject.getName();
            if (mapObject instanceof Entity && (dataMap = (entity = (Entity)mapObject).getDataMap()) != null && dataMap != namespace) {
                label = label + " (" + dataMap.getName() + ")";
            }
            return label;
        }
        if (obj instanceof DataMap) {
            return ((DataMap)obj).getName();
        }
        return obj == null ? null : String.valueOf(obj);
    }

    static {
        procedureIcon = ModelerUtil.buildIcon("icon-stored-procedure.gif");
        queryIcon = ModelerUtil.buildIcon("icon-query.gif");
        relationshipIcon = ModelerUtil.buildIcon("icon-relationship.gif");
        attributeIcon = ModelerUtil.buildIcon("icon-attribute.gif");
    }

    static final class EntityTableRenderer
    extends DefaultTableCellRenderer {
        private ProjectController mediator;

        public EntityTableRenderer(ProjectController mediator) {
            this.mediator = mediator;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object oldValue = value;
            value = CellRenderers.asString(value, this.mediator.getCurrentDataMap());
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setIcon(CellRenderers.iconForObject(oldValue));
            return this;
        }
    }

    static final class TreeRenderer
    extends DefaultTreeCellRenderer {
        TreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            this.setIcon(CellRenderers.iconForObject(node.getUserObject()));
            return this;
        }
    }

    static final class ListRenderer
    extends DefaultListCellRenderer {
        boolean showIcons;

        ListRenderer(boolean showIcons) {
            this.showIcons = showIcons;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String renderedValue = ModelerUtil.getObjectName(value);
            if (renderedValue == null) {
                renderedValue = " ";
            }
            super.getListCellRendererComponent((JList<?>)list, renderedValue, index, isSelected, cellHasFocus);
            if (this.showIcons) {
                this.setIcon(CellRenderers.iconForObject(value));
            }
            return this;
        }
    }

    static final class EntityRenderer
    extends DefaultListCellRenderer {
        MappingNamespace namespace;

        EntityRenderer(MappingNamespace namespace) {
            this.namespace = namespace;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageIcon icon = CellRenderers.iconForObject(value);
            value = CellRenderers.asString(value, this.namespace);
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(icon);
            return this;
        }
    }
}

