/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.objectstyle.ashwood.graph.Algorithm;
import org.objectstyle.ashwood.graph.DepthFirstStampSearch;
import org.objectstyle.ashwood.graph.DigraphIteration;

public class DFSReverseTopologicalSort
extends Algorithm {
    private DepthFirstStampSearch dfs;

    public DFSReverseTopologicalSort(DigraphIteration factory, Object firstVertex) {
        this.dfs = new DepthFirstStampSearch(factory, firstVertex);
    }

    public void reset(Object newFirstVertex) {
        this.dfs.reset(newFirstVertex);
    }

    public boolean hasNext() {
        return this.dfs.hasNext();
    }

    public Object next() {
        Object vertex;
        int stamp;
        do {
            vertex = this.dfs.next();
        } while ((stamp = this.dfs.getStamp()) != 2 && stamp != 3);
        return vertex;
    }

    public SortedMap sort() {
        TreeMap<Integer, Object> sortedVertices = new TreeMap<Integer, Object>(new ReverseComparator());
        int postOrder = 0;
        while (this.hasNext()) {
            sortedVertices.put(new Integer(++postOrder), this.next());
        }
        return sortedVertices;
    }
}

