/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.IntIndexSelector;
import org.scopemvc.core.ModelChangeEvent;
import org.scopemvc.core.ModelChangeEventSource;
import org.scopemvc.core.ModelChangeListener;
import org.scopemvc.core.PropertyManager;
import org.scopemvc.core.Selector;
import org.scopemvc.model.collection.ListModelAdaptor;
import org.scopemvc.model.collection.ListModelSource;
import org.scopemvc.view.swing.Refreshable;
import org.scopemvc.view.swing.SwingBoundModel;
import org.scopemvc.view.swing.SwingUtil;
import org.scopemvc.view.util.ModelBindable;

public abstract class SAbstractListModel
extends AbstractListModel
implements ModelBindable,
Refreshable,
ModelChangeListener {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$SAbstractListModel == null ? (class$org$scopemvc$view$swing$SAbstractListModel = SAbstractListModel.class$("org.scopemvc.view.swing.SAbstractListModel")) : class$org$scopemvc$view$swing$SAbstractListModel);
    private static final IntIndexSelector INDEX_SELECTOR = Selector.fromInt(0);
    private Selector sizeSelector;
    private Object listModel;
    private boolean sorted;
    private Comparator comparator;
    private SwingBoundModel boundModel = new SwingBoundModel(this);
    private Object shownModel;
    private PropertyManager manager;
    static /* synthetic */ Class class$org$scopemvc$view$swing$SAbstractListModel;

    public final Object getBoundModel() {
        return this.boundModel.getBoundModel();
    }

    public final Selector getSelector() {
        return this.boundModel.getSelector();
    }

    public final Object getViewValue() {
        return this.getShownModel();
    }

    public final Object getShownModel() {
        return this.shownModel;
    }

    public Selector getSizeSelector() {
        return this.sizeSelector;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public int getSize() {
        if (this.sizeSelector != null) {
            try {
                PropertyManager propertyManager = this.boundModel.getPropertyManager();
                if (propertyManager == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getSize: no manager for: " + this.shownModel + ": size 0");
                    }
                    return 0;
                }
                Integer n = (Integer)propertyManager.get(this.getBoundModel(), this.sizeSelector);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getSize: from (" + this.sizeSelector + "): size " + n);
                }
                return n;
            }
            catch (Exception exception) {
                LOG.warn("getSize: Can't get size using sizeSelector: " + this.sizeSelector, exception);
                return 0;
            }
        }
        if (this.shownModel instanceof List) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getSize: from java.util.List: size " + ((List)this.shownModel).size());
            }
            return ((List)this.shownModel).size();
        }
        if (this.shownModel instanceof Object[]) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getSize: from Object[]: size " + ((Object[])this.shownModel).length);
            }
            return ((Object[])this.shownModel).length;
        }
        if (this.shownModel instanceof ListModelAdaptor) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getSize: from adaptor: size " + ((ListModelAdaptor)this.shownModel).getSize());
            }
            return ((ListModelAdaptor)this.shownModel).getSize();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSize: from null shownModel: size 0");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getElementAt(int n) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getElementAt: " + n);
        }
        if (this.shownModel == null && this.getBoundModel() == null) {
            LOG.warn("getElementAt: null model trying to get element: " + n);
            return null;
        }
        if (this.shownModel instanceof List) {
            return ((List)this.shownModel).get(n);
        }
        if (this.shownModel instanceof Object[]) {
            return ((Object[])this.shownModel)[n];
        }
        if (this.shownModel instanceof ListModelAdaptor) {
            return ((ListModelAdaptor)this.shownModel).getElementAt(n);
        }
        try {
            IntIndexSelector intIndexSelector = INDEX_SELECTOR;
            synchronized (intIndexSelector) {
                INDEX_SELECTOR.setIndex(n);
                if (this.shownModel == null) {
                    Selector selector = this.boundModel.getSelector().deepClone();
                    selector.chain(INDEX_SELECTOR);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Indexed: " + selector);
                    }
                    return this.boundModel.getPropertyManager().get(this.getBoundModel(), selector);
                }
                if (this.manager != null) {
                    return this.manager.get(this.shownModel, INDEX_SELECTOR);
                }
            }
        }
        catch (Exception exception) {
            LOG.warn("Can't get element " + n + " from: " + this.shownModel, exception);
        }
        return null;
    }

    public final void setSelector(Selector selector) {
        this.boundModel.setSelector(selector);
    }

    public void setSelector(String string) {
        this.boundModel.setSelector(string);
    }

    public void setSelectorString(String string) {
        this.setSelector(string);
    }

    public void setSizeSelector(Selector selector) {
        this.sizeSelector = selector;
    }

    public void setSizeSelector(String string) {
        if (string == null) {
            this.setSizeSelector((Selector)null);
        } else {
            this.setSizeSelector(Selector.fromString(string));
        }
    }

    public void setSizeSelectorString(String string) {
        this.setSizeSelector(string);
    }

    public void setListModel(Object object) {
        this.listModel = object;
        this.setShownModel(this.listModel);
    }

    public void setSorted(boolean bl) {
        this.sorted = true;
        this.boundModel.updateFromModel(0);
    }

    public void setSorted(Comparator comparator) {
        if (comparator == null) {
            this.setSorted(false);
            this.comparator = null;
        } else {
            this.setSorted(true);
            this.comparator = comparator;
        }
        this.boundModel.updateFromModel(0);
    }

    public void setComparator(Comparator comparator) {
        this.setSorted(comparator);
    }

    public void setBoundModel(Object object) {
        this.boundModel.setBoundModel(object);
    }

    public void updateFromProperty(Object object, boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateFromProperty: " + object + ", " + bl);
        }
        this.setShownModel(object);
    }

    public void validationFailed(Exception exception) {
    }

    public void validationSuccess() {
    }

    public void refresh() {
        Object object = this.boundModel.getPropertyValue();
        boolean bl = this.boundModel.getPropertyReadOnly();
        this.updateFromProperty(object, bl);
    }

    public void modelChanged(final ModelChangeEvent modelChangeEvent) {
        SwingUtil.runFromSwingEventThread(new Runnable(){

            public void run() {
                SAbstractListModel.this.doModelChanged(modelChangeEvent);
            }
        });
    }

    protected final PropertyManager getManager() {
        return this.manager;
    }

    protected void setShownModel(Object object) {
        if (this.listModel != null && object != this.listModel) {
            return;
        }
        if (this.shownModel == object) {
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
            return;
        }
        if (this.shownModel instanceof ListModelAdaptor) {
            ((ListModelAdaptor)this.shownModel).removeModelChangeListeners();
        }
        if (this.shownModel instanceof ModelChangeEventSource) {
            ((ModelChangeEventSource)this.shownModel).removeModelChangeListener(this);
        }
        this.shownModel = object;
        if (this.isSorted() && this.shownModel instanceof Collection) {
            this.shownModel = new ListModelAdaptor(new ListModelSource((Collection)object));
            ((ListModelAdaptor)this.shownModel).setComparator(this.comparator);
            ((ListModelAdaptor)this.shownModel).setSorted(true);
        }
        if (this.shownModel != null) {
            this.manager = PropertyManager.getInstance(this.shownModel);
        }
        if (this.shownModel instanceof ModelChangeEventSource) {
            ((ModelChangeEventSource)this.shownModel).addModelChangeListener(this);
        }
        this.shownModelChanged();
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    protected void shownModelChanged() {
    }

    protected void doModelChanged(ModelChangeEvent modelChangeEvent) {
        Selector selector = modelChangeEvent.getSelector();
        int n = 0;
        int n2 = this.getSize() - 1;
        if (selector instanceof IntIndexSelector) {
            n2 = n = ((IntIndexSelector)selector).getIndex();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("modelChanged: " + modelChangeEvent.getModel() + ", selector is " + selector);
        }
        if (modelChangeEvent.getType() == 3) {
            return;
        }
        if (modelChangeEvent.getType() == 1) {
            this.fireIntervalAdded(this, n, n2);
        } else if (modelChangeEvent.getType() == 2) {
            this.fireIntervalRemoved(this, n, n2);
        } else if (modelChangeEvent.getType() == 0) {
            this.fireContentsChanged(this, n, n2);
        }
    }

    protected boolean containsElement(Object object) {
        int n = this.getSize();
        int n2 = 0;
        while (n2 < n) {
            Object object2 = this.getElementAt(n2);
            if (object2 == object || object2 != null && object2.equals(object)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Element " + object + " is contained in the bound list");
                }
                return true;
            }
            ++n2;
        }
        LOG.debug("Element " + object + " isn't contained in the bound list");
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

