/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.Control;
import org.scopemvc.core.PropertyView;
import org.scopemvc.core.Selector;
import org.scopemvc.view.swing.Refreshable;
import org.scopemvc.view.swing.SAction;
import org.scopemvc.view.swing.SwingBoundModel;
import org.scopemvc.view.swing.SwingView;
import org.scopemvc.view.util.ModelBindable;

public class SModelAction
extends SAction
implements ModelBindable,
PropertyView,
Refreshable {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$SModelAction == null ? (class$org$scopemvc$view$swing$SModelAction = SModelAction.class$("org.scopemvc.view.swing.SModelAction")) : class$org$scopemvc$view$swing$SModelAction);
    private SwingBoundModel boundModel = new SwingBoundModel(this);
    private Object shownModel;
    private Comparable valueTest;
    static /* synthetic */ Class class$org$scopemvc$view$swing$SModelAction;

    public SModelAction(String string) {
        super(string);
        this.setValueTest(new NotNullComparable());
    }

    public SModelAction(String string, SwingView swingView, Selector selector) {
        this(string, swingView, selector, new NotNullComparable());
    }

    public SModelAction(String string, SwingView swingView, Selector selector, Comparable comparable) {
        super(string, swingView);
        this.setSelector(selector);
        this.setValueTest(comparable);
    }

    public final Object getBoundModel() {
        return this.boundModel.getBoundModel();
    }

    public final Selector getSelector() {
        return this.boundModel.getSelector();
    }

    public final Object getViewValue() {
        return this.shownModel;
    }

    public Comparable getValueTest() {
        return this.valueTest;
    }

    public final void setSelector(Selector selector) {
        this.boundModel.setSelector(selector);
    }

    public void setSelector(String string) {
        this.boundModel.setSelector(string);
    }

    public void setSelectorString(String string) {
        this.setSelector(string);
    }

    public void setValueTest(Comparable comparable) {
        this.valueTest = comparable;
        this.updateEnabledState();
    }

    public void setBoundModel(Object object) {
        this.boundModel.setBoundModel(object);
    }

    public void updateFromProperty(Object object, boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateFromProperty: " + object + ", " + bl);
        }
        this.setShownModel(object);
    }

    public void validationFailed(Exception exception) {
    }

    public void validationSuccess() {
    }

    public void refresh() {
        Object object = this.boundModel.getPropertyValue();
        boolean bl = this.boundModel.getPropertyReadOnly();
        this.updateFromProperty(object, bl);
    }

    protected Control createControl() {
        Control control = super.createControl();
        if (LOG.isDebugEnabled()) {
            LOG.debug("createControl: Creating the control " + control + "with value " + this.shownModel);
        }
        control.setParameter(this.shownModel);
        return control;
    }

    private void setShownModel(Object object) {
        if (this.shownModel == object) {
            return;
        }
        this.shownModel = object;
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("updateEnabledState: Testing " + this.shownModel + " with test " + this.valueTest + ", result: " + this.valueTest.compareTo(this.shownModel));
            }
            this.setEnabled(this.valueTest.compareTo(this.shownModel) > 0);
        }
        catch (NullPointerException nullPointerException) {
            LOG.info("NPE when testing the view value with the valueTest. Assuming that this action: " + this.getName() + " is disabled");
            this.setEnabled(false);
        }
        catch (Exception exception) {
            LOG.warn("Could not test the view value with the valueTest", exception);
            this.setEnabled(false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class NotNullComparable
    implements Comparable {
        public int compareTo(Object object) {
            if (object == null) {
                return 0;
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? 1 : 0;
            }
            return 1;
        }

        public String toString() {
            return "NotNullComparable";
        }
    }
}

