/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.gen.StringUtils;
import org.apache.cayenne.map.CallbackDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityUtils {
    protected String subClassName;
    protected String superClassName;
    protected String baseClassName;
    protected String subPackageName;
    protected String superPackageName;
    protected String basePackageName;
    protected DataMap primaryDataMap;
    protected ObjEntity objEntity;
    protected Collection<String> callbackNames;

    public EntityUtils(DataMap dataMap, ObjEntity objEntity, String fqnBaseClass, String fqnSuperClass, String fqnSubClass) {
        StringUtils stringUtils = StringUtils.getInstance();
        this.baseClassName = stringUtils.stripPackageName(fqnBaseClass);
        this.basePackageName = stringUtils.stripClass(fqnBaseClass);
        this.superClassName = stringUtils.stripPackageName(fqnSuperClass);
        this.superPackageName = stringUtils.stripClass(fqnSuperClass);
        this.subClassName = stringUtils.stripPackageName(fqnSubClass);
        this.subPackageName = stringUtils.stripClass(fqnSubClass);
        this.primaryDataMap = dataMap;
        this.objEntity = objEntity;
        this.callbackNames = new ArrayList<String>();
        for (CallbackDescriptor cb : objEntity.getCallbackMap().getCallbacks()) {
            this.callbackNames.addAll(cb.getCallbackMethods());
        }
    }

    EntityUtils(DataMap dataMap, ObjEntity objEntity, String baseClassName, String basePackageName, String superClassName, String superPackageName, String subClassName, String subPackageName) {
        this.baseClassName = baseClassName;
        this.basePackageName = basePackageName;
        this.superClassName = superClassName;
        this.superPackageName = superPackageName;
        this.subClassName = subClassName;
        this.subPackageName = subPackageName;
        this.primaryDataMap = dataMap;
        this.objEntity = objEntity;
        this.callbackNames = new ArrayList<String>();
        for (CallbackDescriptor cb : objEntity.getCallbackMap().getCallbacks()) {
            this.callbackNames.addAll(cb.getCallbackMethods());
        }
    }

    public String getSubClassName() {
        return this.subClassName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public String getBaseClassName() {
        return this.baseClassName;
    }

    public String getSubPackageName() {
        return this.subPackageName;
    }

    public String getSuperPackageName() {
        return this.superPackageName;
    }

    public String getBasePackageName() {
        return this.basePackageName;
    }

    public DataMap getPrimaryDataMap() {
        return this.primaryDataMap;
    }

    public MappingNamespace getEntityResolver() {
        return this.primaryDataMap.getNamespace();
    }

    public boolean isAbstract() {
        return this.isAbstract(this.objEntity);
    }

    public boolean isAbstract(ObjEntity anObjEntity) {
        if (anObjEntity == null) {
            return false;
        }
        return this.objEntity.isAbstract();
    }

    public boolean hasToManyRelationships() {
        return this.hasToManyRelationships(this.objEntity);
    }

    public boolean hasToManyRelationships(ObjEntity anObjEntity) {
        if (anObjEntity == null) {
            return false;
        }
        for (ObjRelationship r : anObjEntity.getRelationships()) {
            if (!((Relationship)r).isToMany()) continue;
            return true;
        }
        return false;
    }

    public boolean hasToManyDeclaredRelationships() {
        return this.hasToManyDeclaredRelationships(this.objEntity);
    }

    public boolean hasToManyDeclaredRelationships(ObjEntity anObjEntity) {
        if (anObjEntity == null) {
            return false;
        }
        for (ObjRelationship r : anObjEntity.getDeclaredRelationships()) {
            if (!((Relationship)r).isToMany()) continue;
            return true;
        }
        return false;
    }

    public boolean hasToOneRelationships() {
        return this.hasToOneRelationships(this.objEntity);
    }

    public boolean hasToOneRelationships(ObjEntity anObjEntity) {
        if (anObjEntity == null) {
            return false;
        }
        for (ObjRelationship r : anObjEntity.getRelationships()) {
            if (((Relationship)r).isToMany()) continue;
            return true;
        }
        return false;
    }

    public boolean hasToOneDeclaredRelationships() {
        return this.hasToOneDeclaredRelationships(this.objEntity);
    }

    public boolean hasToOneDeclaredRelationships(ObjEntity anObjEntity) {
        if (anObjEntity == null) {
            return false;
        }
        for (ObjRelationship r : anObjEntity.getDeclaredRelationships()) {
            if (((Relationship)r).isToMany()) continue;
            return true;
        }
        return false;
    }

    public String getMapKeyType(ObjRelationship relationship) {
        ObjEntity targetEntity = (ObjEntity)relationship.getTargetEntity();
        if (relationship.getMapKey() == null) {
            DbEntity dbEntity = targetEntity.getDbEntity();
            if (dbEntity != null && dbEntity.getPrimaryKeys().size() > 1) {
                return ObjectId.class.getName();
            }
            return Object.class.getName();
        }
        ObjAttribute attribute = (ObjAttribute)targetEntity.getAttribute(relationship.getMapKey());
        if (attribute == null) {
            throw new CayenneRuntimeException("Invalid map key '" + relationship.getMapKey() + "', no matching attribute found");
        }
        return attribute.getType();
    }

    public Collection<String> getCallbackNames() {
        return this.callbackNames;
    }
}

