/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.objentity.ObjAttributeInfoDialogView;
import org.apache.cayenne.modeler.dialog.objentity.OverrideEmbeddableAttributeTableModel;
import org.apache.cayenne.modeler.editor.ObjAttributeTableModel;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.EntityTreeFilter;
import org.apache.cayenne.modeler.util.EntityTreeModel;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.swing.BindingBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjAttributeInfoDialog
extends CayenneController
implements TreeSelectionListener {
    private ObjAttributeTableModel model;
    private OverrideEmbeddableAttributeTableModel embeddableModel;
    private int row;
    protected ObjAttributeInfoDialogView view;
    protected ObjAttribute attribute;
    protected ObjAttribute attributeSaved;
    protected List<DbEntity> relTargets;
    protected ObjEntity objectTarget;
    protected List<ObjEntity> objectTargets;
    protected Map<String, Embeddable> stringToEmbeddables;
    protected List<String> embeddableNames;
    protected ProjectController mediator;
    private Object lastObjectType;

    public ObjAttributeInfoDialog(ProjectController mediator, int row, ObjAttributeTableModel model) {
        super(mediator);
        this.view = new ObjAttributeInfoDialogView(mediator);
        this.mediator = mediator;
        this.model = model;
        this.row = row;
        this.stringToEmbeddables = new HashMap<String, Embeddable>();
        this.embeddableNames = new ArrayList<String>();
        for (Embeddable emb : mediator.getEmbeddableNamesInCurRentDataDomain()) {
            this.stringToEmbeddables.put(emb.getClassName(), emb);
            this.embeddableNames.add(emb.getClassName());
        }
        this.initController(model.getAttribute(row));
    }

    @Override
    public Component getView() {
        return this.view;
    }

    public void startupAction() {
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    private void initController(ObjAttribute attr) {
        for (int i = 0; i < this.embeddableNames.size(); ++i) {
            ((DefaultComboBoxModel)this.view.getType().getModel()).addElement(this.embeddableNames.get(i).toString());
        }
        this.attribute = attr;
        this.attributeSaved = this.attribute instanceof EmbeddedAttribute || this.embeddableNames.contains(this.attribute.getType()) ? new EmbeddedAttribute() : new ObjAttribute();
        this.copyObjAttribute(this.attributeSaved, this.attribute);
        this.relTargets = new ArrayList<DbEntity>(this.attribute.getEntity().getDataMap().getDbEntities());
        this.view.getPathBrowser().addTreeSelectionListener(this);
        this.objectTarget = (ObjEntity)attr.getEntity();
        if (this.objectTarget != null) {
            this.updateTargetCombo(this.objectTarget.getDbEntity());
        }
        this.view.getAttributeName().setText(this.attribute.getName());
        if (this.attribute.getDbAttributePath() != null) {
            if (this.attribute.getDbAttributePath().contains(".")) {
                String path = this.attribute.getDbAttributePath();
                this.view.getCurrentPathLabel().setText(path.replace(".", " -> "));
            } else {
                this.view.getCurrentPathLabel().setText(this.attribute.getDbAttributePath());
            }
        } else {
            this.view.getCurrentPathLabel().setText("");
        }
        this.view.getSourceEntityLabel().setText(this.attribute.getEntity().getName());
        this.view.getType().setSelectedItem(this.attribute.getType());
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getCancelButton(), "closeAction()");
        builder.bindToAction(this.view.getSelectPathButton(), "setPath(true)");
        builder.bindToAction(this.view.getSaveButton(), "saveMapping()");
        if (this.view.getPathBrowser().getModel() == null) {
            Entity firstEntity = null;
            if (this.attribute.getDbAttribute() == null) {
                DbEntity dbEnt;
                if (this.attribute.getParent() instanceof ObjEntity && (dbEnt = ((ObjEntity)this.attribute.getParent()).getDbEntity()) != null) {
                    Collection attrib = dbEnt.getAttributes();
                    Collection rel = dbEnt.getRelationships();
                    if (attrib.size() > 0) {
                        Iterator iter = attrib.iterator();
                        firstEntity = ((DbAttribute)iter.next()).getEntity();
                    } else if (rel.size() > 0) {
                        Iterator iter = rel.iterator();
                        firstEntity = ((DbRelationship)iter.next()).getSourceEntity();
                    }
                }
            } else {
                firstEntity = this.getFirstEntity();
            }
            if (firstEntity != null) {
                EntityTreeModel treeModel = new EntityTreeModel(firstEntity);
                treeModel.setFilter(new EntityTreeFilter(){

                    public boolean attributeMatch(Object node, Attribute attr) {
                        return !(node instanceof Attribute);
                    }

                    public boolean relationshipMatch(Object node, Relationship rel) {
                        if (!(node instanceof Relationship)) {
                            return true;
                        }
                        DbRelationship prev = (DbRelationship)node;
                        return rel.isToMany() || prev.getReverseRelationship() != rel;
                    }
                });
                this.view.getPathBrowser().setModel(treeModel);
            }
        }
        if (this.attribute.getDbAttribute() != null) {
            this.setSelectionPath();
        }
        this.view.getType().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (ObjAttributeInfoDialog.this.lastObjectType != null && !ObjAttributeInfoDialog.this.lastObjectType.equals(e.getItemSelectable())) {
                    if (ObjAttributeInfoDialog.this.embeddableNames.contains(e.getItemSelectable().getSelectedObjects()[0].toString())) {
                        if (ObjAttributeInfoDialog.this.attributeSaved instanceof ObjAttribute) {
                            EmbeddedAttribute copyAttrSaved = new EmbeddedAttribute();
                            ObjAttributeInfoDialog.this.copyObjAttribute((ObjAttribute)copyAttrSaved, ObjAttributeInfoDialog.this.attributeSaved);
                            ObjAttributeInfoDialog.this.attributeSaved = copyAttrSaved;
                        }
                    } else if (ObjAttributeInfoDialog.this.attributeSaved instanceof EmbeddedAttribute) {
                        ObjAttribute copyAttrSaved = new ObjAttribute();
                        ObjAttributeInfoDialog.this.copyObjAttribute(copyAttrSaved, ObjAttributeInfoDialog.this.attributeSaved);
                        ObjAttributeInfoDialog.this.attributeSaved = copyAttrSaved;
                    }
                    ObjAttributeInfoDialog.this.attributeSaved.setType(e.getItemSelectable().getSelectedObjects()[0].toString());
                    ObjAttributeInfoDialog.this.rebuildTable();
                    ObjAttributeInfoDialog.this.setEnabledSaveButton();
                }
            }
        });
        this.view.getAttributeName().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (!ObjAttributeInfoDialog.this.view.getAttributeName().getText().equals(ObjAttributeInfoDialog.this.attribute.getName())) {
                    ObjAttributeInfoDialog.this.setEnabledSaveButton();
                }
            }

            public void keyReleased(KeyEvent e) {
                if (!ObjAttributeInfoDialog.this.view.getAttributeName().getText().equals(ObjAttributeInfoDialog.this.attribute.getName())) {
                    ObjAttributeInfoDialog.this.setEnabledSaveButton();
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.rebuildTable();
    }

    private void setEnabledSaveButton() {
        if (!this.attribute.getDbPathIterator().hasNext()) {
            this.view.getSaveButton().setEnabled(true);
        } else {
            boolean isAttributeLast = false;
            Iterator it = this.attribute.getDbPathIterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof DbAttribute) || it.hasNext()) continue;
                isAttributeLast = true;
            }
            this.view.getSaveButton().setEnabled(isAttributeLast);
        }
    }

    private void setUpTableStructure() {
        CellRenderer renderer = new CellRenderer();
        TableColumn nameColumn = this.view.getOverrideAttributeTable().getColumnModel().getColumn(0);
        nameColumn.setMinWidth(180);
        nameColumn.setCellRenderer(renderer);
        TableColumn typeColumn = this.view.getOverrideAttributeTable().getColumnModel().getColumn(1);
        typeColumn.setMinWidth(200);
        typeColumn.setCellRenderer(renderer);
        TableColumn dbAttrColumn = this.view.getOverrideAttributeTable().getColumnModel().getColumn(2);
        dbAttrColumn.setMinWidth(180);
        dbAttrColumn.setCellRenderer(renderer);
        TableColumn dbAttrTypeColumn = this.view.getOverrideAttributeTable().getColumnModel().getColumn(3);
        dbAttrTypeColumn.setMinWidth(180);
        dbAttrTypeColumn.setCellRenderer(renderer);
        this.initComboBoxes();
    }

    private void initComboBoxes() {
        DbEntity currentEnt;
        Collection<String> nameAttr = null;
        if (this.attributeSaved != null && (currentEnt = ((ObjEntity)this.attributeSaved.getEntity()).getDbEntity()) != null) {
            nameAttr = ModelerUtil.getDbAttributeNames(this.mediator, currentEnt);
            this.embeddableModel.setCellEditor(nameAttr, this.view.getOverrideAttributeTable());
            this.embeddableModel.setComboBoxes(nameAttr, 2);
        }
    }

    private void rebuildTable() {
        String typeName = null;
        ArrayList<EmbeddableAttribute> embAttrTempCopy = new ArrayList<EmbeddableAttribute>();
        if (this.attributeSaved.getType() != null) {
            typeName = this.attributeSaved.getType().toString();
        }
        if (this.embeddableNames.contains(typeName)) {
            Collection embAttrTemp = this.stringToEmbeddables.get(typeName).getAttributes();
            for (EmbeddableAttribute temp : embAttrTemp) {
                EmbeddableAttribute at = new EmbeddableAttribute();
                at.setDbAttributeName(temp.getDbAttributeName());
                at.setName(temp.getName());
                at.setType(temp.getType());
                at.setEmbeddable(temp.getEmbeddable());
                embAttrTempCopy.add(at);
            }
        }
        this.embeddableModel = new OverrideEmbeddableAttributeTableModel(this.mediator, this, embAttrTempCopy, this.attributeSaved);
        this.view.getOverrideAttributeTable().setModel(this.embeddableModel);
        this.view.getOverrideAttributeTable().setRowHeight(25);
        this.view.getOverrideAttributeTable().setRowMargin(3);
        this.setUpTableStructure();
        this.lastObjectType = this.view.getType().getSelectedItem() == null ? "" : this.view.getType().getSelectedItem();
    }

    public void closeAction() {
        this.view.dispose();
    }

    public boolean setPath(boolean isChange) {
        if (this.isChange()) {
            this.attributeSaved.setType(this.view.getType().getSelectedItem().toString());
            this.attributeSaved.setName(this.view.getAttributeName().getText());
        }
        if (!(this.attributeSaved instanceof EmbeddedAttribute) || this.isRegistredType(this.attributeSaved.getType())) {
            StringBuilder attributePath = new StringBuilder();
            StringBuilder pathStr = new StringBuilder();
            if (((ObjEntity)this.attribute.getEntity()).getDbEntity() != null) {
                TreePath path = this.view.getPathBrowser().getSelectionPath();
                if (path.getLastPathComponent() instanceof DbAttribute) {
                    Object[] pathComponents = path.getPath();
                    for (int i = 0; i < pathComponents.length; ++i) {
                        boolean attrOrRel = true;
                        if (pathComponents[i] instanceof DbAttribute) {
                            pathStr.append(((DbAttribute)pathComponents[i]).getName());
                            attributePath.append(((DbAttribute)pathComponents[i]).getName());
                        } else if (pathComponents[i] instanceof DbRelationship) {
                            pathStr.append(((DbRelationship)pathComponents[i]).getName());
                            attributePath.append(((DbRelationship)pathComponents[i]).getName());
                        } else {
                            attrOrRel = false;
                        }
                        if (i == pathComponents.length - 1 || !attrOrRel) continue;
                        pathStr.append(" -> ");
                        attributePath.append(".");
                    }
                }
            } else {
                this.view.getCurrentPathLabel().setText("");
            }
            this.view.getCurrentPathLabel().setText(pathStr.toString());
            if (this.attribute.getDbAttributePath() != null && !this.embeddableNames.contains(this.view.getType().getSelectedItem().toString())) {
                if (!this.attribute.getDbAttributePath().equals(attributePath.toString())) {
                    this.attributeSaved.setDbAttributePath(attributePath.toString());
                    if (!this.attribute.getDbAttributePath().equals(attributePath.toString()) && isChange) {
                        this.model.setUpdatedValueAt(this.attributeSaved.getDbAttributePath(), this.row, 3);
                    }
                    return true;
                }
            } else if (attributePath.length() > 0 || this.attribute instanceof EmbeddedAttribute && !(this.attributeSaved instanceof EmbeddedAttribute)) {
                this.attributeSaved.setDbAttributePath(attributePath.toString());
                if (attributePath.length() == 0) {
                    this.model.setUpdatedValueAt(this.attributeSaved.getDbAttributePath(), this.row, 3);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isChange() {
        boolean isOvverideTableChange = ((OverrideEmbeddableAttributeTableModel)this.view.getOverrideAttributeTable().getModel()).isAttributeOverrideChange();
        return isOvverideTableChange || !this.attribute.getName().equals(this.view.getAttributeName().getText()) || this.attribute.getType() == null && this.view.getType().getSelectedItem().toString() != null || !this.attribute.getType().equals(this.view.getType().getSelectedItem().toString());
    }

    public void saveMapping() {
        if (this.setPath(false)) {
            if (JOptionPane.showConfirmDialog(this.getView(), "You have changed Db Attribute path. Do you want it to be saved?", "Save ObjAttribute", 0) == 0) {
                if (this.attribute instanceof EmbeddedAttribute) {
                    this.changeAttributeObject();
                } else {
                    this.model.setUpdatedValueAt(this.attributeSaved.getName(), this.row, 1);
                    this.model.setUpdatedValueAt(this.attributeSaved.getType(), this.row, 2);
                }
                this.model.setUpdatedValueAt(this.attributeSaved.getDbAttributePath(), this.row, 3);
            } else {
                this.model.setUpdatedValueAt(this.attributeSaved.getName(), this.row, 1);
                this.model.setUpdatedValueAt(this.attributeSaved.getType(), this.row, 2);
            }
        } else {
            Map currentOverrAttr;
            Map overrides;
            if (this.attributeSaved instanceof EmbeddedAttribute && !(this.attribute instanceof EmbeddedAttribute) || !(this.attributeSaved instanceof EmbeddedAttribute) && this.attribute instanceof EmbeddedAttribute) {
                this.changeAttributeObject();
            } else if (this.attributeSaved instanceof EmbeddedAttribute && this.attribute instanceof EmbeddedAttribute || !(this.attributeSaved instanceof EmbeddedAttribute) && !(this.attribute instanceof EmbeddedAttribute)) {
                if (this.attributeSaved instanceof EmbeddedAttribute && this.embeddableModel.isAttributeOverrideChange()) {
                    overrides = ((EmbeddedAttribute)this.attributeSaved).getAttributeOverrides();
                    currentOverrAttr = this.getCurrentOverrideAttribute();
                    this.compareAndSetOverrideInEmbeddedAttribute(this.attributeSaved, overrides, currentOverrAttr);
                }
                this.model.setUpdatedValueAt(this.attributeSaved.getName(), this.row, 1);
                this.model.setUpdatedValueAt(this.attributeSaved.getType(), this.row, 2);
                this.model.setUpdatedValueAt(this.attributeSaved.getDbAttributePath(), this.row, 3);
            }
            if (this.attributeSaved instanceof EmbeddedAttribute && this.attribute instanceof EmbeddedAttribute) {
                this.model.setUpdatedValueAt(this.attributeSaved.getDbAttributePath(), this.row, 3);
                if (this.embeddableModel.isAttributeOverrideChange()) {
                    overrides = ((EmbeddedAttribute)this.attribute).getAttributeOverrides();
                    currentOverrAttr = ((EmbeddedAttribute)this.attributeSaved).getAttributeOverrides();
                    this.compareAndSetOverrideInEmbeddedAttribute(this.attribute, overrides, currentOverrAttr);
                }
            }
        }
        this.closeAction();
    }

    private void changeAttributeObject() {
        if (this.attributeSaved instanceof EmbeddedAttribute && this.embeddableModel.isAttributeOverrideChange()) {
            Map overrides = ((EmbeddedAttribute)this.attributeSaved).getAttributeOverrides();
            Map<String, String> currentOverrAttr = this.getCurrentOverrideAttribute();
            this.compareAndSetOverrideInEmbeddedAttribute(this.attributeSaved, overrides, currentOverrAttr);
        }
        if (this.attributeSaved instanceof EmbeddedAttribute) {
            this.attributeSaved.setDbAttributePath(null);
            this.model.setUpdatedValueAt(this.attributeSaved.getDbAttributePath(), this.row, 3);
        }
        this.model.getEntity().removeAttribute(this.attribute.getName());
        this.model.getEntity().addAttribute((Attribute)this.attributeSaved);
        this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, (Entity)this.model.getEntity(), 1));
        EntityDisplayEvent event = new EntityDisplayEvent((Object)this, (Entity)this.mediator.getCurrentObjEntity(), this.mediator.getCurrentDataMap(), this.mediator.getCurrentDataDomain());
        this.mediator.fireObjEntityDisplayEvent(event);
        this.mediator.fireObjAttributeEvent(new AttributeEvent((Object)this, (Attribute)this.attributeSaved, (Entity)this.model.getEntity(), 1));
        AttributeDisplayEvent eventAttr = new AttributeDisplayEvent((Object)this, (Attribute)this.attributeSaved, (Entity)this.mediator.getCurrentObjEntity(), this.mediator.getCurrentDataMap(), this.mediator.getCurrentDataDomain());
        this.mediator.fireObjAttributeDisplayEvent(eventAttr);
    }

    public Map<String, String> getCurrentOverrideAttribute() {
        HashMap<String, String> currentEmbeddableOverrite = new HashMap<String, String>();
        List<EmbeddableAttribute> embList = this.embeddableModel.getEmbeddableList();
        Embeddable emb = this.stringToEmbeddables.get(this.attributeSaved.getType());
        for (EmbeddableAttribute e : embList) {
            if ((emb.getAttribute(e.getName()).getDbAttributeName() != null || e.getDbAttributeName() == null) && (emb.getAttribute(e.getName()).getDbAttributeName() == null || emb.getAttribute(e.getName()).getDbAttributeName().equals(e.getDbAttributeName()))) continue;
            currentEmbeddableOverrite.put(e.getName(), e.getDbAttributeName());
        }
        return currentEmbeddableOverrite;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath selectedPath = e.getPath();
        if (selectedPath == null || selectedPath.getPathCount() < 2) {
            return;
        }
        DbEntity target = null;
        if (selectedPath.getLastPathComponent() instanceof Relationship) {
            Relationship rel = (Relationship)selectedPath.getLastPathComponent();
            target = (DbEntity)rel.getTargetEntity();
        } else if (selectedPath.getLastPathComponent() instanceof Attribute) {
            Attribute attr = (Attribute)selectedPath.getLastPathComponent();
            target = (DbEntity)attr.getEntity();
        }
        if (target != null) {
            Collection objEntities = target.getDataMap().getMappedEntities(target);
            Vector<DbRelationship> relPath = new Vector<DbRelationship>(selectedPath.getPathCount() - 1);
            for (int i = 1; i < selectedPath.getPathCount(); ++i) {
                if (!(selectedPath.getLastPathComponent() instanceof Relationship)) continue;
                relPath.add((DbRelationship)selectedPath.getPathComponent(i));
            }
            this.setObjectTarget(objEntities.size() == 0 ? null : (ObjEntity)objEntities.iterator().next());
            if (this.objectTarget != null) {
                this.updateTargetCombo(this.objectTarget.getDbEntity());
            } else {
                this.updateTargetCombo(null);
            }
        }
    }

    public void setObjectTarget(ObjEntity objectTarget) {
        if (this.objectTarget != objectTarget) {
            this.objectTarget = objectTarget;
        }
    }

    protected void updateTargetCombo(DbEntity dbTarget) {
        if (dbTarget != null) {
            this.view.getTargCombo().removeAllItems();
            this.objectTargets = new ArrayList<ObjEntity>();
            if (dbTarget != null) {
                this.objectTargets.addAll(dbTarget.getDataMap().getMappedEntities(dbTarget));
                Collections.sort(this.objectTargets, Comparators.getNamedObjectComparator());
            }
            for (ObjEntity obj : this.objectTargets) {
                this.view.getTargCombo().addItem(obj.getName());
            }
        } else {
            this.view.getTargCombo().addItem("");
        }
    }

    private Entity getFirstEntity() {
        Iterator it = this.attribute.getDbPathIterator();
        Entity firstEnt = this.attribute.getDbAttribute().getEntity();
        boolean setEnt = false;
        while (it.hasNext()) {
            Object ob = it.next();
            if (ob instanceof DbRelationship) {
                if (setEnt) continue;
                firstEnt = ((DbRelationship)ob).getSourceEntity();
                setEnt = true;
                continue;
            }
            if (!(ob instanceof DbAttribute) || setEnt) continue;
            firstEnt = ((DbAttribute)ob).getEntity();
        }
        return firstEnt;
    }

    public void setSelectionPath() {
        ArrayList list = new ArrayList();
        boolean isAttributeLast = false;
        Iterator it = this.attribute.getDbPathIterator();
        while (it.hasNext()) {
            Object obj = it.next();
            list.add(obj);
            if (!(obj instanceof DbAttribute) || it.hasNext()) continue;
            isAttributeLast = true;
        }
        if (isAttributeLast) {
            Object[] path = new Object[list.size() + 1];
            path[0] = this.getFirstEntity();
            System.arraycopy(list.toArray(), 0, path, 1, list.size());
            this.view.getPathBrowser().setSelectionPath(new TreePath(path));
            this.view.getSaveButton().setEnabled(true);
        }
    }

    public boolean isRegistredType(String typeName) {
        boolean isType = false;
        String[] typeNames = ModelerUtil.getRegisteredTypeNames();
        for (int i = 0; i < typeNames.length; ++i) {
            if (!typeNames[i].equals(typeName)) continue;
            isType = true;
        }
        return isType;
    }

    private void copyObjAttribute(ObjAttribute attributeSaved, ObjAttribute attribute) {
        HashMap attrOverrides;
        attributeSaved.setDbAttributePath(attribute.getDbAttributePath());
        attributeSaved.setName(attribute.getName());
        attributeSaved.setEntity(attribute.getEntity());
        attributeSaved.setParent(attribute.getParent());
        attributeSaved.setType(attribute.getType());
        attributeSaved.setUsedForLocking(attribute.isUsedForLocking());
        if (attributeSaved instanceof EmbeddedAttribute && (attrOverrides = attribute instanceof EmbeddedAttribute ? ((EmbeddedAttribute)attribute).getAttributeOverrides() : new HashMap()).size() > 0) {
            for (Map.Entry attrOv : attrOverrides.entrySet()) {
                ((EmbeddedAttribute)attributeSaved).addAttributeOverride(attrOv.getKey().toString(), attrOv.getValue().toString());
            }
        }
    }

    private void compareAndSetOverrideInEmbeddedAttribute(ObjAttribute attribute, Map<String, String> overrides, Map<String, String> currentOverrAttr) {
        int i;
        String key;
        ArrayList<String> keysForDelete = new ArrayList<String>();
        ArrayList<String> keysForAdd = new ArrayList<String>();
        for (Map.Entry<String, String> obj : overrides.entrySet()) {
            String key2 = obj.getKey();
            if (currentOverrAttr.get(key2) != null && obj.getValue().equals(currentOverrAttr.get(key2))) continue;
            keysForDelete.add(key2);
        }
        for (Map.Entry<String, String> obj : currentOverrAttr.entrySet()) {
            key = obj.getKey();
            if (overrides.get(key) != null && obj.getValue().equals(overrides.get(key))) continue;
            keysForAdd.add(key);
        }
        for (i = 0; i < keysForDelete.size(); ++i) {
            ((EmbeddedAttribute)attribute).removeAttributeOverride((String)keysForDelete.get(i));
        }
        for (i = 0; i < keysForAdd.size(); ++i) {
            key = (String)keysForAdd.get(i);
            ((EmbeddedAttribute)attribute).addAttributeOverride(key, currentOverrAttr.get(key));
        }
    }

    final class CellRenderer
    extends DefaultTableCellRenderer {
        CellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            OverrideEmbeddableAttributeTableModel model = (OverrideEmbeddableAttributeTableModel)table.getModel();
            if (!model.isCellEditable(row, column)) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
            }
            this.setBackground(isSelected && !hasFocus ? table.getSelectionBackground() : table.getBackground());
            return this;
        }
    }
}

