/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache;

import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EhCacheQueryCache
implements QueryCache {
    static final String DEFAULT_CACHE_NAME = "cayenne.default.cachegroup";
    private static Log logger = LogFactory.getLog(EhCacheQueryCache.class);
    protected CacheManager cacheManager;

    public EhCacheQueryCache() {
        this.cacheManager = new CacheManager();
        this.init();
    }

    public EhCacheQueryCache(String configFile) {
        this.cacheManager = new CacheManager(configFile);
        this.init();
    }

    public EhCacheQueryCache(CacheManager cacheManager) {
        if (cacheManager == null) {
            throw new CayenneRuntimeException("CacheManager cannot be null.", new Object[0]);
        }
        this.cacheManager = cacheManager;
        this.init();
    }

    private void init() {
        this.cacheManager.addCacheIfAbsent(DEFAULT_CACHE_NAME);
    }

    public List get(QueryMetadata metadata) {
        String key = metadata.getCacheKey();
        if (key == null) {
            return null;
        }
        Element result = null;
        String[] groupNames = metadata.getCacheGroups();
        if (groupNames != null && groupNames.length > 0) {
            Cache cache = this.cacheManager.getCache(groupNames[0]);
            if (cache == null) {
                return null;
            }
            result = cache.get((Serializable)((Object)key));
            if (result != null) {
                return (List)result.getObjectValue();
            }
            if (groupNames.length > 1) {
                logger.warn("multiple cache groups per key: " + key);
            }
        } else {
            result = this.getDefaultCache().get((Serializable)((Object)key));
            if (result != null) {
                return (List)this.getDefaultCache().get((Serializable)((Object)key)).getObjectValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List get(QueryMetadata metadata, QueryCacheEntryFactory factory) {
        String key = metadata.getCacheKey();
        if (key == null) {
            return null;
        }
        Ehcache cache = null;
        Element result = null;
        String[] groupNames = metadata.getCacheGroups();
        if (groupNames != null && groupNames.length > 0) {
            cache = this.cacheManager.getCache(groupNames[0]);
            if (cache == null) {
                return null;
            }
            result = cache.get((Serializable)((Object)key));
            if (groupNames.length > 1) {
                logger.warn("multiple cache groups per key: " + key);
            }
        } else {
            cache = this.getDefaultCache();
            result = cache.get((Serializable)((Object)key));
        }
        if (result != null) {
            return (List)result.getObjectValue();
        }
        cache.acquireWriteLockOnKey((Object)key);
        try {
            List list = this.get(metadata);
            if (list == null) {
                Object noResult = factory.createObject();
                if (!(noResult instanceof List)) {
                    if (noResult == null) {
                        throw new CayenneRuntimeException("Null object created: " + metadata.getCacheKey(), new Object[0]);
                    }
                    throw new CayenneRuntimeException("Invalid query result, expected List, got " + noResult.getClass().getName(), new Object[0]);
                }
                list = (List)noResult;
                this.put(metadata, list);
                List list2 = list;
                return list2;
            }
            List list3 = list;
            return list3;
        }
        finally {
            cache.releaseWriteLockOnKey((Object)key);
        }
    }

    public void put(QueryMetadata metadata, List results) {
        String key = metadata.getCacheKey();
        if (key != null) {
            String[] groupNames = metadata.getCacheGroups();
            if (groupNames != null && groupNames.length > 0) {
                Ehcache cache = this.cacheManager.addCacheIfAbsent(groupNames[0]);
                cache.put(new Element((Object)key, (Object)results));
                if (groupNames.length > 1) {
                    logger.warn("multiple groups per key: " + key);
                }
            } else {
                this.getDefaultCache().put(new Element((Object)key, (Object)results));
            }
        }
    }

    public void remove(String key) {
        if (key != null) {
            for (String cache : this.cacheManager.getCacheNames()) {
                this.cacheManager.getCache(cache).remove((Serializable)((Object)key));
            }
        }
    }

    public void removeGroup(String groupKey) {
        this.cacheManager.removeCache(groupKey);
    }

    public void clear() {
        this.cacheManager.removalAll();
    }

    public int size() {
        int size = 0;
        for (String cache : this.cacheManager.getCacheNames()) {
            size += this.cacheManager.getCache(cache).getSize();
        }
        return size;
    }

    public Ehcache getDefaultCache() {
        return this.cacheManager.getCache(DEFAULT_CACHE_NAME);
    }

    @BeforeScopeEnd
    public void shutdown() {
        this.cacheManager.shutdown();
    }
}

