/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.LogConsoleView;
import org.apache.cayenne.modeler.dialog.LogConsoleWindow;
import org.apache.cayenne.modeler.pref.ComponentGeometry;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.util.Util;

public class LogConsole
extends CayenneController {
    private static final int TEXT_MAX_LENGTH = 500000;
    public static final String SHOW_CONSOLE_PROPERTY = "show.log.console";
    public static final String DOCKED_PROPERTY = "log.console.docked";
    private static final DateFormat FORMAT = DateFormat.getDateTimeInstance();
    public static final MutableAttributeSet ERROR_STYLE = new SimpleAttributeSet();
    public static final MutableAttributeSet FATAL_STYLE;
    public static final MutableAttributeSet WARN_STYLE;
    public static final MutableAttributeSet INFO_STYLE;
    public static final MutableAttributeSet DEBUG_STYLE;
    private static LogConsole instance;
    private LogConsoleView view = new LogConsoleView();
    private LogConsoleWindow logWindow;
    private boolean autoScroll = true;
    private boolean loggingStopped;

    public LogConsole() {
        super((CayenneController)null);
        this.initBindings();
    }

    protected void initBindings() {
        this.view.getClearButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogConsole.this.clear();
            }
        });
        this.view.getCopyButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogConsole.this.copy();
            }
        });
        this.view.getDockButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogConsole.this.disappear();
                LogConsole.this.setConsoleProperty(LogConsole.DOCKED_PROPERTY, !LogConsole.this.getConsoleProperty(LogConsole.DOCKED_PROPERTY));
                LogConsole.this.appear();
            }
        });
    }

    public void clear() {
        this.view.getLogView().setText("");
    }

    private void appear() {
        if (!this.getConsoleProperty(DOCKED_PROPERTY)) {
            this.view.getDockButton().setText("Dock");
            if (this.logWindow == null) {
                this.logWindow = new LogConsoleWindow(this);
                ComponentGeometry geometry = new ComponentGeometry(this.getClass(), null);
                geometry.bind(this.logWindow, 600, 300, 0);
            }
            this.logWindow.setContentPane(this.view);
            this.logWindow.validate();
            this.logWindow.setVisible(true);
        } else {
            this.view.getDockButton().setText("Undock");
            Application.getFrame().setDockComponent(this.view);
        }
    }

    private void disappear() {
        if (!this.getConsoleProperty(DOCKED_PROPERTY)) {
            this.logWindow.dispose();
            this.logWindow = null;
        } else {
            Application.getFrame().setDockComponent(null);
        }
    }

    public void copy() {
        String selectedText = this.view.getLogView().getSelectedText();
        if (Util.isEmptyString(selectedText)) {
            Document doc = this.view.getLogView().getDocument();
            try {
                selectedText = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e) {
                return;
            }
        }
        Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(selectedText);
        sysClip.setContents(data, data);
    }

    public void toggle() {
        boolean needShow = !this.getConsoleProperty(SHOW_CONSOLE_PROPERTY);
        this.setConsoleProperty(SHOW_CONSOLE_PROPERTY, needShow);
        if (needShow) {
            this.appear();
        } else {
            this.disappear();
        }
    }

    public void showConsoleIfNeeded() {
        if (this.getConsoleProperty(SHOW_CONSOLE_PROPERTY)) {
            this.appear();
        }
    }

    public void setConsoleProperty(String prop, boolean b) {
        Application.getInstance().getPreferencesNode(this.getClass(), null).putBoolean(prop, b);
    }

    public boolean getConsoleProperty(String prop) {
        return Application.getInstance().getPreferencesNode(this.getClass(), null).getBoolean(prop, false);
    }

    public void appendMessage(String level, String message, AttributeSet style) {
        this.appendMessage(message, null, style);
    }

    public void appendMessage(String level, String message, Throwable ex, AttributeSet style) {
        if (this.loggingStopped) {
            return;
        }
        Document doc = this.view.getLogView().getDocument();
        if (doc.getLength() > 500000) {
            this.clear();
        }
        StringBuilder newText = new StringBuilder(FORMAT.format(new Date())).append(System.getProperty("line.separator")).append(level.toUpperCase() + ": ");
        if (message != null) {
            newText.append(message).append(System.getProperty("line.separator"));
        }
        if (ex != null) {
            StringWriter out = new StringWriter();
            PrintWriter printer = new PrintWriter(out);
            ex.printStackTrace(printer);
            printer.flush();
            newText.append(out.toString()).append(System.getProperty("line.separator"));
        }
        try {
            doc.insertString(doc.getLength(), newText.toString(), style);
            if (this.autoScroll) {
                this.view.getLogView().setCaretPosition(doc.getLength() - 1);
            }
        }
        catch (BadLocationException ignored) {
            // empty catch block
        }
    }

    public Component getView() {
        return this.view;
    }

    public void stopLogging() {
        if (!this.getConsoleProperty(DOCKED_PROPERTY)) {
            this.setConsoleProperty(SHOW_CONSOLE_PROPERTY, false);
        }
        this.loggingStopped = true;
    }

    public static LogConsole getInstance() {
        if (instance == null) {
            instance = new LogConsole();
        }
        return instance;
    }

    static {
        StyleConstants.setForeground(ERROR_STYLE, Color.RED);
        FATAL_STYLE = new SimpleAttributeSet();
        StyleConstants.setForeground(FATAL_STYLE, Color.RED);
        StyleConstants.setBold(FATAL_STYLE, true);
        WARN_STYLE = new SimpleAttributeSet();
        StyleConstants.setForeground(WARN_STYLE, Color.RED.darker());
        INFO_STYLE = new SimpleAttributeSet();
        StyleConstants.setForeground(INFO_STYLE, Color.BLUE);
        DEBUG_STYLE = null;
    }
}

