/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjAttributeListener;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyAttributeAction;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CutAttributeAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.dialog.objentity.ObjAttributeInfoDialog;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.ObjAttributeTableModel;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;

public class ObjEntityAttributeTab
extends JPanel
implements ObjEntityDisplayListener,
ObjEntityListener,
ObjAttributeListener,
ExistingSelectionProcessor {
    protected ProjectController mediator;
    protected CayenneTable table;
    private TableColumnPreferences tablePreferences;
    JButton resolve;

    public ObjEntityAttributeTab(ProjectController mediator) {
        this.mediator = mediator;
        this.init();
        this.initController();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        ActionManager actionManager = Application.getInstance().getActionManager();
        toolBar.add(actionManager.getAction(CreateAttributeAction.class).buildButton());
        toolBar.add(actionManager.getAction(ObjEntitySyncAction.class).buildButton());
        toolBar.addSeparator();
        ImageIcon ico = ModelerUtil.buildIcon("icon-info.gif");
        this.resolve = new JButton();
        this.resolve.setIcon(ico);
        this.resolve.setToolTipText("Edit Attribute");
        toolBar.add(this.resolve);
        toolBar.addSeparator();
        toolBar.add(actionManager.getAction(RemoveAttributeAction.class).buildButton());
        toolBar.addSeparator();
        toolBar.add(actionManager.getAction(CutAttributeAction.class).buildButton());
        toolBar.add(actionManager.getAction(CopyAttributeAction.class).buildButton());
        toolBar.add(actionManager.getAction(PasteAction.class).buildButton());
        this.add((Component)toolBar, "North");
        this.table = new CayenneTable();
        this.table.setDefaultRenderer(String.class, new CellRenderer());
        this.tablePreferences = new TableColumnPreferences(ObjAttributeTableModel.class, "objEntity/attributeTable");
        JPopupMenu popup = new JPopupMenu();
        popup.add(actionManager.getAction(RemoveAttributeAction.class).buildMenu());
        popup.addSeparator();
        popup.add(actionManager.getAction(CutAttributeAction.class).buildMenu());
        popup.add(actionManager.getAction(CopyAttributeAction.class).buildMenu());
        popup.add(actionManager.getAction(PasteAction.class).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    private void initController() {
        this.mediator.addObjEntityDisplayListener(this);
        this.mediator.addObjEntityListener(this);
        this.mediator.addObjAttributeListener(this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ObjEntityAttributeTab.this.processExistingSelection(e);
            }
        });
        ActionListener resolver = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = ObjEntityAttributeTab.this.table.getSelectedRow();
                if (row < 0) {
                    return;
                }
                ObjAttributeTableModel model = (ObjAttributeTableModel)ObjEntityAttributeTab.this.table.getModel();
                new ObjAttributeInfoDialog(ObjEntityAttributeTab.this.mediator, row, model).startupAction();
                ObjEntityAttributeTab.this.table.cancelEditing();
                ObjEntityAttributeTab.this.table.getSelectionModel().clearSelection();
                ObjEntityAttributeTab.this.table.select(row);
            }
        };
        this.resolve.addActionListener(resolver);
        ActionManager actionManager = Application.getInstance().getActionManager();
        actionManager.setupCutCopyPaste(this.table, CutAttributeAction.class, CopyAttributeAction.class);
    }

    public void initComboBoxes(ObjAttributeTableModel model) {
        ArrayList<String> embeddableNames = new ArrayList<String>();
        ArrayList<String> typeNames = new ArrayList<String>();
        for (DataMap dataMap : ((DataChannelDescriptor)this.mediator.getProject().getRootNode()).getDataMaps()) {
            for (Embeddable emb : dataMap.getEmbeddables()) {
                embeddableNames.add(emb.getClassName());
            }
        }
        String[] registeredTypes = ModelerUtil.getRegisteredTypeNames();
        for (int i = 0; i < registeredTypes.length; ++i) {
            typeNames.add(registeredTypes[i]);
        }
        typeNames.addAll(embeddableNames);
        TableColumn typeColumn = this.table.getColumnModel().getColumn(2);
        JComboBox javaTypesCombo = Application.getWidgetFactory().createComboBox(typeNames.toArray(), false);
        AutoCompletion.enable(javaTypesCombo, false, true);
        typeColumn.setCellEditor(Application.getWidgetFactory().createCellEditor(javaTypesCombo));
        if (model.getEntity().getDbEntity() != null) {
            Collection<String> nameAttr = ModelerUtil.getDbAttributeNames(this.mediator, model.getEntity().getDbEntity());
            model.setCellEditor(nameAttr, this.table);
            model.setComboBoxes(nameAttr, 3);
        }
    }

    public void selectAttributes(ObjAttribute[] attrs) {
        ModelerUtil.updateActions(attrs.length, RemoveAttributeAction.class, CutAttributeAction.class, CopyAttributeAction.class);
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        List listAttrs = model.getObjectList();
        int[] newSel = new int[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            newSel[i] = listAttrs.indexOf(attrs[i]);
        }
        this.table.select(newSel);
    }

    public void processExistingSelection(EventObject e) {
        if (e instanceof ChangeEvent) {
            this.table.clearSelection();
        }
        Attribute[] attrs = new ObjAttribute[]{};
        if (this.table.getSelectedRow() >= 0) {
            ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
            int[] sel = this.table.getSelectedRows();
            attrs = new ObjAttribute[sel.length];
            for (int i = 0; i < sel.length; ++i) {
                attrs[i] = model.getAttribute(sel[i]);
            }
            if (sel.length == 1) {
                UIUtil.scrollToSelectedRow(this.table);
                this.resolve.setEnabled(true);
            } else {
                this.resolve.setEnabled(false);
            }
        } else {
            this.resolve.setEnabled(false);
        }
        AttributeDisplayEvent ev = new AttributeDisplayEvent((Object)this, attrs, (Entity)this.mediator.getCurrentObjEntity(), this.mediator.getCurrentDataMap(), (DataChannelDescriptor)this.mediator.getProject().getRootNode());
        this.mediator.fireObjAttributeDisplayEvent(ev);
    }

    public void objAttributeChanged(AttributeEvent e) {
        this.rebuildTable((ObjEntity)e.getEntity());
        this.table.select(e.getAttribute());
    }

    public void objAttributeAdded(AttributeEvent e) {
        this.rebuildTable((ObjEntity)e.getEntity());
        this.table.select(e.getAttribute());
    }

    public void objAttributeRemoved(AttributeEvent e) {
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getAttribute());
        model.removeRow(e.getAttribute());
        this.table.select(ind);
    }

    public void currentObjEntityChanged(EntityDisplayEvent e) {
        if (e.getSource() == this) {
            return;
        }
        ObjEntity entity = (ObjEntity)e.getEntity();
        if (entity != null) {
            this.rebuildTable(entity);
        }
        if (e.isUnselectAttributes()) {
            this.table.clearSelection();
        }
    }

    protected void rebuildTable(ObjEntity entity) {
        ObjAttributeTableModel model = new ObjAttributeTableModel(entity, this.mediator, this);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        this.setUpTableStructure(model);
    }

    protected void setUpTableStructure(ObjAttributeTableModel model) {
        int inheritanceColumnWidth = 30;
        HashMap<Integer, Integer> minSizes = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> maxSizes = new HashMap<Integer, Integer>();
        minSizes.put(0, inheritanceColumnWidth);
        maxSizes.put(0, inheritanceColumnWidth);
        this.initComboBoxes(model);
        this.tablePreferences.bind(this.table, minSizes, maxSizes, null, 1, true);
    }

    public void objEntityChanged(EntityEvent e) {
        if (e.getSource() == this) {
            return;
        }
        if (!(this.table.getModel() instanceof ObjAttributeTableModel)) {
            return;
        }
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        if (model.getDbEntity() != ((ObjEntity)e.getEntity()).getDbEntity()) {
            model.resetDbEntity();
            this.setUpTableStructure(model);
        }
    }

    public void objEntityAdded(EntityEvent e) {
    }

    public void objEntityRemoved(EntityEvent e) {
    }

    final class CellRenderer
    extends DefaultTableCellRenderer {
        CellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ObjAttributeTableModel model = (ObjAttributeTableModel)table.getModel();
            column = table.getColumnModel().getColumn(column).getModelIndex();
            ObjAttribute attribute = model.getAttribute(row);
            if (column != 0) {
                if (!model.isCellEditable(row, column)) {
                    this.setForeground(Color.GRAY);
                } else {
                    this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
                }
                if (attribute.isInherited()) {
                    Font font = this.getFont();
                    Font newFont = font.deriveFont(2);
                    this.setFont(newFont);
                }
                this.setIcon(null);
            } else {
                if (attribute.isInherited()) {
                    ImageIcon objEntityIcon = ModelerUtil.buildIcon("icon-override.gif");
                    this.setIcon(objEntityIcon);
                }
                this.setText("");
            }
            this.setBackground(isSelected && !hasFocus ? table.getSelectionBackground() : table.getBackground());
            return this;
        }
    }
}

