/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamePatternMatcher {
    protected Log logger;
    protected Pattern[] itemIncludeFilters;
    protected Pattern[] itemExcludeFilters;

    public NamePatternMatcher(Log logger, String includePattern, String excludePattern) {
        this.logger = logger;
        this.itemIncludeFilters = this.createPatterns(includePattern);
        this.itemExcludeFilters = this.createPatterns(excludePattern);
    }

    List<?> filter(List<?> items) {
        if (items == null || items.isEmpty()) {
            return items;
        }
        if (this.itemIncludeFilters.length == 0 && this.itemExcludeFilters.length == 0) {
            return items;
        }
        Iterator<?> it = items.iterator();
        while (it.hasNext()) {
            CayenneMapEntry entity = (CayenneMapEntry)it.next();
            if (!this.passedIncludeFilter(entity)) {
                it.remove();
                continue;
            }
            if (this.passedExcludeFilter(entity)) continue;
            it.remove();
        }
        return items;
    }

    private boolean passedIncludeFilter(CayenneMapEntry item) {
        if (this.itemIncludeFilters.length == 0) {
            return true;
        }
        String itemName = item.getName();
        for (Pattern itemIncludeFilter : this.itemIncludeFilters) {
            if (!itemIncludeFilter.matcher(itemName).find()) continue;
            return true;
        }
        return false;
    }

    private boolean passedExcludeFilter(CayenneMapEntry item) {
        if (this.itemExcludeFilters.length == 0) {
            return true;
        }
        String itemName = item.getName();
        for (Pattern itemExcludeFilter : this.itemExcludeFilters) {
            if (!itemExcludeFilter.matcher(itemName).find()) continue;
            return false;
        }
        return true;
    }

    public Pattern[] createPatterns(String patternString) {
        String[] patternStrings = this.tokenizePattern(patternString);
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(patternStrings.length);
        for (int i = 0; i < patternStrings.length; ++i) {
            try {
                patterns.add(Pattern.compile(patternStrings[i]));
                continue;
            }
            catch (PatternSyntaxException e) {
                if (this.logger == null) continue;
                this.logger.warn("Ignoring invalid pattern [" + patternStrings[i] + "], reason: " + e.getMessage());
            }
        }
        return patterns.toArray(new Pattern[patterns.size()]);
    }

    public String[] tokenizePattern(String pattern) {
        if (pattern != null && pattern.length() > 0) {
            StringTokenizer toks = new StringTokenizer(pattern, ",");
            int len = toks.countTokens();
            if (len == 0) {
                return new String[0];
            }
            ArrayList<String> patterns = new ArrayList<String>(len);
            for (int i = 0; i < len; ++i) {
                String nextPattern = toks.nextToken();
                StringBuilder buffer = new StringBuilder();
                buffer.append("^");
                for (int j = 0; j < nextPattern.length(); ++j) {
                    char nextChar = nextPattern.charAt(j);
                    if (nextChar == '*' || nextChar == '?') {
                        buffer.append('.');
                    }
                    buffer.append(nextChar);
                }
                buffer.append("$");
                patterns.add(buffer.toString());
            }
            return patterns.toArray(new String[patterns.size()]);
        }
        return new String[0];
    }

    public boolean isIncluded(String string) {
        if (this.itemIncludeFilters.length == 0 && this.itemExcludeFilters.length == 0) {
            return true;
        }
        if (!this.passedIncludeFilter(string)) {
            return false;
        }
        return this.passedExcludeFilter(string);
    }

    boolean passedIncludeFilter(String item) {
        if (this.itemIncludeFilters.length == 0) {
            return true;
        }
        for (Pattern itemIncludeFilter : this.itemIncludeFilters) {
            if (!itemIncludeFilter.matcher(item).find()) continue;
            return true;
        }
        return false;
    }

    boolean passedExcludeFilter(String item) {
        if (this.itemExcludeFilters.length == 0) {
            return true;
        }
        for (Pattern itemExcludeFilter : this.itemExcludeFilters) {
            if (!itemExcludeFilter.matcher(item).find()) continue;
            return false;
        }
        return true;
    }

    public static String replaceWildcardInStringWithString(String wildcard, String pattern, String replacement) {
        if (null == pattern || null == wildcard) {
            return pattern;
        }
        StringBuilder buffer = new StringBuilder();
        int lastPos = 0;
        int wildCardPos = pattern.indexOf(wildcard);
        while (-1 != wildCardPos) {
            if (lastPos != wildCardPos) {
                buffer.append(pattern.substring(lastPos, wildCardPos));
            }
            buffer.append(replacement);
            wildCardPos = pattern.indexOf(wildcard, lastPos += wildCardPos + wildcard.length());
        }
        if (lastPos < pattern.length()) {
            buffer.append(pattern.substring(lastPos));
        }
        return buffer.toString();
    }
}

