/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.AlreadyBeingCreatedException;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlocksWithLocations;
import org.apache.hadoop.dfs.ClientProtocol;
import org.apache.hadoop.dfs.DFSClient;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.NamenodeProtocol;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Balancer
implements Tool {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.Balancer");
    private static final long MAX_BLOCKS_SIZE_TO_FETCH = 0x80000000L;
    private Configuration conf;
    private double threshold = 10.0;
    private NamenodeProtocol namenode;
    private ClientProtocol client;
    private FileSystem fs;
    private static final Random rnd = new Random();
    private Collection<Source> overUtilizedDatanodes = new LinkedList<Source>();
    private Collection<Source> aboveAvgUtilizedDatanodes = new LinkedList<Source>();
    private Collection<BalancerDatanode> belowAvgUtilizedDatanodes = new LinkedList<BalancerDatanode>();
    private Collection<BalancerDatanode> underUtilizedDatanodes = new LinkedList<BalancerDatanode>();
    private Collection<Source> sources = new HashSet<Source>();
    private Collection<BalancerDatanode> targets = new HashSet<BalancerDatanode>();
    private Map<Block, BalancerBlock> globalBlockList = new HashMap<Block, BalancerBlock>();
    private Map<Block, BalancerBlock> movedBlocks = new HashMap<Block, BalancerBlock>();
    private Map<String, BalancerDatanode> datanodes = new HashMap<String, BalancerDatanode>();
    private NetworkTopology cluster = new NetworkTopology();
    private double avgUtilization = 0.0;
    private BytesMoved bytesMoved = new BytesMoved();
    private int notChangedIterations = 0;
    private static long blockMoveWaitTime = 30000L;
    public static final int SUCCESS = 1;
    public static final int ALREADY_RUNNING = -1;
    public static final int NO_MOVE_BLOCK = -2;
    public static final int NO_MOVE_PROGRESS = -3;
    public static final int IO_EXCEPTION = -4;
    public static final int ILLEGAL_ARGS = -5;
    private Path BALANCER_ID_PATH = new Path("/system/balancer.id");

    private static double getUtilization(DatanodeInfo datanode) {
        return (double)datanode.getDfsUsed() / (double)datanode.getCapacity() * 100.0;
    }

    Balancer() {
    }

    Balancer(Configuration conf) {
        this.setConf(conf);
    }

    Balancer(Configuration conf, double threshold) {
        this.setConf(conf);
        this.threshold = threshold;
    }

    public static void main(String[] args) {
        try {
            System.exit(ToolRunner.run(null, new Balancer(), args));
        }
        catch (Throwable e) {
            LOG.error((Object)StringUtils.stringifyException(e));
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java Balancer");
        System.out.println("          [-threshold <threshold>]\tpercentage of disk capacity");
    }

    private double parseArgs(String[] args) {
        int argsLen;
        double threshold = 0.0;
        int n = argsLen = args == null ? 0 : args.length;
        if (argsLen == 0) {
            threshold = 10.0;
        } else {
            if (argsLen != 2 || !"-threshold".equalsIgnoreCase(args[0])) {
                Balancer.printUsage();
                throw new IllegalArgumentException(Arrays.toString(args));
            }
            try {
                threshold = Double.parseDouble(args[1]);
                if (threshold < 0.0 || threshold > 100.0) {
                    throw new NumberFormatException();
                }
                LOG.info((Object)("Using a threshold of " + threshold));
            }
            catch (NumberFormatException e) {
                System.err.println("Expect a double parameter in the range of [0, 100]: " + args[1]);
                Balancer.printUsage();
                throw e;
            }
        }
        return threshold;
    }

    private void init(double threshold) throws IOException {
        this.threshold = threshold;
        this.namenode = Balancer.createNamenode(this.conf);
        this.client = DFSClient.createNamenode(this.conf);
        this.fs = FileSystem.get(this.conf);
    }

    private static NamenodeProtocol createNamenode(Configuration conf) throws IOException {
        UnixUserGroupInformation ugi;
        InetSocketAddress nameNodeAddr = DataNode.createSocketAddr(FileSystem.getDefaultUri(conf).getAuthority());
        RetryPolicy timeoutPolicy = RetryPolicies.exponentialBackoffRetry(5, 200L, TimeUnit.MILLISECONDS);
        HashMap<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        RetryPolicy methodPolicy = RetryPolicies.retryByException(timeoutPolicy, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("getBlocks", methodPolicy);
        try {
            ugi = UnixUserGroupInformation.login(conf);
        }
        catch (LoginException e) {
            throw new IOException(StringUtils.stringifyException(e));
        }
        return (NamenodeProtocol)RetryProxy.create(NamenodeProtocol.class, (Object)RPC.getProxy(NamenodeProtocol.class, 1L, nameNodeAddr, ugi, conf, NetUtils.getDefaultSocketFactory(conf)), methodNameToPolicyMap);
    }

    private static void shuffleArray(DatanodeInfo[] datanodes) {
        for (int i = datanodes.length; i > 1; --i) {
            int randomIndex = rnd.nextInt(i);
            DatanodeInfo tmp = datanodes[randomIndex];
            datanodes[randomIndex] = datanodes[i - 1];
            datanodes[i - 1] = tmp;
        }
    }

    private long initNodes() throws IOException {
        return this.initNodes(this.client.getDatanodeReport(FSConstants.DatanodeReportType.LIVE));
    }

    private long initNodes(DatanodeInfo[] datanodes) {
        long totalCapacity = 0L;
        long totalUsedSpace = 0L;
        for (DatanodeInfo datanode : datanodes) {
            totalCapacity += datanode.getCapacity();
            totalUsedSpace += datanode.getDfsUsed();
        }
        this.avgUtilization = (double)totalUsedSpace / (double)totalCapacity * 100.0;
        long overLoadedBytes = 0L;
        long underLoadedBytes = 0L;
        Balancer.shuffleArray(datanodes);
        for (DatanodeInfo datanode : datanodes) {
            BalancerDatanode datanodeS;
            this.cluster.add(datanode);
            if (Balancer.getUtilization(datanode) > this.avgUtilization) {
                datanodeS = new Source(datanode, this.avgUtilization, this.threshold);
                if (this.isAboveAvgUtilized(datanodeS)) {
                    this.aboveAvgUtilizedDatanodes.add((Source)datanodeS);
                } else {
                    assert (this.isOverUtilized(datanodeS)) : datanodeS.getName() + "is not an overUtilized node";
                    this.overUtilizedDatanodes.add((Source)datanodeS);
                    overLoadedBytes += (long)((datanodeS.utilization - this.avgUtilization - this.threshold) * (double)datanodeS.datanode.getCapacity() / 100.0);
                }
            } else {
                datanodeS = new BalancerDatanode(datanode, this.avgUtilization, this.threshold);
                if (this.isBelowAvgUtilized(datanodeS)) {
                    this.belowAvgUtilizedDatanodes.add(datanodeS);
                } else {
                    assert (this.isUnderUtilized(datanodeS)) : datanodeS.getName() + "is not an underUtilized node";
                    this.underUtilizedDatanodes.add(datanodeS);
                    underLoadedBytes += (long)((this.avgUtilization - this.threshold - datanodeS.utilization) * (double)datanodeS.datanode.getCapacity() / 100.0);
                }
            }
            this.datanodes.put(datanode.getStorageID(), datanodeS);
        }
        this.logImbalancedNodes();
        assert (this.datanodes.size() == this.overUtilizedDatanodes.size() + this.underUtilizedDatanodes.size() + this.aboveAvgUtilizedDatanodes.size() + this.belowAvgUtilizedDatanodes.size()) : "Mismatched number of datanodes";
        return Math.max(overLoadedBytes, underLoadedBytes);
    }

    private void logImbalancedNodes() {
        StringBuilder msg = new StringBuilder();
        msg.append(this.overUtilizedDatanodes.size());
        msg.append(" over utilized nodes:");
        for (Source source : this.overUtilizedDatanodes) {
            msg.append(" ");
            msg.append(source.getName());
        }
        LOG.info((Object)msg);
        msg = new StringBuilder();
        msg.append(this.underUtilizedDatanodes.size());
        msg.append(" under utilized nodes: ");
        for (BalancerDatanode balancerDatanode : this.underUtilizedDatanodes) {
            msg.append(" ");
            msg.append(balancerDatanode.getName());
        }
        LOG.info((Object)msg);
    }

    private long chooseNodes() {
        this.chooseNodes(true);
        this.chooseNodes(false);
        assert (this.datanodes.size() == this.overUtilizedDatanodes.size() + this.underUtilizedDatanodes.size() + this.aboveAvgUtilizedDatanodes.size() + this.belowAvgUtilizedDatanodes.size() + this.sources.size() + this.targets.size()) : "Mismatched number of datanodes";
        long bytesToMove = 0L;
        for (Source src : this.sources) {
            bytesToMove += src.scheduledSize;
        }
        return bytesToMove;
    }

    private void chooseNodes(boolean onRack) {
        this.chooseTargets(this.underUtilizedDatanodes.iterator(), onRack);
        this.chooseTargets(this.belowAvgUtilizedDatanodes.iterator(), onRack);
        this.chooseSources(this.aboveAvgUtilizedDatanodes.iterator(), onRack);
    }

    private void chooseTargets(Iterator<BalancerDatanode> targetCandidates, boolean onRackTarget) {
        Iterator<Source> srcIterator = this.overUtilizedDatanodes.iterator();
        while (srcIterator.hasNext()) {
            Source source = srcIterator.next();
            while (this.chooseTarget(source, targetCandidates, onRackTarget)) {
            }
            if (source.isMoveQuotaFull()) continue;
            srcIterator.remove();
        }
    }

    private void chooseSources(Iterator<Source> sourceCandidates, boolean onRackSource) {
        Iterator<BalancerDatanode> targetIterator = this.underUtilizedDatanodes.iterator();
        while (targetIterator.hasNext()) {
            BalancerDatanode target = targetIterator.next();
            while (this.chooseSource(target, sourceCandidates, onRackSource)) {
            }
            if (target.isMoveQuotaFull()) continue;
            targetIterator.remove();
        }
    }

    private boolean chooseTarget(Source source, Iterator<BalancerDatanode> targetCandidates, boolean onRackTarget) {
        if (!source.isMoveQuotaFull()) {
            return false;
        }
        boolean foundTarget = false;
        BalancerDatanode target = null;
        while (!foundTarget && targetCandidates.hasNext()) {
            target = targetCandidates.next();
            if (!target.isMoveQuotaFull()) {
                targetCandidates.remove();
                continue;
            }
            if (onRackTarget) {
                if (!this.cluster.isOnSameRack(source.datanode, target.datanode)) continue;
                foundTarget = true;
                continue;
            }
            if (this.cluster.isOnSameRack(source.datanode, target.datanode)) continue;
            foundTarget = true;
        }
        if (foundTarget) {
            assert (target != null) : "Choose a null target";
            long size = Math.min(source.availableSizeToMove(), target.availableSizeToMove());
            NodeTask nodeTask = new NodeTask(target, size);
            source.addNodeTask(nodeTask);
            target.incScheduledSize(nodeTask.getSize());
            this.sources.add(source);
            this.targets.add(target);
            if (!target.isMoveQuotaFull()) {
                targetCandidates.remove();
            }
            LOG.info((Object)("Decided to move " + FsShell.byteDesc(size) + " bytes from " + source.datanode.getName() + " to " + target.datanode.getName()));
            return true;
        }
        return false;
    }

    private boolean chooseSource(BalancerDatanode target, Iterator<Source> sourceCandidates, boolean onRackSource) {
        if (!target.isMoveQuotaFull()) {
            return false;
        }
        boolean foundSource = false;
        BalancerDatanode source = null;
        while (!foundSource && sourceCandidates.hasNext()) {
            source = sourceCandidates.next();
            if (!source.isMoveQuotaFull()) {
                sourceCandidates.remove();
                continue;
            }
            if (onRackSource) {
                if (!this.cluster.isOnSameRack(source.getDatanode(), target.getDatanode())) continue;
                foundSource = true;
                continue;
            }
            if (this.cluster.isOnSameRack(((Source)source).datanode, target.datanode)) continue;
            foundSource = true;
        }
        if (foundSource) {
            assert (source != null) : "Choose a null source";
            long size = Math.min(source.availableSizeToMove(), target.availableSizeToMove());
            NodeTask nodeTask = new NodeTask(target, size);
            ((Source)source).addNodeTask(nodeTask);
            target.incScheduledSize(nodeTask.getSize());
            this.sources.add((Source)source);
            this.targets.add(target);
            if (!source.isMoveQuotaFull()) {
                sourceCandidates.remove();
            }
            LOG.info((Object)("Decided to move " + FsShell.byteDesc(size) + " bytes from " + ((Source)source).datanode.getName() + " to " + target.datanode.getName()));
            return true;
        }
        return false;
    }

    private long dispatchBlockMoves() {
        long bytesLastMoved = this.bytesMoved.get();
        Source.BlockMoveDispatcher[] dispatchers = new Source.BlockMoveDispatcher[this.sources.size()];
        int i = 0;
        Iterator<Source> i$ = this.sources.iterator();
        while (i$.hasNext()) {
            Source source;
            Source source2 = source = i$.next();
            source2.getClass();
            dispatchers[i] = source2.new Source.BlockMoveDispatcher();
            dispatchers[i].setName("Dispatcher for source " + source.getName());
            LOG.info((Object)("Starting " + dispatchers[i].getName()));
            dispatchers[i++].start();
        }
        for (Source.BlockMoveDispatcher dispatcher : dispatchers) {
            try {
                dispatcher.join();
            }
            catch (InterruptedException e) {
                LOG.info((Object)StringUtils.stringifyException(e));
            }
        }
        this.waitForMoveCompletion();
        return this.bytesMoved.get() - bytesLastMoved;
    }

    static void setBlockMoveWaitTime(long time) {
        blockMoveWaitTime = time;
    }

    private void waitForMoveCompletion() {
        boolean shouldWait;
        do {
            shouldWait = false;
            for (BalancerDatanode target : this.targets) {
                if (target.isPendingQEmpty()) continue;
                shouldWait = true;
            }
            if (!shouldWait) continue;
            try {
                Thread.sleep(blockMoveWaitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (shouldWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMoved(BalancerBlock block) {
        Map<Block, BalancerBlock> map = this.movedBlocks;
        synchronized (map) {
            this.movedBlocks.put(block.getBlock(), block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMoved(BalancerBlock block) {
        Map<Block, BalancerBlock> map = this.movedBlocks;
        synchronized (map) {
            return this.movedBlocks.containsKey(block.getBlock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGoodBlockCandidate(Source source, BalancerDatanode target, BalancerBlock block) {
        if (this.isMoved(block)) {
            return false;
        }
        if (block.isLocatedOnDatanode(target)) {
            return false;
        }
        boolean goodBlock = false;
        if (this.cluster.isOnSameRack(source.getDatanode(), target.getDatanode())) {
            goodBlock = true;
        } else {
            boolean notOnSameRack = true;
            BalancerBlock balancerBlock = block;
            synchronized (balancerBlock) {
                for (BalancerDatanode loc : block.locations) {
                    if (!this.cluster.isOnSameRack(loc.datanode, target.datanode)) continue;
                    notOnSameRack = false;
                    break;
                }
            }
            if (notOnSameRack) {
                goodBlock = true;
            } else {
                for (BalancerDatanode loc : block.locations) {
                    if (loc == source || !this.cluster.isOnSameRack(loc.datanode, source.datanode)) continue;
                    goodBlock = true;
                    break;
                }
            }
        }
        return goodBlock;
    }

    private void resetData() {
        this.cluster = new NetworkTopology();
        this.overUtilizedDatanodes.clear();
        this.aboveAvgUtilizedDatanodes.clear();
        this.belowAvgUtilizedDatanodes.clear();
        this.underUtilizedDatanodes.clear();
        this.datanodes.clear();
        this.sources.clear();
        this.targets.clear();
        this.avgUtilization = 0.0;
        this.cleanGlobalBlockList();
    }

    private void cleanGlobalBlockList() {
        Iterator<Block> globalBlockListIterator = this.globalBlockList.keySet().iterator();
        while (globalBlockListIterator.hasNext()) {
            Block block = globalBlockListIterator.next();
            if (this.movedBlocks.containsKey(block)) continue;
            globalBlockListIterator.remove();
        }
    }

    private boolean isOverUtilized(BalancerDatanode datanode) {
        return datanode.utilization > this.avgUtilization + this.threshold;
    }

    private boolean isAboveAvgUtilized(BalancerDatanode datanode) {
        return datanode.utilization <= this.avgUtilization + this.threshold && datanode.utilization > this.avgUtilization;
    }

    private boolean isUnderUtilized(BalancerDatanode datanode) {
        return datanode.utilization < this.avgUtilization - this.threshold;
    }

    private boolean isBelowAvgUtilized(BalancerDatanode datanode) {
        return datanode.utilization >= this.avgUtilization - this.threshold && datanode.utilization < this.avgUtilization;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int run(String[] args) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 26[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OutputStream checkAndMarkRunningBalancer() throws IOException {
        try {
            FSDataOutputStream out = this.fs.create(this.BALANCER_ID_PATH);
            out.writeBytes(InetAddress.getLocalHost().getHostName());
            out.flush();
            return out;
        }
        catch (RemoteException e) {
            if (AlreadyBeingCreatedException.class.getName().equals(e.getClassName())) {
                return null;
            }
            throw e;
        }
    }

    private static String time2Str(long elapsedTime) {
        String unit;
        double time = elapsedTime;
        if (elapsedTime < 1000L) {
            unit = "milliseconds";
        } else if (elapsedTime < 60000L) {
            unit = "seconds";
            time /= 1000.0;
        } else if (elapsedTime < 3600000L) {
            unit = "minutes";
            time /= 60000.0;
        } else {
            unit = "hours";
            time /= 3600000.0;
        }
        return time + " " + unit;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    private static class BytesMoved {
        private long bytesMoved = 0L;

        private BytesMoved() {
        }

        private synchronized void inc(long bytes) {
            this.bytesMoved += bytes;
        }

        private long get() {
            return this.bytesMoved;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Source
    extends BalancerDatanode {
        private ArrayList<NodeTask> nodeTasks;
        private long blocksToReceive;
        private List<BalancerBlock> srcBlockList;
        private static final int SOURCE_BLOCK_LIST_MIN_SIZE = 5;
        private static final long MAX_ITERATION_TIME = 1200000L;

        private Source(DatanodeInfo node, double avgUtil, double threshold) {
            super(node, avgUtil, threshold);
            this.nodeTasks = new ArrayList(2);
            this.blocksToReceive = 0L;
            this.srcBlockList = new ArrayList<BalancerBlock>();
        }

        private void addNodeTask(NodeTask task) {
            assert (task.datanode != this) : "Source and target are the same " + this.datanode.getName();
            this.incScheduledSize(task.getSize());
            this.nodeTasks.add(task);
        }

        private Iterator<BalancerBlock> getBlockIterator() {
            return this.srcBlockList.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getBlockList() throws IOException {
            BlocksWithLocations.BlockWithLocations[] newBlocks = Balancer.this.namenode.getBlocks(this.datanode, Math.min(0x80000000L, this.blocksToReceive)).getBlocks();
            long bytesReceived = 0L;
            for (BlocksWithLocations.BlockWithLocations blk : newBlocks) {
                bytesReceived += blk.getBlock().getNumBytes();
                Map map = Balancer.this.globalBlockList;
                synchronized (map) {
                    BalancerBlock block = (BalancerBlock)Balancer.this.globalBlockList.get(blk.getBlock());
                    if (block == null) {
                        block = new BalancerBlock(blk.getBlock());
                        Balancer.this.globalBlockList.put(blk.getBlock(), block);
                    } else {
                        block.clearLocations();
                    }
                    BalancerBlock balancerBlock = block;
                    synchronized (balancerBlock) {
                        for (String location : blk.getDatanodes()) {
                            BalancerDatanode datanode = (BalancerDatanode)Balancer.this.datanodes.get(location);
                            if (datanode == null) continue;
                            block.addLocation(datanode);
                        }
                    }
                    if (!this.srcBlockList.contains(block) && this.isGoodBlockCandidate(block)) {
                        this.srcBlockList.add(block);
                    }
                }
            }
            return bytesReceived;
        }

        private boolean isGoodBlockCandidate(BalancerBlock block) {
            for (NodeTask nodeTask : this.nodeTasks) {
                if (!Balancer.this.isGoodBlockCandidate(this, nodeTask.datanode, block)) continue;
                return true;
            }
            return false;
        }

        private PendingBlockMove chooseNextBlockToMove() {
            Iterator<NodeTask> tasks = this.nodeTasks.iterator();
            while (tasks.hasNext()) {
                PendingBlockMove pendingBlock;
                NodeTask task = tasks.next();
                BalancerDatanode target = task.getDatanode();
                if (!target.addPendingBlock(pendingBlock = new PendingBlockMove())) continue;
                pendingBlock.source = this;
                pendingBlock.target = target;
                if (pendingBlock.chooseBlockAndProxy()) {
                    long blockSize = pendingBlock.block.getNumBytes();
                    this.scheduledSize -= blockSize;
                    task.size -= blockSize;
                    if (task.size == 0L) {
                        tasks.remove();
                    }
                    return pendingBlock;
                }
                target.removePendingBlock(pendingBlock);
            }
            return null;
        }

        private void filterMovedBlocks() {
            Iterator<BalancerBlock> blocks = this.getBlockIterator();
            while (blocks.hasNext()) {
                if (!Balancer.this.isMoved(blocks.next())) continue;
                blocks.remove();
            }
        }

        private boolean shouldFetchMoreBlocks() {
            return this.srcBlockList.size() < 5 && this.blocksToReceive > 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchBlocks() {
            long startTime = FSNamesystem.now();
            this.blocksToReceive = 2L * this.scheduledSize;
            boolean isTimeUp = false;
            while (!(isTimeUp || this.scheduledSize <= 0L || this.srcBlockList.isEmpty() && this.blocksToReceive <= 0L)) {
                PendingBlockMove pendingBlock = this.chooseNextBlockToMove();
                if (pendingBlock != null) {
                    pendingBlock.scheduleBlockMove();
                    continue;
                }
                this.filterMovedBlocks();
                if (this.shouldFetchMoreBlocks()) {
                    try {
                        this.blocksToReceive -= this.getBlockList();
                        continue;
                    }
                    catch (IOException e) {
                        LOG.warn((Object)StringUtils.stringifyException(e));
                        return;
                    }
                }
                if (FSNamesystem.now() - startTime > 1200000L) {
                    isTimeUp = true;
                    continue;
                }
                try {
                    Balancer e = Balancer.this;
                    synchronized (e) {
                        Balancer.this.wait(1000L);
                    }
                }
                catch (InterruptedException ignored) {
                }
            }
        }

        private class BlockMoveDispatcher
        extends Thread {
            private BlockMoveDispatcher() {
            }

            public void run() {
                Source.this.dispatchBlocks();
            }
        }
    }

    private static class BalancerDatanode
    implements Writable {
        private static final long MAX_SIZE_TO_MOVE = 0x280000000L;
        protected static final short MAX_NUM_CONCURRENT_MOVES = 5;
        protected DatanodeInfo datanode;
        private double utilization;
        protected long maxSizeToMove;
        protected long scheduledSize = 0L;
        private List<PendingBlockMove> pendingBlocks = new ArrayList<PendingBlockMove>(5);

        private BalancerDatanode(DatanodeInfo node, double avgUtil, double threshold) {
            this.datanode = node;
            this.utilization = Balancer.getUtilization(node);
            this.maxSizeToMove = this.utilization >= avgUtil + threshold || this.utilization <= avgUtil - threshold ? (long)(threshold * (double)this.datanode.getCapacity() / 100.0) : (long)(Math.abs(avgUtil - this.utilization) * (double)this.datanode.getCapacity() / 100.0);
            if (this.utilization < avgUtil) {
                this.maxSizeToMove = Math.min(this.datanode.getRemaining(), this.maxSizeToMove);
            }
            this.maxSizeToMove = Math.min(0x280000000L, this.maxSizeToMove);
        }

        protected DatanodeInfo getDatanode() {
            return this.datanode;
        }

        protected String getName() {
            return this.datanode.getName();
        }

        protected String getStorageID() {
            return this.datanode.getStorageID();
        }

        protected boolean isMoveQuotaFull() {
            return this.scheduledSize < this.maxSizeToMove;
        }

        protected long availableSizeToMove() {
            return this.maxSizeToMove - this.scheduledSize;
        }

        protected void incScheduledSize(long size) {
            this.scheduledSize += size;
        }

        private synchronized boolean isPendingQNotFull() {
            return this.pendingBlocks.size() < 5;
        }

        private synchronized boolean isPendingQEmpty() {
            return this.pendingBlocks.isEmpty();
        }

        private synchronized boolean addPendingBlock(PendingBlockMove pendingBlock) {
            if (this.isPendingQNotFull()) {
                return this.pendingBlocks.add(pendingBlock);
            }
            return false;
        }

        private synchronized boolean removePendingBlock(PendingBlockMove pendingBlock) {
            return this.pendingBlocks.remove(pendingBlock);
        }

        public void readFields(DataInput in) throws IOException {
            this.datanode.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            this.datanode.write(out);
        }
    }

    private static class NodeTask {
        private BalancerDatanode datanode;
        private long size;

        private NodeTask(BalancerDatanode datanode, long size) {
            this.datanode = datanode;
            this.size = size;
        }

        private BalancerDatanode getDatanode() {
            return this.datanode;
        }

        private long getSize() {
            return this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BalancerBlock {
        private Block block;
        private List<BalancerDatanode> locations = new ArrayList<BalancerDatanode>(3);

        private BalancerBlock(Block block) {
            this.block = block;
        }

        private synchronized void clearLocations() {
            this.locations.clear();
        }

        private synchronized void addLocation(BalancerDatanode datanode) {
            if (!this.locations.contains(datanode)) {
                this.locations.add(datanode);
            }
        }

        private synchronized boolean isLocatedOnDatanode(BalancerDatanode datanode) {
            return this.locations.contains(datanode);
        }

        private synchronized List<BalancerDatanode> getLocations() {
            return this.locations;
        }

        private Block getBlock() {
            return this.block;
        }

        private long getBlockId() {
            return this.block.getBlockId();
        }

        private long getNumBytes() {
            return this.block.getNumBytes();
        }
    }

    private class PendingBlockMove {
        private BalancerBlock block;
        private Source source;
        private BalancerDatanode proxySource;
        private BalancerDatanode target;

        private PendingBlockMove() {
        }

        private boolean chooseBlockAndProxy() {
            Iterator blocks = this.source.getBlockIterator();
            while (blocks.hasNext()) {
                if (!this.markMovedIfGoodBlock((BalancerBlock)blocks.next())) continue;
                blocks.remove();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean markMovedIfGoodBlock(BalancerBlock block) {
            BalancerBlock balancerBlock = block;
            synchronized (balancerBlock) {
                Map map = Balancer.this.movedBlocks;
                synchronized (map) {
                    if (Balancer.this.isGoodBlockCandidate(this.source, this.target, block)) {
                        this.block = block;
                        if (this.chooseProxySource()) {
                            Balancer.this.addToMoved(block);
                            LOG.info((Object)("Decided to move block " + block.getBlockId() + " with a length of " + FsShell.byteDesc(block.getNumBytes()) + " bytes from " + this.source.getName() + " to " + this.target.getName() + " using proxy source " + this.proxySource.getName()));
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private boolean chooseProxySource() {
            for (BalancerDatanode loc : this.block.getLocations()) {
                if (!Balancer.this.cluster.isOnSameRack(loc.getDatanode(), this.target.getDatanode()) || !loc.addPendingBlock(this)) continue;
                this.proxySource = loc;
                return true;
            }
            for (BalancerDatanode loc : this.block.getLocations()) {
                if (!loc.addPendingBlock(this)) continue;
                this.proxySource = loc;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void dispatch() {
            Socket sock = new Socket();
            DataOutputStream out = null;
            DataInputStream in = null;
            try {
                block20: {
                    try {
                        sock.connect(DataNode.createSocketAddr(this.proxySource.datanode.getName()), 60000);
                        long bandwidth = Balancer.this.conf.getLong("dfs.balance.bandwidthPerSec", 0x100000L);
                        sock.setSoTimeout(120000 + (int)(this.block.getNumBytes() * 1500L / bandwidth));
                        out = new DataOutputStream(new BufferedOutputStream(sock.getOutputStream(), FSConstants.BUFFER_SIZE));
                        this.sendRequest(out);
                        in = new DataInputStream(new BufferedInputStream(sock.getInputStream(), FSConstants.BUFFER_SIZE));
                        this.receiveResponse(in);
                        Balancer.this.bytesMoved.inc(this.block.getNumBytes());
                        if (!LOG.isDebugEnabled()) break block20;
                        LOG.debug((Object)("Moving block " + this.block.getBlock().getBlockId() + " from " + this.source.getName() + " to " + this.target.getName() + " through " + this.proxySource.getName() + " succeeded."));
                    }
                    catch (SocketTimeoutException te) {
                        LOG.warn((Object)("Timeout moving block " + this.block.getBlockId() + " from " + this.source.getName() + " to " + this.target.getName() + " through " + this.proxySource.getName()));
                        Object var7_8 = null;
                        IOUtils.closeStream(out);
                        IOUtils.closeStream(in);
                        IOUtils.closeSocket(sock);
                        this.proxySource.removePendingBlock(this);
                        Object object2 = this.target;
                        synchronized (object2) {
                            this.target.removePendingBlock(this);
                        }
                        object2 = this;
                        synchronized (object2) {
                            this.reset();
                        }
                        object2 = Balancer.this;
                        synchronized (object2) {
                            Balancer.this.notifyAll();
                            return;
                        }
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Error moving block " + this.block.getBlockId() + " from " + this.source.getName() + " to " + this.target.getName() + " through " + this.proxySource.getName() + ": " + e.getMessage() + "\n" + StringUtils.stringifyException(e)));
                        Object var7_9 = null;
                        IOUtils.closeStream(out);
                        IOUtils.closeStream(in);
                        IOUtils.closeSocket(sock);
                        this.proxySource.removePendingBlock(this);
                        Object object3 = this.target;
                        synchronized (object3) {
                            this.target.removePendingBlock(this);
                        }
                        object3 = this;
                        synchronized (object3) {
                            this.reset();
                        }
                        object3 = Balancer.this;
                        synchronized (object3) {
                            Balancer.this.notifyAll();
                            return;
                        }
                    }
                }
                Object var7_7 = null;
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
                IOUtils.closeSocket(sock);
                this.proxySource.removePendingBlock(this);
                Object object = this.target;
                synchronized (object) {
                    this.target.removePendingBlock(this);
                }
                object = this;
                synchronized (object) {
                    this.reset();
                }
                object = Balancer.this;
                synchronized (object) {
                    Balancer.this.notifyAll();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
                IOUtils.closeSocket(sock);
                this.proxySource.removePendingBlock(this);
                Object object = this.target;
                synchronized (object) {
                    this.target.removePendingBlock(this);
                }
                object = this;
                synchronized (object) {
                    this.reset();
                }
                object = Balancer.this;
                synchronized (object) {
                    Balancer.this.notifyAll();
                    throw throwable;
                }
            }
        }

        private void sendRequest(DataOutputStream out) throws IOException {
            out.writeShort(11);
            out.writeByte(84);
            out.writeLong(this.block.getBlock().getBlockId());
            out.writeLong(this.block.getBlock().getGenerationStamp());
            Text.writeString(out, this.source.getStorageID());
            this.target.write(out);
            out.flush();
        }

        private void receiveResponse(DataInputStream in) throws IOException {
            short status = in.readShort();
            if (status != 0) {
                throw new IOException("Moving block " + this.block.getBlockId() + " from " + this.source.getName() + " to " + this.target.getName() + " through " + this.proxySource.getName() + "failed");
            }
        }

        private void reset() {
            this.block = null;
            this.source = null;
            this.proxySource = null;
            this.target = null;
        }

        private void scheduleBlockMove() {
            BlockMover blockMover = new BlockMover();
            blockMover.setDaemon(true);
            blockMover.setName("Block mover for " + this.block.getBlockId() + " from " + this.proxySource.getName() + " to " + this.target.getName());
            LOG.info((Object)("Starting " + blockMover.getName()));
            blockMover.start();
        }

        private class BlockMover
        extends Thread {
            BlockMover() {
            }

            public void run() {
                PendingBlockMove.this.dispatch();
            }
        }
    }
}

