/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.dfs.GenerationStamp;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Block
implements Writable,
Comparable<Block> {
    static final long GRANDFATHER_GENERATION_STAMP = 0L;
    long blkid;
    long len;
    long generationStamp;

    static boolean isBlockFilename(File f) {
        String name = f.getName();
        return name.startsWith("blk_") && name.indexOf(46) < 0;
    }

    static long filename2id(String name) {
        return Long.parseLong(name.substring("blk_".length()));
    }

    Block() {
        this(0L, 0L, 0L);
    }

    Block(long blkid, long len, long generationStamp) {
        this.set(blkid, len, generationStamp);
    }

    Block(long blkid) {
        this(blkid, 0L, 1L);
    }

    Block(Block blk) {
        this(blk.blkid, blk.len, blk.generationStamp);
    }

    public Block(File f, long len, long genstamp) {
        this(Block.filename2id(f.getName()), len, genstamp);
    }

    public void set(long blkid, long len, long genStamp) {
        this.blkid = blkid;
        this.len = len;
        this.generationStamp = genStamp;
    }

    public long getBlockId() {
        return this.blkid;
    }

    public String getBlockName() {
        return "blk_" + String.valueOf(this.blkid);
    }

    public long getNumBytes() {
        return this.len;
    }

    public void setNumBytes(long len) {
        this.len = len;
    }

    long getGenerationStamp() {
        return this.generationStamp;
    }

    public String toString() {
        return this.getBlockName() + "_" + this.getGenerationStamp();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.blkid);
        out.writeLong(this.len);
        out.writeLong(this.generationStamp);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.blkid = in.readLong();
        this.len = in.readLong();
        this.generationStamp = in.readLong();
        if (this.len < 0L) {
            throw new IOException("Unexpected block size: " + this.len);
        }
    }

    static void validateGenerationStamp(long generationstamp) {
        if (generationstamp == 1L) {
            throw new IllegalStateException("generationStamp (=" + generationstamp + ") == GenerationStamp.WILDCARD_STAMP");
        }
    }

    @Override
    public int compareTo(Block b) {
        Block.validateGenerationStamp(this.generationStamp);
        Block.validateGenerationStamp(b.generationStamp);
        if (this.blkid < b.blkid) {
            return -1;
        }
        if (this.blkid == b.blkid) {
            return GenerationStamp.compare(this.generationStamp, b.generationStamp);
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Block)) {
            return false;
        }
        Block that = (Block)o;
        return this.blkid == that.blkid && GenerationStamp.equalsWithWildcard(this.generationStamp, that.generationStamp);
    }

    public int hashCode() {
        return 629 + (int)(this.blkid ^ this.blkid >>> 32);
    }

    static {
        WritableFactories.setFactory(Block.class, new WritableFactory(){

            public Writable newInstance() {
                return new Block();
            }
        });
    }
}

