/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

class BlockMetaDataInfo
extends Block {
    static final WritableFactory FACTORY = new WritableFactory(){

        public Writable newInstance() {
            return new BlockMetaDataInfo();
        }
    };
    private long lastScanTime;

    public BlockMetaDataInfo() {
    }

    BlockMetaDataInfo(Block b, long lastScanTime) {
        super(b);
        this.lastScanTime = lastScanTime;
    }

    long getLastScanTime() {
        return this.lastScanTime;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.lastScanTime);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.lastScanTime = in.readLong();
    }

    static {
        WritableFactories.setFactory(BlockMetaDataInfo.class, FACTORY);
    }
}

