/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.ipc.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CorruptReplicasMap {
    private Map<Block, Collection<DatanodeDescriptor>> corruptReplicasMap = new TreeMap<Block, Collection<DatanodeDescriptor>>();

    CorruptReplicasMap() {
    }

    public void addToCorruptReplicasMap(Block blk, DatanodeDescriptor dn) {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        if (nodes == null) {
            nodes = new TreeSet<DatanodeDescriptor>();
            this.corruptReplicasMap.put(blk, nodes);
        }
        if (!nodes.contains(dn)) {
            nodes.add(dn);
            NameNode.stateChangeLog.info((Object)("BLOCK NameSystem.addToCorruptReplicasMap: " + blk.getBlockName() + " added as corrupt on " + dn.getName() + " by " + Server.getRemoteIp()));
        } else {
            NameNode.stateChangeLog.info((Object)("BLOCK NameSystem.addToCorruptReplicasMap: duplicate requested for " + blk.getBlockName() + " to add as corrupt " + "on " + dn.getName() + " by " + Server.getRemoteIp()));
        }
        NameNode.getNameNodeMetrics().numBlocksCorrupted.set(this.corruptReplicasMap.size());
    }

    void removeFromCorruptReplicasMap(Block blk) {
        FSNamesystem fsNamesystem = FSNamesystem.getFSNamesystem();
        if (fsNamesystem.blocksMap.contains(blk)) {
            return;
        }
        if (this.corruptReplicasMap != null) {
            this.corruptReplicasMap.remove(blk);
            NameNode.getNameNodeMetrics().numBlocksCorrupted.set(this.corruptReplicasMap.size());
        }
    }

    Collection<DatanodeDescriptor> getNodes(Block blk) {
        return this.corruptReplicasMap.get(blk);
    }

    boolean isReplicaCorrupt(Block blk, DatanodeDescriptor node) {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        return nodes != null && nodes.contains(node);
    }

    void invalidateCorruptReplicas(Block blk) {
        FSNamesystem fsNamesystem = FSNamesystem.getFSNamesystem();
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        boolean gotException = false;
        if (nodes == null) {
            return;
        }
        for (DatanodeDescriptor node : nodes) {
            try {
                fsNamesystem.invalidateBlock(blk, node);
            }
            catch (IOException e) {
                NameNode.stateChangeLog.info((Object)("NameNode.invalidateCorruptReplicas error in deleting bad block " + blk + " on " + node + e));
            }
        }
        if (!gotException) {
            this.removeFromCorruptReplicasMap(blk);
        }
    }
}

