/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DistributedFileSystem;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.UpgradeStatusReport;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.ToolRunner;

public class DFSAdmin
extends FsShell {
    public DFSAdmin() {
        this(null);
    }

    public DFSAdmin(Configuration conf) {
        super(conf);
    }

    public void report() throws IOException {
        if (this.fs instanceof DistributedFileSystem) {
            DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
            DistributedFileSystem.DiskStatus ds = dfs.getDiskStatus();
            long raw = ds.getCapacity();
            long rawUsed = ds.getDfsUsed();
            long remaining = ds.getRemaining();
            long used = dfs.getUsed();
            boolean mode = dfs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_GET);
            UpgradeStatusReport status = dfs.distributedUpgradeProgress(FSConstants.UpgradeAction.GET_STATUS);
            if (mode) {
                System.out.println("Safe mode is ON");
            }
            if (status != null) {
                System.out.println(status.getStatusText(false));
            }
            System.out.println("Total raw bytes: " + raw + " (" + DFSAdmin.byteDesc(raw) + ")");
            System.out.println("Remaining raw bytes: " + remaining + " (" + DFSAdmin.byteDesc(remaining) + ")");
            System.out.println("Used raw bytes: " + rawUsed + " (" + DFSAdmin.byteDesc(rawUsed) + ")");
            System.out.println("% used: " + DFSAdmin.limitDecimalTo2(1.0 * (double)rawUsed / (double)raw * 100.0) + "%");
            System.out.println();
            System.out.println("Total effective bytes: " + used + " (" + DFSAdmin.byteDesc(used) + ")");
            System.out.println("Effective replication multiplier: " + 1.0 * (double)rawUsed / (double)used);
            System.out.println("-------------------------------------------------");
            DatanodeInfo[] info = dfs.getDataNodeStats();
            System.out.println("Datanodes available: " + info.length);
            System.out.println();
            for (int i = 0; i < info.length; ++i) {
                System.out.println(info[i].getDatanodeReport());
                System.out.println();
            }
        }
    }

    public void setSafeMode(String[] argv, int idx) throws IOException {
        FSConstants.SafeModeAction action;
        if (!(this.fs instanceof DistributedFileSystem)) {
            System.err.println("FileSystem is " + this.fs.getUri());
            return;
        }
        if (idx != argv.length - 1) {
            DFSAdmin.printUsage("-safemode");
            return;
        }
        Boolean waitExitSafe = false;
        if ("leave".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.SafeModeAction.SAFEMODE_LEAVE;
        } else if ("enter".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.SafeModeAction.SAFEMODE_ENTER;
        } else if ("get".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.SafeModeAction.SAFEMODE_GET;
        } else if ("wait".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.SafeModeAction.SAFEMODE_GET;
            waitExitSafe = true;
        } else {
            DFSAdmin.printUsage("-safemode");
            return;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        boolean inSafeMode = dfs.setSafeMode(action);
        if (waitExitSafe.booleanValue()) {
            while (inSafeMode) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new IOException("Wait Interrupted");
                }
                inSafeMode = dfs.setSafeMode(action);
            }
        }
        System.out.println("Safe mode is " + (inSafeMode ? "ON" : "OFF"));
    }

    public int refreshNodes() throws IOException {
        int exitCode = -1;
        if (!(this.fs instanceof DistributedFileSystem)) {
            System.err.println("FileSystem is " + this.fs.getName());
            return exitCode;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        dfs.refreshNodes();
        exitCode = 0;
        return exitCode;
    }

    private void printHelp(String cmd) {
        String summary = "hadoop dfsadmin is the command to execute DFS administrative commands.\nThe full syntax is: \n\nhadoop dfsadmin [-report] [-safemode <enter | leave | get | wait>]\n\t[-refreshNodes]\n\t[-setQuota <quota> <dirname>...<dirname>]\n\t[-clrQuota <dirname>...<dirname>]\n\t[-help [cmd]]\n";
        String report = "-report: \tReports basic filesystem information and statistics.\n";
        String safemode = "-safemode <enter|leave|get|wait>:  Safe mode maintenance command.\n\t\tSafe mode is a Namenode state in which it\n\t\t\t1.  does not accept changes to the name space (read-only)\n\t\t\t2.  does not replicate or delete blocks.\n\t\tSafe mode is entered automatically at Namenode startup, and\n\t\tleaves safe mode automatically when the configured minimum\n\t\tpercentage of blocks satisfies the minimum replication\n\t\tcondition.  Safe mode can also be entered manually, but then\n\t\tit can only be turned off manually as well.\n";
        String refreshNodes = "-refreshNodes: \tRe-read the hosts and exclude files to update the set\n\t\tof Datanodes that are allowed to connect to the Namenode\n\t\tand those that should be decommissioned of recommissioned.\n";
        String finalizeUpgrade = "-finalizeUpgrade: Finalize upgrade of DFS.\n\t\tDatanodes delete their previous version working directories,\n\t\tfollowed by Namenode doing the same.\n\t\tThis completes the upgrade process.\n";
        String upgradeProgress = "-upgradeProgress <status|details|force>: \n\t\trequest current distributed upgrade status, \n\t\ta detailed status or force the upgrade to proceed.\n";
        String metaSave = "-metasave <filename>: \tSave Namenode's primary data structures\n\t\tto <filename> in the directory specified by hadoop.log.dir property.\n\t\t<filename> will contain one line for each of the following\n\t\t\t1. Datanodes heart beating with Namenode\n\t\t\t2. Blocks waiting to be replicated\n\t\t\t3. Blocks currrently being replicated\n\t\t\t4. Blocks waiting to be deleted\n";
        String help = "-help [cmd]: \tDisplays help for the given command or all commands if none\n\t\tis specified.\n";
        if ("report".equals(cmd)) {
            System.out.println(report);
        } else if ("safemode".equals(cmd)) {
            System.out.println(safemode);
        } else if ("refreshNodes".equals(cmd)) {
            System.out.println(refreshNodes);
        } else if ("finalizeUpgrade".equals(cmd)) {
            System.out.println(finalizeUpgrade);
        } else if ("upgradeProgress".equals(cmd)) {
            System.out.println(upgradeProgress);
        } else if ("metasave".equals(cmd)) {
            System.out.println(metaSave);
        } else if (SetQuotaCommand.matches(cmd)) {
            System.out.println("-setQuota <quota> <dirname>...<dirname>: \tSet the quota <quota> for each directory <dirName>.\n\t\tThe directory quota is a long integer that puts a hard limit on the number of names in the directory tree\n\t\tBest effort for the directory, with faults reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file, or\n\t\t4. the directory would immediately exceed the new quota.");
        } else if (ClearQuotaCommand.matches(cmd)) {
            System.out.println("-clrQuota <dirname>...<dirname>: \tClear the quota for each directory <dirName>.\n\t\tBest effort for the directory. with fault reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.");
        } else if ("help".equals(cmd)) {
            System.out.println(help);
        } else {
            System.out.println(summary);
            System.out.println(report);
            System.out.println(safemode);
            System.out.println(refreshNodes);
            System.out.println(finalizeUpgrade);
            System.out.println(upgradeProgress);
            System.out.println(metaSave);
            System.out.println("-setQuota <quota> <dirname>...<dirname>: \tSet the quota <quota> for each directory <dirName>.\n\t\tThe directory quota is a long integer that puts a hard limit on the number of names in the directory tree\n\t\tBest effort for the directory, with faults reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file, or\n\t\t4. the directory would immediately exceed the new quota.");
            System.out.println("-clrQuota <dirname>...<dirname>: \tClear the quota for each directory <dirName>.\n\t\tBest effort for the directory. with fault reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.");
            System.out.println(help);
            System.out.println();
            ToolRunner.printGenericCommandUsage(System.out);
        }
    }

    public int finalizeUpgrade() throws IOException {
        int exitCode = -1;
        if (!(this.fs instanceof DistributedFileSystem)) {
            System.out.println("FileSystem is " + this.fs.getUri());
            return exitCode;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        dfs.finalizeUpgrade();
        exitCode = 0;
        return exitCode;
    }

    public int upgradeProgress(String[] argv, int idx) throws IOException {
        FSConstants.UpgradeAction action;
        if (!(this.fs instanceof DistributedFileSystem)) {
            System.out.println("FileSystem is " + this.fs.getUri());
            return -1;
        }
        if (idx != argv.length - 1) {
            DFSAdmin.printUsage("-upgradeProgress");
            return -1;
        }
        if ("status".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.UpgradeAction.GET_STATUS;
        } else if ("details".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.UpgradeAction.DETAILED_STATUS;
        } else if ("force".equalsIgnoreCase(argv[idx])) {
            action = FSConstants.UpgradeAction.FORCE_PROCEED;
        } else {
            DFSAdmin.printUsage("-upgradeProgress");
            return -1;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        UpgradeStatusReport status = dfs.distributedUpgradeProgress(action);
        String statusText = status == null ? "There are no upgrades in progress." : status.getStatusText(action == FSConstants.UpgradeAction.DETAILED_STATUS);
        System.out.println(statusText);
        return 0;
    }

    public int metaSave(String[] argv, int idx) throws IOException {
        String pathname = argv[idx];
        DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
        dfs.metaSave(pathname);
        System.out.println("Created file " + pathname + " on server " + dfs.getUri());
        return 0;
    }

    private static void printUsage(String cmd) {
        if ("-report".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-report]");
        } else if ("-safemode".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-safemode enter | leave | get | wait]");
        } else if ("-refreshNodes".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refreshNodes]");
        } else if ("-finalizeUpgrade".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-finalizeUpgrade]");
        } else if ("-upgradeProgress".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-upgradeProgress status | details | force]");
        } else if ("-metasave".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-metasave filename]");
        } else if (SetQuotaCommand.matches(cmd)) {
            System.err.println("Usage: java DFSAdmin [-setQuota <quota> <dirname>...<dirname>]");
        } else if (ClearQuotaCommand.matches(cmd)) {
            System.err.println("Usage: java DFSAdmin [-clrQuota <dirname>...<dirname>]");
        } else {
            System.err.println("Usage: java DFSAdmin");
            System.err.println("           [-report]");
            System.err.println("           [-safemode enter | leave | get | wait]");
            System.err.println("           [-refreshNodes]");
            System.err.println("           [-finalizeUpgrade]");
            System.err.println("           [-upgradeProgress status | details | force]");
            System.err.println("           [-metasave filename]");
            System.err.println("           [-setQuota <quota> <dirname>...<dirname>]");
            System.err.println("           [-clrQuota <dirname>...<dirname>]");
            System.err.println("           [-help [cmd]]");
            System.err.println();
            ToolRunner.printGenericCommandUsage(System.err);
        }
    }

    public int run(String[] argv) throws Exception {
        String cmd;
        if (argv.length < 1) {
            DFSAdmin.printUsage("");
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        if ("-safemode".equals(cmd = argv[i++])) {
            if (argv.length != 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-report".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-refreshNodes".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-finalizeUpgrade".equals(cmd)) {
            if (argv.length != 1) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-upgradeProgress".equals(cmd)) {
            if (argv.length != 2) {
                DFSAdmin.printUsage(cmd);
                return exitCode;
            }
        } else if ("-metasave".equals(cmd) && argv.length != 2) {
            DFSAdmin.printUsage(cmd);
            return exitCode;
        }
        try {
            this.init();
        }
        catch (RPC.VersionMismatch v) {
            System.err.println("Version Mismatch between client and server... command aborted.");
            return exitCode;
        }
        catch (IOException e) {
            System.err.println("Bad connection to DFS... command aborted.");
            return exitCode;
        }
        exitCode = 0;
        try {
            if ("-report".equals(cmd)) {
                this.report();
            } else if ("-safemode".equals(cmd)) {
                this.setSafeMode(argv, i);
            } else if ("-refreshNodes".equals(cmd)) {
                exitCode = this.refreshNodes();
            } else if ("-finalizeUpgrade".equals(cmd)) {
                exitCode = this.finalizeUpgrade();
            } else if ("-upgradeProgress".equals(cmd)) {
                exitCode = this.upgradeProgress(argv, i);
            } else if ("-metasave".equals(cmd)) {
                exitCode = this.metaSave(argv, i);
            } else if (ClearQuotaCommand.matches(cmd)) {
                exitCode = new ClearQuotaCommand(argv, i, this.fs).runAll();
            } else if (SetQuotaCommand.matches(cmd)) {
                exitCode = new SetQuotaCommand(argv, i, this.fs).runAll();
            } else if ("-help".equals(cmd)) {
                if (i < argv.length) {
                    this.printHelp(argv[i]);
                } else {
                    this.printHelp("");
                }
            } else {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": Unknown command");
                DFSAdmin.printUsage("");
            }
        }
        catch (IllegalArgumentException arge) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            DFSAdmin.printUsage(cmd);
        }
        catch (RemoteException e) {
            exitCode = -1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
        }
        return exitCode;
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run(new DFSAdmin(), argv);
        System.exit(res);
    }

    private static class SetQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "setQuota";
        private static final String USAGE = "-setQuota <quota> <dirname>...<dirname>";
        private static final String DESCRIPTION = "-setQuota <quota> <dirname>...<dirname>: \tSet the quota <quota> for each directory <dirName>.\n\t\tThe directory quota is a long integer that puts a hard limit on the number of names in the directory tree\n\t\tBest effort for the directory, with faults reported if\n\t\t1. N is not a positive integer, or\n\t\t2. user is not an administrator, or\n\t\t3. the directory does not exist or is a file, or\n\t\t4. the directory would immediately exceed the new quota.";
        private final long quota;

        SetQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(NAME, 2, Integer.MAX_VALUE, new String[0]);
            List<String> parameters = c.parse(args, pos);
            this.quota = Long.parseLong(parameters.remove(0));
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-setQuota".equals(cmd);
        }

        public String getCommandName() {
            return NAME;
        }

        public void run(Path path) throws IOException {
            ((DistributedFileSystem)this.fs).setQuota(path, this.quota);
        }
    }

    private static class ClearQuotaCommand
    extends DFSAdminCommand {
        private static final String NAME = "clrQuota";
        private static final String USAGE = "-clrQuota <dirname>...<dirname>";
        private static final String DESCRIPTION = "-clrQuota <dirname>...<dirname>: \tClear the quota for each directory <dirName>.\n\t\tBest effort for the directory. with fault reported if\n\t\t1. the directory does not exist or is a file, or\n\t\t2. user is not an administrator.\n\t\tIt does not fault if the directory has no quota.";

        ClearQuotaCommand(String[] args, int pos, FileSystem fs) {
            super(fs);
            CommandFormat c = new CommandFormat(NAME, 1, Integer.MAX_VALUE, new String[0]);
            List<String> parameters = c.parse(args, pos);
            this.args = parameters.toArray(new String[parameters.size()]);
        }

        public static boolean matches(String cmd) {
            return "-clrQuota".equals(cmd);
        }

        public String getCommandName() {
            return NAME;
        }

        public void run(Path path) throws IOException {
            ((DistributedFileSystem)this.fs).clearQuota(path);
        }
    }

    private static abstract class DFSAdminCommand
    extends Command {
        public DFSAdminCommand(FileSystem fs) {
            super(fs);
            if (!(fs instanceof DistributedFileSystem)) {
                throw new IllegalArgumentException("FileSystem " + fs.getUri() + " is not a distributed file system");
            }
        }
    }
}

