/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import javax.net.SocketFactory;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.AlreadyBeingCreatedException;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.ClientDatanodeProtocol;
import org.apache.hadoop.dfs.ClientProtocol;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DataChecksum;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DistributedFileSystem;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.dfs.LocatedBlocks;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.NotReplicatedYetException;
import org.apache.hadoop.dfs.QuotaExceededException;
import org.apache.hadoop.dfs.UpgradeStatusReport;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSInputChecker;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FSOutputSummer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.permission.AccessControlException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DFSClient
implements FSConstants {
    public static final Log LOG = LogFactory.getLog(DFSClient.class);
    static final int MAX_BLOCK_ACQUIRE_FAILURES = 3;
    private static final int TCP_WINDOW_SIZE = 131072;
    final ClientProtocol namenode;
    private final ClientProtocol rpcNamenode;
    final UnixUserGroupInformation ugi;
    volatile boolean clientRunning = true;
    Random r = new Random();
    String clientName;
    Daemon leaseChecker;
    private Configuration conf;
    private long defaultBlockSize;
    private short defaultReplication;
    private SocketFactory socketFactory;
    private int socketTimeout;
    private int datanodeWriteTimeout;
    final int writePacketSize;
    private FileSystem.Statistics stats;
    private TreeMap<String, OutputStream> pendingCreates = new TreeMap();

    static ClientProtocol createNamenode(Configuration conf) throws IOException {
        return DFSClient.createNamenode(NameNode.getAddress(conf), conf);
    }

    static ClientProtocol createNamenode(InetSocketAddress nameNodeAddr, Configuration conf) throws IOException {
        try {
            return DFSClient.createNamenode(DFSClient.createRPCNamenode(nameNodeAddr, conf, UnixUserGroupInformation.login(conf, true)));
        }
        catch (LoginException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    private static ClientProtocol createRPCNamenode(InetSocketAddress nameNodeAddr, Configuration conf, UnixUserGroupInformation ugi) throws IOException {
        return (ClientProtocol)RPC.getProxy(ClientProtocol.class, 35L, nameNodeAddr, ugi, conf, NetUtils.getSocketFactory(conf, ClientProtocol.class));
    }

    private static ClientProtocol createNamenode(ClientProtocol rpcNamenode) throws IOException {
        RetryPolicy createPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep(5, 60000L, TimeUnit.MILLISECONDS);
        HashMap<Class<? extends Exception>, RetryPolicy> remoteExceptionToPolicyMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        remoteExceptionToPolicyMap.put(AlreadyBeingCreatedException.class, createPolicy);
        HashMap<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        exceptionToPolicyMap.put(RemoteException.class, RetryPolicies.retryByRemoteException(RetryPolicies.TRY_ONCE_THEN_FAIL, remoteExceptionToPolicyMap));
        RetryPolicy methodPolicy = RetryPolicies.retryByException(RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("create", methodPolicy);
        return (ClientProtocol)RetryProxy.create(ClientProtocol.class, (Object)rpcNamenode, methodNameToPolicyMap);
    }

    static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf) throws IOException {
        InetSocketAddress addr = NetUtils.createSocketAddr(datanodeid.getHost() + ":" + datanodeid.getIpcPort());
        if (ClientDatanodeProtocol.LOG.isDebugEnabled()) {
            ClientDatanodeProtocol.LOG.info((Object)("ClientDatanodeProtocol addr=" + addr));
        }
        return (ClientDatanodeProtocol)RPC.waitForProxy(ClientDatanodeProtocol.class, 1L, addr, conf);
    }

    public DFSClient(Configuration conf) throws IOException {
        this(NameNode.getAddress(conf), conf);
    }

    public DFSClient(InetSocketAddress nameNodeAddr, Configuration conf, FileSystem.Statistics stats) throws IOException {
        this.conf = conf;
        this.stats = stats;
        this.socketTimeout = conf.getInt("dfs.socket.timeout", 60000);
        this.datanodeWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        this.socketFactory = NetUtils.getSocketFactory(conf, ClientProtocol.class);
        this.writePacketSize = conf.getInt("dfs.write.packet.size", 65536);
        try {
            this.ugi = UnixUserGroupInformation.login(conf, true);
        }
        catch (LoginException e) {
            throw (IOException)new IOException().initCause(e);
        }
        this.rpcNamenode = DFSClient.createRPCNamenode(nameNodeAddr, conf, this.ugi);
        this.namenode = DFSClient.createNamenode(this.rpcNamenode);
        String taskId = conf.get("mapred.task.id");
        this.clientName = taskId != null ? "DFSClient_" + taskId : "DFSClient_" + this.r.nextInt();
        this.defaultBlockSize = conf.getLong("dfs.block.size", 0x4000000L);
        this.defaultReplication = (short)conf.getInt("dfs.replication", 3);
        this.leaseChecker = new Daemon(new LeaseChecker());
        this.leaseChecker.start();
    }

    public DFSClient(InetSocketAddress nameNodeAddr, Configuration conf) throws IOException {
        this(nameNodeAddr, conf, FileSystem.getStatistics(DistributedFileSystem.class));
    }

    private void checkOpen() throws IOException {
        if (!this.clientRunning) {
            IOException result = new IOException("Filesystem closed");
            throw result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        DFSClient dFSClient = this;
        synchronized (dFSClient) {
            this.checkOpen();
            TreeMap<String, OutputStream> treeMap = this.pendingCreates;
            synchronized (treeMap) {
                for (String name : this.pendingCreates.keySet()) {
                    OutputStream out = this.pendingCreates.get(name);
                    try {
                        if (out == null) continue;
                        out.close();
                    }
                    catch (IOException ie) {
                        System.err.println("Exception closing file " + name);
                        ie.printStackTrace();
                    }
                }
                this.pendingCreates.clear();
            }
            this.clientRunning = false;
            try {
                this.leaseChecker.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            RPC.stopProxy(this.rpcNamenode);
        }
    }

    public long getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    public long getBlockSize(String f) throws IOException {
        try {
            return this.namenode.getPreferredBlockSize(f);
        }
        catch (IOException ie) {
            LOG.warn((Object)("Problem getting block size: " + StringUtils.stringifyException(ie)));
            throw ie;
        }
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.namenode.reportBadBlocks(blocks);
    }

    public short getDefaultReplication() {
        return this.defaultReplication;
    }

    @Deprecated
    public String[][] getHints(String src, long start, long length) throws IOException {
        BlockLocation[] blkLocations = this.getBlockLocations(src, start, length);
        if (blkLocations == null || blkLocations.length == 0) {
            return new String[0][];
        }
        int blkCount = blkLocations.length;
        String[][] hints = new String[blkCount][];
        for (int i = 0; i < blkCount; ++i) {
            String[] hosts = blkLocations[i].getHosts();
            hints[i] = new String[hosts.length];
            hints[i] = hosts;
        }
        return hints;
    }

    private LocatedBlocks callGetBlockLocations(String src, long start, long length) throws IOException {
        try {
            return this.namenode.getBlockLocations(src, start, length);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    public BlockLocation[] getBlockLocations(String src, long start, long length) throws IOException {
        LocatedBlocks blocks = this.callGetBlockLocations(src, start, length);
        if (blocks == null) {
            return new BlockLocation[0];
        }
        int nrBlocks = blocks.locatedBlockCount();
        BlockLocation[] blkLocations = new BlockLocation[nrBlocks];
        int idx = 0;
        for (LocatedBlock blk : blocks.getLocatedBlocks()) {
            assert (idx < nrBlocks) : "Incorrect index";
            DatanodeInfo[] locations = blk.getLocations();
            String[] hosts = new String[locations.length];
            String[] names = new String[locations.length];
            for (int hCnt = 0; hCnt < locations.length; ++hCnt) {
                hosts[hCnt] = locations[hCnt].getHostName();
                names[hCnt] = locations[hCnt].getName();
            }
            blkLocations[idx] = new BlockLocation(names, hosts, blk.getStartOffset(), blk.getBlockSize());
            ++idx;
        }
        return blkLocations;
    }

    public DFSInputStream open(String src) throws IOException {
        return this.open(src, this.conf.getInt("io.file.buffer.size", 4096), true, null);
    }

    DFSInputStream open(String src, int buffersize, boolean verifyChecksum, FileSystem.Statistics stats) throws IOException {
        this.checkOpen();
        return new DFSInputStream(src, buffersize, verifyChecksum);
    }

    public OutputStream create(String src, boolean overwrite) throws IOException {
        return this.create(src, overwrite, this.defaultReplication, this.defaultBlockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, Progressable progress) throws IOException {
        return this.create(src, overwrite, this.defaultReplication, this.defaultBlockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize) throws IOException {
        return this.create(src, overwrite, replication, blockSize, null);
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(src, overwrite, replication, blockSize, progress, this.conf.getInt("io.file.buffer.size", 4096));
    }

    public OutputStream create(String src, boolean overwrite, short replication, long blockSize, Progressable progress, int buffersize) throws IOException {
        return this.create(src, FsPermission.getDefault(), overwrite, replication, blockSize, progress, buffersize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream create(String src, FsPermission permission, boolean overwrite, short replication, long blockSize, Progressable progress, int buffersize) throws IOException {
        this.checkOpen();
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        FsPermission masked = permission.applyUMask(FsPermission.getUMask(this.conf));
        LOG.debug((Object)(src + ": masked=" + masked));
        DFSOutputStream result = new DFSOutputStream(src, masked, overwrite, replication, blockSize, progress, buffersize);
        TreeMap<String, OutputStream> treeMap = this.pendingCreates;
        synchronized (treeMap) {
            this.pendingCreates.put(src, result);
        }
        return result;
    }

    public boolean setReplication(String src, short replication) throws IOException {
        try {
            return this.namenode.setReplication(src, replication);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class);
        }
    }

    public boolean rename(String src, String dst) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.rename(src, dst);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, QuotaExceededException.class);
        }
    }

    @Deprecated
    public boolean delete(String src) throws IOException {
        this.checkOpen();
        return this.namenode.delete(src, true);
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.delete(src, recursive);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class);
        }
    }

    public boolean exists(String src) throws IOException {
        this.checkOpen();
        return this.getFileInfo(src) != null;
    }

    @Deprecated
    public boolean isDirectory(String src) throws IOException {
        DFSFileInfo fs = this.getFileInfo(src);
        if (fs != null) {
            return fs.isDir();
        }
        throw new FileNotFoundException("File does not exist: " + src);
    }

    public DFSFileInfo[] listPaths(String src) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getListing(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class);
        }
    }

    public DFSFileInfo getFileInfo(String src) throws IOException {
        this.checkOpen();
        try {
            return this.namenode.getFileInfo(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class);
        }
    }

    public void setPermission(String src, FsPermission permission) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setPermission(src, permission);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    public void setOwner(String src, String username, String groupname) throws IOException {
        this.checkOpen();
        try {
            this.namenode.setOwner(src, username, groupname);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    public DistributedFileSystem.DiskStatus getDiskStatus() throws IOException {
        long[] rawNums = this.namenode.getStats();
        return new DistributedFileSystem.DiskStatus(rawNums[0], rawNums[1], rawNums[2]);
    }

    public long totalRawCapacity() throws IOException {
        long[] rawNums = this.namenode.getStats();
        return rawNums[0];
    }

    public long totalRawUsed() throws IOException {
        long[] rawNums = this.namenode.getStats();
        return rawNums[1];
    }

    public DatanodeInfo[] datanodeReport(FSConstants.DatanodeReportType type) throws IOException {
        return this.namenode.getDatanodeReport(type);
    }

    public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        return this.namenode.setSafeMode(action);
    }

    public void refreshNodes() throws IOException {
        this.namenode.refreshNodes();
    }

    public void metaSave(String pathname) throws IOException {
        this.namenode.metaSave(pathname);
    }

    public void finalizeUpgrade() throws IOException {
        this.namenode.finalizeUpgrade();
    }

    public UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        return this.namenode.distributedUpgradeProgress(action);
    }

    public boolean mkdirs(String src) throws IOException {
        return this.mkdirs(src, null);
    }

    public boolean mkdirs(String src, FsPermission permission) throws IOException {
        this.checkOpen();
        if (permission == null) {
            permission = FsPermission.getDefault();
        }
        FsPermission masked = permission.applyUMask(FsPermission.getUMask(this.conf));
        LOG.debug((Object)(src + ": masked=" + masked));
        try {
            return this.namenode.mkdirs(src, masked);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, QuotaExceededException.class);
        }
    }

    ContentSummary getContentSummary(String src) throws IOException {
        try {
            return this.namenode.getContentSummary(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    void clearQuota(String src) throws IOException {
        try {
            this.namenode.clearQuota(src);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class);
        }
    }

    void setQuota(String src, long quota) throws IOException {
        try {
            this.namenode.setQuota(src, quota);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(AccessControlException.class, FileNotFoundException.class, QuotaExceededException.class);
        }
    }

    private DatanodeInfo bestNode(DatanodeInfo[] nodes, AbstractMap<DatanodeInfo, DatanodeInfo> deadNodes) throws IOException {
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (deadNodes.containsKey(nodes[i])) continue;
                return nodes[i];
            }
        }
        throw new IOException("No live nodes contain current block");
    }

    void reportChecksumFailure(String file, Block blk, DatanodeInfo dn) {
        DatanodeInfo[] dnArr = new DatanodeInfo[]{dn};
        LocatedBlock[] lblocks = new LocatedBlock[]{new LocatedBlock(blk, dnArr)};
        this.reportChecksumFailure(file, lblocks);
    }

    void reportChecksumFailure(String file, LocatedBlock[] lblocks) {
        try {
            this.reportBadBlocks(lblocks);
        }
        catch (IOException ie) {
            LOG.info((Object)("Found corruption while reading " + file + ".  Error repairing corrupt blocks.  Bad blocks remain. " + StringUtils.stringifyException(ie)));
        }
    }

    static /* synthetic */ long access$100(DFSClient x0) {
        return x0.defaultBlockSize;
    }

    class DFSOutputStream
    extends FSOutputSummer
    implements Syncable {
        private Socket s;
        boolean closed;
        private String src;
        private DataOutputStream blockStream;
        private DataInputStream blockReplyStream;
        private Block block;
        private long blockSize;
        private DataChecksum checksum;
        private LinkedList<Packet> dataQueue;
        private LinkedList<Packet> ackQueue;
        private Packet currentPacket;
        private int maxPackets;
        private DataStreamer streamer;
        private ResponseProcessor response;
        private long currentSeqno;
        private long bytesCurBlock;
        private int packetSize;
        private int chunksPerPacket;
        private DatanodeInfo[] nodes;
        private volatile boolean hasError;
        private volatile int errorIndex;
        private IOException lastException;
        private long artificialSlowdown;
        private long lastFlushOffset;
        private boolean persistBlocks;
        private int recoveryErrorCount;
        private int maxRecoveryErrorCount;
        private Progressable progress;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processDatanodeError() {
            if (!this.hasError) {
                return false;
            }
            if (this.response != null) {
                LOG.info((Object)("Error Recovery for block " + this.block + " waiting for responder to exit. "));
                return true;
            }
            String msg = "Error Recovery for block " + this.block + " bad datanode[" + this.errorIndex + "]";
            if (this.nodes != null) {
                msg = msg + " " + this.nodes[this.errorIndex].getName();
            }
            LOG.warn((Object)msg);
            if (this.blockStream != null) {
                try {
                    this.blockStream.close();
                    this.blockReplyStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.blockStream = null;
            this.blockReplyStream = null;
            LinkedList<Packet> e = this.ackQueue;
            synchronized (e) {
                this.dataQueue.addAll(0, this.ackQueue);
                this.ackQueue.clear();
            }
            boolean success = false;
            while (!success && DFSClient.this.clientRunning) {
                int i;
                if (this.nodes == null) {
                    this.lastException = new IOException("Could not get block locations. Aborting...");
                    this.closed = true;
                    this.streamer.close();
                    return false;
                }
                StringBuilder pipelineMsg = new StringBuilder();
                for (int j = 0; j < this.nodes.length; ++j) {
                    pipelineMsg.append(this.nodes[j].getName());
                    if (j >= this.nodes.length - 1) continue;
                    pipelineMsg.append(", ");
                }
                String pipeline = pipelineMsg.toString();
                if (this.nodes.length <= 1) {
                    this.lastException = new IOException("All datanodes " + pipeline + " are bad. Aborting...");
                    this.closed = true;
                    this.streamer.close();
                    return false;
                }
                LOG.warn((Object)("Error Recovery for block " + this.block + " in pipeline " + pipeline + ": bad datanode " + this.nodes[this.errorIndex].getName()));
                DatanodeInfo[] newnodes = new DatanodeInfo[this.nodes.length - 1];
                for (i = 0; i < this.errorIndex; ++i) {
                    newnodes[i] = this.nodes[i];
                }
                for (i = this.errorIndex; i < this.nodes.length - 1; ++i) {
                    newnodes[i] = this.nodes[i + 1];
                }
                Block newBlock = null;
                ClientDatanodeProtocol datanodeRPC = null;
                try {
                    datanodeRPC = DFSClient.createClientDatanodeProtocolProxy(newnodes[0], DFSClient.this.conf);
                    newBlock = datanodeRPC.recoverBlock(this.block, newnodes);
                }
                catch (IOException e2) {
                    block21: {
                        boolean bl;
                        try {
                            ++this.recoveryErrorCount;
                            if (this.recoveryErrorCount <= this.maxRecoveryErrorCount) break block21;
                            String emsg = "Error Recovery for block " + this.block + " failed " + " because recovery from primary datanode " + newnodes[0] + " failed " + this.recoveryErrorCount + " times. Aborting...";
                            LOG.warn((Object)emsg);
                            this.lastException = new IOException(emsg);
                            this.closed = true;
                            this.streamer.close();
                            bl = false;
                        }
                        catch (Throwable throwable) {
                            RPC.stopProxy(datanodeRPC);
                            throw throwable;
                        }
                        RPC.stopProxy(datanodeRPC);
                        return bl;
                    }
                    LOG.warn((Object)("Error Recovery for block " + this.block + " failed " + " because recovery from primary datanode " + newnodes[0] + " failed " + this.recoveryErrorCount + " times. Will retry..."));
                    boolean bl = true;
                    RPC.stopProxy(datanodeRPC);
                    return bl;
                }
                RPC.stopProxy(datanodeRPC);
                this.recoveryErrorCount = 0;
                if (newBlock != null) {
                    this.block = newBlock;
                }
                this.nodes = newnodes;
                this.hasError = false;
                this.errorIndex = 0;
                success = this.createBlockOutputStream(this.nodes, this.src, true);
            }
            this.response = new ResponseProcessor(this.nodes);
            this.response.start();
            return false;
        }

        private void isClosed() throws IOException {
            if (this.closed) {
                if (this.lastException != null) {
                    throw this.lastException;
                }
                throw new IOException("Stream closed.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DatanodeInfo[] getPipeline() {
            LinkedList<Packet> linkedList = this.dataQueue;
            synchronized (linkedList) {
                if (this.nodes == null) {
                    return null;
                }
                DatanodeInfo[] value = new DatanodeInfo[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    value[i] = this.nodes[i];
                }
                return value;
            }
        }

        public DFSOutputStream(String src, FsPermission masked, boolean overwrite, short replication, long blockSize, Progressable progress, int buffersize) throws IOException {
            int bytesPerChecksum;
            super(new CRC32(), DFSClient.this.conf.getInt("io.bytes.per.checksum", 512), 4);
            this.closed = false;
            this.dataQueue = new LinkedList();
            this.ackQueue = new LinkedList();
            this.currentPacket = null;
            this.maxPackets = 80;
            this.response = null;
            this.currentSeqno = 0L;
            this.bytesCurBlock = 0L;
            this.packetSize = 0;
            this.chunksPerPacket = 0;
            this.nodes = null;
            this.hasError = false;
            this.errorIndex = 0;
            this.lastException = null;
            this.artificialSlowdown = 0L;
            this.lastFlushOffset = -1L;
            this.persistBlocks = false;
            this.recoveryErrorCount = 0;
            this.maxRecoveryErrorCount = 5;
            this.src = src;
            this.blockSize = blockSize;
            this.progress = progress;
            if (progress != null) {
                LOG.debug((Object)("Set non-null progress callback on DFSOutputStream " + src));
            }
            if ((bytesPerChecksum = DFSClient.this.conf.getInt("io.bytes.per.checksum", 512)) < 1 || blockSize % (long)bytesPerChecksum != 0L) {
                throw new IOException("io.bytes.per.checksum(" + bytesPerChecksum + ") and blockSize(" + blockSize + ") do not match. " + "blockSize should be a " + "multiple of io.bytes.per.checksum");
            }
            this.checksum = DataChecksum.newDataChecksum(1, bytesPerChecksum);
            int chunkSize = bytesPerChecksum + this.checksum.getChecksumSize();
            this.chunksPerPacket = Math.max((DFSClient.this.writePacketSize - 21 - 4 + chunkSize - 1) / chunkSize, 1);
            this.packetSize = 25 + chunkSize * this.chunksPerPacket;
            try {
                DFSClient.this.namenode.create(src, masked, DFSClient.this.clientName, overwrite, replication, blockSize);
            }
            catch (RemoteException re) {
                throw re.unwrapRemoteException(AccessControlException.class, QuotaExceededException.class);
            }
            this.streamer = new DataStreamer();
            this.streamer.setDaemon(true);
            this.streamer.start();
        }

        private DatanodeInfo[] nextBlockOutputStream(String client) throws IOException {
            boolean success;
            DatanodeInfo[] nodes;
            LocatedBlock lb = null;
            boolean retry = false;
            int count = DFSClient.this.conf.getInt("dfs.client.block.write.retries", 3);
            do {
                this.hasError = false;
                this.errorIndex = 0;
                retry = false;
                nodes = null;
                success = false;
                long startTime = System.currentTimeMillis();
                lb = this.locateFollowingBlock(startTime);
                this.block = lb.getBlock();
                nodes = lb.getLocations();
                success = this.createBlockOutputStream(nodes, client, false);
                if (success) continue;
                LOG.info((Object)("Abandoning block " + this.block));
                DFSClient.this.namenode.abandonBlock(this.block, this.src, DFSClient.this.clientName);
                retry = true;
                try {
                    if (System.currentTimeMillis() - startTime > 5000L) {
                        LOG.info((Object)("Waiting to find target node: " + nodes[0].getName()));
                    }
                    Thread.sleep(6000L);
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
            } while (retry && --count >= 0);
            if (!success) {
                throw new IOException("Unable to create new block.");
            }
            return nodes;
        }

        private boolean createBlockOutputStream(DatanodeInfo[] nodes, String client, boolean recoveryFlag) {
            String firstBadLink = "";
            if (LOG.isDebugEnabled()) {
                for (int i = 0; i < nodes.length; ++i) {
                    LOG.debug((Object)("pipeline = " + nodes[i].getName()));
                }
            }
            this.persistBlocks = true;
            try {
                LOG.debug((Object)("Connecting to " + nodes[0].getName()));
                InetSocketAddress target = NetUtils.createSocketAddr(nodes[0].getName());
                this.s = DFSClient.this.socketFactory.createSocket();
                int timeoutValue = 3000 * nodes.length + DFSClient.this.socketTimeout;
                this.s.connect(target, timeoutValue);
                this.s.setSoTimeout(timeoutValue);
                this.s.setSendBufferSize(131072);
                LOG.debug((Object)("Send buf size " + this.s.getSendBufferSize()));
                long writeTimeout = 5000 * nodes.length + DFSClient.this.datanodeWriteTimeout;
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(this.s, writeTimeout), DataNode.SMALL_BUFFER_SIZE));
                this.blockReplyStream = new DataInputStream(NetUtils.getInputStream(this.s));
                out.writeShort(11);
                out.write(80);
                out.writeLong(this.block.getBlockId());
                out.writeLong(this.block.getGenerationStamp());
                out.writeInt(nodes.length);
                out.writeBoolean(recoveryFlag);
                Text.writeString(out, client);
                out.writeBoolean(false);
                out.writeInt(nodes.length - 1);
                for (int i = 1; i < nodes.length; ++i) {
                    nodes[i].write(out);
                }
                this.checksum.writeHeader(out);
                out.flush();
                firstBadLink = Text.readString(this.blockReplyStream);
                if (firstBadLink.length() != 0) {
                    throw new IOException("Bad connect ack with firstBadLink " + firstBadLink);
                }
                this.blockStream = out;
                return true;
            }
            catch (IOException ie) {
                LOG.info((Object)("Exception in createBlockOutputStream " + ie));
                if (firstBadLink.length() != 0) {
                    for (int i = 0; i < nodes.length; ++i) {
                        if (!nodes[i].getName().equals(firstBadLink)) continue;
                        this.errorIndex = i;
                        break;
                    }
                }
                this.hasError = true;
                this.blockReplyStream = null;
                return false;
            }
        }

        private LocatedBlock locateFollowingBlock(long start) throws IOException {
            int retries = 5;
            long sleeptime = 400L;
            long localstart = System.currentTimeMillis();
            while (true) {
                try {
                    return DFSClient.this.namenode.addBlock(this.src, DFSClient.this.clientName);
                }
                catch (RemoteException e) {
                    if (--retries == 0 && !NotReplicatedYetException.class.getName().equals(e.getClassName())) {
                        throw e;
                    }
                    LOG.info((Object)StringUtils.stringifyException(e));
                    if (System.currentTimeMillis() - localstart > 5000L) {
                        LOG.info((Object)("Waiting for replication for " + (System.currentTimeMillis() - localstart) / 1000L + " seconds"));
                    }
                    try {
                        LOG.warn((Object)("NotReplicatedYetException sleeping " + this.src + " retries left " + retries));
                        Thread.sleep(sleeptime);
                        sleeptime *= 2L;
                    }
                    catch (InterruptedException ie) {
                    }
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void writeChunk(byte[] b, int offset, int len, byte[] checksum) throws IOException {
            DFSClient.this.checkOpen();
            this.isClosed();
            int cklen = checksum.length;
            int bytesPerChecksum = this.checksum.getBytesPerChecksum();
            if (len > bytesPerChecksum) {
                throw new IOException("writeChunk() buffer size is " + len + " is larger than supported  bytesPerChecksum " + bytesPerChecksum);
            }
            if (checksum.length != this.checksum.getChecksumSize()) {
                throw new IOException("writeChunk() checksum size is supposed to be " + this.checksum.getChecksumSize() + " but found to be " + checksum.length);
            }
            LinkedList<Packet> linkedList = this.dataQueue;
            synchronized (linkedList) {
                while (!this.closed && this.dataQueue.size() + this.ackQueue.size() > this.maxPackets) {
                    try {
                        this.dataQueue.wait();
                    }
                    catch (InterruptedException e) {}
                }
                this.isClosed();
                if (this.currentPacket == null) {
                    this.currentPacket = new Packet(this.packetSize, this.chunksPerPacket, this.bytesCurBlock);
                    LOG.debug((Object)("DFSClient writeChunk allocating new packet " + this.currentPacket.seqno));
                }
                this.currentPacket.writeChecksum(checksum, 0, cklen);
                this.currentPacket.writeData(b, offset, len);
                ++this.currentPacket.numChunks;
                this.bytesCurBlock += (long)len;
                if (this.currentPacket.numChunks == this.chunksPerPacket || this.bytesCurBlock == this.blockSize) {
                    LOG.debug((Object)("DFSClient writeChunk packet full seqno " + this.currentPacket.seqno));
                    if (this.bytesCurBlock == this.blockSize) {
                        this.currentPacket.lastPacketInBlock = true;
                        this.bytesCurBlock = 0L;
                        this.lastFlushOffset = -1L;
                    }
                    this.dataQueue.addLast(this.currentPacket);
                    this.dataQueue.notifyAll();
                    this.currentPacket = null;
                }
            }
        }

        public synchronized void sync() throws IOException {
            try {
                long saveOffset = this.bytesCurBlock;
                this.flushBuffer(true);
                LOG.debug((Object)("DFSClient flush() : saveOffset " + saveOffset + " bytesCurBlock " + this.bytesCurBlock + " lastFlushOffset " + this.lastFlushOffset));
                if (this.lastFlushOffset != this.bytesCurBlock) {
                    this.lastFlushOffset = this.bytesCurBlock;
                    this.flushInternal();
                } else {
                    this.currentPacket = null;
                }
                this.bytesCurBlock = saveOffset;
                if (this.persistBlocks) {
                    DFSClient.this.namenode.fsync(this.src, DFSClient.this.clientName);
                    this.persistBlocks = false;
                }
            }
            catch (IOException e) {
                this.lastException = new IOException("IOException flush:" + e);
                this.closed = true;
                this.closeThreads();
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void flushInternal() throws IOException {
            DFSClient.this.checkOpen();
            this.isClosed();
            while (!this.closed) {
                LinkedList<Packet> linkedList = this.dataQueue;
                synchronized (linkedList) {
                    this.isClosed();
                    if (this.currentPacket != null) {
                        this.dataQueue.addLast(this.currentPacket);
                        this.dataQueue.notifyAll();
                        this.currentPacket = null;
                    }
                    if (!this.closed && this.dataQueue.size() != 0) {
                        try {
                            this.dataQueue.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                linkedList = this.ackQueue;
                synchronized (linkedList) {
                    if (!this.closed && this.ackQueue.size() != 0) {
                        try {
                            this.ackQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                linkedList = this.dataQueue;
                synchronized (linkedList) {
                    LinkedList<Packet> linkedList2 = this.ackQueue;
                    synchronized (linkedList2) {
                        if (this.dataQueue.size() + this.ackQueue.size() == 0) {
                            break;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            this.closeInternal();
            TreeMap treeMap = DFSClient.this.pendingCreates;
            synchronized (treeMap) {
                DFSClient.this.pendingCreates.remove(this.src);
            }
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
        }

        private void closeThreads() throws IOException {
            try {
                this.streamer.close();
                this.streamer.join();
                if (this.response != null) {
                    this.response.close();
                    this.response.join();
                    this.response = null;
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to shutdown response thread");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void closeInternal() throws IOException {
            DFSClient.this.checkOpen();
            this.isClosed();
            try {
                this.flushBuffer();
                LinkedList<Packet> linkedList = this.dataQueue;
                synchronized (linkedList) {
                    if (this.currentPacket == null && this.bytesCurBlock != 0L) {
                        this.currentPacket = new Packet(this.packetSize, this.chunksPerPacket, this.bytesCurBlock);
                    }
                    if (this.currentPacket != null) {
                        this.currentPacket.lastPacketInBlock = true;
                    }
                }
                this.flushInternal();
                this.closed = true;
                this.closeThreads();
                linkedList = this.dataQueue;
                synchronized (linkedList) {
                    if (this.blockStream != null) {
                        this.blockStream.writeInt(0);
                        this.blockStream.close();
                        this.blockReplyStream.close();
                    }
                    if (this.s != null) {
                        this.s.close();
                        this.s = null;
                    }
                }
                this.streamer = null;
                this.blockStream = null;
                this.blockReplyStream = null;
                long localstart = System.currentTimeMillis();
                boolean fileComplete = false;
                while (!fileComplete) {
                    fileComplete = DFSClient.this.namenode.complete(this.src, DFSClient.this.clientName);
                    if (fileComplete) continue;
                    try {
                        Thread.sleep(400L);
                        if (System.currentTimeMillis() - localstart <= 5000L) continue;
                        LOG.info((Object)("Could not complete file " + this.src + " retrying..."));
                    }
                    catch (InterruptedException ie) {}
                }
            }
            finally {
                this.closed = true;
            }
        }

        void setArtificialSlowdown(long period) {
            this.artificialSlowdown = period;
        }

        synchronized void setChunksPerPacket(int value) {
            this.chunksPerPacket = Math.min(this.chunksPerPacket, value);
            this.packetSize = 25 + (this.checksum.getBytesPerChecksum() + this.checksum.getChecksumSize()) * this.chunksPerPacket;
        }

        synchronized void setTestFilename(String newname) {
            this.src = newname;
        }

        static /* synthetic */ DatanodeInfo[] access$1602(DFSOutputStream x0, DatanodeInfo[] x1) {
            x0.nodes = x1;
            return x1;
        }

        private class ResponseProcessor
        extends Thread {
            private volatile boolean closed = false;
            private DatanodeInfo[] targets = null;
            private boolean lastPacketInBlock = false;

            ResponseProcessor(DatanodeInfo[] targets) {
                this.targets = targets;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.setName("ResponseProcessor for block " + DFSOutputStream.this.block);
                while (!this.closed && DFSClient.this.clientRunning && !this.lastPacketInBlock) {
                    block18: {
                        try {
                            long seqno = DFSOutputStream.this.blockReplyStream.readLong();
                            LOG.debug((Object)("DFSClient received ack for seqno " + seqno));
                            if (seqno == -1L) continue;
                            if (seqno != -2L) {
                                Packet one = null;
                                LinkedList linkedList = DFSOutputStream.this.ackQueue;
                                synchronized (linkedList) {
                                    one = (Packet)DFSOutputStream.this.ackQueue.getFirst();
                                }
                                if (one.seqno != seqno) {
                                    throw new IOException("Responseprocessor: Expecting seqno  for block " + DFSOutputStream.this.block + one.seqno + " but received " + seqno);
                                }
                                this.lastPacketInBlock = one.lastPacketInBlock;
                            }
                            for (int i = 0; i < this.targets.length && DFSClient.this.clientRunning; ++i) {
                                short reply = DFSOutputStream.this.blockReplyStream.readShort();
                                if (reply == 0) continue;
                                DFSOutputStream.this.errorIndex = i;
                                throw new IOException("Bad response " + reply + " for block " + DFSOutputStream.this.block + " from datanode " + this.targets[i].getName());
                            }
                            LinkedList linkedList = DFSOutputStream.this.ackQueue;
                            synchronized (linkedList) {
                                DFSOutputStream.this.ackQueue.removeFirst();
                                DFSOutputStream.this.ackQueue.notifyAll();
                            }
                        }
                        catch (Exception e) {
                            if (this.closed) break block18;
                            DFSOutputStream.this.hasError = true;
                            LOG.warn((Object)("DFSOutputStream ResponseProcessor exception  for block " + DFSOutputStream.this.block + StringUtils.stringifyException(e)));
                            this.closed = true;
                        }
                    }
                    LinkedList linkedList = DFSOutputStream.this.dataQueue;
                    synchronized (linkedList) {
                        DFSOutputStream.this.dataQueue.notifyAll();
                    }
                    linkedList = DFSOutputStream.this.ackQueue;
                    synchronized (linkedList) {
                        DFSOutputStream.this.ackQueue.notifyAll();
                    }
                }
            }

            void close() {
                this.closed = true;
                this.interrupt();
            }
        }

        private class DataStreamer
        extends Thread {
            private volatile boolean closed = false;

            private DataStreamer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!this.closed && DFSClient.this.clientRunning) {
                    if (DFSOutputStream.this.hasError && DFSOutputStream.this.response != null) {
                        try {
                            DFSOutputStream.this.response.close();
                            DFSOutputStream.this.response.join();
                            DFSOutputStream.this.response = null;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    Packet one = null;
                    LinkedList linkedList = DFSOutputStream.this.dataQueue;
                    synchronized (linkedList) {
                        boolean doSleep = DFSOutputStream.this.processDatanodeError();
                        while (!this.closed && !DFSOutputStream.this.hasError && DFSClient.this.clientRunning && DFSOutputStream.this.dataQueue.size() == 0 || doSleep) {
                            try {
                                DFSOutputStream.this.dataQueue.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            doSleep = false;
                        }
                        if (this.closed || DFSOutputStream.this.hasError || DFSOutputStream.this.dataQueue.size() == 0 || !DFSClient.this.clientRunning) {
                            continue;
                        }
                        try {
                            one = (Packet)DFSOutputStream.this.dataQueue.getFirst();
                            long offsetInBlock = one.offsetInBlock;
                            if (DFSOutputStream.this.blockStream == null) {
                                LOG.debug((Object)"Allocating new block");
                                DFSOutputStream.access$1602(DFSOutputStream.this, DFSOutputStream.this.nextBlockOutputStream(DFSOutputStream.this.src));
                                this.setName("DataStreamer for file " + DFSOutputStream.this.src + " block " + DFSOutputStream.this.block);
                                DFSOutputStream.this.response = new ResponseProcessor(DFSOutputStream.this.nodes);
                                DFSOutputStream.this.response.start();
                            }
                            if (offsetInBlock >= DFSOutputStream.this.blockSize) {
                                throw new IOException("BlockSize " + DFSOutputStream.this.blockSize + " is smaller than data size. " + " Offset of packet in block " + offsetInBlock + " Aborting file " + DFSOutputStream.this.src);
                            }
                            ByteBuffer buf = one.getBuffer();
                            DFSOutputStream.this.dataQueue.removeFirst();
                            DFSOutputStream.this.dataQueue.notifyAll();
                            LinkedList linkedList2 = DFSOutputStream.this.ackQueue;
                            synchronized (linkedList2) {
                                DFSOutputStream.this.ackQueue.addLast(one);
                                DFSOutputStream.this.ackQueue.notifyAll();
                            }
                            DFSOutputStream.this.blockStream.write(buf.array(), buf.position(), buf.remaining());
                            if (one.lastPacketInBlock) {
                                DFSOutputStream.this.blockStream.writeInt(0);
                            }
                            DFSOutputStream.this.blockStream.flush();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("DataStreamer block " + DFSOutputStream.this.block + " wrote packet seqno:" + one.seqno + " size:" + buf.remaining() + " offsetInBlock:" + one.offsetInBlock + " lastPacketInBlock:" + one.lastPacketInBlock));
                            }
                        }
                        catch (IOException e) {
                            LOG.warn((Object)("DataStreamer Exception: " + e));
                            DFSOutputStream.this.hasError = true;
                        }
                    }
                    if (this.closed || DFSOutputStream.this.hasError || !DFSClient.this.clientRunning) continue;
                    if (one.lastPacketInBlock) {
                        linkedList = DFSOutputStream.this.ackQueue;
                        synchronized (linkedList) {
                            while (!DFSOutputStream.this.hasError && DFSOutputStream.this.ackQueue.size() != 0 && DFSClient.this.clientRunning) {
                                try {
                                    DFSOutputStream.this.ackQueue.wait();
                                }
                                catch (InterruptedException e) {}
                            }
                        }
                        LOG.debug((Object)("Closing old block " + DFSOutputStream.this.block));
                        this.setName("DataStreamer for file " + DFSOutputStream.this.src);
                        DFSOutputStream.this.response.close();
                        try {
                            DFSOutputStream.this.response.join();
                            DFSOutputStream.this.response = null;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (this.closed || DFSOutputStream.this.hasError || !DFSClient.this.clientRunning) continue;
                        LinkedList e = DFSOutputStream.this.dataQueue;
                        synchronized (e) {
                            try {
                                DFSOutputStream.this.blockStream.close();
                                DFSOutputStream.this.blockReplyStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            DFSOutputStream.access$1602(DFSOutputStream.this, null);
                            DFSOutputStream.this.response = null;
                            DFSOutputStream.this.blockStream = null;
                            DFSOutputStream.this.blockReplyStream = null;
                        }
                    }
                    if (DFSOutputStream.this.progress != null) {
                        DFSOutputStream.this.progress.progress();
                    }
                    if (DFSOutputStream.this.artificialSlowdown == 0L || !DFSClient.this.clientRunning) continue;
                    try {
                        Thread.sleep(DFSOutputStream.this.artificialSlowdown);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void close() {
                this.closed = true;
                LinkedList linkedList = DFSOutputStream.this.dataQueue;
                synchronized (linkedList) {
                    DFSOutputStream.this.dataQueue.notifyAll();
                }
                linkedList = DFSOutputStream.this.ackQueue;
                synchronized (linkedList) {
                    DFSOutputStream.this.ackQueue.notifyAll();
                }
                this.interrupt();
            }
        }

        private class Packet {
            ByteBuffer buffer;
            byte[] buf;
            long seqno;
            long offsetInBlock;
            boolean lastPacketInBlock = false;
            int numChunks = 0;
            int dataStart;
            int dataPos;
            int checksumStart;
            int checksumPos;

            Packet(int pktSize, int chunksPerPkt, long offsetInBlock) {
                this.offsetInBlock = offsetInBlock;
                this.seqno = DFSOutputStream.this.currentSeqno;
                DFSOutputStream.this.currentSeqno++;
                this.buffer = null;
                this.buf = new byte[pktSize];
                this.checksumPos = this.checksumStart = 25;
                this.dataPos = this.dataStart = this.checksumStart + chunksPerPkt * DFSOutputStream.this.checksum.getChecksumSize();
            }

            void writeData(byte[] inarray, int off, int len) {
                if (this.dataPos + len > this.buf.length) {
                    throw new BufferOverflowException();
                }
                System.arraycopy(inarray, off, this.buf, this.dataPos, len);
                this.dataPos += len;
            }

            void writeChecksum(byte[] inarray, int off, int len) {
                if (this.checksumPos + len > this.dataStart) {
                    throw new BufferOverflowException();
                }
                System.arraycopy(inarray, off, this.buf, this.checksumPos, len);
                this.checksumPos += len;
            }

            ByteBuffer getBuffer() {
                if (this.buffer != null) {
                    return this.buffer;
                }
                int dataLen = this.dataPos - this.dataStart;
                int checksumLen = this.checksumPos - this.checksumStart;
                if (this.checksumPos != this.dataStart) {
                    System.arraycopy(this.buf, this.checksumStart, this.buf, this.dataStart - checksumLen, checksumLen);
                }
                int pktLen = 4 + dataLen + checksumLen;
                this.buffer = ByteBuffer.wrap(this.buf, this.dataStart - this.checksumPos, 21 + pktLen);
                this.buf = null;
                this.buffer.mark();
                this.buffer.putInt(pktLen);
                this.buffer.putLong(this.offsetInBlock);
                this.buffer.putLong(this.seqno);
                this.buffer.put((byte)(this.lastPacketInBlock ? 1 : 0));
                this.buffer.putInt(dataLen);
                this.buffer.reset();
                return this.buffer;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DFSDataInputStream
    extends FSDataInputStream {
        DFSDataInputStream(DFSInputStream in) throws IOException {
            super(in);
        }

        public DatanodeInfo getCurrentDatanode() {
            return ((DFSInputStream)this.in).getCurrentDatanode();
        }

        public Block getCurrentBlock() {
            return ((DFSInputStream)this.in).getCurrentBlock();
        }

        synchronized List<LocatedBlock> getAllBlocks() throws IOException {
            return ((DFSInputStream)this.in).getAllBlocks();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DFSInputStream
    extends FSInputStream {
        private Socket s = null;
        private boolean closed = false;
        private String src;
        private long prefetchSize = 10L * DFSClient.access$100(DFSClient.this);
        private BlockReader blockReader = null;
        private boolean verifyChecksum;
        private LocatedBlocks locatedBlocks = null;
        private DatanodeInfo currentNode = null;
        private Block currentBlock = null;
        private long pos = 0L;
        private long blockEnd = -1L;
        private int failures = 0;
        private ConcurrentHashMap<DatanodeInfo, DatanodeInfo> deadNodes = new ConcurrentHashMap();
        private int buffersize = 1;
        private byte[] oneByteBuf = new byte[1];

        void addToDeadNodes(DatanodeInfo dnInfo) {
            this.deadNodes.put(dnInfo, dnInfo);
        }

        DFSInputStream(String src, int buffersize, boolean verifyChecksum) throws IOException {
            this.verifyChecksum = verifyChecksum;
            this.buffersize = buffersize;
            this.src = src;
            this.prefetchSize = DFSClient.this.conf.getLong("dfs.read.prefetch.size", this.prefetchSize);
            this.openInfo();
        }

        synchronized void openInfo() throws IOException {
            LocatedBlocks newInfo = DFSClient.this.callGetBlockLocations(this.src, 0L, this.prefetchSize);
            if (newInfo == null) {
                throw new IOException("Cannot open filename " + this.src);
            }
            if (this.locatedBlocks != null) {
                Iterator<LocatedBlock> oldIter = this.locatedBlocks.getLocatedBlocks().iterator();
                Iterator<LocatedBlock> newIter = newInfo.getLocatedBlocks().iterator();
                while (oldIter.hasNext() && newIter.hasNext()) {
                    if (oldIter.next().getBlock().equals(newIter.next().getBlock())) continue;
                    throw new IOException("Blocklist for " + this.src + " has changed!");
                }
            }
            this.locatedBlocks = newInfo;
            this.currentNode = null;
        }

        public synchronized long getFileLength() {
            return this.locatedBlocks == null ? 0L : this.locatedBlocks.getFileLength();
        }

        public DatanodeInfo getCurrentDatanode() {
            return this.currentNode;
        }

        public Block getCurrentBlock() {
            return this.currentBlock;
        }

        synchronized List<LocatedBlock> getAllBlocks() throws IOException {
            return this.getBlockRange(0L, this.getFileLength());
        }

        private LocatedBlock getBlockAt(long offset) throws IOException {
            assert (this.locatedBlocks != null) : "locatedBlocks is null";
            int targetBlockIdx = this.locatedBlocks.findBlock(offset);
            if (targetBlockIdx < 0) {
                targetBlockIdx = LocatedBlocks.getInsertIndex(targetBlockIdx);
                LocatedBlocks newBlocks = DFSClient.this.callGetBlockLocations(this.src, offset, this.prefetchSize);
                assert (newBlocks != null) : "Could not find target position " + offset;
                this.locatedBlocks.insertRange(targetBlockIdx, newBlocks.getLocatedBlocks());
            }
            LocatedBlock blk = this.locatedBlocks.get(targetBlockIdx);
            this.pos = offset;
            this.blockEnd = blk.getStartOffset() + blk.getBlockSize() - 1L;
            this.currentBlock = blk.getBlock();
            return blk;
        }

        private synchronized List<LocatedBlock> getBlockRange(long offset, long length) throws IOException {
            assert (this.locatedBlocks != null) : "locatedBlocks is null";
            ArrayList<LocatedBlock> blockRange = new ArrayList<LocatedBlock>();
            int blockIdx = this.locatedBlocks.findBlock(offset);
            if (blockIdx < 0) {
                blockIdx = LocatedBlocks.getInsertIndex(blockIdx);
            }
            long remaining = length;
            long curOff = offset;
            while (remaining > 0L) {
                LocatedBlock blk = null;
                if (blockIdx < this.locatedBlocks.locatedBlockCount()) {
                    blk = this.locatedBlocks.get(blockIdx);
                }
                if (blk == null || curOff < blk.getStartOffset()) {
                    LocatedBlocks newBlocks = DFSClient.this.callGetBlockLocations(this.src, curOff, remaining);
                    this.locatedBlocks.insertRange(blockIdx, newBlocks.getLocatedBlocks());
                    continue;
                }
                assert (curOff >= blk.getStartOffset()) : "Block not found";
                blockRange.add(blk);
                long bytesRead = blk.getStartOffset() + blk.getBlockSize() - curOff;
                remaining -= bytesRead;
                curOff += bytesRead;
                ++blockIdx;
            }
            return blockRange;
        }

        private synchronized DatanodeInfo blockSeekTo(long target) throws IOException {
            if (target >= this.getFileLength()) {
                throw new IOException("Attempted to read past end of file");
            }
            if (this.blockReader != null) {
                this.blockReader.close();
                this.blockReader = null;
            }
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
            LocatedBlock targetBlock = this.getBlockAt(target);
            assert (target == this.pos) : "Wrong postion " + this.pos + " expect " + target;
            long offsetIntoBlock = target - targetBlock.getStartOffset();
            DatanodeInfo chosenNode = null;
            while (this.s == null) {
                DNAddrPair retval = this.chooseDataNode(targetBlock);
                chosenNode = retval.info;
                InetSocketAddress targetAddr = retval.addr;
                try {
                    this.s = DFSClient.this.socketFactory.createSocket();
                    this.s.connect(targetAddr, DFSClient.this.socketTimeout);
                    this.s.setSoTimeout(DFSClient.this.socketTimeout);
                    Block blk = targetBlock.getBlock();
                    this.blockReader = BlockReader.newBlockReader(this.s, this.src, blk.getBlockId(), blk.getGenerationStamp(), offsetIntoBlock, blk.getNumBytes() - offsetIntoBlock, this.buffersize, this.verifyChecksum);
                    return chosenNode;
                }
                catch (IOException ex) {
                    LOG.debug((Object)("Failed to connect to " + targetAddr + ":" + StringUtils.stringifyException(ex)));
                    this.addToDeadNodes(chosenNode);
                    if (this.s != null) {
                        try {
                            this.s.close();
                        }
                        catch (IOException iex) {
                            // empty catch block
                        }
                    }
                    this.s = null;
                }
            }
            return chosenNode;
        }

        @Override
        public synchronized void close() throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.blockReader != null) {
                this.blockReader.close();
                this.blockReader = null;
            }
            if (this.s != null) {
                this.s.close();
                this.s = null;
            }
            super.close();
            this.closed = true;
        }

        @Override
        public synchronized int read() throws IOException {
            int ret = this.read(this.oneByteBuf, 0, 1);
            return ret <= 0 ? -1 : this.oneByteBuf[0] & 0xFF;
        }

        private synchronized int readBuffer(byte[] buf, int off, int len) throws IOException {
            IOException ioe;
            do {
                try {
                    return this.blockReader.read(buf, off, len);
                }
                catch (ChecksumException ce) {
                    LOG.warn((Object)("Found Checksum error for " + this.currentBlock + " from " + this.currentNode.getName() + " at " + ce.getPos()));
                    DFSClient.this.reportChecksumFailure(this.src, this.currentBlock, this.currentNode);
                    ioe = ce;
                }
                catch (IOException e) {
                    LOG.warn((Object)("Exception while reading from " + this.currentBlock + " of " + this.src + " from " + this.currentNode + ": " + StringUtils.stringifyException(e)));
                    ioe = e;
                }
                this.addToDeadNodes(this.currentNode);
            } while (this.seekToNewSource(this.pos));
            throw ioe;
        }

        @Override
        public synchronized int read(byte[] buf, int off, int len) throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.pos < this.getFileLength()) {
                int retries = 2;
                while (retries > 0) {
                    try {
                        int realLen;
                        int result;
                        if (this.pos > this.blockEnd) {
                            this.currentNode = this.blockSeekTo(this.pos);
                        }
                        if ((result = this.readBuffer(buf, off, realLen = Math.min(len, (int)(this.blockEnd - this.pos + 1L)))) >= 0) {
                            this.pos += (long)result;
                        } else {
                            throw new IOException("Unexpected EOS from the reader");
                        }
                        if (DFSClient.this.stats != null && result != -1) {
                            DFSClient.this.stats.incrementBytesRead(result);
                        }
                        return result;
                    }
                    catch (ChecksumException ce) {
                        throw ce;
                    }
                    catch (IOException e) {
                        if (retries == 1) {
                            LOG.warn((Object)("DFS Read: " + StringUtils.stringifyException(e)));
                        }
                        this.blockEnd = -1L;
                        if (this.currentNode != null) {
                            this.addToDeadNodes(this.currentNode);
                        }
                        if (--retries != 0) continue;
                        throw e;
                    }
                }
            }
            return -1;
        }

        private DNAddrPair chooseDataNode(LocatedBlock block) throws IOException {
            while (true) {
                DatanodeInfo[] nodes = block.getLocations();
                try {
                    DatanodeInfo chosenNode = DFSClient.this.bestNode(nodes, this.deadNodes);
                    InetSocketAddress targetAddr = NetUtils.createSocketAddr(chosenNode.getName());
                    return new DNAddrPair(chosenNode, targetAddr);
                }
                catch (IOException ie) {
                    String blockInfo = block.getBlock() + " file=" + this.src;
                    if (this.failures >= 3) {
                        throw new IOException("Could not obtain block: " + blockInfo);
                    }
                    if (nodes == null || nodes.length == 0) {
                        LOG.info((Object)("No node available for block: " + blockInfo));
                    }
                    LOG.info((Object)("Could not obtain block " + block.getBlock() + " from any node:  " + ie));
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException iex) {
                        // empty catch block
                    }
                    this.deadNodes.clear();
                    this.openInfo();
                    ++this.failures;
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void fetchBlockByteRange(LocatedBlock block, long start, long end, byte[] buf, int offset) throws IOException {
            Socket dn = null;
            int numAttempts = block.getLocations().length;
            IOException ioe = null;
            while (dn == null && numAttempts-- > 0) {
                DatanodeInfo chosenNode;
                block9: {
                    DNAddrPair retval = this.chooseDataNode(block);
                    chosenNode = retval.info;
                    InetSocketAddress targetAddr = retval.addr;
                    BlockReader reader = null;
                    try {
                        dn = DFSClient.this.socketFactory.createSocket();
                        dn.connect(targetAddr, DFSClient.this.socketTimeout);
                        dn.setSoTimeout(DFSClient.this.socketTimeout);
                        int len = (int)(end - start + 1L);
                        reader = BlockReader.newBlockReader(dn, this.src, block.getBlock().getBlockId(), block.getBlock().getGenerationStamp(), start, len, this.buffersize, this.verifyChecksum);
                        int nread = reader.readAll(buf, offset, len);
                        if (nread != len) {
                            throw new IOException("truncated return from reader.read(): excpected " + len + ", got " + nread);
                        }
                        IOUtils.closeStream(reader);
                    }
                    catch (ChecksumException e) {
                        ioe = e;
                        LOG.warn((Object)("fetchBlockByteRange(). Got a checksum exception for " + this.src + " at " + block.getBlock() + ":" + e.getPos() + " from " + chosenNode.getName()));
                        DFSClient.this.reportChecksumFailure(this.src, block.getBlock(), chosenNode);
                        IOUtils.closeStream(reader);
                        IOUtils.closeSocket(dn);
                        dn = null;
                        break block9;
                    }
                    catch (IOException e2) {
                        ioe = e2;
                        LOG.warn((Object)("Failed to connect to " + targetAddr + " for file " + this.src + " for block " + block.getBlock().getBlockId() + ":" + StringUtils.stringifyException(e2)));
                        break block9;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        IOUtils.closeStream(reader);
                        IOUtils.closeSocket(dn);
                        dn = null;
                    }
                    IOUtils.closeSocket(dn);
                    dn = null;
                    return;
                }
                this.addToDeadNodes(chosenNode);
            }
            throw ioe == null ? new IOException("Could not read data") : ioe;
        }

        @Override
        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            DFSClient.this.checkOpen();
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            long filelen = this.getFileLength();
            if (position < 0L || position >= filelen) {
                return -1;
            }
            int realLen = length;
            if (position + (long)length > filelen) {
                realLen = (int)(filelen - position);
            }
            List<LocatedBlock> blockRange = this.getBlockRange(position, realLen);
            int remaining = realLen;
            for (LocatedBlock blk : blockRange) {
                long targetStart = position - blk.getStartOffset();
                long bytesToRead = Math.min((long)remaining, blk.getBlockSize() - targetStart);
                this.fetchBlockByteRange(blk, targetStart, targetStart + bytesToRead - 1L, buffer, offset);
                remaining = (int)((long)remaining - bytesToRead);
                position += bytesToRead;
                offset = (int)((long)offset + bytesToRead);
            }
            assert (remaining == 0) : "Wrong number of bytes read.";
            if (DFSClient.this.stats != null) {
                DFSClient.this.stats.incrementBytesRead(realLen);
            }
            return realLen;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n > 0L) {
                long fileLen;
                long curPos = this.getPos();
                if (n + curPos > (fileLen = this.getFileLength())) {
                    n = fileLen - curPos;
                }
                this.seek(curPos + n);
                return n;
            }
            return n < 0L ? -1L : 0L;
        }

        @Override
        public synchronized void seek(long targetPos) throws IOException {
            int diff;
            if (targetPos > this.getFileLength()) {
                throw new IOException("Cannot seek after EOF");
            }
            boolean done = false;
            if (this.pos <= targetPos && targetPos <= this.blockEnd && (diff = (int)(targetPos - this.pos)) <= 131072) {
                this.pos += this.blockReader.skip(diff);
                if (this.pos == targetPos) {
                    done = true;
                }
            }
            if (!done) {
                this.pos = targetPos;
                this.blockEnd = -1L;
            }
        }

        @Override
        public synchronized boolean seekToNewSource(long targetPos) throws IOException {
            boolean markedDead = this.deadNodes.containsKey(this.currentNode);
            this.addToDeadNodes(this.currentNode);
            DatanodeInfo oldNode = this.currentNode;
            DatanodeInfo newNode = this.blockSeekTo(targetPos);
            if (!markedDead) {
                this.deadNodes.remove(oldNode);
            }
            if (!oldNode.getStorageID().equals(newNode.getStorageID())) {
                this.currentNode = newNode;
                return true;
            }
            return false;
        }

        @Override
        public synchronized long getPos() throws IOException {
            return this.pos;
        }

        @Override
        public synchronized int available() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            return (int)(this.getFileLength() - this.pos);
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int readLimit) {
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("Mark/reset not supported");
        }
    }

    static class BlockReader
    extends FSInputChecker {
        private Socket dnSock;
        private DataInputStream in;
        private DataChecksum checksum;
        private long lastChunkOffset = -1L;
        private long lastChunkLen = -1L;
        private long lastSeqNo = -1L;
        private long startOffset;
        private long firstChunkOffset;
        private int bytesPerChecksum;
        private int checksumSize;
        private boolean gotEOS = false;
        byte[] skipBuf = null;
        ByteBuffer checksumBytes = null;
        int dataLeft = 0;
        boolean isLastPacket = false;

        public synchronized int read(byte[] buf, int off, int len) throws IOException {
            int nRead;
            if (this.lastChunkLen < 0L && this.startOffset > this.firstChunkOffset && len > 0) {
                int toSkip = (int)(this.startOffset - this.firstChunkOffset);
                if (this.skipBuf == null) {
                    this.skipBuf = new byte[this.bytesPerChecksum];
                }
                if (super.read(this.skipBuf, 0, toSkip) != toSkip) {
                    throw new IOException("Could not skip required number of bytes");
                }
            }
            if ((nRead = super.read(buf, off, len)) >= 0 && this.gotEOS && this.needChecksum()) {
                this.checksumOk(this.dnSock);
            }
            return nRead;
        }

        public synchronized long skip(long n) throws IOException {
            long nSkipped;
            int ret;
            if (this.skipBuf == null) {
                this.skipBuf = new byte[this.bytesPerChecksum];
            }
            for (nSkipped = 0L; nSkipped < n; nSkipped += (long)ret) {
                int toSkip = (int)Math.min(n - nSkipped, (long)this.skipBuf.length);
                ret = this.read(this.skipBuf, 0, toSkip);
                if (ret > 0) continue;
                return nSkipped;
            }
            return nSkipped;
        }

        public int read() throws IOException {
            throw new IOException("read() is not expected to be invoked. Use read(buf, off, len) instead.");
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        public void seek(long pos) throws IOException {
            throw new IOException("Seek() is not supported in BlockInputChecker");
        }

        protected long getChunkPosition(long pos) {
            throw new RuntimeException("getChunkPosition() is not supported, since seek is not required");
        }

        private void adjustChecksumBytes(int dataLen) {
            int requiredSize = (dataLen + this.bytesPerChecksum - 1) / this.bytesPerChecksum * this.checksumSize;
            if (this.checksumBytes == null || requiredSize > this.checksumBytes.capacity()) {
                this.checksumBytes = ByteBuffer.wrap(new byte[requiredSize]);
            } else {
                this.checksumBytes.clear();
            }
            this.checksumBytes.limit(requiredSize);
        }

        protected synchronized int readChunk(long pos, byte[] buf, int offset, int len, byte[] checksumBuf) throws IOException {
            int chunkLen;
            if (this.gotEOS) {
                if (this.startOffset < 0L) {
                    throw new IOException("BlockRead: already got EOS or an error");
                }
                this.startOffset = -1L;
                return -1;
            }
            long chunkOffset = this.lastChunkOffset;
            if (this.lastChunkLen > 0L) {
                chunkOffset += this.lastChunkLen;
            }
            if (pos + this.firstChunkOffset != chunkOffset) {
                throw new IOException("Mismatch in pos : " + pos + " + " + this.firstChunkOffset + " != " + chunkOffset);
            }
            if (this.dataLeft <= 0) {
                int dataLen;
                int packetLen = this.in.readInt();
                long offsetInBlock = this.in.readLong();
                long seqno = this.in.readLong();
                boolean lastPacketInBlock = this.in.readBoolean();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("DFSClient readChunk got seqno " + seqno + " offsetInBlock " + offsetInBlock + " lastPacketInBlock " + lastPacketInBlock + " packetLen " + packetLen));
                }
                if ((dataLen = this.in.readInt()) < 0 || dataLen % this.bytesPerChecksum != 0 && !lastPacketInBlock || seqno != this.lastSeqNo + 1L) {
                    throw new IOException("BlockReader: error in packet header(chunkOffset : " + chunkOffset + ", dataLen : " + dataLen + ", seqno : " + seqno + " (last: " + this.lastSeqNo + "))");
                }
                this.lastSeqNo = seqno;
                this.isLastPacket = lastPacketInBlock;
                this.dataLeft = dataLen;
                this.adjustChecksumBytes(dataLen);
                if (dataLen > 0) {
                    IOUtils.readFully(this.in, this.checksumBytes.array(), 0, this.checksumBytes.limit());
                }
            }
            if ((chunkLen = Math.min(this.dataLeft, this.bytesPerChecksum)) > 0) {
                IOUtils.readFully(this.in, buf, offset, chunkLen);
                this.checksumBytes.get(checksumBuf, 0, this.checksumSize);
            }
            this.dataLeft -= chunkLen;
            this.lastChunkOffset = chunkOffset;
            this.lastChunkLen = chunkLen;
            if (this.dataLeft == 0 && this.isLastPacket || chunkLen == 0) {
                this.gotEOS = true;
            }
            if (chunkLen == 0) {
                return -1;
            }
            return chunkLen;
        }

        private BlockReader(String file, long blockId, DataInputStream in, DataChecksum checksum, boolean verifyChecksum, long startOffset, long firstChunkOffset, Socket dnSock) {
            super(new Path("/blk_" + blockId + ":of:" + file), 1, verifyChecksum, checksum.getChecksumSize() > 0 ? checksum : null, checksum.getBytesPerChecksum(), checksum.getChecksumSize());
            this.dnSock = dnSock;
            this.in = in;
            this.checksum = checksum;
            this.startOffset = Math.max(startOffset, 0L);
            this.firstChunkOffset = firstChunkOffset;
            this.lastChunkOffset = firstChunkOffset;
            this.lastChunkLen = -1L;
            this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
            this.checksumSize = this.checksum.getChecksumSize();
        }

        static BlockReader newBlockReader(Socket sock, String file, long blockId, long genStamp, long startOffset, long len, int bufferSize) throws IOException {
            return BlockReader.newBlockReader(sock, file, blockId, genStamp, startOffset, len, bufferSize, true);
        }

        static BlockReader newBlockReader(Socket sock, String file, long blockId, long genStamp, long startOffset, long len, int bufferSize, boolean verifyChecksum) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(sock, 480000L)));
            out.writeShort(11);
            out.write(81);
            out.writeLong(blockId);
            out.writeLong(genStamp);
            out.writeLong(startOffset);
            out.writeLong(len);
            out.flush();
            DataInputStream in = new DataInputStream(new BufferedInputStream(NetUtils.getInputStream(sock), bufferSize));
            if (in.readShort() != 0) {
                throw new IOException("Got error in response to OP_READ_BLOCK for file " + file + " for block " + blockId);
            }
            DataChecksum checksum = DataChecksum.newDataChecksum(in);
            long firstChunkOffset = in.readLong();
            if (firstChunkOffset < 0L || firstChunkOffset > startOffset || firstChunkOffset >= startOffset + (long)checksum.getBytesPerChecksum()) {
                throw new IOException("BlockReader: error in first chunk offset (" + firstChunkOffset + ") startOffset is " + startOffset + " for file " + file);
            }
            return new BlockReader(file, blockId, in, checksum, verifyChecksum, startOffset, firstChunkOffset, sock);
        }

        public synchronized void close() throws IOException {
            this.startOffset = -1L;
            this.checksum = null;
        }

        int readAll(byte[] buf, int offset, int len) throws IOException {
            return BlockReader.readFully(this, buf, offset, len);
        }

        private void checksumOk(Socket sock) {
            try {
                OutputStream out = NetUtils.getOutputStream(sock, 480000L);
                byte[] buf = new byte[]{0, 5};
                out.write(buf);
                out.flush();
            }
            catch (IOException e) {
                LOG.debug((Object)("Could not write to datanode " + sock.getInetAddress() + ": " + e.getMessage()));
            }
        }
    }

    private static class DNAddrPair {
        DatanodeInfo info;
        InetSocketAddress addr;

        DNAddrPair(DatanodeInfo info, InetSocketAddress addr) {
            this.info = info;
            this.addr = addr;
        }
    }

    class LeaseChecker
    implements Runnable {
        LeaseChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long lastRenewed = 0L;
            while (DFSClient.this.clientRunning) {
                if (System.currentTimeMillis() - lastRenewed > 30000L) {
                    try {
                        TreeMap treeMap = DFSClient.this.pendingCreates;
                        synchronized (treeMap) {
                            if (DFSClient.this.pendingCreates.size() > 0) {
                                DFSClient.this.namenode.renewLease(DFSClient.this.clientName);
                            }
                        }
                        lastRenewed = System.currentTimeMillis();
                    }
                    catch (IOException ie) {
                        String err = StringUtils.stringifyException(ie);
                        LOG.warn((Object)("Problem renewing lease for " + DFSClient.this.clientName + ": " + err));
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

