/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlockCommand;
import org.apache.hadoop.dfs.BlockListAsLongs;
import org.apache.hadoop.dfs.BlockMetaDataInfo;
import org.apache.hadoop.dfs.BlockMetadataHeader;
import org.apache.hadoop.dfs.ClientDatanodeProtocol;
import org.apache.hadoop.dfs.DataBlockScanner;
import org.apache.hadoop.dfs.DataChecksum;
import org.apache.hadoop.dfs.DataStorage;
import org.apache.hadoop.dfs.DatanodeCommand;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DatanodeProtocol;
import org.apache.hadoop.dfs.DatanodeRegistration;
import org.apache.hadoop.dfs.DisallowedDatanodeException;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSDataset;
import org.apache.hadoop.dfs.FSDatasetInterface;
import org.apache.hadoop.dfs.InterDatanodeProtocol;
import org.apache.hadoop.dfs.LeaseManager;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.NamespaceInfo;
import org.apache.hadoop.dfs.Storage;
import org.apache.hadoop.dfs.StreamFile;
import org.apache.hadoop.dfs.UnregisteredDatanodeException;
import org.apache.hadoop.dfs.UpgradeCommand;
import org.apache.hadoop.dfs.UpgradeManagerDatanode;
import org.apache.hadoop.dfs.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.StatusHttpServer;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.SocketOutputStream;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataNode
extends Configured
implements InterDatanodeProtocol,
ClientDatanodeProtocol,
FSConstants,
Runnable {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.DataNode");
    private static final int MIN_BUFFER_WITH_TRANSFERTO = 65536;
    DatanodeProtocol namenode = null;
    FSDatasetInterface data = null;
    DatanodeRegistration dnRegistration = null;
    volatile boolean shouldRun = true;
    private LinkedList<Block> receivedBlockList = new LinkedList();
    private LinkedList<String> delHints = new LinkedList();
    static final String EMPTY_DEL_HINT = "";
    int xmitsInProgress = 0;
    Daemon dataXceiveServer = null;
    ThreadGroup threadGroup = null;
    long blockReportInterval;
    long lastBlockReport = Long.MAX_VALUE;
    boolean resetBlockReportTime = true;
    long initialBlockReportDelay = 0L;
    private boolean waitForFirstBlockReportRequest = false;
    long lastHeartbeat = 0L;
    long heartBeatInterval;
    private DataStorage storage = null;
    private StatusHttpServer infoServer = null;
    private DataNodeMetrics myMetrics;
    private static InetSocketAddress nameNodeAddr;
    private InetSocketAddress selfAddr;
    private static DataNode datanodeObject;
    private Thread dataNodeThread = null;
    String machineName;
    private static String dnThreadName;
    private int socketTimeout;
    private int socketWriteTimeout = 0;
    private boolean transferToAllowed = true;
    private int writePacketSize = 0;
    DataBlockScanner blockScanner = null;
    Daemon blockScannerThread = null;
    private static final Random R;
    private long estimateBlockSize;
    static final short MAX_BALANCING_THREADS = 5;
    private Semaphore balancingSem = new Semaphore(5);
    long balanceBandwidth;
    private Throttler balancingThrottler;
    Server ipcServer;
    Map<Socket, Socket> childSockets = Collections.synchronizedMap(new HashMap());
    Count xceiverCount = new Count(0);
    UpgradeManagerDatanode upgradeManager = new UpgradeManagerDatanode(this);
    static final int PKT_HEADER_LEN = 21;

    @Deprecated
    public static InetSocketAddress createSocketAddr(String target) throws IOException {
        return NetUtils.createSocketAddr(target);
    }

    static long now() {
        return System.currentTimeMillis();
    }

    DataNode(Configuration conf, AbstractList<File> dataDirs) throws IOException {
        super(conf);
        datanodeObject = this;
        try {
            this.startDataNode(conf, dataDirs);
        }
        catch (IOException ie) {
            this.shutdown();
            throw ie;
        }
    }

    void startDataNode(Configuration conf, AbstractList<File> dataDirs) throws IOException {
        if (conf.get("slave.host.name") != null) {
            this.machineName = conf.get("slave.host.name");
        }
        if (this.machineName == null) {
            this.machineName = DNS.getDefaultHost(conf.get("dfs.datanode.dns.interface", "default"), conf.get("dfs.datanode.dns.nameserver", "default"));
        }
        InetSocketAddress nameNodeAddr = NameNode.getAddress(conf);
        this.estimateBlockSize = conf.getLong("dfs.block.size", 0x4000000L);
        this.socketTimeout = conf.getInt("dfs.socket.timeout", 60000);
        this.socketWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        this.transferToAllowed = conf.getBoolean("dfs.datanode.transferTo.allowed", true);
        this.writePacketSize = conf.getInt("dfs.write.packet.size", 65536);
        String address = NetUtils.getServerAddress(conf, "dfs.datanode.bindAddress", "dfs.datanode.port", "dfs.datanode.address");
        InetSocketAddress socAddr = NetUtils.createSocketAddr(address);
        int tmpPort = socAddr.getPort();
        this.storage = new DataStorage();
        this.dnRegistration = new DatanodeRegistration(this.machineName + ":" + tmpPort);
        this.namenode = (DatanodeProtocol)RPC.waitForProxy(DatanodeProtocol.class, 15L, nameNodeAddr, conf);
        NamespaceInfo nsInfo = this.handshake();
        FSConstants.StartupOption startOpt = DataNode.getStartupOption(conf);
        assert (startOpt != null) : "Startup option must be set.";
        boolean simulatedFSDataset = conf.getBoolean("dfs.datanode.simulateddatastorage", false);
        if (simulatedFSDataset) {
            DataNode.setNewStorageID(this.dnRegistration);
            this.dnRegistration.storageInfo.layoutVersion = -16;
            this.dnRegistration.storageInfo.namespaceID = nsInfo.namespaceID;
            conf.set("StorageId", this.dnRegistration.getStorageID());
            try {
                this.data = (FSDatasetInterface)ReflectionUtils.newInstance(Class.forName("org.apache.hadoop.dfs.SimulatedFSDataset"), conf);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException(e));
            }
        } else {
            this.storage.recoverTransitionRead(nsInfo, dataDirs, startOpt);
            this.dnRegistration.setStorageInfo(this.storage);
            this.data = new FSDataset(this.storage, conf);
        }
        ServerSocket ss = this.socketWriteTimeout > 0 ? ServerSocketChannel.open().socket() : new ServerSocket();
        Server.bind(ss, socAddr, 0);
        ss.setReceiveBufferSize(131072);
        tmpPort = ss.getLocalPort();
        this.selfAddr = new InetSocketAddress(ss.getInetAddress().getHostAddress(), tmpPort);
        this.dnRegistration.setName(this.machineName + ":" + tmpPort);
        LOG.info((Object)("Opened info server at " + tmpPort));
        this.threadGroup = new ThreadGroup("dataXceiveServer");
        this.dataXceiveServer = new Daemon(this.threadGroup, new DataXceiveServer(ss));
        this.threadGroup.setDaemon(true);
        this.blockReportInterval = conf.getLong("dfs.blockreport.intervalMsec", 3600000L);
        this.initialBlockReportDelay = conf.getLong("dfs.blockreport.initialDelay", 0L) * 1000L;
        if (this.initialBlockReportDelay >= this.blockReportInterval) {
            this.initialBlockReportDelay = 0L;
            LOG.info((Object)"dfs.blockreport.initialDelay is greater than dfs.blockreport.intervalMsec. Setting initial delay to 0 msec:");
        }
        this.heartBeatInterval = conf.getLong("dfs.heartbeat.interval", 3L) * 1000L;
        DataNode.nameNodeAddr = nameNodeAddr;
        this.balanceBandwidth = conf.getLong("dfs.balance.bandwidthPerSec", 0x100000L);
        LOG.info((Object)("Balancing bandwith is " + this.balanceBandwidth + " bytes/s"));
        this.balancingThrottler = new Throttler(this.balanceBandwidth);
        String reason = null;
        if (conf.getInt("dfs.datanode.scan.period.hours", 0) < 0) {
            reason = "verification is turned off by configuration";
        } else if (!(this.data instanceof FSDataset)) {
            reason = "verifcation is supported only with FSDataset";
        }
        if (reason == null) {
            this.blockScanner = new DataBlockScanner(this, (FSDataset)this.data, conf);
        } else {
            LOG.info((Object)("Periodic Block Verification is disabled because " + reason + "."));
        }
        String infoAddr = NetUtils.getServerAddress(conf, "dfs.datanode.info.bindAddress", "dfs.datanode.info.port", "dfs.datanode.http.address");
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(infoAddr);
        String infoHost = infoSocAddr.getHostName();
        int tmpInfoPort = infoSocAddr.getPort();
        this.infoServer = new StatusHttpServer("datanode", infoHost, tmpInfoPort, tmpInfoPort == 0);
        InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr(conf.get("dfs.datanode.https.address", infoHost + ":" + 0));
        Configuration sslConf = new Configuration(conf);
        sslConf.addResource(conf.get("https.keystore.info.rsrc", "sslinfo.xml"));
        String keyloc = sslConf.get("https.keystore.location");
        if (null != keyloc) {
            this.infoServer.addSslListener(secInfoSocAddr, keyloc, sslConf.get("https.keystore.password", EMPTY_DEL_HINT), sslConf.get("https.keystore.keypassword", EMPTY_DEL_HINT));
        }
        this.infoServer.addServlet(null, "/streamFile/*", StreamFile.class);
        this.infoServer.setAttribute("datanode.blockScanner", this.blockScanner);
        this.infoServer.addServlet(null, "/blockScannerReport", DataBlockScanner.Servlet.class);
        this.infoServer.start();
        this.dnRegistration.setInfoPort(this.infoServer.getPort());
        this.myMetrics = new DataNodeMetrics(conf, this.dnRegistration.getStorageID());
        InetSocketAddress ipcAddr = NetUtils.createSocketAddr(conf.get("dfs.datanode.ipc.address"));
        this.ipcServer = RPC.getServer(this, ipcAddr.getHostName(), ipcAddr.getPort(), conf.getInt("dfs.datanode.handler.count", 3), false, conf);
        this.ipcServer.start();
        this.dnRegistration.setIpcPort(this.ipcServer.getListenerAddress().getPort());
        LOG.info((Object)("dnRegistration = " + this.dnRegistration));
    }

    private Socket newSocket() throws IOException {
        return this.socketWriteTimeout > 0 ? SocketChannel.open().socket() : new Socket();
    }

    private NamespaceInfo handshake() throws IOException {
        NamespaceInfo nsInfo = new NamespaceInfo();
        while (this.shouldRun) {
            try {
                nsInfo = this.namenode.versionRequest();
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.getNameNodeAddr()));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
        }
        String errorMsg = null;
        if (!nsInfo.getBuildVersion().equals(Storage.getBuildVersion())) {
            errorMsg = "Incompatible build versions: namenode BV = " + nsInfo.getBuildVersion() + "; datanode BV = " + Storage.getBuildVersion();
            LOG.fatal((Object)errorMsg);
            try {
                this.namenode.errorReport(this.dnRegistration, 0, errorMsg);
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.getNameNodeAddr()));
            }
            throw new IOException(errorMsg);
        }
        assert (-16 == nsInfo.getLayoutVersion()) : "Data-node and name-node layout versions must be the same.Expected: -16 actual " + nsInfo.getLayoutVersion();
        return nsInfo;
    }

    public static DataNode getDataNode() {
        return datanodeObject;
    }

    static InterDatanodeProtocol createInterDataNodeProtocolProxy(DatanodeID datanodeid, Configuration conf) throws IOException {
        InetSocketAddress addr = NetUtils.createSocketAddr(datanodeid.getHost() + ":" + datanodeid.getIpcPort());
        if (InterDatanodeProtocol.LOG.isDebugEnabled()) {
            InterDatanodeProtocol.LOG.info((Object)("InterDatanodeProtocol addr=" + addr));
        }
        return (InterDatanodeProtocol)RPC.waitForProxy(InterDatanodeProtocol.class, 3L, addr, conf);
    }

    public InetSocketAddress getNameNodeAddr() {
        return nameNodeAddr;
    }

    public InetSocketAddress getSelfAddr() {
        return this.selfAddr;
    }

    DataNodeMetrics getMetrics() {
        return this.myMetrics;
    }

    public String getNamenode() {
        return "<namenode>";
    }

    static void setNewStorageID(DatanodeRegistration dnReg) {
        String ip = "unknownIP";
        try {
            ip = DNS.getDefaultIP("default");
        }
        catch (UnknownHostException ignored) {
            LOG.warn((Object)"Could not find ip address of \"default\" inteface.");
        }
        int rand = 0;
        try {
            rand = SecureRandom.getInstance("SHA1PRNG").nextInt(Integer.MAX_VALUE);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn((Object)"Could not use SecureRandom");
            rand = R.nextInt(Integer.MAX_VALUE);
        }
        dnReg.storageID = "DS-" + rand + "-" + ip + "-" + dnReg.getPort() + "-" + System.currentTimeMillis();
    }

    private void register() throws IOException {
        if (this.dnRegistration.getStorageID().equals(EMPTY_DEL_HINT)) {
            DataNode.setNewStorageID(this.dnRegistration);
        }
        while (this.shouldRun) {
            try {
                this.dnRegistration.name = this.machineName + ":" + this.dnRegistration.getPort();
                this.dnRegistration = this.namenode.register(this.dnRegistration);
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.getNameNodeAddr()));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        assert (EMPTY_DEL_HINT.equals(this.storage.getStorageID()) && !EMPTY_DEL_HINT.equals(this.dnRegistration.getStorageID()) || this.storage.getStorageID().equals(this.dnRegistration.getStorageID())) : "New storageID can be assigned only if data-node is not formatted";
        if (this.storage.getStorageID().equals(EMPTY_DEL_HINT)) {
            this.storage.setStorageID(this.dnRegistration.getStorageID());
            this.storage.writeAll();
            LOG.info((Object)("New storage id " + this.dnRegistration.getStorageID() + " is assigned to data-node " + this.dnRegistration.getName()));
        }
        if (!this.storage.getStorageID().equals(this.dnRegistration.getStorageID())) {
            throw new IOException("Inconsistent storage IDs. Name-node returned " + this.dnRegistration.getStorageID() + ". Expecting " + this.storage.getStorageID());
        }
        this.waitForFirstBlockReportRequest = true;
    }

    public void shutdown() {
        if (this.infoServer != null) {
            try {
                this.infoServer.stop();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.ipcServer != null) {
            this.ipcServer.stop();
        }
        this.shouldRun = false;
        if (this.dataXceiveServer != null) {
            ((DataXceiveServer)this.dataXceiveServer.getRunnable()).kill();
            this.dataXceiveServer.interrupt();
            if (this.threadGroup != null) {
                while (true) {
                    this.threadGroup.interrupt();
                    LOG.info((Object)("Waiting for threadgroup to exit, active threads is " + this.threadGroup.activeCount()));
                    if (this.threadGroup.isDestroyed() || this.threadGroup.activeCount() == 0) break;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        RPC.stopProxy(this.namenode);
        if (this.upgradeManager != null) {
            this.upgradeManager.shutdownUpgrade();
        }
        if (this.blockScanner != null) {
            this.blockScanner.shutdown();
        }
        if (this.blockScannerThread != null) {
            this.blockScannerThread.interrupt();
        }
        if (this.storage != null) {
            try {
                this.storage.unlockAll();
            }
            catch (IOException ie) {
                // empty catch block
            }
        }
        if (this.dataNodeThread != null) {
            this.dataNodeThread.interrupt();
            try {
                this.dataNodeThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.data != null) {
            this.data.shutdown();
        }
        if (this.myMetrics != null) {
            this.myMetrics.shutdown();
        }
    }

    private void checkDiskError(IOException e) throws IOException {
        if (e.getMessage().startsWith("No space left on device")) {
            throw new DiskChecker.DiskOutOfSpaceException("No space left on device");
        }
        this.checkDiskError();
    }

    private void checkDiskError() throws IOException {
        try {
            this.data.checkDataDir();
        }
        catch (DiskChecker.DiskErrorException de) {
            this.handleDiskError(de.getMessage());
        }
    }

    private void handleDiskError(String errMsgr) {
        LOG.warn((Object)("DataNode is shutting down.\n" + errMsgr));
        try {
            this.namenode.errorReport(this.dnRegistration, 1, errMsgr);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerService() throws Exception {
        LOG.info((Object)("using BLOCKREPORT_INTERVAL of " + this.blockReportInterval + "msec" + " Initial delay: " + this.initialBlockReportDelay + "msec"));
        while (this.shouldRun) {
            try {
                LinkedList<String> linkedList;
                long startTime = DataNode.now();
                if (startTime - this.lastHeartbeat > this.heartBeatInterval) {
                    DatanodeCommand cmd = this.namenode.sendHeartbeat(this.dnRegistration, this.data.getCapacity(), this.data.getDfsUsed(), this.data.getRemaining(), this.xmitsInProgress, this.xceiverCount.getValue());
                    this.myMetrics.heartbeats.inc(DataNode.now() - startTime);
                    this.lastHeartbeat = startTime;
                    if (!this.processCommand(cmd)) continue;
                }
                Block[] blockArray = null;
                String[] delHintArray = null;
                LinkedList<Block> linkedList2 = this.receivedBlockList;
                synchronized (linkedList2) {
                    linkedList = this.delHints;
                    synchronized (linkedList) {
                        int numBlocks = this.receivedBlockList.size();
                        if (numBlocks > 0) {
                            if (numBlocks != this.delHints.size()) {
                                LOG.warn((Object)"Panic: receiveBlockList and delHints are not of the same length");
                            }
                            blockArray = this.receivedBlockList.toArray(new Block[numBlocks]);
                            delHintArray = this.delHints.toArray(new String[numBlocks]);
                        }
                    }
                }
                if (blockArray != null) {
                    if (delHintArray == null || delHintArray.length != blockArray.length) {
                        LOG.warn((Object)"Panic: block array & delHintArray are not the same");
                    }
                    this.namenode.blockReceived(this.dnRegistration, blockArray, delHintArray);
                    linkedList2 = this.receivedBlockList;
                    synchronized (linkedList2) {
                        linkedList = this.delHints;
                        synchronized (linkedList) {
                            for (int i = 0; i < blockArray.length; ++i) {
                                this.receivedBlockList.remove(blockArray[i]);
                                this.delHints.remove(delHintArray[i]);
                            }
                        }
                    }
                }
                if (startTime - this.lastBlockReport > this.blockReportInterval) {
                    long brStartTime = DataNode.now();
                    Block[] bReport = this.data.getBlockReport();
                    DatanodeCommand cmd = this.namenode.blockReport(this.dnRegistration, BlockListAsLongs.convertToArrayLongs(bReport));
                    long brTime = DataNode.now() - brStartTime;
                    this.myMetrics.blockReports.inc(brTime);
                    LOG.info((Object)("BlockReport of " + bReport.length + " blocks got processed in " + brTime + " msecs"));
                    if (this.resetBlockReportTime) {
                        this.lastBlockReport = startTime - (long)R.nextInt((int)this.blockReportInterval);
                        this.resetBlockReportTime = false;
                    } else {
                        this.lastBlockReport = startTime;
                    }
                    this.processCommand(cmd);
                }
                if (this.blockScanner != null && this.blockScannerThread == null && this.upgradeManager.isUpgradeCompleted()) {
                    LOG.info((Object)"Starting Periodic block scanner.");
                    this.blockScannerThread = new Daemon(this.blockScanner);
                    this.blockScannerThread.start();
                }
                long waitTime = this.heartBeatInterval - (System.currentTimeMillis() - this.lastHeartbeat);
                LinkedList<Block> linkedList3 = this.receivedBlockList;
                synchronized (linkedList3) {
                    if (waitTime > 0L && this.receivedBlockList.size() == 0) {
                        try {
                            this.receivedBlockList.wait(waitTime);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (UnregisteredDatanodeException.class.getName().equals(reClass) || DisallowedDatanodeException.class.getName().equals(reClass)) {
                    LOG.warn((Object)("DataNode is shutting down: " + StringUtils.stringifyException(re)));
                    this.shutdown();
                    return;
                }
                LOG.warn((Object)StringUtils.stringifyException(re));
            }
            catch (IOException e) {
                LOG.warn((Object)StringUtils.stringifyException(e));
            }
        }
    }

    private boolean processCommand(DatanodeCommand cmd) throws IOException {
        if (cmd == null) {
            return true;
        }
        BlockCommand bcmd = cmd instanceof BlockCommand ? (BlockCommand)cmd : null;
        switch (cmd.getAction()) {
            case 1: {
                this.transferBlocks(bcmd.getBlocks(), bcmd.getTargets());
                this.myMetrics.blocksReplicated.inc(bcmd.getBlocks().length);
                break;
            }
            case 2: {
                Block[] toDelete = bcmd.getBlocks();
                try {
                    if (this.blockScanner != null) {
                        this.blockScanner.deleteBlocks(toDelete);
                    }
                    this.data.invalidate(toDelete);
                }
                catch (IOException e) {
                    this.checkDiskError();
                    throw e;
                }
                this.myMetrics.blocksRemoved.inc(toDelete.length);
                break;
            }
            case 3: {
                this.shutdown();
                return false;
            }
            case 4: {
                this.register();
                break;
            }
            case 5: {
                this.storage.finalizeUpgrade();
                break;
            }
            case 101: {
                this.processDistributedUpgradeCommand((UpgradeCommand)cmd);
                break;
            }
            case 6: {
                if (!this.waitForFirstBlockReportRequest) break;
                this.waitForFirstBlockReportRequest = false;
                this.scheduleBlockReport(this.initialBlockReportDelay);
                break;
            }
            case 7: {
                this.recoverBlocks(bcmd.getBlocks(), bcmd.getTargets());
                break;
            }
            default: {
                LOG.warn((Object)("Unknown DatanodeCommand action: " + cmd.getAction()));
            }
        }
        return true;
    }

    private void processDistributedUpgradeCommand(UpgradeCommand comm) throws IOException {
        assert (this.upgradeManager != null) : "DataNode.upgradeManager is null.";
        this.upgradeManager.processUpgradeCommand(comm);
    }

    private void startDistributedUpgradeIfNeeded() throws IOException {
        UpgradeManagerDatanode um = DataNode.getDataNode().upgradeManager;
        assert (um != null) : "DataNode.upgradeManager is null.";
        if (!um.getUpgradeState()) {
            return;
        }
        um.setUpgradeState(false, um.getUpgradeVersion());
        um.startUpgrade();
    }

    private void transferBlocks(Block[] blocks, DatanodeInfo[][] xferTargets) throws IOException {
        for (int i = 0; i < blocks.length; ++i) {
            if (!this.data.isValidBlock(blocks[i])) {
                String errStr = "Can't send invalid block " + blocks[i];
                LOG.info((Object)errStr);
                this.namenode.errorReport(this.dnRegistration, 2, errStr);
                break;
            }
            int numTargets = xferTargets[i].length;
            if (numTargets <= 0) continue;
            if (LOG.isInfoEnabled()) {
                StringBuilder xfersBuilder = new StringBuilder();
                for (int j = 0; j < numTargets; ++j) {
                    DatanodeInfo nodeInfo = xferTargets[i][j];
                    xfersBuilder.append(nodeInfo.getName());
                    if (j >= numTargets - 1) continue;
                    xfersBuilder.append(", ");
                }
                String xfersTo = xfersBuilder.toString();
                LOG.info((Object)(this.dnRegistration + " Starting thread to transfer block " + blocks[i] + " to " + xfersTo));
            }
            new Daemon(new DataTransfer(xferTargets[i], blocks[i])).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void receiveResponse(Socket s, int numTargets) throws IOException {
        DataInputStream reply = new DataInputStream(new BufferedInputStream(NetUtils.getInputStream(s), BUFFER_SIZE));
        try {
            for (int i = 0; i < numTargets; ++i) {
                short opStatus = reply.readShort();
                if (opStatus == 0) continue;
                throw new IOException("operation failed at " + s.getInetAddress());
            }
        }
        finally {
            IOUtils.closeStream(reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendResponse(Socket s, short opStatus, long timeout) throws IOException {
        DataOutputStream reply = new DataOutputStream(NetUtils.getOutputStream(s, timeout));
        try {
            reply.writeShort(opStatus);
            reply.flush();
        }
        finally {
            IOUtils.closeStream(reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNamenodeReceivedBlock(Block block, String delHint) {
        if (block == null || delHint == null) {
            throw new IllegalArgumentException(block == null ? "Block is null" : "delHint is null");
        }
        LinkedList<Block> linkedList = this.receivedBlockList;
        synchronized (linkedList) {
            LinkedList<String> linkedList2 = this.delHints;
            synchronized (linkedList2) {
                this.receivedBlockList.add(block);
                this.delHints.add(delHint);
                this.receivedBlockList.notifyAll();
            }
        }
    }

    @Override
    public void run() {
        LOG.info((Object)(this.dnRegistration + "In DataNode.run, data = " + this.data));
        this.dataXceiveServer.start();
        while (this.shouldRun) {
            try {
                this.startDistributedUpgradeIfNeeded();
                this.offerService();
            }
            catch (Exception ex) {
                LOG.error((Object)("Exception: " + StringUtils.stringifyException(ex)));
                if (!this.shouldRun) continue;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            this.dataXceiveServer.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.info((Object)(this.dnRegistration + ":Finishing DataNode in: " + this.data));
    }

    static void runDatanodeDaemon(DataNode dn) throws IOException {
        if (dn != null) {
            dn.register();
            dn.dataNodeThread = new Thread((Runnable)dn, dnThreadName);
            dn.dataNodeThread.setDaemon(true);
            dn.dataNodeThread.start();
        }
    }

    static DataNode instantiateDataNode(String[] args, Configuration conf) throws IOException {
        if (conf == null) {
            conf = new Configuration();
        }
        if (!DataNode.parseArguments(args, conf)) {
            DataNode.printUsage();
            return null;
        }
        if (conf.get("dfs.network.script") != null) {
            LOG.error((Object)"This configuration for rack identification is not supported anymore. RackID resolution is handled by the NameNode.");
            System.exit(-1);
        }
        String[] dataDirs = conf.getStrings("dfs.data.dir");
        dnThreadName = "DataNode: [" + StringUtils.arrayToString(dataDirs) + "]";
        return DataNode.makeInstance(dataDirs, conf);
    }

    static DataNode createDataNode(String[] args, Configuration conf) throws IOException {
        DataNode dn = DataNode.instantiateDataNode(args, conf);
        DataNode.runDatanodeDaemon(dn);
        return dn;
    }

    void join() {
        if (this.dataNodeThread != null) {
            try {
                this.dataNodeThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static DataNode makeInstance(String[] dataDirs, Configuration conf) throws IOException {
        ArrayList<File> dirs = new ArrayList<File>();
        for (int i = 0; i < dataDirs.length; ++i) {
            File data = new File(dataDirs[i]);
            try {
                DiskChecker.checkDir(data);
                dirs.add(data);
                continue;
            }
            catch (DiskChecker.DiskErrorException e) {
                LOG.warn((Object)("Invalid directory in dfs.data.dir: " + e.getMessage()));
            }
        }
        if (dirs.size() > 0) {
            return new DataNode(conf, dirs);
        }
        LOG.error((Object)"All directories in dfs.data.dir are invalid.");
        return null;
    }

    public String toString() {
        return "DataNode{data=" + this.data + ", localName='" + this.dnRegistration.getName() + "'" + ", storageID='" + this.dnRegistration.getStorageID() + "'" + ", xmitsInProgress=" + this.xmitsInProgress + "}";
    }

    private static void printUsage() {
        System.err.println("Usage: java DataNode");
        System.err.println("           [-rollback]");
    }

    private static boolean parseArguments(String[] args, Configuration conf) {
        int argsLen = args == null ? 0 : args.length;
        FSConstants.StartupOption startOpt = FSConstants.StartupOption.REGULAR;
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if ("-r".equalsIgnoreCase(cmd) || "--rack".equalsIgnoreCase(cmd)) {
                LOG.error((Object)"-r, --rack arguments are not supported anymore. RackID resolution is handled by the NameNode.");
                System.exit(-1);
                continue;
            }
            if ("-rollback".equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.ROLLBACK;
                continue;
            }
            if ("-regular".equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.REGULAR;
                continue;
            }
            return false;
        }
        DataNode.setStartupOption(conf, startOpt);
        return true;
    }

    private static void setStartupOption(Configuration conf, FSConstants.StartupOption opt) {
        conf.set("dfs.datanode.startup", opt.toString());
    }

    static FSConstants.StartupOption getStartupOption(Configuration conf) {
        return FSConstants.StartupOption.valueOf(conf.get("dfs.datanode.startup", FSConstants.StartupOption.REGULAR.toString()));
    }

    public void scheduleBlockReport(long delay) {
        this.lastBlockReport = delay > 0L ? System.currentTimeMillis() - (this.blockReportInterval - (long)R.nextInt((int)delay)) : this.lastHeartbeat - this.blockReportInterval;
        this.resetBlockReportTime = true;
    }

    public FSDatasetInterface getFSDataset() {
        return this.data;
    }

    public static void main(String[] args) {
        try {
            StringUtils.startupShutdownMessage(DataNode.class, args, LOG);
            DataNode datanode = DataNode.createDataNode(args, null);
            if (datanode != null) {
                datanode.join();
            }
        }
        catch (Throwable e) {
            LOG.error((Object)StringUtils.stringifyException(e));
            System.exit(-1);
        }
    }

    @Override
    public BlockMetaDataInfo getBlockMetaDataInfo(Block block) throws IOException {
        Block stored;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("block=" + block));
        }
        return (stored = this.data.getStoredBlock(block.blkid)) == null ? null : new BlockMetaDataInfo(stored, this.blockScanner.getLastScanTime(stored));
    }

    Daemon recoverBlocks(final Block[] blocks, final DatanodeInfo[][] targets) {
        Daemon d = new Daemon(this.threadGroup, new Runnable(){

            public void run() {
                LeaseManager.recoverBlocks(blocks, targets, DataNode.this.namenode, DataNode.this.getConf());
            }
        });
        d.start();
        return d;
    }

    @Override
    public void updateBlock(Block oldblock, Block newblock, boolean finalize) throws IOException {
        LOG.info((Object)("oldblock=" + oldblock + ", newblock=" + newblock));
        this.data.updateBlock(oldblock, newblock);
        if (finalize) {
            this.data.finalizeBlock(newblock);
            this.myMetrics.blocksWritten.inc();
            this.notifyNamenodeReceivedBlock(newblock, EMPTY_DEL_HINT);
            LOG.info((Object)("Received block " + newblock + " of size " + newblock.getNumBytes() + " as part of lease recovery."));
        }
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(InterDatanodeProtocol.class.getName())) {
            return 3L;
        }
        if (protocol.equals(ClientDatanodeProtocol.class.getName())) {
            return 1L;
        }
        throw new IOException("Unknown protocol to " + this.getClass().getSimpleName() + ": " + protocol);
    }

    @Override
    public Block recoverBlock(Block block, DatanodeInfo[] targets) throws IOException {
        LOG.info((Object)("Client invoking recoverBlock for block " + block));
        return LeaseManager.recoverBlock(block, targets, this.namenode, this.getConf(), false);
    }

    static {
        datanodeObject = null;
        R = new Random();
    }

    class DataTransfer
    implements Runnable {
        DatanodeInfo[] targets;
        Block b;

        public DataTransfer(DatanodeInfo[] targets, Block b) throws IOException {
            this.targets = targets;
            this.b = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ++DataNode.this.xmitsInProgress;
            Socket sock = null;
            DataOutputStream out = null;
            BlockSender blockSender = null;
            try {
                InetSocketAddress curTarget = NetUtils.createSocketAddr(this.targets[0].getName());
                sock = DataNode.this.newSocket();
                sock.connect(curTarget, DataNode.this.socketTimeout);
                sock.setSoTimeout(this.targets.length * DataNode.this.socketTimeout);
                long writeTimeout = DataNode.this.socketWriteTimeout + 5000 * (this.targets.length - 1);
                OutputStream baseStream = NetUtils.getOutputStream(sock, writeTimeout);
                out = new DataOutputStream(new BufferedOutputStream(baseStream, FSConstants.SMALL_BUFFER_SIZE));
                blockSender = new BlockSender(this.b, 0L, -1L, false, false, false);
                DatanodeInfo srcNode = new DatanodeInfo(DataNode.this.dnRegistration);
                out.writeShort(11);
                out.writeByte(80);
                out.writeLong(this.b.getBlockId());
                out.writeLong(this.b.getGenerationStamp());
                out.writeInt(0);
                out.writeBoolean(false);
                Text.writeString(out, DataNode.EMPTY_DEL_HINT);
                out.writeBoolean(true);
                srcNode.write(out);
                out.writeInt(this.targets.length - 1);
                for (int i = 1; i < this.targets.length; ++i) {
                    this.targets[i].write(out);
                }
                blockSender.sendBlock(out, baseStream, null);
                LOG.info((Object)(DataNode.this.dnRegistration + ":Transmitted block " + this.b + " to " + curTarget));
            }
            catch (IOException ie) {
                try {
                    LOG.warn((Object)(DataNode.this.dnRegistration + ":Failed to transfer " + this.b + " to " + this.targets[0].getName() + " got " + StringUtils.stringifyException(ie)));
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(blockSender);
                    IOUtils.closeStream(out);
                    IOUtils.closeSocket(sock);
                    --DataNode.this.xmitsInProgress;
                    throw throwable;
                }
                IOUtils.closeStream(blockSender);
                IOUtils.closeStream(out);
                IOUtils.closeSocket(sock);
                --DataNode.this.xmitsInProgress;
            }
            IOUtils.closeStream(blockSender);
            IOUtils.closeStream(out);
            IOUtils.closeSocket(sock);
            --DataNode.this.xmitsInProgress;
        }
    }

    private class BlockReceiver
    implements Closeable {
        private Block block;
        private boolean finalized;
        private DataInputStream in = null;
        private DataChecksum checksum;
        private OutputStream out = null;
        private DataOutputStream checksumOut = null;
        private int bytesPerChecksum;
        private int checksumSize;
        private ByteBuffer buf;
        private int bufRead;
        private int maxPacketReadLen;
        private long offsetInBlock;
        private final String inAddr;
        private String mirrorAddr;
        private DataOutputStream mirrorOut;
        private Daemon responder = null;
        private Throttler throttler;
        private FSDatasetInterface.BlockWriteStreams streams;
        private boolean isRecovery = false;
        private String clientName;
        DatanodeInfo srcDataNode = null;

        BlockReceiver(Block block, DataInputStream in, String inAddr, boolean isRecovery, String clientName, DatanodeInfo srcDataNode) throws IOException {
            try {
                this.block = block;
                this.in = in;
                this.inAddr = inAddr;
                this.isRecovery = isRecovery;
                this.clientName = clientName;
                this.offsetInBlock = 0L;
                this.checksum = DataChecksum.newDataChecksum(in);
                this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
                this.checksumSize = this.checksum.getChecksumSize();
                this.srcDataNode = srcDataNode;
                this.streams = DataNode.this.data.writeToBlock(block, isRecovery);
                this.finalized = DataNode.this.data.isValidBlock(block);
                if (this.streams != null) {
                    this.out = this.streams.dataOut;
                    this.checksumOut = new DataOutputStream(new BufferedOutputStream(this.streams.checksumOut, FSConstants.SMALL_BUFFER_SIZE));
                }
            }
            catch (IOException ioe) {
                IOUtils.closeStream(this);
                throw ioe;
            }
        }

        public void close() throws IOException {
            IOException ioe = null;
            try {
                if (this.checksumOut != null) {
                    this.checksumOut.close();
                    this.checksumOut = null;
                }
            }
            catch (IOException e) {
                ioe = e;
            }
            try {
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (IOException e) {
                ioe = e;
            }
            if (ioe != null) {
                DataNode.this.checkDiskError(ioe);
                throw ioe;
            }
        }

        void flush() throws IOException {
            if (this.checksumOut != null) {
                this.checksumOut.flush();
            }
            if (this.out != null) {
                this.out.flush();
            }
        }

        private void handleMirrorOutError(IOException ioe) throws IOException {
            LOG.info((Object)(DataNode.this.dnRegistration + ":Exception writing block " + this.block + " to mirror " + this.mirrorAddr + "\n" + StringUtils.stringifyException(ioe)));
            this.mirrorOut = null;
            if (this.clientName.length() > 0) {
                throw ioe;
            }
        }

        private void verifyChunks(byte[] dataBuf, int dataOff, int len, byte[] checksumBuf, int checksumOff) throws IOException {
            while (len > 0) {
                int chunkLen = Math.min(len, this.bytesPerChecksum);
                this.checksum.update(dataBuf, dataOff, chunkLen);
                if (!this.checksum.compare(checksumBuf, checksumOff)) {
                    if (this.srcDataNode != null) {
                        try {
                            LOG.info((Object)("report corrupt block " + this.block + " from datanode " + this.srcDataNode + " to namenode"));
                            LocatedBlock lb = new LocatedBlock(this.block, new DatanodeInfo[]{this.srcDataNode});
                            DataNode.this.namenode.reportBadBlocks(new LocatedBlock[]{lb});
                        }
                        catch (IOException e) {
                            LOG.warn((Object)("Failed to report bad block " + this.block + " from datanode " + this.srcDataNode + " to namenode"));
                        }
                    }
                    throw new IOException("Unexpected checksum mismatch while writing " + this.block + " from " + this.inAddr);
                }
                this.checksum.reset();
                dataOff += chunkLen;
                checksumOff += this.checksumSize;
                len -= chunkLen;
            }
        }

        private void shiftBufData() {
            if (this.bufRead != this.buf.limit()) {
                throw new IllegalStateException("bufRead should be same as buf.limit()");
            }
            if (this.buf.position() > 0) {
                int dataLeft = this.buf.remaining();
                if (dataLeft > 0) {
                    byte[] b = this.buf.array();
                    System.arraycopy(b, this.buf.position(), b, 0, dataLeft);
                }
                this.buf.position(0);
                this.bufRead = dataLeft;
                this.buf.limit(this.bufRead);
            }
        }

        private int readToBuf(int toRead) throws IOException {
            int nRead;
            if (toRead < 0) {
                toRead = (this.maxPacketReadLen > 0 ? this.maxPacketReadLen : this.buf.capacity()) - this.buf.limit();
            }
            if ((nRead = this.in.read(this.buf.array(), this.buf.limit(), toRead)) < 0) {
                throw new EOFException("while trying to read " + toRead + " bytes");
            }
            this.bufRead = this.buf.limit() + nRead;
            this.buf.limit(this.bufRead);
            return nRead;
        }

        private int readNextPacket() throws IOException {
            if (this.buf == null) {
                int chunkSize = this.bytesPerChecksum + this.checksumSize;
                int chunksPerPacket = (DataNode.this.writePacketSize - 21 - 4 + chunkSize - 1) / chunkSize;
                this.buf = ByteBuffer.allocate(25 + Math.max(chunksPerPacket, 1) * chunkSize);
                this.buf.limit(0);
            }
            if (this.bufRead > this.buf.limit()) {
                this.buf.limit(this.bufRead);
            }
            while (this.buf.remaining() < 4) {
                if (this.buf.position() > 0) {
                    this.shiftBufData();
                }
                this.readToBuf(-1);
            }
            this.buf.mark();
            int payloadLen = this.buf.getInt();
            this.buf.reset();
            if (payloadLen == 0) {
                this.buf.limit(this.buf.position() + 4);
                return 0;
            }
            if (payloadLen < 0 || payloadLen > 0x6400000) {
                throw new IOException("Incorrect value for packet payload : " + payloadLen);
            }
            int pktSize = payloadLen + 21;
            if (this.buf.remaining() < pktSize) {
                int spaceLeft;
                int toRead = pktSize - this.buf.remaining();
                if (toRead > (spaceLeft = this.buf.capacity() - this.buf.limit()) && this.buf.position() > 0) {
                    this.shiftBufData();
                    spaceLeft = this.buf.capacity() - this.buf.limit();
                }
                if (toRead > spaceLeft) {
                    byte[] oldBuf = this.buf.array();
                    int toCopy = this.buf.limit();
                    this.buf = ByteBuffer.allocate(toCopy + toRead);
                    System.arraycopy(oldBuf, 0, this.buf.array(), 0, toCopy);
                    this.buf.limit(toCopy);
                }
                while (toRead > 0) {
                    toRead -= this.readToBuf(toRead);
                }
            }
            if (this.buf.remaining() > pktSize) {
                this.buf.limit(this.buf.position() + pktSize);
            }
            if (pktSize > this.maxPacketReadLen) {
                this.maxPacketReadLen = pktSize;
            }
            return payloadLen;
        }

        private int receivePacket() throws IOException {
            int payloadLen = this.readNextPacket();
            if (payloadLen <= 0) {
                return payloadLen;
            }
            this.buf.mark();
            this.buf.getInt();
            this.offsetInBlock = this.buf.getLong();
            long seqno = this.buf.getLong();
            boolean lastPacketInBlock = this.buf.get() != 0;
            int endOfHeader = this.buf.position();
            this.buf.reset();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Receiving one packet for block " + this.block + " of length " + payloadLen + " seqno " + seqno + " offsetInBlock " + this.offsetInBlock + " lastPacketInBlock " + lastPacketInBlock));
            }
            this.setBlockPosition(this.offsetInBlock);
            if (this.mirrorOut != null) {
                try {
                    this.mirrorOut.write(this.buf.array(), this.buf.position(), this.buf.remaining());
                    this.mirrorOut.flush();
                }
                catch (IOException e) {
                    this.handleMirrorOutError(e);
                }
            }
            this.buf.position(endOfHeader);
            int len = this.buf.getInt();
            if (len < 0) {
                throw new IOException("Got wrong length during writeBlock(" + this.block + ") from " + this.inAddr + " at offset " + this.offsetInBlock + ": " + len);
            }
            if (len == 0) {
                LOG.debug((Object)("Receiving empty packet for block " + this.block));
            } else {
                this.offsetInBlock += (long)len;
                int checksumLen = (len + this.bytesPerChecksum - 1) / this.bytesPerChecksum * this.checksumSize;
                if (this.buf.remaining() != checksumLen + len) {
                    throw new IOException("Data remaining in packet does not match sum of checksumLen and dataLen");
                }
                int checksumOff = this.buf.position();
                int dataOff = checksumOff + checksumLen;
                byte[] pktBuf = this.buf.array();
                this.buf.position(this.buf.limit());
                this.verifyChunks(pktBuf, dataOff, len, pktBuf, checksumOff);
                try {
                    if (!this.finalized) {
                        this.out.write(pktBuf, dataOff, len);
                        this.checksumOut.write(pktBuf, checksumOff, checksumLen);
                        ((DataNode)DataNode.this).myMetrics.bytesWritten.inc(len);
                    }
                }
                catch (IOException iex) {
                    DataNode.this.checkDiskError(iex);
                    throw iex;
                }
            }
            this.flush();
            if (this.responder != null) {
                ((PacketResponder)this.responder.getRunnable()).enqueue(seqno, lastPacketInBlock);
            }
            if (this.throttler != null) {
                this.throttler.throttle(payloadLen);
            }
            return payloadLen;
        }

        public void writeChecksumHeader(DataOutputStream mirrorOut) throws IOException {
            this.checksum.writeHeader(mirrorOut);
        }

        public void receiveBlock(DataOutputStream mirrOut, DataInputStream mirrIn, DataOutputStream replyOut, String mirrAddr, Throttler throttlerArg, int numTargets) throws IOException {
            this.mirrorOut = mirrOut;
            this.mirrorAddr = mirrAddr;
            this.throttler = throttlerArg;
            try {
                if (!this.finalized) {
                    BlockMetadataHeader.writeHeader(this.checksumOut, this.checksum);
                }
                if (this.clientName.length() > 0) {
                    this.responder = new Daemon(DataNode.this.threadGroup, new PacketResponder(this, this.block, mirrIn, replyOut, numTargets, this.clientName));
                    this.responder.start();
                }
                while (this.receivePacket() > 0) {
                }
                if (this.mirrorOut != null) {
                    try {
                        this.mirrorOut.writeInt(0);
                        this.mirrorOut.flush();
                    }
                    catch (IOException e) {
                        this.handleMirrorOutError(e);
                    }
                }
                if (this.responder != null) {
                    ((PacketResponder)this.responder.getRunnable()).close();
                }
                if (this.clientName.length() == 0) {
                    this.close();
                    this.block.setNumBytes(this.offsetInBlock);
                    DataNode.this.data.finalizeBlock(this.block);
                    ((DataNode)DataNode.this).myMetrics.blocksWritten.inc();
                }
            }
            catch (IOException ioe) {
                LOG.info((Object)("Exception in receiveBlock for block " + this.block + " " + ioe));
                IOUtils.closeStream(this);
                if (this.responder != null) {
                    this.responder.interrupt();
                }
                throw ioe;
            }
            finally {
                if (this.responder != null) {
                    try {
                        this.responder.join();
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted receiveBlock");
                    }
                    this.responder = null;
                }
            }
        }

        private void setBlockPosition(long offsetInBlock) throws IOException {
            if (this.finalized) {
                if (!this.isRecovery) {
                    throw new IOException("Write to offset " + offsetInBlock + " of block " + this.block + " that is already finalized.");
                }
                if (offsetInBlock > DataNode.this.data.getLength(this.block)) {
                    throw new IOException("Write to offset " + offsetInBlock + " of block " + this.block + " that is already finalized and is of size " + DataNode.this.data.getLength(this.block));
                }
                return;
            }
            if (DataNode.this.data.getChannelPosition(this.block, this.streams) == offsetInBlock) {
                return;
            }
            if (offsetInBlock % (long)this.bytesPerChecksum != 0L) {
                throw new IOException("setBlockPosition trying to set position to " + offsetInBlock + " which is not a multiple of bytesPerChecksum " + this.bytesPerChecksum);
            }
            long offsetInChecksum = (long)BlockMetadataHeader.getHeaderSize() + offsetInBlock / (long)this.bytesPerChecksum * (long)this.checksumSize;
            if (this.out != null) {
                this.out.flush();
            }
            if (this.checksumOut != null) {
                this.checksumOut.flush();
            }
            LOG.info((Object)("Changing block file offset of block " + this.block + " from " + DataNode.this.data.getChannelPosition(this.block, this.streams) + " to " + offsetInBlock + " meta file offset to " + offsetInChecksum));
            DataNode.this.data.setChannelPosition(this.block, this.streams, offsetInBlock, offsetInChecksum);
        }
    }

    class PacketResponder
    implements Runnable {
        private LinkedList<Packet> ackQueue = new LinkedList();
        private volatile boolean running = true;
        private Block block;
        DataInputStream mirrorIn;
        DataOutputStream replyOut;
        private int numTargets;
        private String clientName;
        private BlockReceiver receiver;

        public String toString() {
            return "PacketResponder " + this.numTargets + " for Block " + this.block;
        }

        PacketResponder(BlockReceiver receiver, Block b, DataInputStream in, DataOutputStream out, int numTargets, String clientName) {
            this.receiver = receiver;
            this.block = b;
            this.mirrorIn = in;
            this.replyOut = out;
            this.numTargets = numTargets;
            this.clientName = clientName;
        }

        synchronized void enqueue(long seqno, boolean lastPacketInBlock) {
            if (this.running) {
                LOG.debug((Object)("PacketResponder " + this.numTargets + " adding seqno " + seqno + " to ack queue."));
                this.ackQueue.addLast(new Packet(seqno, lastPacketInBlock));
                this.notifyAll();
            }
        }

        synchronized void close() {
            while (this.running && this.ackQueue.size() != 0 && DataNode.this.shouldRun) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.running = false;
                }
            }
            LOG.debug((Object)("PacketResponder " + this.numTargets + " for block " + this.block + " Closing down."));
            this.running = false;
            this.notifyAll();
        }

        private synchronized void lastDataNodeRun() {
            long lastHeartbeat = System.currentTimeMillis();
            boolean lastPacket = false;
            while (this.running && DataNode.this.shouldRun && !lastPacket) {
                long now = System.currentTimeMillis();
                try {
                    while (this.running && DataNode.this.shouldRun && this.ackQueue.size() == 0) {
                        long idle = now - lastHeartbeat;
                        long timeout = (long)(DataNode.this.socketTimeout / 2) - idle;
                        if (timeout <= 0L) {
                            timeout = 1000L;
                        }
                        try {
                            this.wait(timeout);
                        }
                        catch (InterruptedException e) {
                            if (!this.running) break;
                            LOG.info((Object)("PacketResponder " + this.numTargets + " for block " + this.block + " Interrupted."));
                            this.running = false;
                            break;
                        }
                        now = System.currentTimeMillis();
                        if (now - lastHeartbeat <= (long)(DataNode.this.socketTimeout / 2)) continue;
                        this.replyOut.writeLong(-1L);
                        this.replyOut.flush();
                        lastHeartbeat = now;
                    }
                    if (!this.running || !DataNode.this.shouldRun) break;
                    Packet pkt = this.ackQueue.removeFirst();
                    long expected = pkt.seqno;
                    this.notifyAll();
                    LOG.debug((Object)("PacketResponder " + this.numTargets + " for block " + this.block + " acking for packet " + expected));
                    if (pkt.lastPacketInBlock) {
                        if (!this.receiver.finalized) {
                            this.receiver.close();
                            this.block.setNumBytes(this.receiver.offsetInBlock);
                            DataNode.this.data.finalizeBlock(this.block);
                            ((DataNode)DataNode.this).myMetrics.blocksWritten.inc();
                            DataNode.this.notifyNamenodeReceivedBlock(this.block, DataNode.EMPTY_DEL_HINT);
                            LOG.info((Object)("Received block " + this.block + " of size " + this.block.getNumBytes() + " from " + this.receiver.inAddr));
                        }
                        lastPacket = true;
                    }
                    this.replyOut.writeLong(expected);
                    this.replyOut.writeShort(0);
                    this.replyOut.flush();
                }
                catch (Exception e) {
                    if (!this.running) continue;
                    LOG.info((Object)("PacketResponder " + this.block + " " + this.numTargets + " Exception " + StringUtils.stringifyException(e)));
                    this.running = false;
                }
            }
            LOG.info((Object)("PacketResponder " + this.numTargets + " for block " + this.block + " terminating"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.numTargets == 0) {
                this.lastDataNodeRun();
                return;
            }
            boolean lastPacketInBlock = false;
            while (this.running && DataNode.this.shouldRun && !lastPacketInBlock) {
                try {
                    long expected;
                    boolean didRead;
                    short op;
                    block23: {
                        op = 0;
                        didRead = false;
                        expected = -2L;
                        try {
                            long seqno = this.mirrorIn.readLong();
                            didRead = true;
                            if (seqno == -1L) {
                                this.replyOut.writeLong(-1L);
                                this.replyOut.flush();
                                LOG.debug((Object)("PacketResponder " + this.numTargets + " got -1"));
                                continue;
                            }
                            if (seqno == -2L) {
                                LOG.debug((Object)("PacketResponder " + this.numTargets + " got -2"));
                                break block23;
                            }
                            LOG.debug((Object)("PacketResponder " + this.numTargets + " got seqno = " + seqno));
                            Packet pkt = null;
                            PacketResponder packetResponder = this;
                            synchronized (packetResponder) {
                                while (this.running && DataNode.this.shouldRun && this.ackQueue.size() == 0) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("PacketResponder " + this.numTargets + " seqno = " + seqno + " for block " + this.block + " waiting for local datanode to finish write."));
                                    }
                                    this.wait();
                                }
                                pkt = this.ackQueue.removeFirst();
                                expected = pkt.seqno;
                                this.notifyAll();
                                LOG.debug((Object)("PacketResponder " + this.numTargets + " seqno = " + seqno));
                                if (seqno != expected) {
                                    throw new IOException("PacketResponder " + this.numTargets + " for block " + this.block + " expected seqno:" + expected + " received:" + seqno);
                                }
                                lastPacketInBlock = pkt.lastPacketInBlock;
                            }
                        }
                        catch (Throwable e) {
                            if (!this.running) break block23;
                            LOG.info((Object)("PacketResponder " + this.block + " " + this.numTargets + " Exception " + StringUtils.stringifyException(e)));
                            this.running = false;
                        }
                    }
                    if (Thread.interrupted()) {
                        LOG.info((Object)("PacketResponder " + this.block + " " + this.numTargets + " : Thread is interrupted."));
                        this.running = false;
                    }
                    if (!didRead) {
                        op = 1;
                    }
                    if (lastPacketInBlock && !this.receiver.finalized) {
                        this.receiver.close();
                        this.block.setNumBytes(this.receiver.offsetInBlock);
                        DataNode.this.data.finalizeBlock(this.block);
                        ((DataNode)DataNode.this).myMetrics.blocksWritten.inc();
                        DataNode.this.notifyNamenodeReceivedBlock(this.block, DataNode.EMPTY_DEL_HINT);
                        LOG.info((Object)("Received block " + this.block + " of size " + this.block.getNumBytes() + " from " + this.receiver.inAddr));
                    }
                    this.replyOut.writeLong(expected);
                    this.replyOut.writeShort(0);
                    LOG.debug((Object)("PacketResponder " + this.numTargets + " for block " + this.block + " responded my status " + " for seqno " + expected));
                    for (int i = 0; i < this.numTargets && DataNode.this.shouldRun; ++i) {
                        try {
                            if (op == 0 && (op = this.mirrorIn.readShort()) != 0) {
                                LOG.debug((Object)("PacketResponder for block " + this.block + ": error code received from downstream " + " datanode[" + i + "] " + op));
                            }
                        }
                        catch (Throwable e) {
                            op = 1;
                        }
                        this.replyOut.writeShort(op);
                    }
                    this.replyOut.flush();
                    LOG.debug((Object)("PacketResponder " + this.block + " " + this.numTargets + " responded other status " + " for seqno " + expected));
                    if (expected == -2L) {
                        this.running = false;
                    }
                    if (op != 1 || this.clientName.length() <= 0) continue;
                    this.running = false;
                }
                catch (IOException e) {
                    if (!this.running) continue;
                    LOG.info((Object)("PacketResponder " + this.block + " " + this.numTargets + " Exception " + StringUtils.stringifyException(e)));
                    this.running = false;
                }
                catch (RuntimeException e) {
                    if (!this.running) continue;
                    LOG.info((Object)("PacketResponder " + this.block + " " + this.numTargets + " Exception " + StringUtils.stringifyException(e)));
                    this.running = false;
                }
            }
            LOG.info((Object)("PacketResponder " + this.numTargets + " for block " + this.block + " terminating"));
        }
    }

    private static class Packet {
        long seqno;
        boolean lastPacketInBlock;

        Packet(long seqno, boolean lastPacketInBlock) {
            this.seqno = seqno;
            this.lastPacketInBlock = lastPacketInBlock;
        }
    }

    class BlockSender
    implements Closeable {
        private Block block;
        private InputStream blockIn;
        private long blockInPosition = -1L;
        private DataInputStream checksumIn;
        private DataChecksum checksum;
        private long offset;
        private long endOffset;
        private long blockLength;
        private int bytesPerChecksum;
        private int checksumSize;
        private boolean corruptChecksumOk;
        private boolean chunkOffsetOK;
        private long seqno;
        private boolean blockReadFully;
        private boolean verifyChecksum;
        private Throttler throttler;

        BlockSender(Block block, long startOffset, long length, boolean corruptChecksumOk, boolean chunkOffsetOK, boolean verifyChecksum) throws IOException {
            try {
                long checksumSkip;
                this.block = block;
                this.chunkOffsetOK = chunkOffsetOK;
                this.corruptChecksumOk = corruptChecksumOk;
                this.verifyChecksum = verifyChecksum;
                this.blockLength = DataNode.this.data.getLength(block);
                if (!corruptChecksumOk || DataNode.this.data.metaFileExists(block)) {
                    this.checksumIn = new DataInputStream(new BufferedInputStream(DataNode.this.data.getMetaDataInputStream(block), FSConstants.BUFFER_SIZE));
                    BlockMetadataHeader header = BlockMetadataHeader.readHeader(this.checksumIn);
                    short version = header.getVersion();
                    if (version != 1) {
                        LOG.warn((Object)("Wrong version (" + version + ") for metadata file for " + block + " ignoring ..."));
                    }
                    this.checksum = header.getChecksum();
                } else {
                    LOG.warn((Object)("Could not find metadata file for " + block));
                    this.checksum = DataChecksum.newDataChecksum(0, 16384);
                }
                this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
                if (this.bytesPerChecksum > 0xA00000 && (long)this.bytesPerChecksum > this.blockLength) {
                    this.checksum = DataChecksum.newDataChecksum(this.checksum.getChecksumType(), Math.max((int)this.blockLength, 0xA00000));
                    this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
                }
                this.checksumSize = this.checksum.getChecksumSize();
                if (length < 0L) {
                    length = this.blockLength;
                }
                this.endOffset = this.blockLength;
                if (startOffset < 0L || startOffset > this.endOffset || length + startOffset > this.endOffset) {
                    String msg = " Offset " + startOffset + " and length " + length + " don't match block " + block + " ( blockLen " + this.endOffset + " )";
                    LOG.warn((Object)(DataNode.this.dnRegistration + ":sendBlock() : " + msg));
                    throw new IOException(msg);
                }
                this.offset = startOffset - startOffset % (long)this.bytesPerChecksum;
                if (length >= 0L) {
                    long tmpLen = startOffset + length + (startOffset - this.offset);
                    if (tmpLen % (long)this.bytesPerChecksum != 0L) {
                        tmpLen += (long)this.bytesPerChecksum - tmpLen % (long)this.bytesPerChecksum;
                    }
                    if (tmpLen < this.endOffset) {
                        this.endOffset = tmpLen;
                    }
                }
                if (this.offset > 0L && (checksumSkip = this.offset / (long)this.bytesPerChecksum * (long)this.checksumSize) > 0L) {
                    IOUtils.skipFully(this.checksumIn, checksumSkip);
                }
                this.seqno = 0L;
                this.blockIn = DataNode.this.data.getBlockInputStream(block, this.offset);
            }
            catch (IOException ioe) {
                IOUtils.closeStream(this);
                IOUtils.closeStream(this.blockIn);
                throw ioe;
            }
        }

        public void close() throws IOException {
            IOException ioe = null;
            if (this.checksumIn != null) {
                try {
                    this.checksumIn.close();
                }
                catch (IOException e) {
                    ioe = e;
                }
                this.checksumIn = null;
            }
            if (this.blockIn != null) {
                try {
                    this.blockIn.close();
                }
                catch (IOException e) {
                    ioe = e;
                }
                this.blockIn = null;
            }
            if (ioe != null) {
                throw ioe;
            }
        }

        private int sendChunks(ByteBuffer pkt, int maxChunks, OutputStream out) throws IOException {
            int len = Math.min((int)(this.endOffset - this.offset), this.bytesPerChecksum * maxChunks);
            if (len == 0) {
                return 0;
            }
            int numChunks = (len + this.bytesPerChecksum - 1) / this.bytesPerChecksum;
            int packetLen = len + numChunks * this.checksumSize + 4;
            pkt.clear();
            pkt.putInt(packetLen);
            pkt.putLong(this.offset);
            pkt.putLong(this.seqno);
            pkt.put((byte)(this.offset + (long)len >= this.endOffset ? 1 : 0));
            pkt.putInt(len);
            int checksumOff = pkt.position();
            int checksumLen = numChunks * this.checksumSize;
            byte[] buf = pkt.array();
            if (this.checksumSize > 0 && this.checksumIn != null) {
                try {
                    this.checksumIn.readFully(buf, checksumOff, checksumLen);
                }
                catch (IOException e) {
                    LOG.warn((Object)(" Could not read or failed to veirfy checksum for data at offset " + this.offset + " for block " + this.block + " got : " + StringUtils.stringifyException(e)));
                    IOUtils.closeStream(this.checksumIn);
                    this.checksumIn = null;
                    if (this.corruptChecksumOk) {
                        Arrays.fill(buf, checksumOff, checksumLen, (byte)0);
                    }
                    throw e;
                }
            }
            int dataOff = checksumOff + checksumLen;
            if (this.blockInPosition >= 0L) {
                SocketOutputStream sockOut = (SocketOutputStream)out;
                sockOut.write(buf, 0, dataOff);
                sockOut.transferToFully(((FileInputStream)this.blockIn).getChannel(), this.blockInPosition, len);
                this.blockInPosition += (long)len;
            } else {
                IOUtils.readFully(this.blockIn, buf, dataOff, len);
                if (this.verifyChecksum) {
                    int dOff = dataOff;
                    int cOff = checksumOff;
                    int dLeft = len;
                    for (int i = 0; i < numChunks; ++i) {
                        this.checksum.reset();
                        int dLen = Math.min(dLeft, this.bytesPerChecksum);
                        this.checksum.update(buf, dOff, dLen);
                        if (!this.checksum.compare(buf, cOff)) {
                            throw new ChecksumException("Checksum failed at " + (this.offset + (long)len - (long)dLeft), len);
                        }
                        dLeft -= dLen;
                        dOff += dLen;
                        cOff += this.checksumSize;
                    }
                }
                out.write(buf, 0, dataOff + len);
            }
            if (this.throttler != null) {
                this.throttler.throttle(packetLen);
            }
            return len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long sendBlock(DataOutputStream out, OutputStream baseStream, Throttler throttler) throws IOException {
            if (out == null) {
                throw new IOException("out stream is null");
            }
            this.throttler = throttler;
            long initialOffset = this.offset;
            long totalRead = 0L;
            OutputStream streamForSendChunks = out;
            try {
                int maxChunksPerPacket;
                this.checksum.writeHeader(out);
                if (this.chunkOffsetOK) {
                    out.writeLong(this.offset);
                }
                out.flush();
                int pktSize = 25;
                if (DataNode.this.transferToAllowed && !this.verifyChecksum && baseStream instanceof SocketOutputStream && this.blockIn instanceof FileInputStream) {
                    FileChannel fileChannel = ((FileInputStream)this.blockIn).getChannel();
                    this.blockInPosition = fileChannel.position();
                    streamForSendChunks = baseStream;
                    maxChunksPerPacket = (Math.max(FSConstants.BUFFER_SIZE, 65536) + this.bytesPerChecksum - 1) / this.bytesPerChecksum;
                    pktSize += this.checksumSize * maxChunksPerPacket;
                } else {
                    maxChunksPerPacket = Math.max(1, (FSConstants.BUFFER_SIZE + this.bytesPerChecksum - 1) / this.bytesPerChecksum);
                    pktSize += (this.bytesPerChecksum + this.checksumSize) * maxChunksPerPacket;
                }
                ByteBuffer pktBuf = ByteBuffer.allocate(pktSize);
                while (this.endOffset > this.offset) {
                    long len = this.sendChunks(pktBuf, maxChunksPerPacket, streamForSendChunks);
                    this.offset += len;
                    totalRead += len + (len + (long)this.bytesPerChecksum - 1L) / (long)this.bytesPerChecksum * (long)this.checksumSize;
                    ++this.seqno;
                }
                out.writeInt(0);
                out.flush();
            }
            finally {
                this.close();
            }
            this.blockReadFully = initialOffset == 0L && this.offset >= this.blockLength;
            return totalRead;
        }

        boolean isBlockReadFully() {
            return this.blockReadFully;
        }
    }

    static class Throttler {
        private long period;
        private long periodExtension;
        private long bytesPerPeriod;
        private long curPeriodStart = System.currentTimeMillis();
        private long curReserve;
        private long bytesAlreadyUsed;

        Throttler(long bandwidthPerSec) {
            this(500L, bandwidthPerSec);
        }

        Throttler(long period, long bandwidthPerSec) {
            this.period = period;
            this.curReserve = this.bytesPerPeriod = bandwidthPerSec * period / 1000L;
            this.periodExtension = period * 3L;
        }

        public synchronized long getBandwidth() {
            return this.bytesPerPeriod * 1000L / this.period;
        }

        public synchronized void setBandwidth(long bytesPerSecond) {
            if (bytesPerSecond <= 0L) {
                throw new IllegalArgumentException(DataNode.EMPTY_DEL_HINT + bytesPerSecond);
            }
            this.bytesPerPeriod = bytesPerSecond * this.period / 1000L;
        }

        public synchronized void throttle(long numOfBytes) {
            if (numOfBytes <= 0L) {
                return;
            }
            this.curReserve -= numOfBytes;
            this.bytesAlreadyUsed += numOfBytes;
            while (this.curReserve <= 0L) {
                long curPeriodEnd;
                long now = System.currentTimeMillis();
                if (now < (curPeriodEnd = this.curPeriodStart + this.period)) {
                    try {
                        this.wait(curPeriodEnd - now);
                    }
                    catch (InterruptedException ignored) {}
                    continue;
                }
                if (now < this.curPeriodStart + this.periodExtension) {
                    this.curPeriodStart = curPeriodEnd;
                    this.curReserve += this.bytesPerPeriod;
                    continue;
                }
                this.curPeriodStart = now;
                this.curReserve = this.bytesPerPeriod - this.bytesAlreadyUsed;
            }
            this.bytesAlreadyUsed -= numOfBytes;
        }
    }

    class DataXceiver
    implements Runnable {
        Socket s;
        String remoteAddress;
        String localAddress;

        public DataXceiver(Socket s) {
            this.s = s;
            DataNode.this.childSockets.put(s, s);
            InetSocketAddress isock = (InetSocketAddress)s.getRemoteSocketAddress();
            this.remoteAddress = isock.toString();
            this.localAddress = s.getInetAddress() + ":" + s.getLocalPort();
            LOG.debug((Object)("Number of active connections is: " + DataNode.this.xceiverCount));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            DataInputStream in = null;
            try {
                in = new DataInputStream(new BufferedInputStream(NetUtils.getInputStream(this.s), FSConstants.SMALL_BUFFER_SIZE));
                short version = in.readShort();
                if (version != 11) {
                    throw new IOException("Version Mismatch");
                }
                boolean local = this.s.getInetAddress().equals(this.s.getLocalAddress());
                byte op = in.readByte();
                long startTime = DataNode.now();
                switch (op) {
                    case 81: {
                        this.readBlock(in);
                        ((DataNode)DataNode.this).myMetrics.readBlockOp.inc(DataNode.now() - startTime);
                        if (local) {
                            ((DataNode)DataNode.this).myMetrics.readsFromLocalClient.inc();
                            return;
                        } else {
                            ((DataNode)DataNode.this).myMetrics.readsFromRemoteClient.inc();
                            return;
                        }
                    }
                    case 80: {
                        this.writeBlock(in);
                        ((DataNode)DataNode.this).myMetrics.writeBlockOp.inc(DataNode.now() - startTime);
                        if (local) {
                            ((DataNode)DataNode.this).myMetrics.writesFromLocalClient.inc();
                            return;
                        } else {
                            ((DataNode)DataNode.this).myMetrics.writesFromRemoteClient.inc();
                            return;
                        }
                    }
                    case 82: {
                        this.readMetadata(in);
                        ((DataNode)DataNode.this).myMetrics.readMetadataOp.inc(DataNode.now() - startTime);
                        return;
                    }
                    case 83: {
                        this.replaceBlock(in);
                        ((DataNode)DataNode.this).myMetrics.replaceBlockOp.inc(DataNode.now() - startTime);
                        return;
                    }
                    case 84: {
                        this.copyBlock(in);
                        ((DataNode)DataNode.this).myMetrics.copyBlockOp.inc(DataNode.now() - startTime);
                        return;
                    }
                    default: {
                        throw new IOException("Unknown opcode " + op + " in data stream");
                    }
                }
            }
            catch (Throwable t) {
                LOG.error((Object)(DataNode.this.dnRegistration + ":DataXceiver: " + StringUtils.stringifyException(t)));
                return;
            }
            finally {
                LOG.debug((Object)(DataNode.this.dnRegistration + ":Number of active connections is: " + DataNode.this.xceiverCount));
                IOUtils.closeStream(in);
                IOUtils.closeSocket(this.s);
                DataNode.this.childSockets.remove(this.s);
            }
        }

        /*
         * Loose catch block
         */
        private void readBlock(DataInputStream in) throws IOException {
            DataNode.this.xceiverCount.incr();
            long blockId = in.readLong();
            Block block = new Block(blockId, 0L, in.readLong());
            long startOffset = in.readLong();
            long length = in.readLong();
            OutputStream baseStream = NetUtils.getOutputStream(this.s, DataNode.this.socketWriteTimeout);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(baseStream, FSConstants.SMALL_BUFFER_SIZE));
            BlockSender blockSender = null;
            try {
                try {
                    blockSender = new BlockSender(block, startOffset, length, true, true, false);
                }
                catch (IOException e) {
                    out.writeShort(1);
                    throw e;
                }
                out.writeShort(0);
                long read = blockSender.sendBlock(out, baseStream, null);
                if (blockSender.isBlockReadFully()) {
                    try {
                        if (in.readShort() == 5 && DataNode.this.blockScanner != null) {
                            DataNode.this.blockScanner.verifiedByClient(block);
                        }
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                ((DataNode)DataNode.this).myMetrics.bytesRead.inc((int)read);
                ((DataNode)DataNode.this).myMetrics.blocksRead.inc();
                LOG.info((Object)(DataNode.this.dnRegistration + " Served block " + block + " to " + this.s.getInetAddress()));
                DataNode.this.xceiverCount.decr();
            }
            catch (SocketException ignored) {
                ((DataNode)DataNode.this).myMetrics.blocksRead.inc();
                DataNode.this.xceiverCount.decr();
                IOUtils.closeStream(out);
                IOUtils.closeStream(blockSender);
            }
            catch (IOException ioe) {
                LOG.warn((Object)(DataNode.this.dnRegistration + ":Got exception while serving " + block + " to " + this.s.getInetAddress() + ":\n" + StringUtils.stringifyException(ioe)));
                throw ioe;
                {
                    catch (Throwable throwable) {
                        DataNode.this.xceiverCount.decr();
                        IOUtils.closeStream(out);
                        IOUtils.closeStream(blockSender);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeStream(out);
            IOUtils.closeStream(blockSender);
        }

        private void writeBlock(DataInputStream in) throws IOException {
            int numTargets;
            DataNode.this.xceiverCount.incr();
            DatanodeInfo srcDataNode = null;
            LOG.debug((Object)("writeBlock receive buf size " + this.s.getReceiveBufferSize() + " tcp no delay " + this.s.getTcpNoDelay()));
            Block block = new Block(in.readLong(), DataNode.this.estimateBlockSize, in.readLong());
            LOG.info((Object)("Receiving block " + block + " src: " + this.remoteAddress + " dest: " + this.localAddress));
            int pipelineSize = in.readInt();
            boolean isRecovery = in.readBoolean();
            String client = Text.readString(in);
            boolean hasSrcDataNode = in.readBoolean();
            if (hasSrcDataNode) {
                srcDataNode = new DatanodeInfo();
                srcDataNode.readFields(in);
            }
            if ((numTargets = in.readInt()) < 0) {
                throw new IOException("Mislabelled incoming datastream.");
            }
            DatanodeInfo[] targets = new DatanodeInfo[numTargets];
            for (int i = 0; i < targets.length; ++i) {
                DatanodeInfo tmp = new DatanodeInfo();
                tmp.readFields(in);
                targets[i] = tmp;
            }
            DataOutputStream mirrorOut = null;
            DataInputStream mirrorIn = null;
            DataOutputStream replyOut = null;
            Socket mirrorSock = null;
            BlockReceiver blockReceiver = null;
            String mirrorNode = null;
            String firstBadLink = DataNode.EMPTY_DEL_HINT;
            try {
                blockReceiver = new BlockReceiver(block, in, this.s.getInetAddress().toString(), isRecovery, client, srcDataNode);
                replyOut = new DataOutputStream(NetUtils.getOutputStream(this.s, DataNode.this.socketWriteTimeout));
                if (targets.length > 0) {
                    InetSocketAddress mirrorTarget = null;
                    mirrorNode = targets[0].getName();
                    mirrorTarget = NetUtils.createSocketAddr(mirrorNode);
                    mirrorSock = DataNode.this.newSocket();
                    try {
                        int timeoutValue = numTargets * DataNode.this.socketTimeout;
                        int writeTimeout = DataNode.this.socketWriteTimeout + 5000 * numTargets;
                        mirrorSock.connect(mirrorTarget, timeoutValue);
                        mirrorSock.setSoTimeout(timeoutValue);
                        mirrorSock.setSendBufferSize(131072);
                        mirrorOut = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(mirrorSock, writeTimeout), FSConstants.SMALL_BUFFER_SIZE));
                        mirrorIn = new DataInputStream(NetUtils.getInputStream(mirrorSock));
                        mirrorOut.writeShort(11);
                        mirrorOut.write(80);
                        mirrorOut.writeLong(block.getBlockId());
                        mirrorOut.writeLong(block.getGenerationStamp());
                        mirrorOut.writeInt(pipelineSize);
                        mirrorOut.writeBoolean(isRecovery);
                        Text.writeString(mirrorOut, client);
                        mirrorOut.writeBoolean(hasSrcDataNode);
                        if (hasSrcDataNode) {
                            srcDataNode.write(mirrorOut);
                        }
                        mirrorOut.writeInt(targets.length - 1);
                        for (int i = 1; i < targets.length; ++i) {
                            targets[i].write(mirrorOut);
                        }
                        blockReceiver.writeChecksumHeader(mirrorOut);
                        mirrorOut.flush();
                        if (client.length() != 0) {
                            firstBadLink = Text.readString(mirrorIn);
                            if (LOG.isDebugEnabled() || firstBadLink.length() > 0) {
                                LOG.info((Object)("Datanode " + targets.length + " got response for connect ack " + " from downstream datanode with firstbadlink as " + firstBadLink));
                            }
                        }
                    }
                    catch (IOException e) {
                        if (client.length() != 0) {
                            Text.writeString(replyOut, mirrorNode);
                            replyOut.flush();
                        }
                        IOUtils.closeStream(mirrorOut);
                        mirrorOut = null;
                        IOUtils.closeStream(mirrorIn);
                        mirrorIn = null;
                        IOUtils.closeSocket(mirrorSock);
                        mirrorSock = null;
                        if (client.length() > 0) {
                            throw e;
                        }
                        LOG.info((Object)(DataNode.this.dnRegistration + ":Exception transfering block " + block + " to mirror " + mirrorNode + ". continuing without the mirror.\n" + StringUtils.stringifyException(e)));
                    }
                }
                if (client.length() != 0) {
                    if (LOG.isDebugEnabled() || firstBadLink.length() > 0) {
                        LOG.info((Object)("Datanode " + targets.length + " forwarding connect ack to upstream firstbadlink is " + firstBadLink));
                    }
                    Text.writeString(replyOut, firstBadLink);
                    replyOut.flush();
                }
                String mirrorAddr = mirrorSock == null ? null : mirrorNode;
                blockReceiver.receiveBlock(mirrorOut, mirrorIn, replyOut, mirrorAddr, null, targets.length);
                if (client.length() == 0) {
                    DataNode.this.notifyNamenodeReceivedBlock(block, DataNode.EMPTY_DEL_HINT);
                    LOG.info((Object)("Received block " + block + " src: " + this.remoteAddress + " dest: " + this.localAddress + " of size " + block.getNumBytes()));
                }
                if (DataNode.this.blockScanner != null) {
                    DataNode.this.blockScanner.addBlock(block);
                }
            }
            catch (IOException ioe) {
                try {
                    LOG.info((Object)("writeBlock " + block + " received exception " + ioe));
                    throw ioe;
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(mirrorOut);
                    IOUtils.closeStream(mirrorIn);
                    IOUtils.closeStream(replyOut);
                    IOUtils.closeSocket(mirrorSock);
                    IOUtils.closeStream(blockReceiver);
                    DataNode.this.xceiverCount.decr();
                    throw throwable;
                }
            }
            IOUtils.closeStream(mirrorOut);
            IOUtils.closeStream(mirrorIn);
            IOUtils.closeStream(replyOut);
            IOUtils.closeSocket(mirrorSock);
            IOUtils.closeStream(blockReceiver);
            DataNode.this.xceiverCount.decr();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readMetadata(DataInputStream in) throws IOException {
            DataNode.this.xceiverCount.incr();
            Block block = new Block(in.readLong(), 0L, in.readLong());
            FSDatasetInterface.MetaDataInputStream checksumIn = null;
            DataOutputStream out = null;
            try {
                checksumIn = DataNode.this.data.getMetaDataInputStream(block);
                long fileSize = checksumIn.getLength();
                if (fileSize >= 0x80000000L || fileSize <= 0L) {
                    throw new IOException("Unexpected size for checksumFile of block" + block);
                }
                byte[] buf = new byte[(int)fileSize];
                IOUtils.readFully(checksumIn, buf, 0, buf.length);
                out = new DataOutputStream(NetUtils.getOutputStream(this.s, DataNode.this.socketWriteTimeout));
                out.writeByte(0);
                out.writeInt(buf.length);
                out.write(buf);
                out.writeInt(0);
                DataNode.this.xceiverCount.decr();
            }
            catch (Throwable throwable) {
                DataNode.this.xceiverCount.decr();
                IOUtils.closeStream(out);
                IOUtils.closeStream(checksumIn);
                throw throwable;
            }
            IOUtils.closeStream(out);
            IOUtils.closeStream(checksumIn);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void copyBlock(DataInputStream in) throws IOException {
            long blockId = in.readLong();
            Block block = new Block(blockId, 0L, in.readLong());
            String source = Text.readString(in);
            DatanodeInfo target = new DatanodeInfo();
            target.readFields(in);
            Socket targetSock = null;
            short opStatus = 0;
            BlockSender blockSender = null;
            DataOutputStream targetOut = null;
            try {
                DataNode.this.balancingSem.acquireUninterruptibly();
                blockSender = new BlockSender(block, 0L, -1L, false, false, false);
                InetSocketAddress targetAddr = NetUtils.createSocketAddr(target.getName());
                targetSock = DataNode.this.newSocket();
                targetSock.connect(targetAddr, DataNode.this.socketTimeout);
                targetSock.setSoTimeout(DataNode.this.socketTimeout);
                OutputStream baseStream = NetUtils.getOutputStream(targetSock, DataNode.this.socketWriteTimeout);
                targetOut = new DataOutputStream(new BufferedOutputStream(baseStream, FSConstants.SMALL_BUFFER_SIZE));
                targetOut.writeShort(11);
                targetOut.writeByte(83);
                targetOut.writeLong(block.getBlockId());
                targetOut.writeLong(block.getGenerationStamp());
                Text.writeString(targetOut, source);
                long read = blockSender.sendBlock(targetOut, baseStream, DataNode.this.balancingThrottler);
                ((DataNode)DataNode.this).myMetrics.bytesRead.inc((int)read);
                ((DataNode)DataNode.this).myMetrics.blocksRead.inc();
                DataNode.receiveResponse(targetSock, 1);
                LOG.info((Object)("Copied block " + block + " to " + targetAddr));
            }
            catch (IOException ioe) {
                try {
                    opStatus = 1;
                    LOG.warn((Object)("Got exception while serving " + block + " to " + target.getName() + ": " + StringUtils.stringifyException(ioe)));
                    throw ioe;
                }
                catch (Throwable throwable) {
                    try {
                        DataNode.sendResponse(this.s, opStatus, DataNode.this.socketWriteTimeout);
                    }
                    catch (IOException replyE) {
                        LOG.warn((Object)("Error writing the response back to " + this.s.getRemoteSocketAddress() + "\n" + StringUtils.stringifyException(replyE)));
                    }
                    IOUtils.closeStream(targetOut);
                    IOUtils.closeStream(blockSender);
                    DataNode.this.balancingSem.release();
                    throw throwable;
                }
            }
            try {
                DataNode.sendResponse(this.s, opStatus, DataNode.this.socketWriteTimeout);
            }
            catch (IOException replyE) {
                LOG.warn((Object)("Error writing the response back to " + this.s.getRemoteSocketAddress() + "\n" + StringUtils.stringifyException(replyE)));
            }
            IOUtils.closeStream(targetOut);
            IOUtils.closeStream(blockSender);
            DataNode.this.balancingSem.release();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void replaceBlock(DataInputStream in) throws IOException {
            DataNode.this.balancingSem.acquireUninterruptibly();
            Block block = new Block(in.readLong(), DataNode.this.estimateBlockSize, in.readLong());
            String sourceID = Text.readString(in);
            short opStatus = 0;
            BlockReceiver blockReceiver = null;
            try {
                blockReceiver = new BlockReceiver(block, in, this.s.getRemoteSocketAddress().toString(), false, DataNode.EMPTY_DEL_HINT, null);
                blockReceiver.receiveBlock(null, null, null, null, DataNode.this.balancingThrottler, -1);
                DataNode.this.notifyNamenodeReceivedBlock(block, sourceID);
                LOG.info((Object)("Moved block " + block + " from " + this.s.getRemoteSocketAddress()));
            }
            catch (IOException ioe) {
                try {
                    opStatus = 1;
                    throw ioe;
                }
                catch (Throwable throwable) {
                    try {
                        DataNode.sendResponse(this.s, opStatus, DataNode.this.socketWriteTimeout);
                    }
                    catch (IOException ioe2) {
                        LOG.warn((Object)("Error writing reply back to " + this.s.getRemoteSocketAddress()));
                    }
                    IOUtils.closeStream(blockReceiver);
                    DataNode.this.balancingSem.release();
                    throw throwable;
                }
            }
            try {
                DataNode.sendResponse(this.s, opStatus, DataNode.this.socketWriteTimeout);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Error writing reply back to " + this.s.getRemoteSocketAddress()));
            }
            IOUtils.closeStream(blockReceiver);
            DataNode.this.balancingSem.release();
        }
    }

    class DataXceiveServer
    implements Runnable {
        ServerSocket ss;

        public DataXceiveServer(ServerSocket ss) {
            this.ss = ss;
        }

        public void run() {
            try {
                while (DataNode.this.shouldRun) {
                    Socket s = this.ss.accept();
                    s.setTcpNoDelay(true);
                    new Daemon(DataNode.this.threadGroup, new DataXceiver(s)).start();
                }
                this.ss.close();
            }
            catch (IOException ie) {
                LOG.info((Object)(DataNode.this.dnRegistration + ":Exiting DataXceiveServer due to " + ie.toString()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() {
            assert (!DataNode.this.shouldRun) : "shoudRun should be set to false before killing";
            try {
                this.ss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Map<Socket, Socket> map = DataNode.this.childSockets;
            synchronized (map) {
                for (Socket thissock : DataNode.this.childSockets.values()) {
                    try {
                        thissock.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private static class Count {
        int value = 0;

        Count(int init) {
            this.value = init;
        }

        synchronized void incr() {
            ++this.value;
        }

        synchronized void decr() {
            --this.value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        public int getValue() {
            return this.value;
        }
    }
}

