/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

abstract class DatanodeCommand
implements Writable {
    static final DatanodeCommand REGISTER;
    static final DatanodeCommand BLOCKREPORT;
    static final DatanodeCommand FINALIZE;
    private int action;

    public DatanodeCommand() {
        this(0);
    }

    DatanodeCommand(int action) {
        this.action = action;
    }

    int getAction() {
        return this.action;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.action);
    }

    public void readFields(DataInput in) throws IOException {
        this.action = in.readInt();
    }

    static {
        WritableFactories.setFactory(Register.class, new WritableFactory(){

            public Writable newInstance() {
                return new Register();
            }
        });
        WritableFactories.setFactory(BlockReport.class, new WritableFactory(){

            public Writable newInstance() {
                return new BlockReport();
            }
        });
        WritableFactories.setFactory(Finalize.class, new WritableFactory(){

            public Writable newInstance() {
                return new Finalize();
            }
        });
        REGISTER = new Register();
        BLOCKREPORT = new BlockReport();
        FINALIZE = new Finalize();
    }

    static class Finalize
    extends DatanodeCommand {
        private Finalize() {
            super(5);
        }

        public void readFields(DataInput in) {
        }

        public void write(DataOutput out) {
        }
    }

    static class BlockReport
    extends DatanodeCommand {
        private BlockReport() {
            super(6);
        }

        public void readFields(DataInput in) {
        }

        public void write(DataOutput out) {
        }
    }

    static class Register
    extends DatanodeCommand {
        private Register() {
            super(4);
        }

        public void readFields(DataInput in) {
        }

        public void write(DataOutput out) {
        }
    }
}

